/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.runtime.core;

import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.titan.runtime.core.Base_Template;
import org.eclipse.titan.runtime.core.Base_Type;
import org.eclipse.titan.runtime.core.Default_Base;
import org.eclipse.titan.runtime.core.Optional;
import org.eclipse.titan.runtime.core.Param_Types;
import org.eclipse.titan.runtime.core.TTCN_Default;
import org.eclipse.titan.runtime.core.TTCN_Logger;
import org.eclipse.titan.runtime.core.Text_Buf;
import org.eclipse.titan.runtime.core.TitanDefault;
import org.eclipse.titan.runtime.core.TtcnError;

public class TitanDefault_template
extends Base_Template {
    private Default_Base single_value;
    private ArrayList<TitanDefault_template> value_list;

    public TitanDefault_template() {
    }

    public TitanDefault_template(Base_Template.template_sel otherValue) {
        super(otherValue);
        TitanDefault_template.check_single_selection(otherValue);
    }

    public TitanDefault_template(int otherValue) {
        super(Base_Template.template_sel.SPECIFIC_VALUE);
        if (otherValue != 0) {
            throw new TtcnError("Creating a template from an invalid default reference.");
        }
        this.single_value = null;
    }

    public TitanDefault_template(Default_Base otherValue) {
        super(Base_Template.template_sel.SPECIFIC_VALUE);
        this.single_value = otherValue;
    }

    public TitanDefault_template(TitanDefault otherValue) {
        super(Base_Template.template_sel.SPECIFIC_VALUE);
        otherValue.must_bound("Creating a template from an unbound default reference.");
        this.single_value = otherValue.default_ptr;
    }

    public TitanDefault_template(Optional<TitanDefault> otherValue) {
        switch (otherValue.get_selection()) {
            case OPTIONAL_PRESENT: {
                this.set_selection(Base_Template.template_sel.SPECIFIC_VALUE);
                this.single_value = otherValue.constGet().default_ptr;
                break;
            }
            case OPTIONAL_OMIT: {
                this.set_selection(Base_Template.template_sel.OMIT_VALUE);
                break;
            }
            case OPTIONAL_UNBOUND: {
                throw new TtcnError("Creating a default reference template from an unbound optional field.");
            }
        }
    }

    public TitanDefault_template(TitanDefault_template otherValue) {
        this.copy_template(otherValue);
    }

    private void copy_template(TitanDefault_template otherValue) {
        switch (otherValue.template_selection) {
            case SPECIFIC_VALUE: {
                this.single_value = otherValue.single_value;
                break;
            }
            case OMIT_VALUE: 
            case ANY_VALUE: 
            case ANY_OR_OMIT: {
                break;
            }
            case VALUE_LIST: 
            case COMPLEMENTED_LIST: {
                this.value_list = new ArrayList(otherValue.value_list.size());
                for (int i = 0; i < otherValue.value_list.size(); ++i) {
                    TitanDefault_template temp = new TitanDefault_template(otherValue.value_list.get(i));
                    this.value_list.add(temp);
                }
                break;
            }
            default: {
                throw new TtcnError("Copying an uninitialized/unsupported default reference template.");
            }
        }
        this.set_selection(otherValue);
    }

    @Override
    public void clean_up() {
        switch (this.template_selection) {
            case SPECIFIC_VALUE: {
                this.single_value = null;
                break;
            }
            case VALUE_LIST: 
            case COMPLEMENTED_LIST: {
                this.value_list.clear();
                this.value_list = null;
                break;
            }
        }
        this.template_selection = Base_Template.template_sel.UNINITIALIZED_TEMPLATE;
    }

    @Override
    public TitanDefault_template operator_assign(Base_Type otherValue) {
        if (otherValue instanceof TitanDefault) {
            return this.operator_assign((TitanDefault)otherValue);
        }
        throw new TtcnError(MessageFormat.format("Internal Error: value `{0}'' can not be cast to default", otherValue));
    }

    @Override
    public TitanDefault_template operator_assign(Base_Template otherValue) {
        if (otherValue instanceof TitanDefault_template) {
            return this.operator_assign((TitanDefault_template)otherValue);
        }
        throw new TtcnError(MessageFormat.format("Internal Error: value `{0}'' can not be cast to default", otherValue));
    }

    @Override
    public void log_match(Base_Type match_value, boolean legacy) {
        if (match_value instanceof TitanDefault) {
            this.log_match((TitanDefault)match_value, legacy);
            return;
        }
        throw new TtcnError(MessageFormat.format("Internal Error: value `{0}'' can not be cast to default", match_value));
    }

    @Override
    public TitanDefault_template operator_assign(Base_Template.template_sel otherValue) {
        TitanDefault_template.check_single_selection(otherValue);
        this.clean_up();
        this.set_selection(otherValue);
        return this;
    }

    public TitanDefault_template operator_assign(int otherValue) {
        if (otherValue != 0) {
            throw new TtcnError("Assignment of an invalid default reference to a template.");
        }
        this.clean_up();
        this.set_selection(Base_Template.template_sel.SPECIFIC_VALUE);
        this.single_value = null;
        return this;
    }

    public TitanDefault_template operator_assign(Default_Base otherValue) {
        this.clean_up();
        this.set_selection(Base_Template.template_sel.SPECIFIC_VALUE);
        this.single_value = otherValue;
        return this;
    }

    public TitanDefault_template operator_assign(TitanDefault otherValue) {
        otherValue.must_bound("Assignment of an unbound default reference to a template.");
        this.clean_up();
        this.set_selection(Base_Template.template_sel.SPECIFIC_VALUE);
        this.single_value = otherValue.default_ptr;
        return this;
    }

    public TitanDefault_template operator_assign(TitanDefault_template otherValue) {
        if (otherValue != this) {
            this.clean_up();
            this.copy_template(otherValue);
        }
        return this;
    }

    @Override
    public boolean match(Base_Type otherValue, boolean legacy) {
        if (otherValue instanceof TitanDefault) {
            return this.match((TitanDefault)otherValue, legacy);
        }
        throw new TtcnError(MessageFormat.format("Internal Error: value `{0}'' can not be cast to default", otherValue));
    }

    public boolean match(int otherValue) {
        return this.match(otherValue, false);
    }

    public boolean match(int otherValue, boolean legacy) {
        if (otherValue == 0) {
            return false;
        }
        return this.match((Default_Base)null);
    }

    public boolean match(Default_Base otherValue) {
        return this.match(otherValue, false);
    }

    public boolean match(Default_Base otherValue, boolean legacy) {
        if (otherValue == TitanDefault.UNBOUND_DEFAULT) {
            return false;
        }
        switch (this.template_selection) {
            case SPECIFIC_VALUE: {
                return this.single_value == otherValue;
            }
            case OMIT_VALUE: {
                return false;
            }
            case ANY_VALUE: 
            case ANY_OR_OMIT: {
                return true;
            }
            case VALUE_LIST: 
            case COMPLEMENTED_LIST: {
                for (int i = 0; i < this.value_list.size(); ++i) {
                    if (!this.value_list.get(i).match(otherValue, legacy)) continue;
                    return this.template_selection == Base_Template.template_sel.VALUE_LIST;
                }
                return this.template_selection == Base_Template.template_sel.COMPLEMENTED_LIST;
            }
        }
        throw new TtcnError("Matching with an uninitialized/unsupported default reference template.");
    }

    public boolean match(TitanDefault otherValue) {
        return this.match(otherValue, false);
    }

    public boolean match(TitanDefault otherValue, boolean legacy) {
        if (!otherValue.is_bound()) {
            return false;
        }
        return this.match(otherValue.default_ptr);
    }

    @Override
    public TitanDefault valueof() {
        if (this.template_selection != Base_Template.template_sel.SPECIFIC_VALUE || this.is_ifPresent) {
            throw new TtcnError("Performing a valueof or send operation on a non-specific default reference template.");
        }
        return new TitanDefault(this.single_value);
    }

    @Override
    public void set_type(Base_Template.template_sel templateType, int listLength) {
        if (templateType != Base_Template.template_sel.VALUE_LIST && templateType != Base_Template.template_sel.COMPLEMENTED_LIST) {
            throw new TtcnError("Setting an invalid list type for a default reference template.");
        }
        this.clean_up();
        this.set_selection(templateType);
        this.value_list = new ArrayList(listLength);
    }

    @Override
    public int n_list_elem() {
        if (this.template_selection != Base_Template.template_sel.VALUE_LIST && this.template_selection != Base_Template.template_sel.COMPLEMENTED_LIST) {
            throw new TtcnError("Accessing a list element of a non-list default reference template.");
        }
        return this.value_list.size();
    }

    @Override
    public TitanDefault_template list_item(int listIndex) {
        if (!Base_Template.template_sel.VALUE_LIST.equals((Object)this.template_selection) && !Base_Template.template_sel.COMPLEMENTED_LIST.equals((Object)this.template_selection)) {
            throw new TtcnError("Accessing a list element of a non-list default reference template.");
        }
        if (listIndex < 0) {
            throw new TtcnError("Accessing an default reference value list template using a negative index (" + listIndex + ").");
        }
        if (listIndex > this.value_list.size()) {
            throw new TtcnError("Index overflow in an default reference value list template.");
        }
        return this.value_list.get(listIndex);
    }

    @Override
    public void log() {
        switch (this.template_selection) {
            case SPECIFIC_VALUE: {
                TTCN_Default.log(this.single_value);
                break;
            }
            case COMPLEMENTED_LIST: {
                TTCN_Logger.log_event_str("complement");
            }
            case VALUE_LIST: {
                TTCN_Logger.log_char('(');
                for (int i = 0; i < this.value_list.size(); ++i) {
                    if (i > 0) {
                        TTCN_Logger.log_event_str(", ");
                    }
                    this.value_list.get(i).log();
                }
                TTCN_Logger.log_char(')');
                break;
            }
            default: {
                this.log_generic();
            }
        }
        this.log_ifpresent();
    }

    @Override
    public void set_param(Param_Types.Module_Parameter param) {
        param.basic_check(Param_Types.Module_Parameter.basic_check_bits_t.BC_TEMPLATE.getValue(), "default reference (null) template");
        if (param.get_type() == Param_Types.Module_Parameter.type_t.MP_Reference) {
            param = param.get_referenced_param().get();
        }
        switch (param.get_type()) {
            case MP_Omit: {
                this.operator_assign(Base_Template.template_sel.OMIT_VALUE);
                break;
            }
            case MP_Any: {
                this.operator_assign(Base_Template.template_sel.ANY_VALUE);
                break;
            }
            case MP_AnyOrNone: {
                this.operator_assign(Base_Template.template_sel.ANY_OR_OMIT);
                break;
            }
            case MP_List_Template: 
            case MP_ComplementList_Template: {
                TitanDefault_template temp = new TitanDefault_template();
                temp.set_type(param.get_type() == Param_Types.Module_Parameter.type_t.MP_List_Template ? Base_Template.template_sel.VALUE_LIST : Base_Template.template_sel.COMPLEMENTED_LIST, param.get_size());
                for (int i = 0; i < param.get_size(); ++i) {
                    temp.list_item(i).set_param(param.get_elem(i));
                }
                this.operator_assign(temp);
                break;
            }
            default: {
                param.type_error("default reference (null) template");
            }
        }
        this.is_ifPresent = param.get_ifpresent();
    }

    @Override
    public Param_Types.Module_Parameter get_param(Param_Types.Module_Param_Name param_name) {
        Param_Types.Module_Parameter mp = null;
        switch (this.template_selection) {
            case UNINITIALIZED_TEMPLATE: {
                mp = new Param_Types.Module_Param_Unbound();
                break;
            }
            case OMIT_VALUE: {
                mp = new Param_Types.Module_Param_Omit();
                break;
            }
            case ANY_VALUE: {
                mp = new Param_Types.Module_Param_Any();
                break;
            }
            case ANY_OR_OMIT: {
                mp = new Param_Types.Module_Param_AnyOrNone();
                break;
            }
            case SPECIFIC_VALUE: {
                mp = new Param_Types.Module_Param_Ttcn_Null();
                break;
            }
            case VALUE_LIST: 
            case COMPLEMENTED_LIST: {
                mp = this.template_selection == Base_Template.template_sel.VALUE_LIST ? new Param_Types.Module_Param_List_Template() : new Param_Types.Module_Param_ComplementList_Template();
                for (int i = 0; i < this.value_list.size(); ++i) {
                    mp.add_elem(this.value_list.get(i).get_param(param_name));
                }
                break;
            }
        }
        if (this.is_ifPresent) {
            mp.set_ifpresent();
        }
        return mp;
    }

    public void log_match(TitanDefault match_value, boolean legacy) {
        if (TTCN_Logger.matching_verbosity_t.VERBOSITY_COMPACT == TTCN_Logger.get_matching_verbosity() && TTCN_Logger.get_logmatch_buffer_len() != 0) {
            TTCN_Logger.print_logmatch_buffer();
            TTCN_Logger.log_event_str(" := ");
        }
        match_value.log();
        TTCN_Logger.log_event_str(" with ");
        this.log();
        if (this.match(match_value)) {
            TTCN_Logger.log_event_str(" matched");
        } else {
            TTCN_Logger.log_event_str(" unmatched");
        }
    }

    @Override
    public boolean match_omit(boolean legacy) {
        if (this.is_ifPresent) {
            return true;
        }
        switch (this.template_selection) {
            case OMIT_VALUE: 
            case ANY_OR_OMIT: {
                return true;
            }
            case VALUE_LIST: 
            case COMPLEMENTED_LIST: {
                if (legacy) {
                    for (int i = 0; i < this.value_list.size(); ++i) {
                        if (!this.value_list.get(i).match_omit()) continue;
                        return this.template_selection == Base_Template.template_sel.VALUE_LIST;
                    }
                    return this.template_selection == Base_Template.template_sel.COMPLEMENTED_LIST;
                }
                return false;
            }
        }
        return false;
    }

    @Override
    public void encode_text(Text_Buf text_buf) {
        throw new TtcnError("Default reference templates cannot be sent to other test components.");
    }

    @Override
    public void decode_text(Text_Buf text_buf) {
        throw new TtcnError("Default reference templates cannot be received from other test components.");
    }

    @Override
    public void check_restriction(Base_Template.template_res restriction, String name, boolean legacy) {
        if (this.template_selection == Base_Template.template_sel.UNINITIALIZED_TEMPLATE) {
            return;
        }
        switch (name != null && restriction == Base_Template.template_res.TR_VALUE ? Base_Template.template_res.TR_OMIT : restriction) {
            case TR_VALUE: {
                if (this.is_ifPresent || this.template_selection != Base_Template.template_sel.SPECIFIC_VALUE) break;
                return;
            }
            case TR_OMIT: {
                if (this.is_ifPresent || this.template_selection != Base_Template.template_sel.OMIT_VALUE && this.template_selection != Base_Template.template_sel.SPECIFIC_VALUE) break;
                return;
            }
            case TR_PRESENT: {
                if (this.match_omit(legacy)) break;
                return;
            }
            default: {
                return;
            }
        }
        throw new TtcnError(MessageFormat.format("Restriction `{0}'' on template of type {1} violated.", TitanDefault_template.get_res_name(restriction), name == null ? "default reference" : name));
    }
}

