/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.runtime.core;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.titan.runtime.core.AdditionalFunctions;
import org.eclipse.titan.runtime.core.BER;
import org.eclipse.titan.runtime.core.Base_Type;
import org.eclipse.titan.runtime.core.JSON;
import org.eclipse.titan.runtime.core.JSON_Tokenizer;
import org.eclipse.titan.runtime.core.Param_Types;
import org.eclipse.titan.runtime.core.RAW;
import org.eclipse.titan.runtime.core.TTCN_Buffer;
import org.eclipse.titan.runtime.core.TTCN_EncDec;
import org.eclipse.titan.runtime.core.TTCN_EncDec_ErrorContext;
import org.eclipse.titan.runtime.core.TTCN_Logger;
import org.eclipse.titan.runtime.core.Text_Buf;
import org.eclipse.titan.runtime.core.TitanBitString_Element;
import org.eclipse.titan.runtime.core.TitanCharString;
import org.eclipse.titan.runtime.core.TitanInteger;
import org.eclipse.titan.runtime.core.TitanString_Utils;
import org.eclipse.titan.runtime.core.TtcnError;

public class TitanBitString
extends Base_Type {
    private static final BER.ASN_Tag[] TitanBitString_tag_ = new BER.ASN_Tag[]{new BER.ASN_Tag(BER.ASN_TagClass.ASN_TAG_UNIV, 3)};
    public static final BER.ASN_BERdescriptor TitanBitString_Ber_ = new BER.ASN_BERdescriptor(1, TitanBitString_tag_);
    public static final RAW.TTCN_RAWdescriptor TitanBitString_raw_ = new RAW.TTCN_RAWdescriptor(0, RAW.raw_sign_t.SG_NO, TTCN_EncDec.raw_order_t.ORDER_LSB, TTCN_EncDec.raw_order_t.ORDER_LSB, TTCN_EncDec.raw_order_t.ORDER_LSB, TTCN_EncDec.raw_order_t.ORDER_LSB, RAW.ext_bit_t.EXT_BIT_NO, TTCN_EncDec.raw_order_t.ORDER_LSB, TTCN_EncDec.raw_order_t.ORDER_LSB, RAW.top_bit_order_t.TOP_BIT_INHERITED, 0, 0, 0, 8, 0, null, -1, TitanCharString.CharCoding.UNKNOWN, null, false);
    public static final JSON.TTCN_JSONdescriptor TitanBitString_json_ = new JSON.TTCN_JSONdescriptor(false, null, false, null, false, false, false, 0, null, false, JSON.json_string_escaping.ESCAPE_AS_SHORT);
    public static final Base_Type.TTCN_Typedescriptor TitanBitString_descr_ = new Base_Type.TTCN_Typedescriptor("BIT STRING", TitanBitString_Ber_, TitanBitString_raw_, TitanBitString_json_, null);
    private int[] bits_ptr;
    private int n_bits;

    public TitanBitString() {
        this.bits_ptr = null;
        this.n_bits = 0;
    }

    public TitanBitString(int[] other_value, int nof_bits) {
        this.bits_ptr = TitanString_Utils.copy_integer_list(other_value);
        this.n_bits = nof_bits;
        this.clear_unused_bits();
    }

    public TitanBitString(TitanBitString otherValue) {
        otherValue.must_bound("Copying an unbound bitstring value.");
        this.bits_ptr = TitanString_Utils.copy_integer_list(otherValue.bits_ptr);
        this.n_bits = otherValue.n_bits;
    }

    public TitanBitString(TitanBitString_Element otherValue) {
        otherValue.must_bound("Copying an unbound bitstring element.");
        this.bits_ptr = new int[1];
        this.bits_ptr[0] = otherValue.get_bit() ? 1 : 0;
        this.n_bits = 1;
    }

    public TitanBitString(int value) {
        this.bits_ptr = new int[1];
        this.bits_ptr[0] = value;
        this.n_bits = 8;
    }

    public TitanBitString(String value) {
        String bitString = value.replaceAll(" ", "");
        this.bits_ptr = TitanBitString.bitstr2intlist(bitString);
        this.n_bits = bitString.length();
    }

    private static int[] bitstr2intlist(String aBitString) {
        int len = aBitString.length();
        int[] result = new int[(len + 7) / 8];
        for (int i = 0; i < len; i += 8) {
            int byteValue;
            String byteStr = aBitString.substring(i, i + 8 < len ? i + 8 : len);
            byte[] byteArray = byteStr.getBytes();
            result[i / 8] = byteValue = TitanBitString.bitstr2byte(byteArray);
        }
        return result;
    }

    private static int bitstr2byte(byte[] aBitString8) {
        int result = 0;
        int digit = 1;
        int i = 0;
        while (i < aBitString8.length) {
            if (aBitString8[i] == 49) {
                result += digit;
            }
            ++i;
            digit *= 2;
        }
        return result;
    }

    private void clear_unused_bits() {
        if (this.n_bits % 8 != 0) {
            int listIndex = (this.n_bits - 1) / 8;
            int bytevalue = this.bits_ptr[listIndex];
            this.bits_ptr[listIndex] = bytevalue &= 255 >> 7 - (this.n_bits - 1) % 8;
        }
    }

    boolean get_bit(int aBitIndex) {
        return (this.bits_ptr[aBitIndex / 8] & 1 << aBitIndex % 8) != 0;
    }

    void set_bit(int aBitIndex, boolean aNewValue) {
        int mask = 1 << aBitIndex % 8;
        int listIndex = aBitIndex / 8;
        int bytevalue = this.bits_ptr[listIndex];
        bytevalue = aNewValue ? (bytevalue |= mask) : (bytevalue &= ~mask);
        this.bits_ptr[listIndex] = bytevalue;
    }

    public int[] get_value() {
        this.must_bound("Casting an unbound bitstring value to const unsigned char*.");
        return this.bits_ptr;
    }

    public void setValue(int[] other_value, int nof_bits) {
        this.bits_ptr = other_value;
        this.n_bits = nof_bits;
        this.clear_unused_bits();
    }

    public TitanBitString operator_assign(TitanBitString_Element otherValue) {
        otherValue.must_bound("Assignment of an unbound bitstring element to a bitstring.");
        boolean bitValue = otherValue.get_bit();
        this.clean_up();
        this.n_bits = 1;
        this.bits_ptr = new int[1];
        this.bits_ptr[0] = bitValue ? 1 : 0;
        return this;
    }

    public TitanBitString operator_assign(TitanBitString otherValue) {
        otherValue.must_bound("Assignment of an unbound bitstring value.");
        if (otherValue != this) {
            this.clean_up();
            this.bits_ptr = TitanString_Utils.copy_integer_list(otherValue.bits_ptr);
            this.n_bits = otherValue.n_bits;
        }
        return this;
    }

    public TitanBitString operator_assign(TitanInteger otherValue) {
        return this.operator_assign(AdditionalFunctions.int2bit(otherValue, this.n_bits));
    }

    @Override
    public TitanBitString operator_assign(Base_Type otherValue) {
        if (otherValue instanceof TitanBitString) {
            return this.operator_assign((TitanBitString)otherValue);
        }
        if (otherValue instanceof TitanInteger) {
            return this.operator_assign((TitanInteger)otherValue);
        }
        throw new TtcnError(MessageFormat.format("Internal Error: value `{0}'' can not be cast to bitstring", otherValue));
    }

    @Override
    public boolean is_bound() {
        return this.bits_ptr != null;
    }

    @Override
    public boolean is_value() {
        return this.is_bound();
    }

    public TitanInteger lengthof() {
        this.must_bound("Performing lengthof operation on an unbound bitstring value.");
        return new TitanInteger(this.n_bits);
    }

    public boolean operator_equals(TitanBitString otherValue) {
        this.must_bound("Unbound left operand of bitstring comparison.");
        otherValue.must_bound("Unbound right operand of bitstring comparison.");
        return this.n_bits == otherValue.n_bits && Arrays.equals(this.bits_ptr, otherValue.bits_ptr);
    }

    public boolean operator_equals(TitanBitString_Element otherValue) {
        this.must_bound("Unbound left operand of bitstring comparison.");
        otherValue.must_bound("Unbound right operand of bitstring element comparison.");
        if (this.n_bits != 1) {
            return false;
        }
        return this.get_bit(0) == otherValue.get_bit();
    }

    @Override
    public boolean operator_equals(Base_Type otherValue) {
        if (otherValue instanceof TitanBitString) {
            return this.operator_equals((TitanBitString)otherValue);
        }
        throw new TtcnError(MessageFormat.format("Internal Error: value `{0}'' can not be cast to bitstring", otherValue));
    }

    public boolean operator_not_equals(TitanBitString otherValue) {
        return !this.operator_equals(otherValue);
    }

    public boolean operator_not_equals(TitanBitString_Element otherValue) {
        return !this.operator_equals(otherValue);
    }

    @Override
    public void clean_up() {
        this.n_bits = 0;
        this.bits_ptr = null;
    }

    public TitanBitString operator_concatenate(TitanBitString other_value) {
        this.must_bound("Unbound left operand of bitstring concatenation.");
        other_value.must_bound("Unbound right operand of bitstring element concatenation.");
        if (this.n_bits == 0) {
            return new TitanBitString(other_value);
        }
        if (other_value.n_bits == 0) {
            return new TitanBitString(this);
        }
        int resultBits = this.n_bits + other_value.n_bits;
        int left_n_bytes = (this.n_bits + 7) / 8;
        int right_n_bytes = (other_value.n_bits + 7) / 8;
        int last_octet_bits = this.n_bits % 8;
        TitanBitString result = new TitanBitString();
        result.bits_ptr = new int[(resultBits + 7) / 8];
        result.n_bits = resultBits;
        System.arraycopy(this.bits_ptr, 0, result.bits_ptr, 0, this.bits_ptr.length);
        if (last_octet_bits != 0) {
            int n_bytes = (resultBits + 7) / 8;
            for (int i = left_n_bytes; i < n_bytes; ++i) {
                Integer right_byte = other_value.bits_ptr[i - left_n_bytes];
                int temp = result.bits_ptr[i - 1] | right_byte << last_octet_bits;
                result.bits_ptr[i - 1] = temp & 0xFF;
                result.bits_ptr[i] = temp = right_byte >> 8 - last_octet_bits;
            }
            if (left_n_bytes + right_n_bytes > n_bytes) {
                int temp = result.bits_ptr[n_bytes - 1] | other_value.bits_ptr[right_n_bytes - 1] << last_octet_bits;
                result.bits_ptr[n_bytes - 1] = temp & 0xFF;
            }
        } else {
            System.arraycopy(other_value.bits_ptr, 0, result.bits_ptr, this.bits_ptr.length, other_value.bits_ptr.length);
        }
        return result;
    }

    public TitanBitString operator_concatenate(TitanBitString_Element other_value) {
        this.must_bound("Unbound left operand of bitstring concatenation.");
        other_value.must_bound("Unbound right operand of bitstring element");
        int n_bytes = this.n_bits / 8 + 1;
        TitanBitString ret_val = new TitanBitString();
        ret_val.bits_ptr = new int[n_bytes];
        ret_val.n_bits = this.n_bits + 1;
        System.arraycopy(this.bits_ptr, 0, ret_val.bits_ptr, 0, this.bits_ptr.length);
        ret_val.set_bit(this.n_bits, other_value.get_bit());
        ret_val.clear_unused_bits();
        return ret_val;
    }

    public TitanBitString not4b() {
        this.must_bound("Unbound bitstring operand of operator not4b.");
        int n_bytes = (this.n_bits + 7) / 8;
        if (n_bytes == 0) {
            return new TitanBitString(this);
        }
        TitanBitString result = new TitanBitString();
        result.n_bits = this.n_bits;
        result.bits_ptr = new int[(this.n_bits + 7) / 8];
        for (int i = 0; i < this.bits_ptr.length; ++i) {
            result.bits_ptr[i] = ~this.bits_ptr[i] & 0xFF;
        }
        result.clear_unused_bits();
        return result;
    }

    public TitanBitString and4b(TitanBitString otherValue) {
        this.must_bound("Left operand of operator and4b is an unbound bitstring value.");
        otherValue.must_bound("Right operand of operator and4b is an unbound bitstring value.");
        if (this.n_bits != otherValue.n_bits) {
            throw new TtcnError("The bitstring operands of operator and4b must have the same length.");
        }
        if (this.n_bits == 0) {
            return new TitanBitString(this);
        }
        int n_bytes = (this.n_bits + 7) / 8;
        TitanBitString result = new TitanBitString();
        result.bits_ptr = new int[n_bytes];
        result.n_bits = this.n_bits;
        for (int i = 0; i < this.bits_ptr.length; ++i) {
            result.bits_ptr[i] = this.bits_ptr[i] & otherValue.bits_ptr[i];
        }
        result.clear_unused_bits();
        return result;
    }

    public TitanBitString and4b(TitanBitString_Element otherValue) {
        this.must_bound("Left operand of operator and4b is an unbound bitstring value.");
        otherValue.must_bound("Right operand of operator and4b is an unbound bitstring element.");
        if (this.n_bits != 1) {
            throw new TtcnError("The bitstring operands of operator and4b must have the same length.");
        }
        TitanBitString result = new TitanBitString();
        result.bits_ptr = new int[1];
        result.n_bits = 1;
        result.bits_ptr[0] = this.get_bit(0) && otherValue.get_bit() ? 1 : 0;
        return result;
    }

    public TitanBitString or4b(TitanBitString otherValue) {
        this.must_bound("Left operand of operator or4b is an unbound bitstring value.");
        otherValue.must_bound("Right operand of operator or4b is an unbound bitstring value.");
        if (this.n_bits != otherValue.n_bits) {
            throw new TtcnError("The bitstring operands of operator or4b must have the same length.");
        }
        if (this.n_bits == 0) {
            return new TitanBitString(this);
        }
        int n_bytes = (this.n_bits + 7) / 8;
        TitanBitString result = new TitanBitString();
        result.bits_ptr = new int[n_bytes];
        result.n_bits = this.n_bits;
        for (int i = 0; i < this.bits_ptr.length; ++i) {
            result.bits_ptr[i] = this.bits_ptr[i] | otherValue.bits_ptr[i];
        }
        result.clear_unused_bits();
        return result;
    }

    public TitanBitString or4b(TitanBitString_Element otherValue) {
        this.must_bound("Left operand of operator or4b is an unbound bitstring value.");
        otherValue.must_bound("Right operand of operator or4b is an unbound bitstring element.");
        if (this.n_bits != 1) {
            throw new TtcnError("The bitstring operands of operator or4b must have the same length.");
        }
        TitanBitString result = new TitanBitString();
        result.bits_ptr = new int[1];
        result.n_bits = 1;
        result.bits_ptr[0] = this.get_bit(0) || otherValue.get_bit() ? 1 : 0;
        return result;
    }

    public TitanBitString xor4b(TitanBitString otherValue) {
        this.must_bound("Left operand of operator xor4b is an unbound bitstring value.");
        otherValue.must_bound("Right operand of operator xor4b is an unbound bitstring value.");
        if (this.n_bits != otherValue.n_bits) {
            throw new TtcnError("The bitstring operands of operator xor4b must have the same length.");
        }
        if (this.n_bits == 0) {
            return new TitanBitString(this);
        }
        int n_bytes = (this.n_bits + 7) / 8;
        TitanBitString result = new TitanBitString();
        result.bits_ptr = new int[n_bytes];
        result.n_bits = this.n_bits;
        for (int i = 0; i < this.bits_ptr.length; ++i) {
            result.bits_ptr[i] = this.bits_ptr[i] ^ otherValue.bits_ptr[i];
        }
        result.clear_unused_bits();
        return result;
    }

    public TitanBitString xor4b(TitanBitString_Element otherValue) {
        this.must_bound("Left operand of operator xor4b is an unbound bitstring value.");
        otherValue.must_bound("Right operand of operator xor4b is an unbound bitstring element.");
        if (this.n_bits != 1) {
            throw new TtcnError("The bitstring operands of operator xor4b must have the same length.");
        }
        TitanBitString result = new TitanBitString();
        result.bits_ptr = new int[1];
        result.n_bits = 1;
        result.bits_ptr[0] = this.get_bit(0) ^ otherValue.get_bit() ? 1 : 0;
        return result;
    }

    public TitanBitString shift_left(int shift_count) {
        this.must_bound("Unbound bitstring operand of shift left operator.");
        if (shift_count > 0) {
            int i;
            if (this.n_bits == 0) {
                return new TitanBitString(this);
            }
            int n_bytes = (this.n_bits + 7) / 8;
            this.clear_unused_bits();
            if (shift_count > this.n_bits) {
                shift_count = this.n_bits;
            }
            int shift_bytes = shift_count / 8;
            int shift_bits = shift_count % 8;
            TitanBitString result = new TitanBitString();
            result.bits_ptr = new int[n_bytes];
            result.n_bits = this.n_bits;
            if (shift_bits != 0) {
                for (int byte_count = 0; byte_count < n_bytes - shift_bytes - 1; ++byte_count) {
                    result.bits_ptr[byte_count] = (this.bits_ptr[byte_count + shift_bytes] >> shift_bits | this.bits_ptr[byte_count + shift_bytes + 1] << 8 - shift_bits) & 0xFF;
                }
                result.bits_ptr[n_bytes - shift_bytes - 1] = this.bits_ptr[n_bytes - 1] >> shift_bits;
            } else {
                for (i = shift_bytes; i < n_bytes; ++i) {
                    result.bits_ptr[i - shift_bytes] = this.bits_ptr[i];
                }
            }
            for (i = n_bytes - shift_bytes; i < n_bytes; ++i) {
                result.bits_ptr[i] = 0;
            }
            result.clear_unused_bits();
            return result;
        }
        if (shift_count == 0) {
            return new TitanBitString(this);
        }
        return this.shift_right(-shift_count);
    }

    public TitanBitString shift_left(TitanInteger shift_count) {
        shift_count.must_bound("Unbound right operand of shift left operator.");
        return this.shift_left(shift_count.get_int());
    }

    public TitanBitString shift_right(int shift_count) {
        this.must_bound("Unbound bitstring operand of shift right operator.");
        if (shift_count > 0) {
            int i;
            if (this.n_bits == 0) {
                return new TitanBitString(this);
            }
            int n_bytes = (this.n_bits + 7) / 8;
            this.clear_unused_bits();
            if (shift_count > this.n_bits) {
                shift_count = this.n_bits;
            }
            int shift_bytes = shift_count / 8;
            int shift_bits = shift_count % 8;
            TitanBitString result = new TitanBitString();
            result.bits_ptr = new int[n_bytes];
            result.n_bits = this.n_bits;
            for (i = 0; i < shift_bytes; ++i) {
                result.bits_ptr[i] = 0;
            }
            if (shift_bits != 0) {
                result.bits_ptr[shift_bytes] = this.bits_ptr[0] << shift_bits & 0xFF;
                for (int byte_count = shift_bytes + 1; byte_count < n_bytes; ++byte_count) {
                    result.bits_ptr[byte_count] = this.bits_ptr[byte_count - shift_bytes - 1] >> 8 - shift_bits | this.bits_ptr[byte_count - shift_bytes] << shift_bits & 0xFF;
                }
            } else {
                for (i = shift_bytes; i < n_bytes; ++i) {
                    result.bits_ptr[i] = this.bits_ptr[i - shift_bytes];
                }
            }
            result.clear_unused_bits();
            return result;
        }
        if (shift_count == 0) {
            return new TitanBitString(this);
        }
        return this.shift_left(-shift_count);
    }

    public TitanBitString shift_right(TitanInteger shift_count) {
        shift_count.must_bound("Unbound bitstring operand of shift left operator.");
        return this.shift_right(shift_count.get_int());
    }

    public TitanBitString rotate_left(int rotate_count) {
        this.must_bound("Unbound bitstring operand of rotate left operator.");
        if (this.n_bits == 0) {
            return new TitanBitString(this);
        }
        if (rotate_count >= 0) {
            if ((rotate_count %= this.n_bits) == 0) {
                return new TitanBitString(this);
            }
            return this.shift_left(rotate_count).or4b(this.shift_right(this.n_bits - rotate_count));
        }
        return this.rotate_right(-rotate_count);
    }

    public TitanBitString rotate_left(TitanInteger rotate_count) {
        rotate_count.must_bound("Unbound right operand of rotate left operator.");
        return this.rotate_left(rotate_count.get_int());
    }

    public TitanBitString rotate_right(int rotate_count) {
        this.must_bound("Unbound bitstring operand of rotate right operator.");
        if (this.n_bits == 0) {
            return new TitanBitString(this);
        }
        if (rotate_count >= 0) {
            if ((rotate_count %= this.n_bits) == 0) {
                return new TitanBitString(this);
            }
            return this.shift_right(rotate_count).or4b(this.shift_left(this.n_bits - rotate_count));
        }
        return this.rotate_left(-rotate_count);
    }

    public TitanBitString rotate_right(TitanInteger rotate_count) {
        rotate_count.must_bound("Unbound right operand of rotate right operator.");
        return this.rotate_right(rotate_count.get_int());
    }

    public TitanBitString_Element get_at(int index_value) {
        if (this.bits_ptr == null && index_value == 0) {
            this.bits_ptr = new int[1];
            this.n_bits = 1;
            return new TitanBitString_Element(false, this, 0);
        }
        this.must_bound("Accessing an element of an unbound bitstring value.");
        if (index_value < 0) {
            throw new TtcnError("Accessing an bitstring element using a negative index (" + index_value + ").");
        }
        if (index_value > this.n_bits) {
            throw new TtcnError("Index overflow when accessing a bitstring element: The index is " + index_value + ", but the string has only " + this.n_bits + " bits.");
        }
        if (index_value == this.n_bits) {
            ++this.n_bits;
            int[] temp = new int[(this.n_bits + 7) / 8];
            System.arraycopy(this.bits_ptr, 0, temp, 0, this.bits_ptr.length);
            this.bits_ptr = temp;
            return new TitanBitString_Element(false, this, index_value);
        }
        return new TitanBitString_Element(true, this, index_value);
    }

    public TitanBitString_Element get_at(TitanInteger index_value) {
        index_value.must_bound("Indexing a bitstring value with an unbound integer value.");
        return this.get_at(index_value.get_int());
    }

    public final TitanBitString_Element constGet_at(int index_value) {
        this.must_bound("Accessing an element of an unbound bitstring value.");
        if (index_value < 0) {
            throw new TtcnError("Accessing an bitstring element using a negative index (" + index_value + ").");
        }
        if (index_value >= this.n_bits) {
            throw new TtcnError("Index overflow when accessing a bitstring element: The index is " + index_value + ", but the string has only " + this.n_bits + " bits.");
        }
        return new TitanBitString_Element(true, this, index_value);
    }

    public final TitanBitString_Element constGet_at(TitanInteger index_value) {
        index_value.must_bound("Indexing a bitstring value with an unbound integer value.");
        return this.constGet_at(index_value.get_int());
    }

    @Override
    public void log() {
        if (this.bits_ptr != null) {
            TTCN_Logger.log_char('\'');
            for (int bit_count = 0; bit_count < this.n_bits; ++bit_count) {
                TTCN_Logger.log_char(this.get_bit(bit_count) ? (char)'1' : '0');
            }
            TTCN_Logger.log_event_str("'B");
        } else {
            TTCN_Logger.log_event_unbound();
        }
    }

    @Override
    public void set_param(Param_Types.Module_Parameter param) {
        param.basic_check(Param_Types.Module_Parameter.basic_check_bits_t.BC_VALUE.getValue() | Param_Types.Module_Parameter.basic_check_bits_t.BC_LIST.getValue(), "bitstring value");
        if (param.get_type() == Param_Types.Module_Parameter.type_t.MP_Reference) {
            param = param.get_referenced_param().get();
        }
        block0 : switch (param.get_type()) {
            case MP_Bitstring: {
                switch (param.get_operation_type()) {
                    case OT_ASSIGN: {
                        this.clean_up();
                        this.n_bits = param.get_string_size();
                        this.bits_ptr = (int[])param.get_string_data();
                        this.clear_unused_bits();
                        break block0;
                    }
                    case OT_CONCAT: {
                        TitanBitString temp = new TitanBitString((int[])param.get_string_data(), param.get_string_size());
                        if (this.is_bound()) {
                            this.operator_assign(this.operator_concatenate(temp));
                            break block0;
                        }
                        this.operator_assign(temp);
                        break block0;
                    }
                }
                throw new TtcnError("Internal error: TitanBitString.set_param()");
            }
            case MP_Expression: {
                if (param.get_expr_type() == Param_Types.Module_Parameter.expression_operand_t.EXPR_CONCATENATE) {
                    TitanBitString operand1 = new TitanBitString();
                    TitanBitString operand2 = new TitanBitString();
                    operand1.set_param(param.get_operand1());
                    operand2.set_param(param.get_operand2());
                    if (param.get_operation_type() == Param_Types.Module_Parameter.operation_type_t.OT_CONCAT) {
                        this.operator_assign(this.operator_concatenate(operand1).operator_concatenate(operand2));
                        break;
                    }
                    this.operator_assign(operand1.operator_concatenate(operand2));
                    break;
                }
                param.expr_type_error("a bitstring");
                break;
            }
            default: {
                param.expr_type_error("a bitstring value");
            }
        }
    }

    @Override
    public Param_Types.Module_Parameter get_param(Param_Types.Module_Param_Name param_name) {
        if (!this.is_bound()) {
            return new Param_Types.Module_Param_Unbound();
        }
        return new Param_Types.Module_Param_Bitstring(this);
    }

    @Override
    public boolean is_present() {
        return this.is_bound();
    }

    public String toString() {
        StringBuilder result = new StringBuilder(this.n_bits + 2);
        result.append('\'');
        for (int i = 0; i < this.n_bits; ++i) {
            result.append(this.get_bit(i) ? (char)'1' : '0');
        }
        result.append("'B");
        return result.toString();
    }

    @Override
    public void encode_text(Text_Buf text_buf) {
        this.must_bound("Text encoder: Encoding an unbound bitstring value.");
        text_buf.push_int(this.n_bits);
        if (this.n_bits > 0) {
            byte[] temp = new byte[this.bits_ptr.length];
            for (int i = 0; i < this.bits_ptr.length; ++i) {
                temp[i] = (byte)this.bits_ptr[i];
            }
            text_buf.push_raw(temp);
        }
    }

    @Override
    public void decode_text(Text_Buf text_buf) {
        this.clean_up();
        this.n_bits = text_buf.pull_int().get_int();
        if (this.n_bits < 0) {
            throw new TtcnError("Text decoder: Invalid length was received for a bitstring.");
        }
        int bytes = (this.n_bits + 7) / 8;
        this.bits_ptr = new int[bytes];
        if (this.n_bits > 0) {
            byte[] temp = new byte[bytes];
            text_buf.pull_raw(bytes, temp);
            for (int i = 0; i < bytes; ++i) {
                this.bits_ptr[i] = temp[i];
            }
            this.clear_unused_bits();
        }
    }

    public int get_n_bits() {
        return this.n_bits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void encode(Base_Type.TTCN_Typedescriptor p_td, TTCN_Buffer p_buf, TTCN_EncDec.coding_type p_coding, int flavour) {
        switch (p_coding) {
            case CT_RAW: {
                TTCN_EncDec_ErrorContext errorContext = new TTCN_EncDec_ErrorContext("While RAW-encoding type '%s': ", p_td.name);
                try {
                    if (p_td.raw == null) {
                        TTCN_EncDec_ErrorContext.error_internal("No RAW descriptor available for type '%s'.", p_td.name);
                    }
                    RAW.RAW_enc_tr_pos tree_position = new RAW.RAW_enc_tr_pos(0, null);
                    RAW.RAW_enc_tree root = new RAW.RAW_enc_tree(true, null, tree_position, 1, p_td.raw);
                    this.RAW_encode(p_td, root);
                    root.put_to_buf(p_buf);
                    break;
                }
                finally {
                    errorContext.leave_context();
                }
            }
            case CT_JSON: {
                TTCN_EncDec_ErrorContext errorContext = new TTCN_EncDec_ErrorContext("While JSON-encoding type '%s': ", p_td.name);
                try {
                    if (p_td.json == null) {
                        TTCN_EncDec_ErrorContext.error_internal("No JSON descriptor available for type '%s'.", p_td.name);
                    }
                    JSON_Tokenizer tok = new JSON_Tokenizer(flavour != 0);
                    this.JSON_encode(p_td, tok);
                    StringBuilder temp = tok.get_buffer();
                    for (int i = 0; i < temp.length(); ++i) {
                        char temp2 = temp.charAt(i);
                        p_buf.put_c((byte)temp2);
                    }
                    break;
                }
                finally {
                    errorContext.leave_context();
                }
            }
            default: {
                throw new TtcnError(MessageFormat.format("Unknown coding method requested to encode type `{0}''", p_td.name));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void decode(Base_Type.TTCN_Typedescriptor p_td, TTCN_Buffer p_buf, TTCN_EncDec.coding_type p_coding, int flavour) {
        switch (p_coding) {
            case CT_RAW: {
                TTCN_EncDec_ErrorContext errorContext = new TTCN_EncDec_ErrorContext("While RAW-decoding type '%s': ", p_td.name);
                try {
                    TTCN_EncDec.raw_order_t order;
                    if (p_td.raw == null) {
                        TTCN_EncDec_ErrorContext.error_internal("No RAW descriptor available for type '%s'.", p_td.name);
                    }
                    TTCN_EncDec.raw_order_t raw_order_t2 = order = p_td.raw.top_bit_order == RAW.top_bit_order_t.TOP_BIT_LEFT ? TTCN_EncDec.raw_order_t.ORDER_LSB : TTCN_EncDec.raw_order_t.ORDER_MSB;
                    if (this.RAW_decode(p_td, p_buf, p_buf.get_len() * 8, order) >= 0) break;
                    TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_INCOMPL_MSG, "Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
                    break;
                }
                finally {
                    errorContext.leave_context();
                }
            }
            case CT_JSON: {
                TTCN_EncDec_ErrorContext errorContext = new TTCN_EncDec_ErrorContext("While JSON-decoding type '%s': ", p_td.name);
                try {
                    if (p_td.json == null) {
                        TTCN_EncDec_ErrorContext.error_internal("No JSON descriptor available for type '%s'.", p_td.name);
                    }
                    byte[] data = p_buf.get_data();
                    char[] temp = new char[data.length];
                    for (int i = 0; i < data.length; ++i) {
                        temp[i] = (char)data[i];
                    }
                    JSON_Tokenizer tok = new JSON_Tokenizer(new String(temp), p_buf.get_len());
                    if (this.JSON_decode(p_td, tok, false) < 0) {
                        TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_INCOMPL_MSG, "Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
                    }
                    p_buf.set_pos(tok.get_buf_pos());
                    break;
                }
                finally {
                    errorContext.leave_context();
                }
            }
            default: {
                throw new TtcnError(MessageFormat.format("Unknown coding method requested to decode type `{0}''", p_td.name));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int RAW_encode(Base_Type.TTCN_Typedescriptor p_td, RAW.RAW_enc_tree myleaf) {
        if (!this.is_bound()) {
            TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_UNBOUND, "Encoding an unbound value.", new Object[0]);
        }
        TTCN_EncDec_ErrorContext errorcontext = new TTCN_EncDec_ErrorContext();
        try {
            boolean orders;
            int align_length;
            int bl = this.n_bits;
            int n = align_length = p_td.raw.fieldlength != 0 ? p_td.raw.fieldlength - bl : 0;
            if (bl + align_length < this.n_bits) {
                TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_LEN_ERR, "There is no sufficient bits to encode '%s':", p_td.name);
                bl = p_td.raw.fieldlength;
                align_length = 0;
            }
            myleaf.data_array = new byte[this.bits_ptr.length];
            for (int i = 0; i < this.bits_ptr.length; ++i) {
                myleaf.data_array[i] = (byte)this.bits_ptr[i];
            }
            boolean bl2 = orders = p_td.raw.byteorder == TTCN_EncDec.raw_order_t.ORDER_MSB;
            if (p_td.raw.bitorderinfield == TTCN_EncDec.raw_order_t.ORDER_LSB) {
                orders = !orders;
            }
            myleaf.coding_par.byteorder = orders ? TTCN_EncDec.raw_order_t.ORDER_MSB : TTCN_EncDec.raw_order_t.ORDER_LSB;
            boolean bl3 = orders = p_td.raw.bitorderinoctet == TTCN_EncDec.raw_order_t.ORDER_MSB;
            if (p_td.raw.bitorderinfield == TTCN_EncDec.raw_order_t.ORDER_LSB) {
                orders = !orders;
            }
            myleaf.coding_par.bitorder = orders ? TTCN_EncDec.raw_order_t.ORDER_MSB : TTCN_EncDec.raw_order_t.ORDER_LSB;
            myleaf.coding_par.csn1lh = p_td.raw.csn1lh;
            myleaf.align = p_td.raw.endianness == TTCN_EncDec.raw_order_t.ORDER_MSB ? align_length : -align_length;
            int n2 = myleaf.length = bl + align_length;
            return n2;
        }
        finally {
            errorcontext.leave_context();
        }
    }

    @Override
    public int RAW_decode(Base_Type.TTCN_Typedescriptor p_td, TTCN_Buffer buff, int limit, TTCN_EncDec.raw_order_t top_bit_ord) {
        return this.RAW_decode(p_td, buff, limit, top_bit_ord, false, -1, true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int RAW_decode(Base_Type.TTCN_Typedescriptor p_td, TTCN_Buffer buff, int limit, TTCN_EncDec.raw_order_t top_bit_ord, boolean no_err, int sel_field, boolean first_call, RAW.RAW_Force_Omit force_omit) {
        int prepaddlength = buff.increase_pos_padd(p_td.raw.prepadding);
        int decode_length = p_td.raw.fieldlength == 0 ? (limit -= prepaddlength) : p_td.raw.fieldlength;
        TTCN_EncDec_ErrorContext errorcontext = new TTCN_EncDec_ErrorContext();
        try {
            boolean orders;
            if (p_td.raw.fieldlength > limit || p_td.raw.fieldlength > buff.unread_len_bit()) {
                if (no_err) {
                    int n = -TTCN_EncDec.error_type.ET_LEN_ERR.ordinal();
                    return n;
                }
                TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_LEN_ERR, "There is not enough bits in the buffer to decode type %s.", p_td.name);
                decode_length = limit > buff.unread_len_bit() ? buff.unread_len_bit() : limit;
            }
            this.clean_up();
            this.n_bits = decode_length;
            this.bits_ptr = new int[(decode_length + 7) / 8];
            RAW.RAW_coding_par cp = new RAW.RAW_coding_par();
            boolean bl = orders = p_td.raw.bitorderinoctet == TTCN_EncDec.raw_order_t.ORDER_MSB;
            if (p_td.raw.bitorderinfield == TTCN_EncDec.raw_order_t.ORDER_LSB) {
                orders = !orders;
            }
            cp.bitorder = orders ? TTCN_EncDec.raw_order_t.ORDER_MSB : TTCN_EncDec.raw_order_t.ORDER_LSB;
            boolean bl2 = orders = p_td.raw.byteorder == TTCN_EncDec.raw_order_t.ORDER_MSB;
            if (p_td.raw.bitorderinfield == TTCN_EncDec.raw_order_t.ORDER_LSB) {
                orders = !orders;
            }
            cp.byteorder = orders ? TTCN_EncDec.raw_order_t.ORDER_MSB : TTCN_EncDec.raw_order_t.ORDER_LSB;
            cp.fieldorder = p_td.raw.fieldorder;
            cp.hexorder = TTCN_EncDec.raw_order_t.ORDER_LSB;
            cp.csn1lh = p_td.raw.csn1lh;
            byte[] tmp_bits = new byte[this.bits_ptr.length];
            buff.get_b(decode_length, tmp_bits, cp, top_bit_ord);
            for (int i = 0; i < tmp_bits.length; ++i) {
                this.bits_ptr[i] = tmp_bits[i] & 0xFF;
            }
            if (p_td.raw.length_restrition != -1 && decode_length > p_td.raw.length_restrition) {
                this.n_bits = p_td.raw.length_restrition;
                if (p_td.raw.endianness == TTCN_EncDec.raw_order_t.ORDER_LSB) {
                    if ((decode_length - this.n_bits) % 8 != 0) {
                        int bound = (decode_length - this.n_bits) % 8;
                        int maxindex = (decode_length - 1) / 8;
                        int a = 0;
                        int b = (decode_length - this.n_bits - 1) / 8;
                        while (a < (this.n_bits + 7) / 8) {
                            this.bits_ptr[a] = this.bits_ptr[b] >> bound;
                            if (b < maxindex) {
                                this.bits_ptr[a] = this.bits_ptr[b + 1] << 8 - bound;
                            }
                            ++a;
                            ++b;
                        }
                    } else {
                        System.arraycopy(this.bits_ptr, (decode_length - this.n_bits) / 8, this.bits_ptr, 0, this.n_bits / 8);
                    }
                }
            }
            this.clear_unused_bits();
        }
        finally {
            errorcontext.leave_context();
        }
        return (decode_length += buff.increase_pos_padd(p_td.raw.padding)) + prepaddlength;
    }

    @Override
    public int JSON_encode(Base_Type.TTCN_Typedescriptor p_td, JSON_Tokenizer p_tok, boolean p_parent_is_map) {
        if (!this.is_bound()) {
            TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_UNBOUND, "Encoding an unbound bitstring value.", new Object[0]);
            return -1;
        }
        StringBuilder tmp_str = new StringBuilder();
        tmp_str.append('\"');
        for (int i = 0; i < this.n_bits; ++i) {
            tmp_str.append(this.get_bit(i) ? (char)'1' : '0');
        }
        tmp_str.append('\"');
        int enc_len = p_tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_STRING, tmp_str.toString());
        return enc_len;
    }

    @Override
    public int JSON_decode(Base_Type.TTCN_Typedescriptor p_td, JSON_Tokenizer p_tok, boolean p_silent, boolean p_parent_is_map, int p_chosen_field) {
        AtomicReference<JSON_Tokenizer.json_token_t> token = new AtomicReference<JSON_Tokenizer.json_token_t>(JSON_Tokenizer.json_token_t.JSON_TOKEN_NONE);
        StringBuilder value = new StringBuilder();
        AtomicInteger value_len = new AtomicInteger(0);
        boolean error = false;
        if (p_td.json.getActualDefaultValue() != null && 0 == p_tok.get_buffer_length()) {
            this.operator_assign(p_td.json.getActualDefaultValue());
            return 0;
        }
        int dec_len = p_tok.get_next_token(token, value, value_len);
        if (JSON_Tokenizer.json_token_t.JSON_TOKEN_ERROR == token.get()) {
            if (!p_silent) {
                TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_INVAL_MSG, "Failed to extract valid token, invalid JSON format%s", "");
            }
            return -2;
        }
        if (JSON_Tokenizer.json_token_t.JSON_TOKEN_STRING == token.get()) {
            if (value_len.get() >= 2 && value.charAt(0) == '\"' && value.charAt(value_len.get() - 1) == '\"') {
                String valueWithoutQuotes = value.substring(1, value.length() - 1);
                value.setLength(0);
                value.append(valueWithoutQuotes);
                value_len.set(value.length());
                int bits = value_len.get();
                for (int i = 0; i < value_len.get(); ++i) {
                    if (value.charAt(i) == ' ') {
                        --bits;
                        continue;
                    }
                    if (value.charAt(i) == '0' || value.charAt(i) == '1') continue;
                    if (value.charAt(i) == '\\' && i + 1 < value_len.get() && (value.charAt(i + 1) == 'n' || value.charAt(i + 1) == 'r' || value.charAt(i + 1) == 't')) {
                        ++i;
                        bits -= 2;
                        continue;
                    }
                    error = true;
                    break;
                }
                if (!error) {
                    this.init_struct(bits);
                    int bit_index = 0;
                    for (int i = 0; i < value_len.get(); ++i) {
                        if (value.charAt(i) != '0' && value.charAt(i) != '1') continue;
                        this.set_bit(bit_index, value.charAt(i) - 48 != 0);
                        ++bit_index;
                    }
                }
            } else {
                error = true;
            }
        } else {
            return -1;
        }
        if (error) {
            if (!p_silent) {
                TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_INVAL_MSG, "Invalid JSON %s format, expecting %s value", "string", "bitstring");
            }
            return -2;
        }
        return dec_len;
    }

    private void init_struct(int n_bits) {
        if (n_bits < 0) {
            this.bits_ptr = null;
            this.n_bits = 0;
            throw new TtcnError("Initializing a bitstring with a negative length.");
        }
        if (n_bits == 0) {
            this.bits_ptr = new int[0];
            this.n_bits = 0;
        } else {
            this.bits_ptr = new int[(n_bits + 7) / 8];
            this.n_bits = n_bits;
        }
    }

    public static TitanBitString convert_to_BitString(TitanBitString otherValue) {
        return otherValue;
    }

    public static TitanBitString convert_to_BitString(TitanBitString_Element otherValue) {
        return new TitanBitString(otherValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TitanInteger convert_to_Integer(Base_Type.TTCN_Typedescriptor p_td) {
        TTCN_EncDec_ErrorContext errorContext = new TTCN_EncDec_ErrorContext("While converting to integer type '%s': ", p_td.name);
        try {
            TitanInteger titanInteger = AdditionalFunctions.bit2int(this);
            return titanInteger;
        }
        finally {
            errorContext.leave_context();
        }
    }
}

