/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.runtime.core;

import java.text.MessageFormat;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.titan.runtime.core.TTCN_Logger;
import org.eclipse.titan.runtime.core.TitanUniversalCharString;
import org.eclipse.titan.runtime.core.TtcnError;

public final class TTCN_EncDec {
    public static final int BER_ENCODE_CER = 1;
    public static final int BER_ENCODE_DER = 2;
    public static final int BER_ACCEPT_SHORT = 1;
    public static final int BER_ACCEPT_LONG = 2;
    public static final int BER_ACCEPT_INDEFINITE = 4;
    public static final int BER_ACCEPT_DEFINITE = 3;
    public static final int BER_ACCEPT_ALL = 7;
    public static final int XER_EXTENDED = 4;
    private static error_type last_error_type = error_type.ET_NONE;
    private static String error_str;
    public static final byte CSN1_L_H_Mask = 43;
    private static final error_behavior_type[] default_error_behavior;
    private static final error_behavior_type[] error_behavior;

    public static void set_error_behavior(error_type p_et, error_behavior_type p_eb) {
        if (p_et.ordinal() < error_type.ET_UNDEF.ordinal() || p_et.ordinal() > error_type.ET_ALL.ordinal() || p_eb.ordinal() < error_behavior_type.EB_DEFAULT.ordinal() || p_eb.ordinal() > error_behavior_type.EB_IGNORE.ordinal()) {
            throw new TtcnError("TTCN_EncDec.set_error_behavior(): Invalid parameter.");
        }
        if (p_eb == error_behavior_type.EB_DEFAULT) {
            if (p_et == error_type.ET_ALL) {
                System.arraycopy(default_error_behavior, error_type.ET_UNDEF.ordinal(), error_behavior, error_type.ET_UNDEF.ordinal(), error_type.ET_ALL.ordinal());
            } else {
                TTCN_EncDec.error_behavior[p_et.ordinal()] = default_error_behavior[p_et.ordinal()];
            }
        } else if (p_et == error_type.ET_ALL) {
            for (int i = error_type.ET_UNDEF.ordinal(); i < error_type.ET_ALL.ordinal(); ++i) {
                TTCN_EncDec.error_behavior[i] = p_eb;
            }
        } else {
            TTCN_EncDec.error_behavior[p_et.ordinal()] = p_eb;
        }
    }

    public static error_behavior_type get_error_behavior(error_type p_et) {
        if (p_et.ordinal() < error_type.ET_UNDEF.ordinal() || p_et.ordinal() >= error_type.ET_ALL.ordinal()) {
            throw new TtcnError("TTCN_EncDec.get_error_behavior(): Invalid parameter.");
        }
        return error_behavior[p_et.ordinal()];
    }

    public static error_behavior_type get_default_error_behavior(error_type p_et) {
        if (p_et.ordinal() < error_type.ET_UNDEF.ordinal() || p_et.ordinal() >= error_type.ET_ALL.ordinal()) {
            throw new TtcnError("TTCN_EncDec.get_default_error_behavior(): Invalid parameter.");
        }
        return default_error_behavior[p_et.ordinal()];
    }

    public static error_type get_last_error_type() {
        return last_error_type;
    }

    public static String get_error_str() {
        return error_str;
    }

    public static void clear_error() {
        last_error_type = error_type.ET_NONE;
        error_str = null;
    }

    public static void error(error_type p_et, String msg) {
        last_error_type = p_et;
        error_str = "";
        error_str = msg;
        if (p_et.ordinal() >= error_type.ET_UNDEF.ordinal() && p_et.ordinal() < error_type.ET_ALL.ordinal()) {
            switch (error_behavior[p_et.ordinal()]) {
                case EB_ERROR: {
                    throw new TtcnError(error_str);
                }
                case EB_WARNING: {
                    TtcnError.TtcnWarning(error_str);
                    break;
                }
            }
        }
    }

    public static coding_type get_coding_from_str(TitanUniversalCharString coding_str, AtomicInteger extra, boolean encode) {
        if (coding_str.operator_equals("BER:2002") || coding_str.operator_equals("DER:2002")) {
            if (encode) {
                extra.set(2);
            } else {
                extra.set(7);
            }
            return coding_type.CT_BER;
        }
        if (coding_str.operator_equals("CER:2002")) {
            if (encode) {
                extra.set(1);
            } else {
                extra.set(7);
            }
            return coding_type.CT_BER;
        }
        if (coding_str.operator_equals("RAW")) {
            return coding_type.CT_RAW;
        }
        if (coding_str.operator_equals("TEXT")) {
            return coding_type.CT_TEXT;
        }
        if (coding_str.operator_equals("JSON")) {
            return coding_type.CT_JSON;
        }
        if (coding_str.operator_equals("XML") || coding_str.operator_equals("XER")) {
            if (extra != null) {
                extra.set(4);
            }
            return coding_type.CT_XER;
        }
        if (coding_str.operator_equals("OER")) {
            return coding_type.CT_OER;
        }
        TTCN_Logger.begin_event_log2str();
        coding_str.log();
        throw new TtcnError(MessageFormat.format("Invalid encoding string: {0}", TTCN_Logger.end_event_log2str()));
    }

    static {
        default_error_behavior = new error_behavior_type[]{error_behavior_type.EB_ERROR, error_behavior_type.EB_ERROR, error_behavior_type.EB_ERROR, error_behavior_type.EB_WARNING, error_behavior_type.EB_ERROR, error_behavior_type.EB_WARNING, error_behavior_type.EB_ERROR, error_behavior_type.EB_WARNING, error_behavior_type.EB_WARNING, error_behavior_type.EB_ERROR, error_behavior_type.EB_ERROR, error_behavior_type.EB_ERROR, error_behavior_type.EB_ERROR, error_behavior_type.EB_ERROR, error_behavior_type.EB_WARNING, error_behavior_type.EB_WARNING, error_behavior_type.EB_WARNING, error_behavior_type.EB_ERROR, error_behavior_type.EB_ERROR, error_behavior_type.EB_ERROR, error_behavior_type.EB_ERROR, error_behavior_type.EB_IGNORE, error_behavior_type.EB_WARNING, error_behavior_type.EB_ERROR, error_behavior_type.EB_ERROR, error_behavior_type.EB_ERROR, error_behavior_type.EB_WARNING};
        error_behavior = new error_behavior_type[]{error_behavior_type.EB_ERROR, error_behavior_type.EB_ERROR, error_behavior_type.EB_ERROR, error_behavior_type.EB_WARNING, error_behavior_type.EB_ERROR, error_behavior_type.EB_WARNING, error_behavior_type.EB_ERROR, error_behavior_type.EB_WARNING, error_behavior_type.EB_WARNING, error_behavior_type.EB_ERROR, error_behavior_type.EB_ERROR, error_behavior_type.EB_ERROR, error_behavior_type.EB_ERROR, error_behavior_type.EB_ERROR, error_behavior_type.EB_WARNING, error_behavior_type.EB_WARNING, error_behavior_type.EB_WARNING, error_behavior_type.EB_ERROR, error_behavior_type.EB_ERROR, error_behavior_type.EB_ERROR, error_behavior_type.EB_ERROR, error_behavior_type.EB_IGNORE, error_behavior_type.EB_WARNING, error_behavior_type.EB_ERROR, error_behavior_type.EB_ERROR, error_behavior_type.EB_ERROR, error_behavior_type.EB_WARNING};
    }

    public static enum error_behavior_type {
        EB_DEFAULT,
        EB_ERROR,
        EB_WARNING,
        EB_IGNORE;

    }

    public static enum error_type {
        ET_UNDEF,
        ET_UNBOUND,
        ET_INCOMPL_ANY,
        ET_ENC_ENUM,
        ET_INCOMPL_MSG,
        ET_LEN_FORM,
        ET_INVAL_MSG,
        ET_REPR,
        ET_CONSTRAINT,
        ET_TAG,
        ET_SUPERFL,
        ET_EXTENSION,
        ET_DEC_ENUM,
        ET_DEC_DUPFLD,
        ET_DEC_MISSFLD,
        ET_DEC_OPENTYPE,
        ET_DEC_UCSTR,
        ET_LEN_ERR,
        ET_SIGN_ERR,
        ET_INCOMP_ORDER,
        ET_TOKEN_ERR,
        ET_LOG_MATCHING,
        ET_FLOAT_TR,
        ET_FLOAT_NAN,
        ET_OMITTED_TAG,
        ET_NEGTEST_CONFL,
        ET_EXTRA_DATA,
        ET_ALL,
        ET_INTERNAL,
        ET_NONE;

    }

    public static enum coding_type {
        CT_BER,
        CT_PER,
        CT_RAW,
        CT_TEXT,
        CT_XER,
        CT_JSON,
        CT_OER;

    }

    public static enum raw_order_t {
        ORDER_MSB,
        ORDER_LSB;

    }
}

