/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.runtime.core;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.eclipse.titan.runtime.core.Module_List;
import org.eclipse.titan.runtime.core.Module_Param_Length_Restriction;
import org.eclipse.titan.runtime.core.TTCN_Logger;
import org.eclipse.titan.runtime.core.TitanBitString;
import org.eclipse.titan.runtime.core.TitanBitString_template;
import org.eclipse.titan.runtime.core.TitanBoolean;
import org.eclipse.titan.runtime.core.TitanCharString;
import org.eclipse.titan.runtime.core.TitanFloat;
import org.eclipse.titan.runtime.core.TitanHexString;
import org.eclipse.titan.runtime.core.TitanHexString_template;
import org.eclipse.titan.runtime.core.TitanInteger;
import org.eclipse.titan.runtime.core.TitanObjectid;
import org.eclipse.titan.runtime.core.TitanOctetString;
import org.eclipse.titan.runtime.core.TitanOctetString_template;
import org.eclipse.titan.runtime.core.TitanUniversalChar;
import org.eclipse.titan.runtime.core.TitanUniversalCharString;
import org.eclipse.titan.runtime.core.TitanVerdictType;
import org.eclipse.titan.runtime.core.TtcnError;

public final class Param_Types {

    public static class Module_Param_Permutation_Template
    extends Module_Param_Compound {
        @Override
        public Module_Parameter.type_t get_type() {
            return Module_Parameter.type_t.MP_Permutation_Template;
        }

        public String get_type_str() {
            return "permutation template";
        }

        @Override
        public void log_value() {
            this.log_value_vec("permutation(", ")");
        }
    }

    public static class Module_Param_Subset_Template
    extends Module_Param_Compound {
        @Override
        public Module_Parameter.type_t get_type() {
            return Module_Parameter.type_t.MP_Subset_Template;
        }

        public String get_type_str() {
            return "subset template";
        }

        @Override
        public void log_value() {
            this.log_value_vec("subset(", ")");
        }
    }

    public static class Module_Param_Superset_Template
    extends Module_Param_Compound {
        @Override
        public Module_Parameter.type_t get_type() {
            return Module_Parameter.type_t.MP_Superset_Template;
        }

        public String get_type_str() {
            return "superset template";
        }

        @Override
        public void log_value() {
            this.log_value_vec("superset(", ")");
        }
    }

    public static class Module_Param_ConjunctionList_Template
    extends Module_Param_Compound {
        @Override
        public Module_Parameter.type_t get_type() {
            return Module_Parameter.type_t.MP_ConjunctionList_Template;
        }

        public String get_type_str() {
            return "conjunction list template";
        }

        @Override
        public void log_value() {
            this.log_value_vec("conjunct(", ")");
        }
    }

    public static class Module_Param_ComplementList_Template
    extends Module_Param_Compound {
        @Override
        public Module_Parameter.type_t get_type() {
            return Module_Parameter.type_t.MP_ComplementList_Template;
        }

        public String get_type_str() {
            return "complemented list template";
        }

        @Override
        public void log_value() {
            this.log_value_vec("complement(", ")");
        }
    }

    public static class Module_Param_List_Template
    extends Module_Param_Compound {
        @Override
        public Module_Parameter.type_t get_type() {
            return Module_Parameter.type_t.MP_List_Template;
        }

        public String get_type_str() {
            return "list template";
        }

        @Override
        public void log_value() {
            this.log_value_vec("(", ")");
        }
    }

    public static class Module_Param_Indexed_List
    extends Module_Param_Compound {
        @Override
        public Module_Parameter.type_t get_type() {
            return Module_Parameter.type_t.MP_Indexed_List;
        }

        public String get_type_str() {
            return "indexed value list";
        }

        @Override
        public void log_value() {
            this.log_value_vec("{", "}");
        }
    }

    public static class Module_Param_Value_List
    extends Module_Param_Compound {
        @Override
        public Module_Parameter.type_t get_type() {
            return Module_Parameter.type_t.MP_Value_List;
        }

        public String get_type_str() {
            return "value list";
        }

        @Override
        public void log_value() {
            this.log_value_vec("{", "}");
        }
    }

    public static class Module_Param_Assignment_List
    extends Module_Param_Compound {
        @Override
        public Module_Parameter.type_t get_type() {
            return Module_Parameter.type_t.MP_Assignment_List;
        }

        public String get_type_str() {
            return "list with assignment notation";
        }

        @Override
        public void log_value() {
            this.log_value_vec("{", "}");
        }
    }

    public static class Module_Param_Compound
    extends Module_Parameter {
        private final List<Module_Parameter> values = new ArrayList<Module_Parameter>();

        @Override
        public int get_size() {
            return this.values.size();
        }

        @Override
        public Module_Parameter get_elem(int index) {
            if (index >= this.values.size()) {
                throw new TtcnError("Internal error: Module_Param.get_elem(): index overflow");
            }
            return this.values.get(index);
        }

        public void log_value_vec(String begin_str, String end_str) {
            TTCN_Logger.log_event_str(begin_str);
            TTCN_Logger.log_event_str(" ");
            for (int i = 0; i < this.values.size(); ++i) {
                if (i > 0) {
                    TTCN_Logger.log_event_str(", ");
                }
                this.values.get(i).log(true);
            }
            if (!this.values.isEmpty()) {
                TTCN_Logger.log_event_str(" ");
            }
            TTCN_Logger.log_event_str(end_str);
        }

        @Override
        public void add_elem(Module_Parameter value) {
            value.set_parent(this);
            this.values.add(value);
        }

        @Override
        public void add_list_with_implicit_ids(List<Module_Parameter> mp_list) {
            for (int i = 0; i < mp_list.size(); ++i) {
                Module_Parameter mp_current = mp_list.get(i);
                mp_current.set_id(new Module_Param_Index(this.get_size(), false));
                this.add_elem(mp_current);
            }
        }

        @Override
        public void log_value() {
        }

        @Override
        public Module_Parameter.type_t get_type() {
            return null;
        }
    }

    public static class Module_Param_CustomName
    extends Module_Param_Id {
        private final String name;

        public Module_Param_CustomName(String p) {
            this.name = p;
        }

        @Override
        public String get_name() {
            return this.name;
        }

        @Override
        public boolean is_explicit() {
            return true;
        }

        @Override
        public String get_str() {
            return this.name;
        }

        @Override
        public boolean is_custom() {
            return true;
        }
    }

    public static class Module_Param_Index
    extends Module_Param_Id {
        private final int index;
        private final boolean is_expl;

        public Module_Param_Index(int p_index, boolean p_is_expl) {
            this.index = p_index;
            this.is_expl = p_is_expl;
        }

        @Override
        public int get_index() {
            return this.index;
        }

        @Override
        public boolean is_index() {
            return true;
        }

        @Override
        public boolean is_explicit() {
            return this.is_expl;
        }

        @Override
        public String get_str() {
            return '[' + String.valueOf(this.index) + ']';
        }
    }

    public static class Module_Param_FieldName
    extends Module_Param_Id {
        private final String name;

        public Module_Param_FieldName(String p) {
            this.name = p;
        }

        @Override
        public String get_name() {
            return this.name;
        }

        @Override
        public boolean is_explicit() {
            return true;
        }

        @Override
        public String get_str() {
            return this.name;
        }
    }

    public static class Module_Param_Name
    extends Module_Param_Id {
        private final List<String> names;
        private int pos;

        public Module_Param_Name(List<String> p) {
            this.names = p;
            this.pos = 0;
        }

        @Override
        public boolean is_explicit() {
            return true;
        }

        @Override
        public String get_current_name() {
            return this.names.get(this.pos);
        }

        @Override
        public boolean next_name() {
            if (this.pos + 1 >= this.names.size()) {
                return false;
            }
            ++this.pos;
            return true;
        }

        @Override
        public void reset() {
            this.pos = 0;
        }

        @Override
        public int get_nof_names() {
            return this.names.size();
        }

        @Override
        public String get_str() {
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < this.names.size(); ++i) {
                boolean index;
                boolean bl = index = this.names.get(i).charAt(0) >= '0' && this.names.get(i).charAt(0) <= '9';
                if (i > 0 && !index) {
                    result.append('.');
                }
                if (index) {
                    result.append('[');
                }
                result.append(this.names.get(i));
                if (!index) continue;
                result.append(']');
            }
            return result.toString();
        }
    }

    public static class Module_Param_Id {
        public boolean is_explicit() {
            return false;
        }

        public boolean is_index() {
            return false;
        }

        public boolean is_custom() {
            return false;
        }

        public int get_index() {
            throw new TtcnError("Internal error: Module_Param_Id.get_index()");
        }

        public String get_name() {
            throw new TtcnError("Internal error: Module_Param_Id.get_name()");
        }

        public String get_current_name() {
            throw new TtcnError("Internal error: Module_Param_Id.get_current_name()");
        }

        public boolean next_name() {
            throw new TtcnError("Internal error: Module_Param_Id.next_name()");
        }

        public void reset() {
            throw new TtcnError("Internal error: Module_Param_Id.reset()");
        }

        public int get_nof_names() {
            throw new TtcnError("Internal error: Module_Param_Id.get_nof_names()");
        }

        public String get_str() {
            return "";
        }
    }

    public static class Module_Param_Octetstring_Template
    extends Module_Parameter {
        private final TitanOctetString_template ostr_template;

        @Override
        public Module_Parameter.type_t get_type() {
            return Module_Parameter.type_t.MP_Octetstring_Template;
        }

        public Module_Param_Octetstring_Template(String p_c) {
            this.ostr_template = new TitanOctetString_template(p_c);
        }

        public String get_type_str() {
            return "octetstring template";
        }

        @Override
        public void log_value() {
            this.ostr_template.log();
        }

        @Override
        public Object get_string_data() {
            return this.ostr_template;
        }
    }

    public static class Module_Param_Hexstring_Template
    extends Module_Parameter {
        private final TitanHexString_template hstr_template;

        @Override
        public Module_Parameter.type_t get_type() {
            return Module_Parameter.type_t.MP_Hexstring_Template;
        }

        public Module_Param_Hexstring_Template(String p_c) {
            this.hstr_template = new TitanHexString_template(p_c);
        }

        public String get_type_str() {
            return "hexstring template";
        }

        @Override
        public void log_value() {
            this.hstr_template.log();
        }

        @Override
        public Object get_string_data() {
            return this.hstr_template;
        }
    }

    public static class Module_Param_Bitstring_Template
    extends Module_Parameter {
        private final TitanBitString_template bstr_template;

        @Override
        public Module_Parameter.type_t get_type() {
            return Module_Parameter.type_t.MP_Bitstring_Template;
        }

        public Module_Param_Bitstring_Template(String p_c) {
            this.bstr_template = new TitanBitString_template(p_c);
        }

        public String get_type_str() {
            return "bitstring template";
        }

        @Override
        public void log_value() {
            this.bstr_template.log();
        }

        @Override
        public Object get_string_data() {
            return this.bstr_template;
        }
    }

    public static class Module_Param_Pattern
    extends Module_Parameter {
        private final String pattern;
        private final boolean nocase;

        @Override
        public Module_Parameter.type_t get_type() {
            return Module_Parameter.type_t.MP_Pattern;
        }

        public Module_Param_Pattern(String p_p, boolean p_nc) {
            this.pattern = p_p;
            this.nocase = p_nc;
        }

        @Override
        public String get_pattern() {
            return this.pattern;
        }

        @Override
        public boolean get_nocase() {
            return this.nocase;
        }

        public String get_type_str() {
            return "pattern";
        }

        @Override
        public void log_value() {
            TTCN_Logger.log_event_str("pattern ");
            if (this.nocase) {
                TTCN_Logger.log_event_str("@nocase ");
            }
            TTCN_Logger.log_event_str("\"");
            TTCN_Logger.log_event_str(this.pattern);
            TTCN_Logger.log_event_str("\"");
        }
    }

    public static class Module_Param_StringRange
    extends Module_Parameter {
        private final TitanUniversalChar lower_bound;
        private final TitanUniversalChar upper_bound;
        private final boolean min_exclusive;
        private final boolean max_exclusive;

        @Override
        public Module_Parameter.type_t get_type() {
            return Module_Parameter.type_t.MP_StringRange;
        }

        public Module_Param_StringRange(TitanUniversalChar p_lb, TitanUniversalChar p_ub, boolean min_is_exclusive, boolean max_is_exclusive) {
            this.lower_bound = p_lb;
            this.upper_bound = p_ub;
            this.min_exclusive = min_is_exclusive;
            this.max_exclusive = max_is_exclusive;
        }

        @Override
        public TitanUniversalChar get_lower_uchar() {
            return this.lower_bound;
        }

        @Override
        public TitanUniversalChar get_upper_uchar() {
            return this.upper_bound;
        }

        public String get_type_str() {
            return "char range";
        }

        @Override
        public boolean get_is_min_exclusive() {
            return this.min_exclusive;
        }

        @Override
        public boolean get_is_max_exclusive() {
            return this.max_exclusive;
        }

        @Override
        public void log_value() {
            TTCN_Logger.log_event_str("(");
            new TitanUniversalCharString(this.lower_bound).log();
            TTCN_Logger.log_event_str("..");
            new TitanUniversalCharString(this.upper_bound).log();
            TTCN_Logger.log_event_str(")");
        }
    }

    public static class Module_Param_FloatRange
    extends Module_Parameter {
        private final double lower_bound;
        private final boolean has_lower;
        private final double upper_bound;
        private final boolean has_upper;
        private final boolean min_exclusive;
        private final boolean max_exclusive;

        @Override
        public Module_Parameter.type_t get_type() {
            return Module_Parameter.type_t.MP_FloatRange;
        }

        public Module_Param_FloatRange(double p_lb, boolean p_hl, double p_ub, boolean p_hu, boolean min_is_exclusive, boolean max_is_exclusive) {
            this.lower_bound = p_lb;
            this.has_lower = p_hl;
            this.upper_bound = p_ub;
            this.has_upper = p_hu;
            this.min_exclusive = min_is_exclusive;
            this.max_exclusive = max_is_exclusive;
        }

        @Override
        public double get_lower_float() {
            return this.lower_bound;
        }

        @Override
        public double get_upper_float() {
            return this.upper_bound;
        }

        @Override
        public boolean has_lower_float() {
            return this.has_lower;
        }

        @Override
        public boolean has_upper_float() {
            return this.has_upper;
        }

        public String get_type_str() {
            return "float range";
        }

        @Override
        public boolean get_is_min_exclusive() {
            return this.min_exclusive;
        }

        @Override
        public boolean get_is_max_exclusive() {
            return this.max_exclusive;
        }

        @Override
        public void log_value() {
            TTCN_Logger.log_event_str("(");
            if (this.has_lower) {
                new TitanFloat(this.lower_bound).log();
            } else {
                TTCN_Logger.log_event_str("-infinity");
            }
            TTCN_Logger.log_event_str("..");
            if (this.has_upper) {
                new TitanFloat(this.upper_bound).log();
            } else {
                TTCN_Logger.log_event_str("infinity");
            }
            TTCN_Logger.log_event_str(")");
        }
    }

    public static class Module_Param_IntRange
    extends Module_Parameter {
        private final TitanInteger lower_bound;
        private final TitanInteger upper_bound;
        private final boolean min_exclusive;
        private final boolean max_exclusive;

        public Module_Param_IntRange(TitanInteger p_l, TitanInteger p_u, boolean min_is_exclusive, boolean max_is_exclusive) {
            this.lower_bound = p_l;
            this.upper_bound = p_u;
            this.min_exclusive = min_is_exclusive;
            this.max_exclusive = max_is_exclusive;
        }

        @Override
        public TitanInteger get_lower_int() {
            return this.lower_bound;
        }

        @Override
        public TitanInteger get_upper_int() {
            return this.upper_bound;
        }

        @Override
        public Module_Parameter.type_t get_type() {
            return Module_Parameter.type_t.MP_IntRange;
        }

        public String get_type_str() {
            return "integer range";
        }

        @Override
        public boolean get_is_min_exclusive() {
            return this.min_exclusive;
        }

        @Override
        public boolean get_is_max_exclusive() {
            return this.max_exclusive;
        }

        @Override
        public void log_value() {
            TTCN_Logger.log_event_str("(");
            Module_Param_IntRange.log_bound(this.lower_bound, true);
            TTCN_Logger.log_event_str("..");
            Module_Param_IntRange.log_bound(this.upper_bound, false);
            TTCN_Logger.log_event_str(")");
        }

        public static void log_bound(TitanInteger bound, boolean is_lower) {
            if (bound == null) {
                if (is_lower) {
                    TTCN_Logger.log_event_str("-");
                }
                TTCN_Logger.log_event_str("infinity");
            } else if (bound.is_native()) {
                bound.log();
            } else {
                bound.log();
            }
        }
    }

    public static class Module_Param_AnyOrNone
    extends Module_Parameter {
        @Override
        public Module_Parameter.type_t get_type() {
            return Module_Parameter.type_t.MP_AnyOrNone;
        }

        public String get_type_str() {
            return "*";
        }

        @Override
        public void log_value() {
            TTCN_Logger.log_event_str("*");
        }
    }

    public static class Module_Param_Any
    extends Module_Parameter {
        @Override
        public Module_Parameter.type_t get_type() {
            return Module_Parameter.type_t.MP_Any;
        }

        public String get_type_str() {
            return "?";
        }

        @Override
        public void log_value() {
            TTCN_Logger.log_event_str("?");
        }
    }

    public static class Module_Param_Asn_Null
    extends Module_Parameter {
        @Override
        public Module_Parameter.type_t get_type() {
            return Module_Parameter.type_t.MP_Asn_Null;
        }

        public String get_type_str() {
            return "NULL";
        }

        @Override
        public void log_value() {
            TTCN_Logger.log_event_str("NULL");
        }
    }

    public static class Module_Param_Ttcn_system
    extends Module_Parameter {
        @Override
        public Module_Parameter.type_t get_type() {
            return Module_Parameter.type_t.MP_Ttcn_system;
        }

        public String get_type_str() {
            return "system";
        }

        @Override
        public void log_value() {
            TTCN_Logger.log_event_str("system");
        }
    }

    public static class Module_Param_Ttcn_mtc
    extends Module_Parameter {
        @Override
        public Module_Parameter.type_t get_type() {
            return Module_Parameter.type_t.MP_Ttcn_mtc;
        }

        public String get_type_str() {
            return "mtc";
        }

        @Override
        public void log_value() {
            TTCN_Logger.log_event_str("mtc");
        }
    }

    public static class Module_Param_Ttcn_Null
    extends Module_Parameter {
        @Override
        public Module_Parameter.type_t get_type() {
            return Module_Parameter.type_t.MP_Ttcn_Null;
        }

        public String get_type_str() {
            return "null";
        }

        @Override
        public void log_value() {
            TTCN_Logger.log_event_str("null");
        }
    }

    public static class Module_Param_Omit
    extends Module_Parameter {
        @Override
        public Module_Parameter.type_t get_type() {
            return Module_Parameter.type_t.MP_Omit;
        }

        public String get_type_str() {
            return "omit";
        }

        @Override
        public void log_value() {
            TTCN_Logger.log_event_str("omit");
        }
    }

    public static class Module_Param_Universal_Charstring
    extends Module_Parameter {
        private final TitanUniversalCharString ucstr;

        @Override
        public Module_Parameter.type_t get_type() {
            return Module_Parameter.type_t.MP_Universal_Charstring;
        }

        public Module_Param_Universal_Charstring(TitanUniversalCharString p_ucstr) {
            this.ucstr = p_ucstr;
        }

        public String get_type_str() {
            return "universal charstring";
        }

        @Override
        public void log_value() {
            this.ucstr.log();
        }

        @Override
        public Object get_string_data() {
            return this.ucstr;
        }
    }

    public static class Module_Param_Charstring
    extends Module_Parameter {
        private final TitanCharString cstr;

        @Override
        public Module_Parameter.type_t get_type() {
            return Module_Parameter.type_t.MP_Charstring;
        }

        public Module_Param_Charstring(TitanCharString p_cstr) {
            this.cstr = p_cstr;
        }

        public String get_type_str() {
            return "charstring";
        }

        @Override
        public void log_value() {
            this.cstr.log();
        }

        @Override
        public Object get_string_data() {
            return this.cstr.get_value().toString();
        }

        @Override
        public int get_string_size() {
            return this.cstr.get_value().length();
        }

        @Override
        public TitanCharString get_charstring() {
            return this.cstr;
        }
    }

    public static class Module_Param_Octetstring
    extends Module_Parameter {
        private final TitanOctetString ostr;

        @Override
        public Module_Parameter.type_t get_type() {
            return Module_Parameter.type_t.MP_Octetstring;
        }

        public Module_Param_Octetstring(String str) {
            this.ostr = new TitanOctetString(str);
        }

        public Module_Param_Octetstring(TitanOctetString ostr) {
            this.ostr = new TitanOctetString(ostr);
        }

        public String get_type_str() {
            return "octetstring";
        }

        @Override
        public void log_value() {
            this.ostr.log();
        }

        @Override
        public Object get_string_data() {
            return this.ostr.get_value();
        }

        @Override
        public int get_string_size() {
            return this.ostr.get_value().length;
        }
    }

    public static class Module_Param_Hexstring
    extends Module_Parameter {
        private final TitanHexString hstr;

        @Override
        public Module_Parameter.type_t get_type() {
            return Module_Parameter.type_t.MP_Hexstring;
        }

        public Module_Param_Hexstring(String str) {
            this.hstr = new TitanHexString(str);
        }

        public Module_Param_Hexstring(TitanHexString hstr) {
            this.hstr = new TitanHexString(hstr);
        }

        public String get_type_str() {
            return "hexstring";
        }

        @Override
        public void log_value() {
            this.hstr.log();
        }

        @Override
        public Object get_string_data() {
            return this.hstr.get_value();
        }

        @Override
        public int get_string_size() {
            return this.hstr.get_value().length;
        }
    }

    public static class Module_Param_Bitstring
    extends Module_Parameter {
        private final TitanBitString bstr;

        @Override
        public Module_Parameter.type_t get_type() {
            return Module_Parameter.type_t.MP_Bitstring;
        }

        public Module_Param_Bitstring(String str) {
            this.bstr = new TitanBitString(str);
        }

        public Module_Param_Bitstring(TitanBitString bstr) {
            this.bstr = new TitanBitString(bstr);
        }

        public String get_type_str() {
            return "bitstring";
        }

        @Override
        public void log_value() {
            this.bstr.log();
        }

        @Override
        public int get_string_size() {
            return this.bstr.get_n_bits();
        }

        public int[] get_string_data() {
            return this.bstr.get_value();
        }
    }

    public static class Module_Param_Objid
    extends Module_Parameter {
        private final int n_chars;
        private final TitanInteger[] chars_ptr;

        @Override
        public Module_Parameter.type_t get_type() {
            return Module_Parameter.type_t.MP_Objid;
        }

        public Module_Param_Objid(int p_n, TitanInteger[] p_c) {
            this.n_chars = p_n;
            this.chars_ptr = p_c;
        }

        public String get_type_str() {
            return "object identifier";
        }

        @Override
        public void log_value() {
            new TitanObjectid(this.n_chars, this.chars_ptr).log();
        }

        @Override
        public Object get_string_data() {
            return this.chars_ptr;
        }

        @Override
        public int get_string_size() {
            return this.n_chars;
        }
    }

    public static class Module_Param_Verdict
    extends Module_Parameter {
        private final TitanVerdictType verdict_value;

        @Override
        public Module_Parameter.type_t get_type() {
            return Module_Parameter.type_t.MP_Verdict;
        }

        public Module_Param_Verdict(TitanVerdictType p) {
            this.verdict_value = p;
        }

        @Override
        public TitanVerdictType get_verdict() {
            return this.verdict_value;
        }

        public String get_type_str() {
            return "verdict";
        }

        @Override
        public void log_value() {
            this.verdict_value.log();
        }
    }

    public static class Module_Param_Enumerated
    extends Module_Parameter {
        private final String enum_value;

        @Override
        public Module_Parameter.type_t get_type() {
            return Module_Parameter.type_t.MP_Enumerated;
        }

        public Module_Param_Enumerated(String p_e) {
            this.enum_value = p_e;
        }

        @Override
        public String get_enumerated() {
            return this.enum_value;
        }

        public String get_type_str() {
            return "enumerated";
        }

        @Override
        public void log_value() {
            TTCN_Logger.log_event_str(this.enum_value);
        }
    }

    public static class Module_Param_Boolean
    extends Module_Parameter {
        private final boolean boolean_value;

        @Override
        public Module_Parameter.type_t get_type() {
            return Module_Parameter.type_t.MP_Boolean;
        }

        public Module_Param_Boolean(boolean p) {
            this.boolean_value = p;
        }

        @Override
        public boolean get_boolean() {
            return this.boolean_value;
        }

        public String get_type_str() {
            return "boolean";
        }

        @Override
        public void log_value() {
            new TitanBoolean(this.boolean_value).log();
        }
    }

    public static class Module_Param_Float
    extends Module_Parameter {
        private final double float_value;

        @Override
        public Module_Parameter.type_t get_type() {
            return Module_Parameter.type_t.MP_Float;
        }

        public Module_Param_Float(double p) {
            this.float_value = p;
        }

        @Override
        public double get_float() {
            return this.float_value;
        }

        public String get_type_str() {
            return "float";
        }

        @Override
        public void log_value() {
            TitanFloat.log_float(this.float_value);
        }
    }

    public static class Module_Param_Integer
    extends Module_Parameter {
        private final TitanInteger integer_value;

        @Override
        public Module_Parameter.type_t get_type() {
            return Module_Parameter.type_t.MP_Integer;
        }

        public Module_Param_Integer(TitanInteger p) {
            this.integer_value = p;
            if (this.integer_value == null) {
                throw new TtcnError("Internal error: Module_Param_Integer.Module_Param_Integer()");
            }
        }

        @Override
        public TitanInteger get_integer() {
            return this.integer_value;
        }

        public String get_type_str() {
            return "integer";
        }

        @Override
        public void log_value() {
            this.integer_value.log();
        }
    }

    public static class Module_Param_NotUsed
    extends Module_Parameter {
        @Override
        public Module_Parameter.type_t get_type() {
            return Module_Parameter.type_t.MP_NotUsed;
        }

        public String get_type_str() {
            return "-";
        }

        @Override
        public void log_value() {
            TTCN_Logger.log_event_str("-");
        }
    }

    public static class Module_Param_Expression
    extends Module_Parameter {
        private final Module_Parameter.expression_operand_t expr_type;
        private final Module_Parameter operand1;
        private final Module_Parameter operand2;
        private boolean no_case = false;

        public Module_Param_Expression(Module_Parameter.expression_operand_t p_type, Module_Parameter p_op1, Module_Parameter p_op2) {
            this.expr_type = p_type;
            this.operand1 = p_op1;
            this.operand2 = p_op2;
            if (this.operand1 == null || this.operand2 == null) {
                throw new TtcnError("Internal error: Module_Param_Expression.Module_Param_Expression()");
            }
            this.operand1.set_parent(this);
            this.operand2.set_parent(this);
        }

        public Module_Param_Expression(Module_Parameter p_op) {
            this.expr_type = Module_Parameter.expression_operand_t.EXPR_NEGATE;
            this.operand1 = p_op;
            this.operand2 = null;
            if (this.operand1 == null) {
                throw new TtcnError("Internal error: Module_Param_Expression.Module_Param_Expression()");
            }
            this.operand1.set_parent(this);
        }

        @Override
        public Module_Parameter.expression_operand_t get_expr_type() {
            return this.expr_type;
        }

        @Override
        public String get_expr_type_str() {
            switch (this.expr_type) {
                case EXPR_ADD: {
                    return "Adding (+)";
                }
                case EXPR_SUBTRACT: {
                    return "Subtracting (-)";
                }
                case EXPR_MULTIPLY: {
                    return "Multiplying (*)";
                }
                case EXPR_DIVIDE: {
                    return "Dividing (/)";
                }
                case EXPR_NEGATE: {
                    return "Negating (-)";
                }
                case EXPR_CONCATENATE: {
                    return "Concatenating (&)";
                }
            }
            return null;
        }

        @Override
        public Module_Parameter get_operand1() {
            return this.operand1;
        }

        @Override
        public Module_Parameter get_operand2() {
            return this.operand2;
        }

        @Override
        public Module_Parameter.type_t get_type() {
            return Module_Parameter.type_t.MP_Expression;
        }

        public String get_type_str() {
            return "expression";
        }

        @Override
        public void log_value() {
            if (this.expr_type == Module_Parameter.expression_operand_t.EXPR_NEGATE) {
                TTCN_Logger.log_event_str("- ");
            }
            this.operand1.log_value();
            switch (this.expr_type) {
                case EXPR_ADD: {
                    TTCN_Logger.log_event_str(" + ");
                    break;
                }
                case EXPR_SUBTRACT: {
                    TTCN_Logger.log_event_str(" - ");
                    break;
                }
                case EXPR_MULTIPLY: {
                    TTCN_Logger.log_event_str(" * ");
                    break;
                }
                case EXPR_DIVIDE: {
                    TTCN_Logger.log_event_str(" / ");
                    break;
                }
                case EXPR_CONCATENATE: {
                    TTCN_Logger.log_event_str(" & ");
                    break;
                }
            }
            if (this.expr_type != Module_Parameter.expression_operand_t.EXPR_NEGATE) {
                this.operand2.log_value();
            }
        }

        @Override
        public boolean get_nocase() {
            return this.no_case;
        }

        public void set_nocase(boolean nocase) {
            this.no_case = nocase;
            if (this.parent != null && this.parent != this && this.parent.get_type() == Module_Parameter.type_t.MP_Expression) {
                ((Module_Param_Expression)this.parent).set_nocase(this.no_case);
            }
        }
    }

    public static class Module_Param_Unbound
    extends Module_Parameter {
        @Override
        public Module_Parameter.type_t get_type() {
            return Module_Parameter.type_t.MP_Unbound;
        }

        public final String get_type_str() {
            return "<unbound>";
        }

        @Override
        public void log_value() {
            TTCN_Logger.log_event_str("<unbound>");
        }
    }

    public static class Module_Param_Reference
    extends Module_Parameter {
        private final Module_Param_Name mp_ref;

        public Module_Param_Reference(Module_Param_Name p) {
            this.mp_ref = p;
            if (this.mp_ref == null) {
                throw new TtcnError("Internal error: Module_Param_Reference.Module_Param_Reference()");
            }
        }

        @Override
        public Module_Parameter.type_t get_type() {
            return Module_Parameter.type_t.MP_Reference;
        }

        @Override
        public Module_Param_Ptr get_referenced_param() {
            this.mp_ref.reset();
            Module_Parameter mp = Module_List.get_param(this.mp_ref, this);
            Module_Param_Ptr ptr = new Module_Param_Ptr(mp);
            ptr.set_temporary();
            return ptr;
        }

        @Override
        public String get_enumerated() {
            if (this.mp_ref.get_nof_names() == 1) {
                return this.mp_ref.get_current_name();
            }
            return null;
        }

        public String get_type_str() {
            return "module parameter reference";
        }

        @Override
        public void log_value() {
            TTCN_Logger.log_event_str(this.mp_ref.get_str());
        }
    }

    public static class Module_Param_Ptr {
        private module_param_ptr_struct ptr = new module_param_ptr_struct();

        public Module_Param_Ptr(Module_Parameter p) {
            this.ptr.mp_ptr = p;
            this.ptr.temporary = false;
        }

        public Module_Param_Ptr(Module_Param_Ptr r) {
            this.ptr.mp_ptr = r.ptr.mp_ptr;
            this.ptr.temporary = r.ptr.temporary;
        }

        public Module_Param_Ptr operator_assign(Module_Param_Ptr r) {
            this.ptr = r.ptr;
            return this;
        }

        public Module_Parameter get() {
            return this.ptr.mp_ptr;
        }

        public void set_temporary() {
            this.ptr.temporary = true;
        }

        private class module_param_ptr_struct {
            Module_Parameter mp_ptr;
            boolean temporary;

            private module_param_ptr_struct() {
            }
        }
    }

    public static abstract class Module_Parameter {
        protected operation_type_t operation_type = operation_type_t.OT_ASSIGN;
        protected Module_Param_Id id = null;
        protected Module_Parameter parent = null;
        protected boolean has_ifpresent = false;
        protected Module_Param_Length_Restriction length_restriction = null;

        public void set_parent(Module_Parameter p_parent) {
            this.parent = p_parent;
        }

        public void set_id(Module_Param_Id p_id) {
            if (this.id != null) {
                throw new TtcnError("Internal error: Module_Param.set_id()");
            }
            this.id = p_id;
        }

        public Module_Param_Id get_id() {
            return this.id;
        }

        public void set_ifpresent() {
            this.has_ifpresent = true;
        }

        public boolean get_ifpresent() {
            return this.has_ifpresent;
        }

        public void set_length_restriction(Module_Param_Length_Restriction p_length_restriction) {
            if (this.length_restriction != null) {
                throw new TtcnError("Internal error: Module_Param.set_length_restriction()");
            }
            this.length_restriction = p_length_restriction;
        }

        public Module_Param_Length_Restriction get_length_restriction() {
            return this.length_restriction;
        }

        public operation_type_t get_operation_type() {
            return this.operation_type;
        }

        public void set_operation_type(operation_type_t p_optype) {
            this.operation_type = p_optype;
        }

        public String get_operation_type_str() {
            switch (this.operation_type) {
                case OT_ASSIGN: {
                    return "assignment";
                }
                case OT_CONCAT: {
                    return "concatenation";
                }
            }
            return "<unknown operation>";
        }

        public String get_operation_type_sign_str() {
            switch (this.operation_type) {
                case OT_ASSIGN: {
                    return ":=";
                }
                case OT_CONCAT: {
                    return "&=";
                }
            }
            return "<unknown operation>";
        }

        public void log(boolean log_id) {
            if (log_id && this.id != null && this.id.is_explicit()) {
                String id_str = this.id.get_str();
                TTCN_Logger.log_event_str(id_str);
                id_str = null;
                TTCN_Logger.log_event_str(this.get_operation_type_sign_str());
            }
            this.log_value();
            if (this.has_ifpresent) {
                TTCN_Logger.log_event_str(" ifpresent");
            }
            if (this.length_restriction != null) {
                this.length_restriction.log();
            }
        }

        public abstract void log_value();

        public abstract type_t get_type();

        public void basic_check(int check_bits, String what) {
            boolean is_list;
            boolean is_template = (check_bits & basic_check_bits_t.BC_TEMPLATE.getValue()) != 0;
            boolean bl = is_list = (check_bits & basic_check_bits_t.BC_LIST.getValue()) != 0;
            if ((is_template || !is_list) && this.get_operation_type() != operation_type_t.OT_ASSIGN) {
                throw new TtcnError(MessageFormat.format("The {0} of {1}s is not allowed.", this.get_operation_type_str(), what));
            }
            if (!is_template && this.has_ifpresent) {
                throw new TtcnError(MessageFormat.format("{0} cannot have an 'ifpresent' attribute", what));
            }
            if (!(is_template && is_list || this.length_restriction == null)) {
                throw new TtcnError(MessageFormat.format("{0} cannot have a length restriction", what));
            }
        }

        public String get_param_context() {
            StringBuilder result = new StringBuilder();
            if (this.parent != null) {
                result.append(this.parent.get_param_context());
            }
            if (this.id != null) {
                String id_str = this.id.get_str();
                if (this.parent != null && !this.id.is_index()) {
                    result.append('.');
                }
                result.append(id_str);
            }
            return result.toString();
        }

        public void add_elem(Module_Parameter value) {
            throw new TtcnError("Internal error: Module_Param.add_elem()");
        }

        public void add_list_with_implicit_ids(List<Module_Parameter> mp_list) {
            throw new TtcnError("Internal error: Module_Param.add_list_with_implicit_ids()");
        }

        public boolean get_boolean() {
            throw new TtcnError("Internal error: Module_Param.get_boolean()");
        }

        public TitanCharString get_charstring() {
            throw new TtcnError("Internal error: Module_Param.get_charstring()");
        }

        public int get_size() {
            throw new TtcnError("Internal error: Module_Param.get_size()");
        }

        public Module_Parameter get_elem(int index) {
            throw new TtcnError("Internal error: Module_Param.get_elem()");
        }

        public int get_string_size() {
            throw new TtcnError("Internal error: Module_Param.get_string_size()");
        }

        public Object get_string_data() {
            throw new TtcnError("Internal error: Module_Param.get_string_data()");
        }

        public TitanInteger get_lower_int() {
            throw new TtcnError("Internal error: Module_Param.get_lower_int()");
        }

        public TitanInteger get_upper_int() {
            throw new TtcnError("Internal error: Module_Param.get_upper_int()");
        }

        public boolean get_is_min_exclusive() {
            throw new TtcnError("Internal error: Module_Param.get_is_min_exclusive()");
        }

        public boolean get_is_max_exclusive() {
            throw new TtcnError("Internal error: Module_Param.get_is_max_exclusive()");
        }

        public double get_lower_float() {
            throw new TtcnError("Internal error: Module_Param.get_lower_float()");
        }

        public double get_upper_float() {
            throw new TtcnError("Internal error: Module_Param.get_upper_float()");
        }

        public boolean has_lower_float() {
            throw new TtcnError("Internal error: Module_Param.has_lower_float()");
        }

        public boolean has_upper_float() {
            throw new TtcnError("Internal error: Module_Param.has_upper_float()");
        }

        public TitanUniversalChar get_lower_uchar() {
            throw new TtcnError("Internal error: Module_Param.get_lower_uchar()");
        }

        public TitanUniversalChar get_upper_uchar() {
            throw new TtcnError("Internal error: Module_Param.get_upper_uchar()");
        }

        public TitanInteger get_integer() {
            throw new TtcnError("Internal error: Module_Param.get_integer()");
        }

        public double get_float() {
            throw new TtcnError("Internal error: Module_Param.get_float()");
        }

        public String get_pattern() {
            throw new TtcnError("Internal error: Module_Param.get_pattern()");
        }

        public boolean get_nocase() {
            throw new TtcnError("Internal error: Module_Param.get_nocase()");
        }

        public TitanVerdictType get_verdict() {
            throw new TtcnError("Internal error: Module_Param.get_verdict()");
        }

        public String get_enumerated() {
            throw new TtcnError("Internal error: Module_Param.get_enumerated()");
        }

        public Module_Param_Ptr get_referenced_param() {
            throw new TtcnError("Internal error: Module_Param.get_referenced_param()");
        }

        public expression_operand_t get_expr_type() {
            throw new TtcnError("Internal error: Module_Param.get_expr_type()");
        }

        public String get_expr_type_str() {
            throw new TtcnError("Internal error: Module_Param.get_expr_type_str()");
        }

        public Module_Parameter get_operand1() {
            throw new TtcnError("Internal error: Module_Param.get_operand1()");
        }

        public Module_Parameter get_operand2() {
            throw new TtcnError("Internal error: Module_Param.get_operand2()");
        }

        public void error(String err, Object ... args) {
            StringBuilder exception_str = new StringBuilder();
            TTCN_Logger.begin_event(TTCN_Logger.Severity.ERROR_UNQUALIFIED);
            TTCN_Logger.log_event_str("Error while ");
            exception_str.append("Error while ");
            switch (this.operation_type) {
                case OT_ASSIGN: {
                    TTCN_Logger.log_event_str("setting");
                    exception_str.append("setting");
                    break;
                }
                case OT_CONCAT: {
                    TTCN_Logger.log_event_str("concatenating");
                    exception_str.append("concatenating");
                    break;
                }
                default: {
                    TTCN_Logger.log_event_str("???");
                    exception_str.append("???");
                }
            }
            TTCN_Logger.log_event_str(" ");
            exception_str.append(' ');
            if (this.id != null && this.id.is_custom()) {
                String custom_ctx = this.id.get_str();
                TTCN_Logger.log_event_str(custom_ctx);
                exception_str.append(custom_ctx);
                TTCN_Logger.log_event_str(" in module parameter");
                exception_str.append(" in module parameter");
            } else {
                TTCN_Logger.log_event_str("parameter field '");
                exception_str.append("parameter field '");
                String param_ctx = this.get_param_context();
                TTCN_Logger.log_event_str(param_ctx);
                exception_str.append(param_ctx);
                TTCN_Logger.log_event_str("'");
                exception_str.append('\'');
            }
            switch (this.operation_type) {
                case OT_ASSIGN: {
                    TTCN_Logger.log_event_str(" to '");
                    exception_str.append(" to '");
                    break;
                }
                case OT_CONCAT: {
                    TTCN_Logger.log_event_str(" and '");
                    exception_str.append(" and '");
                    break;
                }
                default: {
                    TTCN_Logger.log_event_str("' ??? '");
                    exception_str.append("' ??? '");
                }
            }
            this.log(false);
            TTCN_Logger.log_event_str("': ");
            exception_str.append("': ");
            TTCN_Logger.log_event_va_list(err, args);
            exception_str.append(String.format(Locale.US, err, args));
            TTCN_Logger.send_event_as_error();
            TTCN_Logger.end_event();
            throw new TtcnError(exception_str.toString());
        }

        public void type_error(String expected, String type_name) {
            this.error(String.format("Type mismatch: %s was expected instead of %s.", expected, type_name), new Object[0]);
        }

        public void type_error(String expected) {
            this.type_error(expected, null);
        }

        public void expr_type_error(String type_name) {
            this.error(MessageFormat.format("{0} is not allowed in {1} expression.", this.get_expr_type_str(), type_name), new Object[0]);
        }

        public static enum expression_operand_t {
            EXPR_ERROR,
            EXPR_ADD,
            EXPR_SUBTRACT,
            EXPR_MULTIPLY,
            EXPR_DIVIDE,
            EXPR_CONCATENATE,
            EXPR_NEGATE;

        }

        public static enum basic_check_bits_t {
            BC_VALUE(0),
            BC_LIST(1),
            BC_TEMPLATE(2);

            private final int value;

            private basic_check_bits_t(int value) {
                this.value = value;
            }

            public int getValue() {
                return this.value;
            }
        }

        public static enum operation_type_t {
            OT_ASSIGN,
            OT_CONCAT;

        }

        public static enum type_t {
            MP_NotUsed,
            MP_Omit,
            MP_Integer,
            MP_Float,
            MP_Boolean,
            MP_Verdict,
            MP_Objid,
            MP_Bitstring,
            MP_Hexstring,
            MP_Octetstring,
            MP_Charstring,
            MP_Universal_Charstring,
            MP_Enumerated,
            MP_Ttcn_Null,
            MP_Ttcn_mtc,
            MP_Ttcn_system,
            MP_Asn_Null,
            MP_Any,
            MP_AnyOrNone,
            MP_IntRange,
            MP_FloatRange,
            MP_StringRange,
            MP_Pattern,
            MP_Bitstring_Template,
            MP_Hexstring_Template,
            MP_Octetstring_Template,
            MP_Assignment_List,
            MP_Value_List,
            MP_Indexed_List,
            MP_List_Template,
            MP_ComplementList_Template,
            MP_ConjunctionList_Template,
            MP_Superset_Template,
            MP_Subset_Template,
            MP_Permutation_Template,
            MP_Reference,
            MP_Unbound,
            MP_Expression;

        }
    }
}

