/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.refactoring.scope.nodes;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.ILocateableNode;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titanium.refactoring.Utils;
import org.eclipse.titanium.refactoring.scope.nodes.BlockNode;
import org.eclipse.titanium.refactoring.scope.nodes.MultiDeclaration;
import org.eclipse.titanium.refactoring.scope.nodes.Node;
import org.eclipse.titanium.refactoring.scope.nodes.Variable;

public class StatementNode
extends Node {
    protected BlockNode parent;
    protected final List<BlockNode> blocks = new ArrayList<BlockNode>();
    protected final Set<Variable> referedVars = new HashSet<Variable>();
    protected Variable declaredVar;
    protected MultiDeclaration multiDeclaration;
    protected boolean hasFunctionCall = false;
    protected boolean hasUncheckedRef = false;
    protected boolean moved = false;

    public StatementNode(IVisitableNode astNode) {
        super(astNode);
    }

    public BlockNode getParent() {
        return this.parent;
    }

    public List<BlockNode> getBlocks() {
        return this.blocks;
    }

    public Set<Variable> getReferredVars() {
        return this.referedVars;
    }

    public Variable getDeclaredVar() {
        return this.declaredVar;
    }

    public MultiDeclaration getMultiDeclaration() {
        return this.multiDeclaration;
    }

    public boolean isLocationEqualTo(StatementNode sn) {
        if (!(this.getAstNode() instanceof ILocateableNode)) {
            return false;
        }
        if (!(sn.getAstNode() instanceof ILocateableNode)) {
            return false;
        }
        Location loc0 = ((ILocateableNode)this.getAstNode()).getLocation();
        Location loc1 = ((ILocateableNode)sn.getAstNode()).getLocation();
        return loc0.getFile().equals((Object)loc1.getFile()) && loc0.getOffset() == loc1.getOffset() && loc0.getEndOffset() == loc1.getEndOffset();
    }

    public boolean isDeclaration() {
        return this.declaredVar != null;
    }

    public boolean isMultiDeclaration() {
        return this.multiDeclaration != null;
    }

    public boolean hasFunctionCall() {
        return this.hasFunctionCall;
    }

    public boolean isMoved() {
        return this.moved;
    }

    public void setParent(BlockNode parent) {
        this.parent = parent;
    }

    public void addBlock(BlockNode bl) {
        this.blocks.add(bl);
    }

    public void addReferedVars(Variable var) {
        this.referedVars.add(var);
    }

    public void setDeclaredVar(Variable declaredVar) {
        if (this.declaredVar != null) {
            ErrorReporter.logError((String)"StatementNode.setDeclaredVar(): A declared variable is already present! ");
        }
        this.declaredVar = declaredVar;
    }

    public void setMultiDeclaration(MultiDeclaration multiDeclaration) {
        this.multiDeclaration = multiDeclaration;
    }

    public void setHasFunctionCall() {
        this.hasFunctionCall = true;
    }

    public void setHasUncheckedRef() {
        this.hasUncheckedRef = true;
    }

    public void linkWithOtherAsMultiDeclaration(StatementNode sn) {
        if (this.multiDeclaration != null && sn.multiDeclaration != null) {
            ErrorReporter.logError((String)"StatementNode.linkWithOtherAsMultiDeclaration(): Both nodes are already part of a multi-declaration! ");
            return;
        }
        if (this.multiDeclaration != null) {
            this.multiDeclaration.addDeclarationStatement(sn);
            sn.setMultiDeclaration(this.multiDeclaration);
        } else if (sn.multiDeclaration != null) {
            sn.multiDeclaration.addDeclarationStatement(this);
            this.setMultiDeclaration(sn.multiDeclaration);
        } else {
            MultiDeclaration md = new MultiDeclaration();
            md.addDeclarationStatement(this);
            md.addDeclarationStatement(sn);
            this.setMultiDeclaration(md);
            sn.setMultiDeclaration(md);
        }
    }

    public void removeFromMultiDeclaration() {
        if (this.multiDeclaration == null) {
            return;
        }
        this.multiDeclaration.declStmts.remove(this);
        this.multiDeclaration = null;
    }

    public void setMoved() {
        this.moved = true;
    }

    @Override
    protected boolean containsNode(Node n) {
        if (this.equals(n)) {
            return true;
        }
        for (BlockNode bn : this.blocks) {
            if (!bn.containsNode(n)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isBlockAncestorOfThis(BlockNode bn) {
        BlockNode parent = this.getParent();
        while (parent != null && !parent.equals(bn)) {
            parent = parent.parent == null ? null : parent.parent.parent;
        }
        return parent != null;
    }

    @Override
    public boolean isStmtAncestorOfThis(StatementNode sn) {
        StatementNode parent;
        if (this.equals(sn)) {
            return false;
        }
        StatementNode statementNode = parent = this.parent == null ? null : this.parent.parent;
        while (parent != null && !parent.equals(sn)) {
            parent = parent.parent == null ? null : parent.parent.parent;
        }
        return parent != null;
    }

    public BlockNode findBlockInStmtWhichContainsNode(Node containedNode) {
        if (!containedNode.isStmtAncestorOfThis(this)) {
            return null;
        }
        ListIterator<BlockNode> it = this.blocks.listIterator();
        while (it.hasNext()) {
            BlockNode currB = it.next();
            if (!containedNode.isBlockAncestorOfThis(currB)) continue;
            return currB;
        }
        return null;
    }

    protected int compareCurrentPositionTo(StatementNode other) {
        if (this.equals(other)) {
            return 0;
        }
        if (this.isStmtAncestorOfThis(other)) {
            return 0;
        }
        if (other.isStmtAncestorOfThis(this)) {
            return 0;
        }
        LinkedList<Integer> pos0 = new LinkedList<Integer>();
        StatementNode currSt = this;
        BlockNode currBlock = this.getParent();
        while (currBlock != null) {
            pos0.addFirst(currBlock.getStatements().indexOf(currSt));
            currSt = currBlock.getParent();
            if (currSt != null) {
                pos0.addFirst(currSt.getBlocks().indexOf(currBlock));
                currBlock = currSt.getParent();
                continue;
            }
            currBlock = null;
        }
        LinkedList<Integer> pos1 = new LinkedList<Integer>();
        currSt = other;
        currBlock = other.getParent();
        while (currBlock != null) {
            pos1.addFirst(currBlock.getStatements().indexOf(currSt));
            currSt = currBlock.getParent();
            if (currSt != null) {
                pos1.addFirst(currSt.getBlocks().indexOf(currBlock));
                currBlock = currSt.getParent();
                continue;
            }
            currBlock = null;
        }
        ListIterator it0 = pos0.listIterator();
        ListIterator it1 = pos1.listIterator();
        while (it0.hasNext() && it1.hasNext()) {
            int ind1;
            int ind0 = (Integer)it0.next();
            if (ind0 == (ind1 = ((Integer)it1.next()).intValue())) continue;
            return ind0 < ind1 ? -1 : (ind0 == ind1 ? 0 : 1);
        }
        ErrorReporter.logError((String)("StatementNode.compareCurrentPositionTo(): Erroneous state: " + Utils.createLocationString(this.astNode)));
        return 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SN(").append(this.astNode.toString()).append("), loc: ");
        if (this.astNode instanceof ILocateableNode) {
            Location loc = ((ILocateableNode)this.astNode).getLocation();
            sb.append(loc.getOffset()).append('-').append(loc.getEndOffset()).append(';');
        } else {
            sb.append("<none>;");
        }
        sb.append(" parent: ");
        if (this.parent == null) {
            sb.append("<null>; ");
        } else {
            sb.append("BN(").append(this.parent.astNode.toString()).append("); ");
        }
        if (this.moved) {
            sb.append("MOVED; ");
        }
        if (this.isDeclaration()) {
            sb.append("declaration: ").append(this.declaredVar);
        }
        return sb.toString();
    }

    public String toStringRecursive(boolean recursive, int prefixLen) {
        String prefix = new String(new char[prefixLen]).replace('\u0000', ' ');
        StringBuilder sb = new StringBuilder();
        sb.append(prefix).append("SN: ").append(this.toString()).append('\n');
        if (recursive) {
            sb.append(prefix).append("  blocks:\n");
            for (BlockNode bn : this.blocks) {
                sb.append(bn.toStringRecursive(true, prefixLen + 4)).append('\n');
            }
            sb.append('\n');
        }
        sb.append(prefix).append("  refdVars:\n");
        for (Variable var : this.referedVars) {
            sb.append(var.toStringRecursive(false, prefixLen + 4)).append('\n');
        }
        return sb.toString();
    }
}

