/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.refactoring.scope.nodes;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.titan.designer.AST.ILocateableNode;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titanium.refactoring.scope.nodes.Node;
import org.eclipse.titanium.refactoring.scope.nodes.StatementNode;

public class BlockNode
extends Node {
    protected StatementNode parent;
    protected final List<StatementNode> sts = new ArrayList<StatementNode>();

    public BlockNode(IVisitableNode astNode) {
        super(astNode);
    }

    public StatementNode getParent() {
        return this.parent;
    }

    public List<StatementNode> getStatements() {
        return this.sts;
    }

    public StatementNode getPreviousStatement(StatementNode sn) {
        int ind = this.sts.indexOf(sn);
        if (ind <= 0) {
            return null;
        }
        return this.sts.get(ind - 1);
    }

    public StatementNode getNextStatement(StatementNode sn) {
        int ind = this.sts.indexOf(sn);
        if (ind >= this.sts.size() - 1) {
            return null;
        }
        return this.sts.get(ind + 1);
    }

    public void setParent(StatementNode parent) {
        this.parent = parent;
    }

    public void addStatement(StatementNode st) {
        this.sts.add(st);
    }

    @Override
    protected boolean containsNode(Node n) {
        if (this.equals(n)) {
            return true;
        }
        for (StatementNode sn : this.sts) {
            if (!sn.containsNode(n)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isBlockAncestorOfThis(BlockNode bn) {
        BlockNode parent;
        if (this.equals(bn)) {
            return false;
        }
        BlockNode blockNode = parent = this.parent == null ? null : this.parent.parent;
        while (parent != null && !parent.equals(bn)) {
            parent = parent.parent == null ? null : parent.parent.parent;
        }
        return parent != null;
    }

    @Override
    public boolean isStmtAncestorOfThis(StatementNode sn) {
        StatementNode parent = this.getParent();
        while (parent != null && !parent.equals(sn)) {
            parent = parent.parent == null ? null : parent.parent.parent;
        }
        return parent != null;
    }

    public BlockNode findSmallestCommonAncestorBlock(BlockNode bn) {
        BlockNode parentNode;
        if (bn.equals(this)) {
            return this;
        }
        if (bn.isBlockAncestorOfThis(this)) {
            return this;
        }
        if (this.isBlockAncestorOfThis(bn)) {
            return bn;
        }
        BlockNode blockNode = parentNode = this.parent == null ? null : this.parent.parent;
        while (parentNode != null) {
            if (bn.isBlockAncestorOfThis(parentNode)) {
                return parentNode;
            }
            parentNode = this.parent == null ? null : this.parent.parent;
        }
        return null;
    }

    public StatementNode findStmtInBlockWhichContainsNode(Node containedNode) {
        if (!containedNode.isBlockAncestorOfThis(this)) {
            return null;
        }
        ListIterator<StatementNode> it = this.sts.listIterator();
        while (it.hasNext()) {
            StatementNode currSt = it.next();
            if (!containedNode.equals(currSt) && !containedNode.isStmtAncestorOfThis(currSt)) continue;
            return currSt;
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("BN(").append(this.astNode.toString()).append("), loc: ");
        if (this.astNode instanceof ILocateableNode) {
            Location loc = ((ILocateableNode)this.astNode).getLocation();
            sb.append(loc.getOffset()).append('-').append(loc.getEndOffset()).append(';');
        } else {
            sb.append("<none>;");
        }
        sb.append(" parent: ");
        if (this.parent == null) {
            sb.append("<null>");
        } else {
            sb.append("SN(").append(this.parent.astNode.toString()).append(')');
        }
        return sb.toString();
    }

    public String toStringRecursive(boolean recursive, int prefixLen) {
        String prefix = new String(new char[prefixLen]).replace('\u0000', ' ');
        StringBuilder sb = new StringBuilder();
        sb.append(prefix).append("BN: ").append(this.toString()).append('\n');
        if (recursive) {
            for (StatementNode sn : this.sts) {
                sb.append(sn.toStringRecursive(true, prefixLen + 2)).append('\n');
            }
        }
        return sb.toString();
    }
}

