/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.refactoring.scope;

import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.titanium.refactoring.scope.MinimizeScopeRefactoring;

public class MinimizeScopeWizardOptionsPage
extends UserInputWizardPage {
    private static final String LABEL_PAGECONTENT = "Modify refactoring settings:";
    private final MinimizeScopeRefactoring.Settings settings;

    public MinimizeScopeWizardOptionsPage(String name, MinimizeScopeRefactoring.Settings settings) {
        super(name);
        this.settings = settings;
    }

    public void createControl(Composite parent) {
        Composite top = new Composite(parent, 0);
        this.initializeDialogUnits((Control)top);
        this.setControl((Control)top);
        top.setLayout((Layout)new GridLayout());
        Label label = new Label(top, 0);
        label.setText(LABEL_PAGECONTENT);
        Button chb_option1 = new Button(top, 32);
        chb_option1.setText("Move variable declarations");
        chb_option1.setSelection(this.settings.getSetting(1));
        chb_option1.addSelectionListener((SelectionListener)new CHBSelectionListener(1));
        Button chb_option2 = new Button(top, 32);
        chb_option2.setText("Move variable declarations when their scope is correct");
        chb_option2.setSelection(this.settings.getSetting(2));
        chb_option2.addSelectionListener((SelectionListener)new CHBSelectionListener(2));
        chb_option2.setEnabled(this.settings.getSetting(1));
        chb_option1.addSelectionListener((SelectionListener)new CHBSelectionListenerDisabler(chb_option2));
        Button chb_option3 = new Button(top, 32);
        chb_option3.setText("Remove unused variables");
        chb_option3.setSelection(this.settings.getSetting(4));
        chb_option3.addSelectionListener((SelectionListener)new CHBSelectionListener(4));
        Button chb_option4 = new Button(top, 32);
        chb_option4.setText("Avoid refactoring variables with function calls in their declaration statements (disabling may alter the refactored code behaviour)");
        chb_option4.setSelection(this.settings.getSetting(8));
        chb_option4.addSelectionListener((SelectionListener)new CHBSelectionListener(8));
        Button chb_option5 = new Button(top, 32);
        chb_option5.setText("Avoid moving variables with unchecked references in their declaration statements (disabling may alter the refactored code behaviour)");
        chb_option5.setSelection(this.settings.getSetting(16));
        chb_option5.addSelectionListener((SelectionListener)new CHBSelectionListener(16));
        chb_option1.addSelectionListener((SelectionListener)new CHBSelectionListenerDisabler(chb_option5));
        Button chb_option6 = new Button(top, 32);
        chb_option6.setText("Avoid moving and/or taking apart declaration lists (unused variables can still be removed from them)");
        chb_option6.setSelection(this.settings.getSetting(32));
        chb_option6.addSelectionListener((SelectionListener)new CHBSelectionListener(32));
        chb_option1.addSelectionListener((SelectionListener)new CHBSelectionListenerDisabler(chb_option6));
        this.setPageComplete(true);
        this.setErrorMessage(null);
    }

    private class CHBSelectionListenerDisabler
    implements SelectionListener {
        private final Button toDisable;

        public CHBSelectionListenerDisabler(Button toDisable) {
            this.toDisable = toDisable;
        }

        public void widgetSelected(SelectionEvent e) {
            if (!(e.getSource() instanceof Button)) {
                return;
            }
            Button source = (Button)e.getSource();
            this.toDisable.setEnabled(source.getSelection());
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    private class CHBSelectionListener
    implements SelectionListener {
        private final int setting;

        public CHBSelectionListener(int setting) {
            this.setting = setting;
        }

        public void widgetSelected(SelectionEvent e) {
            if (!(e.getSource() instanceof Button)) {
                return;
            }
            Button checkBox = (Button)e.getSource();
            MinimizeScopeWizardOptionsPage.this.settings.setSetting(this.setting, checkBox.getSelection());
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }
}

