/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.refactoring.logging.context;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.TTCN3.statements.If_Clause;
import org.eclipse.titan.designer.AST.TTCN3.statements.If_Clauses;
import org.eclipse.titan.designer.AST.TTCN3.statements.If_Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.StatementBlock;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titanium.refactoring.logging.ContextLoggingRefactoring;
import org.eclipse.titanium.refactoring.logging.context.Context;

class IfContext
extends Context {
    private final Set<String> varNamesInConditions = new HashSet<String>();

    IfContext(If_Statement st, ContextLoggingRefactoring.Settings settings) {
        super((IVisitableNode)st, settings);
    }

    public If_Statement getNode() {
        return (If_Statement)super.getNode();
    }

    @Override
    protected void process_internal() {
        block3: {
            If_Clauses ics;
            block2: {
                If_Statement st = this.getNode();
                ics = st.getIfClauses();
                Context child = this.getChild();
                if (child == null || !child.getNode().equals(ics)) break block2;
                List icl = ics.getClauses();
                Context clauseContext = child.getChild();
                if (clauseContext == null || !icl.contains(clauseContext.getNode())) break block3;
                IVisitableNode ic = clauseContext.getNode();
                ClauseVisitor vis = new ClauseVisitor();
                ic.accept((ASTVisitor)vis);
                List refs = vis.getResult();
                for (Reference ref : refs) {
                    this.varNamesInConditions.add(ref.getDisplayName());
                }
                break block3;
            }
            List<Reference> refs = IfContext.extractAllIdsFromClauses(ics);
            for (Reference ref : refs) {
                this.varNamesInConditions.add(ref.getDisplayName());
            }
        }
    }

    private static List<Reference> extractAllIdsFromClauses(If_Clauses ics) {
        List icl = ics.getClauses();
        ArrayList<Reference> ret = new ArrayList<Reference>();
        for (If_Clause ic : icl) {
            ClauseVisitor vis = new ClauseVisitor();
            ic.accept((ASTVisitor)vis);
            ret.addAll(vis.getResult());
        }
        return ret;
    }

    @Override
    protected List<String> createLogParts_internal(Set<String> idsAlreadyHandled) {
        ArrayList<String> ret = new ArrayList<String>();
        if (this.varNamesInConditions == null) {
            return ret;
        }
        for (String s : this.varNamesInConditions) {
            if (idsAlreadyHandled.contains(s)) continue;
            idsAlreadyHandled.add(s);
            ret.add(this.formatLogPart(s));
        }
        return ret;
    }

    private static class ClauseVisitor
    extends ASTVisitor {
        private final List<Reference> result = new ArrayList<Reference>();

        private ClauseVisitor() {
        }

        private List<Reference> getResult() {
            return this.result;
        }

        public int visit(IVisitableNode node) {
            if (node instanceof Reference) {
                Reference ref = (Reference)node;
                Assignment refdAssignment = ref.getRefdAssignment(CompilationTimeStamp.getBaseTimestamp(), false);
                switch (refdAssignment.getAssignmentType()) {
                    case A_ALTSTEP: 
                    case A_EXT_FUNCTION: 
                    case A_EXT_FUNCTION_RTEMP: 
                    case A_EXT_FUNCTION_RVAL: 
                    case A_FUNCTION: 
                    case A_FUNCTION_RTEMP: 
                    case A_FUNCTION_RVAL: 
                    case A_TESTCASE: {
                        break;
                    }
                    default: {
                        this.result.add(ref);
                    }
                }
                return 1;
            }
            if (node instanceof StatementBlock) {
                return 1;
            }
            return 3;
        }
    }
}

