/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.refactoring.definition;

import java.net.URI;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.core.TITANNature;
import org.eclipse.titan.designer.properties.data.ProjectFileHandler;
import org.eclipse.titanium.refactoring.Utils;
import org.eclipse.titanium.refactoring.definition.ExtractDefinitionRefactoring;

public class ExtractDefinitionHeadless {
    private URI location;

    public void run(IProject sourceProj, Definition selection, String targetProjName) {
        block9: {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IProject newProj = workspace.getRoot().getProject(targetProjName);
            IProjectDescription description = workspace.newProjectDescription(targetProjName);
            description.setLocationURI(this.location);
            TITANNature.addTITANNatureToProject((IProjectDescription)description);
            if (newProj == null) {
                ErrorReporter.logError((String)"ExtractDefinitionHeadless: Target project is null. ");
                return;
            }
            try {
                if (!Utils.createProject(description, newProj)) break block9;
                try {
                    TITANNature.addTITANBuilderToProject((IProject)newProj);
                }
                catch (CoreException ce) {
                    ErrorReporter.logExceptionStackTrace((Exception)((Object)ce));
                    return;
                }
                ProjectFileHandler pfh = new ProjectFileHandler(sourceProj);
                if (pfh.projectFileExists()) {
                    IFile settingsFile = sourceProj.getFile("/.TITAN_properties");
                    IFile settingsCopy = newProj.getFile("/.TITAN_properties");
                    try {
                        if (settingsCopy.exists()) {
                            settingsCopy.delete(true, (IProgressMonitor)new NullProgressMonitor());
                        }
                        settingsFile.copy(settingsCopy.getFullPath(), true, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (CoreException ce) {
                        ErrorReporter.logError((String)"ExtractDefinitionHeadless: Copying project settings to new project failed.");
                    }
                }
                ExtractDefinitionRefactoring refactoring = new ExtractDefinitionRefactoring(sourceProj, selection);
                refactoring.setTargetProject(newProj);
                refactoring.perform();
            }
            catch (CoreException e) {
                ErrorReporter.logError((String)"ExtractDefinitionHeadless: Target project creation was unsuccessful. ");
                ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
            }
        }
    }

    public void setLocation(URI location) {
        this.location = location;
    }
}

