/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.refactoring;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.ASN1.definitions.ASN1Module;
import org.eclipse.titan.designer.AST.ASN1.types.ASN1_Choice_Type;
import org.eclipse.titan.designer.AST.ASN1.types.ASN1_Enumerated_Type;
import org.eclipse.titan.designer.AST.ASN1.types.ASN1_Sequence_Type;
import org.eclipse.titan.designer.AST.ASN1.types.ASN1_Set_Type;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.FieldSubReference;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.NamedBridgeScope;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.SubScopeVisitor;
import org.eclipse.titan.designer.AST.TTCN3.types.TTCN3_Enumerated_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.TTCN3_Set_Seq_Choice_BaseType;
import org.eclipse.titan.designer.commonFilters.ResourceExclusionHelper;
import org.eclipse.titan.designer.consoles.TITANDebugConsole;
import org.eclipse.titan.designer.core.TITANNature;
import org.eclipse.titan.designer.declarationsearch.Declaration;
import org.eclipse.titan.designer.declarationsearch.IdentifierFinderVisitor;
import org.eclipse.titan.designer.editors.IEditorWithCarretOffset;
import org.eclipse.titan.designer.graphics.ImageCache;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.parsers.ProjectSourceParser;
import org.eclipse.titan.designer.refactoring.RenameRefactoringWizard;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.progress.IProgressConstants;

public class RenameRefactoring
extends Refactoring {
    public static final String FILENOTIDENTIFIABLE = "The file related to the editor could not be identified";
    public static final String NORECOGNISABLEMODULENAME = "The name of the module in the file `{0}'' could not be identified";
    public static final String EXCLUDEDFROMBUILD = "The name of the module in the file `{0}'' could not be identified, the file is excluded from build";
    public static final String NOTFOUNDMODULE = "The module in file `{0}'' could not be found";
    public static final String PROJECTCONTAINSERRORS = "The project `{0}'' contains errors, which might corrupt the result of the refactoring";
    public static final String PROJECTCONTAINSTTCNPPFILES = "The project `{0}'' contains .ttcnpp files, which might corrupt the result of the refactoring";
    public static final String FIELDALREADYEXISTS = "Field with name `{0}'' already exists in type `{1}''";
    public static final String DEFINITIONALREADYEXISTS = "Name conflict: definition with name `{0}'' already exists in the scope of the selected definition or in one of its parent scopes";
    public static final String DEFINITIONALREADYEXISTS2 = "Name conflict: definition with name `{0}'' already exists in module `{1}'' at line {2}";
    private static final String ONTHEFLYANALAYSISDISABLED = "On-the-fly analysis is disabled, there is no reliable semantic information present for the refactoring to work on";
    private final IFile file;
    private final Module module;
    private Map<Module, List<ReferenceFinder.Hit>> idsMap = null;
    private String newIdentifierName;
    private ReferenceFinder referenceFinder;

    public RenameRefactoring(IFile file, Module module, ReferenceFinder referenceFinder) {
        this.file = file;
        this.module = module;
        this.referenceFinder = referenceFinder;
    }

    public String getName() {
        return "Rename " + this.referenceFinder.getSearchName();
    }

    public Module getModule() {
        return this.module;
    }

    public Identifier getRefdIdentifier() {
        return this.referenceFinder.getReferredIdentifier();
    }

    public void setNewIdentifierName(String newIdentifierName) {
        this.newIdentifierName = newIdentifierName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RefactoringStatus checkInitialConditions(IProgressMonitor monitor) throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        try {
            monitor.beginTask("Checking preconditions...", 2);
            IPreferencesService prefs = Platform.getPreferencesService();
            if (!prefs.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.useOnTheFlyParsing", false, null)) {
                result.addFatalError(ONTHEFLYANALAYSISDISABLED);
            }
            if (GlobalParser.hasTtcnppFiles((IResource)this.file.getProject())) {
                result.addError(MessageFormat.format(PROJECTCONTAINSTTCNPPFILES, this.file.getProject()));
            }
            monitor.worked(1);
            IProject project = this.file.getProject();
            if (this.projectHasOnTheFlyError(project)) {
                result.addError(MessageFormat.format(PROJECTCONTAINSERRORS, project));
            }
            monitor.worked(1);
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
            result.addFatalError(e.getMessage());
        }
        finally {
            monitor.done();
        }
        return result;
    }

    private boolean projectHasOnTheFlyError(IProject project) throws CoreException {
        String[] onTheFlyMarkerTypes;
        for (String markerType : onTheFlyMarkerTypes = new String[]{"org.eclipse.titan.designer.ontheflySyntacticMarker", "org.eclipse.titan.designer.ontheflySemanticMarker", "org.eclipse.titan.designer.ontheflyMixedMarker"}) {
            IMarker[] markers;
            for (IMarker marker : markers = project.findMarkers(markerType, true, 2)) {
                if (2 != marker.getAttribute("severity", 2)) continue;
                return true;
            }
        }
        return false;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor monitor) throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        boolean reportDebugInformation = Platform.getPreferencesService().getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.displayDebugInformation", true, null);
        this.idsMap = this.referenceFinder.findAllReferences(this.module, this.file.getProject(), monitor, reportDebugInformation);
        Identifier refdIdentifier = this.referenceFinder.getReferredIdentifier();
        Module refdModule = this.referenceFinder.assignment.getMyScope().getModuleScope();
        if (this.idsMap.containsKey(refdModule)) {
            this.idsMap.get(refdModule).add(new ReferenceFinder.Hit(refdIdentifier));
        } else {
            ArrayList<ReferenceFinder.Hit> identifierList = new ArrayList<ReferenceFinder.Hit>();
            identifierList.add(new ReferenceFinder.Hit(refdIdentifier));
            this.idsMap.put(refdModule, identifierList);
        }
        if (this.referenceFinder.fieldId == null) {
            Identifier.Identifier_type idType = this.referenceFinder.scope.getModuleScope() instanceof ASN1Module ? Identifier.Identifier_type.ID_ASN : Identifier.Identifier_type.ID_TTCN;
            Identifier newId = new Identifier(idType, this.newIdentifierName);
            Scope rootScope = this.referenceFinder.assignment.getMyScope();
            if (rootScope instanceof NamedBridgeScope && rootScope.getParentScope() != null) {
                rootScope = rootScope.getParentScope();
            }
            SubScopeVisitor subScopeVisitor = new SubScopeVisitor(rootScope);
            this.module.accept(subScopeVisitor);
            List<Scope> subScopes = subScopeVisitor.getSubScopes();
            subScopes.add(rootScope);
            for (Scope ss : subScopes) {
                if (!ss.hasAssignmentWithId(CompilationTimeStamp.getBaseTimestamp(), newId)) continue;
                ArrayList<ISubReference> subReferences = new ArrayList<ISubReference>();
                subReferences.add(new FieldSubReference(newId));
                Reference reference = new Reference(null, subReferences);
                Assignment assignment = ss.getAssBySRef(CompilationTimeStamp.getBaseTimestamp(), reference);
                if (assignment != null && assignment.getLocation() != null) {
                    result.addError(MessageFormat.format(DEFINITIONALREADYEXISTS2, newId.getDisplayName(), this.module.getName(), assignment.getLocation().getLine()));
                } else {
                    result.addError(MessageFormat.format(DEFINITIONALREADYEXISTS, newId.getDisplayName()));
                }
                return result;
            }
        } else {
            boolean alreadyExists = this.referenceFinder.type instanceof TTCN3_Set_Seq_Choice_BaseType ? ((TTCN3_Set_Seq_Choice_BaseType)this.referenceFinder.type).hasComponentWithName(this.newIdentifierName) : (this.referenceFinder.type instanceof TTCN3_Enumerated_Type ? ((TTCN3_Enumerated_Type)this.referenceFinder.type).hasEnumItemWithName(new Identifier(Identifier.Identifier_type.ID_TTCN, this.newIdentifierName)) : (this.referenceFinder.type instanceof ASN1_Choice_Type ? ((ASN1_Choice_Type)this.referenceFinder.type).hasComponentWithName(new Identifier(Identifier.Identifier_type.ID_ASN, this.newIdentifierName)) : (this.referenceFinder.type instanceof ASN1_Enumerated_Type ? ((ASN1_Enumerated_Type)this.referenceFinder.type).hasEnumItemWithName(new Identifier(Identifier.Identifier_type.ID_ASN, this.newIdentifierName)) : (this.referenceFinder.type instanceof ASN1_Sequence_Type ? ((ASN1_Sequence_Type)this.referenceFinder.type).hasComponentWithName(new Identifier(Identifier.Identifier_type.ID_ASN, this.newIdentifierName)) : (this.referenceFinder.type instanceof ASN1_Set_Type ? ((ASN1_Set_Type)this.referenceFinder.type).hasComponentWithName(new Identifier(Identifier.Identifier_type.ID_ASN, this.newIdentifierName)) : false)))));
            if (alreadyExists) {
                result.addError(MessageFormat.format(FIELDALREADYEXISTS, this.newIdentifierName, this.referenceFinder.type.getTypename()));
            }
        }
        return result;
    }

    public Change createChange(IProgressMonitor monitor) throws CoreException {
        CompositeChange result = new CompositeChange(this.getName());
        boolean isAsnRename = this.module.getModuletype() == Module.module_type.ASN_MODULE;
        String newTtcnIdentifierName = isAsnRename ? Identifier.getTtcnNameFromAsnName(this.newIdentifierName) : this.newIdentifierName;
        ArrayList<IFile> filesToProcess = new ArrayList<IFile>(this.idsMap.size());
        for (Module m : this.idsMap.keySet()) {
            List<ReferenceFinder.Hit> hitList = this.idsMap.get(m);
            boolean isTtcnModule = m.getModuletype() == Module.module_type.TTCN3_MODULE;
            IFile file = (IFile)hitList.get((int)0).identifier.getLocation().getFile();
            TextFileChange tfc = new TextFileChange(file.getName(), file);
            result.add((Change)tfc);
            MultiTextEdit rootEdit = new MultiTextEdit();
            tfc.setEdit((TextEdit)rootEdit);
            for (ReferenceFinder.Hit hit : hitList) {
                String newName;
                int offset = hit.identifier.getLocation().getOffset();
                int length = hit.identifier.getLocation().getEndOffset() - offset;
                String string = newName = isTtcnModule ? newTtcnIdentifierName : this.newIdentifierName;
                if (this.referenceFinder.fieldId == null && hit.reference != null && hit.reference.getModuleIdentifier() == null && this.referenceFinder.assignment.getMyScope().getModuleScope() != hit.reference.getMyScope().getModuleScope() && hit.reference.getMyScope().hasAssignmentWithId(CompilationTimeStamp.getBaseTimestamp(), new Identifier(isTtcnModule ? Identifier.Identifier_type.ID_TTCN : Identifier.Identifier_type.ID_ASN, this.newIdentifierName))) {
                    newName = this.referenceFinder.assignment.getMyScope().getModuleScope().getName() + "." + newName;
                }
                rootEdit.addChild((TextEdit)new ReplaceEdit(offset, length, newName));
            }
            filesToProcess.add((IFile)m.getLocation().getFile());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runAction(IEditorPart targetEditor, ISelection selection) {
        boolean isDetected;
        int offset;
        IStatusLineManager statusLineManager = targetEditor.getEditorSite().getActionBars().getStatusLineManager();
        statusLineManager.setErrorMessage(null);
        IFile file = (IFile)targetEditor.getEditorInput().getAdapter(IFile.class);
        if (file == null) {
            statusLineManager.setErrorMessage(FILENOTIDENTIFIABLE);
            return;
        }
        if (!TITANNature.hasTITANNature(file.getProject())) {
            statusLineManager.setErrorMessage("The project containing the selected file does not have the TITAN nature among its natures");
            return;
        }
        IPreferencesService prefs = Platform.getPreferencesService();
        boolean reportDebugInformation = prefs.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.displayDebugInformation", true, null);
        if (selection instanceof TextSelection && !selection.isEmpty() && !"".equals(((TextSelection)selection).getText())) {
            if (reportDebugInformation) {
                TITANDebugConsole.println("text selected: " + ((TextSelection)selection).getText());
            }
            TextSelection tSelection = (TextSelection)selection;
            offset = tSelection.getOffset() + tSelection.getLength();
        } else {
            offset = ((IEditorWithCarretOffset)targetEditor).getCarretOffset();
        }
        ProjectSourceParser projectSourceParser = GlobalParser.getProjectSourceParser(file.getProject());
        WorkspaceJob job = projectSourceParser.analyzeAll();
        if (job == null) {
            if (reportDebugInformation) {
                TITANDebugConsole.println("Rename refactoring: WorkspaceJob to analyze project could not be created.");
            }
            return;
        }
        try {
            job.join();
        }
        catch (InterruptedException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
            return;
        }
        if (ResourceExclusionHelper.isExcluded((IResource)file)) {
            targetEditor.getEditorSite().getActionBars().getStatusLineManager().setErrorMessage(MessageFormat.format(EXCLUDEDFROMBUILD, file.getFullPath()));
            return;
        }
        Module module = projectSourceParser.containedModule(file);
        if (module == null) {
            statusLineManager.setErrorMessage(MessageFormat.format(NOTFOUNDMODULE, file.getName()));
            return;
        }
        ReferenceFinder referenceFinder = RenameRefactoring.findOccurrencesLocationBased(module, offset);
        if (referenceFinder == null && !(isDetected = (referenceFinder = new ReferenceFinder()).detectAssignmentDataByOffset(module, offset, targetEditor, true, reportDebugInformation, null))) {
            return;
        }
        RenameRefactoring renameRefactoring = new RenameRefactoring(file, module, referenceFinder);
        RenameRefactoringWizard renameWizard = new RenameRefactoringWizard(renameRefactoring);
        RefactoringWizardOpenOperation operation = new RefactoringWizardOpenOperation((RefactoringWizard)renameWizard);
        try {
            operation.run(targetEditor.getEditorSite().getShell(), "");
        }
        catch (InterruptedException irex) {
            if (reportDebugInformation) {
                TITANDebugConsole.println("Rename refactoring has been cancelled");
            }
        }
        finally {
            Map<Module, List<ReferenceFinder.Hit>> changed = referenceFinder.findAllReferences(module, file.getProject(), null, reportDebugInformation);
            HashSet<Module> modules = new HashSet<Module>();
            modules.add(module);
            modules.addAll(changed.keySet());
            RenameRefactoring.reanalyseAstAfterRefactoring(file.getProject(), modules);
        }
    }

    public static void reanalyseAstAfterRefactoring(final IProject project, Set<Module> modules) {
        final ConcurrentLinkedQueue<1> reportOutdatingJobs = new ConcurrentLinkedQueue<1>();
        for (Module tempModule : modules) {
            final IFile file = (IFile)tempModule.getLocation().getFile();
            WorkspaceJob operation = new WorkspaceJob("Reports outdating for file: " + file.getName()){

                public IStatus runInWorkspace(IProgressMonitor monitor) {
                    IProject proj = file.getProject();
                    reportOutdatingJobs.add(GlobalParser.getProjectSourceParser(proj).reportOutdating(file));
                    return Status.OK_STATUS;
                }
            };
            operation.setPriority(30);
            operation.setSystem(true);
            operation.setUser(false);
            operation.setRule((ISchedulingRule)file);
            operation.setProperty(IProgressConstants.ICON_PROPERTY, (Object)ImageCache.getImageDescriptor("titan.gif"));
            reportOutdatingJobs.add(operation);
            operation.schedule();
        }
        WorkspaceJob operation = new WorkspaceJob("Analyzes all projects related to this change"){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                while (!reportOutdatingJobs.isEmpty()) {
                    WorkspaceJob job = (WorkspaceJob)reportOutdatingJobs.poll();
                    try {
                        if (job == null) continue;
                        job.join();
                    }
                    catch (InterruptedException e) {
                        ErrorReporter.logExceptionStackTrace((Exception)e);
                    }
                }
                ProjectSourceParser projectSourceParser = GlobalParser.getProjectSourceParser(project);
                projectSourceParser.analyzeAll();
                return Status.OK_STATUS;
            }
        };
        operation.setPriority(30);
        operation.setSystem(true);
        operation.setUser(false);
        operation.setProperty(IProgressConstants.ICON_PROPERTY, (Object)ImageCache.getImageDescriptor("titan.gif"));
        operation.schedule();
    }

    protected static ReferenceFinder findOccurrencesLocationBased(Module module, int offset) {
        IdentifierFinderVisitor visitor = new IdentifierFinderVisitor(offset);
        module.accept(visitor);
        Declaration def = visitor.getReferencedDeclaration();
        if (def == null || !def.shouldMarkOccurrences()) {
            return null;
        }
        return def.getReferenceFinder(module);
    }
}

