/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.preferences.pages;

import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.Activator;
import org.eclipse.titan.designer.editors.controls.HoverContentType;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public final class ContentAssistPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static final String DESCRIPTION = "Preferences for the editor's content assist";
    private static final String[][] SORTING_OPTIONS = new String[][]{{"by relevance", "by relevance"}, {"alphabetically", "alphabetically"}};
    private Composite pageComposite;
    private Group insertionGroup;
    private Composite insertionComposite;
    private BooleanFieldEditor insertSingleProposal;
    private BooleanFieldEditor insertCommonPrefixes;
    private Composite sortingComposite;
    private Group sortingGroup;
    private ComboFieldEditor sorting;
    private IntegerFieldEditor proposalListSize;
    private Group autoActivationGroup;
    private Composite autoActivationComposite;
    private BooleanFieldEditor enableAutoActivation;
    private IntegerFieldEditor autoActivationDelay;
    private Group hoverWindowContentGroup;
    private Composite hoverWindowContentComposite;
    private BooleanFieldEditor enableCodeHoverPopups;
    private ComboFieldEditor hoverWindowContentCombo;

    public ContentAssistPage() {
        super(1);
    }

    public void init(IWorkbench workbench) {
        this.setDescription(DESCRIPTION);
    }

    protected void createFieldEditors() {
        this.pageComposite = new Composite(this.getFieldEditorParent(), 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        this.pageComposite.setLayout((Layout)layout);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.pageComposite.setLayoutData((Object)gridData);
        this.insertionGroup = new Group(this.pageComposite, 64);
        this.insertionGroup.setText("Insertion");
        this.insertionGroup.setLayout((Layout)new GridLayout(2, false));
        this.insertionGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        this.insertionComposite = new Composite((Composite)this.insertionGroup, 0);
        gridData = new GridData(4, 4, false, false);
        gridData.horizontalIndent = 3;
        this.insertionComposite.setLayoutData((Object)gridData);
        this.insertSingleProposal = new BooleanFieldEditor("org.eclipse.titan.designer.singleProposalInsertion", "Insert single proposals automatically", this.insertionComposite);
        this.addField((FieldEditor)this.insertSingleProposal);
        this.insertCommonPrefixes = new BooleanFieldEditor("org.eclipse.titan.designer.commonPrefixInsertion", "Insert common prefixes automatically", this.insertionComposite);
        this.addField((FieldEditor)this.insertCommonPrefixes);
        this.sortingGroup = new Group(this.pageComposite, 64);
        this.sortingGroup.setText("Sorting");
        this.sortingGroup.setLayout((Layout)new GridLayout(2, false));
        this.sortingGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        this.sortingComposite = new Composite((Composite)this.sortingGroup, 0);
        gridData = new GridData(4, 4, false, false);
        gridData.horizontalIndent = 3;
        this.sortingComposite.setLayoutData((Object)gridData);
        this.sorting = new ComboFieldEditor("org.eclipse.titan.designer.proposalSorting", "Sort proposals", SORTING_OPTIONS, this.sortingComposite);
        Label text = this.sorting.getLabelControl(this.sortingComposite);
        text.setToolTipText("Sort proposals");
        this.addField((FieldEditor)this.sorting);
        this.proposalListSize = new IntegerFieldEditor("org.eclipse.titan.designer.proposalListSize", "Maximum amount of proposals to show", this.sortingComposite, 4);
        this.proposalListSize.setValidRange(0, 9999);
        this.proposalListSize.setErrorMessage("Value of 'Maximum amount of proposals to show' must be an Integer between 0 and 9,999");
        Label proposalListSizeText = this.proposalListSize.getLabelControl(this.sortingComposite);
        proposalListSizeText.setToolTipText("Due to performance consideration, this preference allows to limit the amount of proposals displayed at once. Zero means unlimited.");
        this.addField((FieldEditor)this.proposalListSize);
        this.autoActivationGroup = new Group(this.pageComposite, 64);
        this.autoActivationGroup.setText("Auto-Activation");
        this.autoActivationGroup.setLayout((Layout)new GridLayout(2, false));
        this.autoActivationGroup.setLayoutData((Object)new GridData(4, 4, false, false));
        this.autoActivationComposite = new Composite((Composite)this.autoActivationGroup, 0);
        gridData = new GridData(4, 4, false, false);
        gridData.horizontalIndent = 3;
        this.autoActivationComposite.setLayoutData((Object)gridData);
        this.enableAutoActivation = new BooleanFieldEditor("org.eclipse.titan.designer.autoActivation", "Enable auto activation", this.autoActivationComposite);
        this.addField((FieldEditor)this.enableAutoActivation);
        this.autoActivationDelay = new IntegerFieldEditor("org.eclipse.titan.designer.autoActivationDelay", "Auto activation delay:", this.autoActivationComposite);
        this.autoActivationDelay.setValidRange(10, 1000);
        this.autoActivationDelay.setTextLimit(10);
        this.autoActivationDelay.setEnabled(this.doGetPreferenceStore().getBoolean("org.eclipse.titan.designer.autoActivation"), this.autoActivationComposite);
        this.addField((FieldEditor)this.autoActivationDelay);
        this.hoverWindowContentGroup = new Group(this.pageComposite, 64);
        this.hoverWindowContentGroup.setText("Content of hover window");
        this.hoverWindowContentGroup.setLayout((Layout)new GridLayout(2, false));
        this.hoverWindowContentGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        this.hoverWindowContentComposite = new Composite((Composite)this.hoverWindowContentGroup, 0);
        gridData = new GridData(4, 4, false, false);
        gridData.horizontalIndent = 3;
        this.hoverWindowContentComposite.setLayoutData((Object)gridData);
        this.enableCodeHoverPopups = new BooleanFieldEditor("org.eclipse.titan.designer.enableHoverWindowPopups", "Enable code hover popups", this.hoverWindowContentComposite);
        this.addField((FieldEditor)this.enableCodeHoverPopups);
        this.hoverWindowContentCombo = new ComboFieldEditor("org.eclipse.titan.designer.hoverWindowContent", "Hover window content:", HoverContentType.getDisplayNamesAndValues(), this.hoverWindowContentComposite);
        this.hoverWindowContentCombo.setEnabled(this.doGetPreferenceStore().getBoolean("org.eclipse.titan.designer.enableHoverWindowPopups"), this.hoverWindowContentComposite);
        Label text2 = this.hoverWindowContentCombo.getLabelControl(this.hoverWindowContentComposite);
        text2.setToolTipText("What do you want to see as hover tooltip");
        this.addField((FieldEditor)this.hoverWindowContentCombo);
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return Activator.getDefault().getPreferenceStore();
    }

    public void dispose() {
        this.pageComposite.dispose();
        this.enableAutoActivation.dispose();
        this.insertionGroup.dispose();
        this.insertionComposite.dispose();
        this.insertSingleProposal.dispose();
        this.insertCommonPrefixes.dispose();
        this.sortingComposite.dispose();
        this.sortingGroup.dispose();
        this.sorting.dispose();
        this.proposalListSize.dispose();
        this.autoActivationGroup.dispose();
        this.autoActivationComposite.dispose();
        this.enableAutoActivation.dispose();
        this.autoActivationDelay.dispose();
        this.enableCodeHoverPopups.dispose();
        this.hoverWindowContentGroup.dispose();
        this.hoverWindowContentCombo.dispose();
        super.dispose();
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.autoActivationDelay.setEnabled(this.enableAutoActivation.getBooleanValue(), this.autoActivationComposite);
        this.hoverWindowContentCombo.setEnabled(this.enableCodeHoverPopups.getBooleanValue(), this.hoverWindowContentComposite);
        super.propertyChange(event);
    }

    protected void performDefaults() {
        this.autoActivationDelay.setEnabled(true, this.autoActivationComposite);
        super.performDefaults();
    }

    public boolean performOk() {
        boolean result = super.performOk();
        IEclipsePreferences node = InstanceScope.INSTANCE.getNode("org.eclipse.titan.designer");
        if (node != null) {
            try {
                node.flush();
            }
            catch (Exception e) {
                ErrorReporter.logExceptionStackTrace((Exception)e);
            }
        }
        return result;
    }
}

