/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.parsers.asn1parser;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.parsers.Interval;
import org.eclipse.titan.common.parsers.SyntacticErrorStorage;
import org.eclipse.titan.common.parsers.TITANMarker;
import org.eclipse.titan.designer.AST.ASN1.definitions.ASN1Module;
import org.eclipse.titan.designer.parsers.ISourceAnalyzer;
import org.eclipse.titan.designer.parsers.asn1parser.ASN1Listener;
import org.eclipse.titan.designer.parsers.asn1parser.Asn1Lexer;
import org.eclipse.titan.designer.parsers.asn1parser.Asn1Parser;
import org.eclipse.titan.designer.parsers.asn1parser.ModuleLevelTokenStreamTracker;
import org.eclipse.titan.designer.parsers.asn1parser.TokenWithIndexAndSubTokensFactory;

public class ASN1Analyzer
implements ISourceAnalyzer {
    private List<TITANMarker> warnings;
    private List<TITANMarker> unsupportedConstructs;
    private Interval rootInterval;
    private ASN1Module actualAsn1Module = null;
    private ASN1Listener lexerListener = null;
    private ASN1Listener parserListener = null;

    @Override
    public List<TITANMarker> getWarnings() {
        return this.warnings;
    }

    @Override
    public List<TITANMarker> getUnsupportedConstructs() {
        return this.unsupportedConstructs;
    }

    @Override
    public ASN1Module getModule() {
        return this.actualAsn1Module;
    }

    @Override
    public Interval getRootInterval() {
        return this.rootInterval;
    }

    @Override
    public List<SyntacticErrorStorage> getErrorStorage() {
        if (this.lexerListener == null || this.parserListener == null) {
            return new ArrayList<SyntacticErrorStorage>();
        }
        if (!this.lexerListener.getErrorsStored().isEmpty() && this.parserListener.getErrorsStored().isEmpty()) {
            return this.lexerListener.getErrorsStored();
        }
        if (this.lexerListener.getErrorsStored().isEmpty() && !this.parserListener.getErrorsStored().isEmpty()) {
            return this.parserListener.getErrorsStored();
        }
        if (!this.lexerListener.getErrorsStored().isEmpty() && !this.parserListener.getErrorsStored().isEmpty() && this.lexerListener.addAll(this.parserListener.getErrorsStored())) {
            return this.lexerListener.getErrorsStored();
        }
        return new ArrayList<SyntacticErrorStorage>();
    }

    @Override
    public void parse(IFile file, String code) throws FileNotFoundException {
        ANTLRInputStream charStream;
        Reader reader = null;
        if (code != null) {
            reader = new StringReader(code);
        } else if (file != null) {
            try {
                reader = new BufferedReader(new InputStreamReader(file.getContents(), file.getCharset()));
            }
            catch (Exception e) {
                ErrorReporter.logExceptionStackTrace((String)("Could not get the contents of `" + file.getName() + "'"), (Throwable)e);
                return;
            }
        } else {
            return;
        }
        try {
            charStream = new ANTLRInputStream(reader);
        }
        catch (IOException e) {
            try {
                reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return;
        }
        Asn1Lexer lexer = new Asn1Lexer((CharStream)charStream);
        lexer.setTokenFactory(new TokenWithIndexAndSubTokensFactory(true));
        lexer.setActualFile(file);
        this.lexerListener = new ASN1Listener();
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)this.lexerListener);
        ModuleLevelTokenStreamTracker tracker = new ModuleLevelTokenStreamTracker((TokenSource)lexer);
        tracker.discard(2);
        tracker.discard(100);
        tracker.discard(99);
        tracker.setActualFile(file);
        Asn1Parser parser = new Asn1Parser((TokenStream)tracker);
        parser.setProject(file.getProject());
        parser.setActualFile(file);
        parser.setBuildParseTree(false);
        this.parserListener = new ASN1Listener(parser);
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)this.parserListener);
        parser.pr_ASN1ModuleDefinition();
        this.actualAsn1Module = parser.getModule();
        this.warnings = parser.getWarnings();
        this.unsupportedConstructs = parser.getUnsupportedConstructs();
        try {
            reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

