/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.ttcn3editor;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.editors.AstSyntaxHighlightTokens;
import org.eclipse.titan.designer.editors.DocumentTracker;
import org.eclipse.titan.designer.editors.ttcn3editor.ReconcilingStrategy;
import org.eclipse.titan.designer.editors.ttcn3editor.TTCN3Editor;

public class Reconciler
implements IReconciler {
    private static final ConcurrentHashMap<IDocument, LinkedList<Listener>> MAP = new ConcurrentHashMap();
    private LinkedBlockingQueue<DirtyRegion> dirtyRegionQueue;
    private BackgroundThread backgroundThread;
    private Listener changeListener;
    private boolean mIsIncrementalReconcilerAllowed = true;
    private IProgressMonitor progressMonitor;
    private boolean isAllowedToModifyDocument = true;
    private IDocument document;
    private ITextViewer textViewer;
    private final ReconcilingStrategy reconcilingStrategy;

    protected Reconciler(ReconcilingStrategy strategy) {
        Assert.isNotNull((Object)strategy);
        this.progressMonitor = new NullProgressMonitor();
        this.reconcilingStrategy = strategy;
        this.reconcilingStrategy.setProgressMonitor(this.getProgressMonitor());
    }

    protected final void reconcilerDocumentChanged(IDocument document) {
        this.reconcilingStrategy.setDocument(document);
    }

    public final void allowIncrementalReconciler(boolean aIsIncrementalReconcilerAllowed) {
        this.mIsIncrementalReconcilerAllowed = aIsIncrementalReconcilerAllowed;
    }

    public final void setIsAllowedToModifyDocument(boolean isAllowedToModify) {
        this.isAllowedToModifyDocument = isAllowedToModify;
    }

    public final void setProgressMonitor(IProgressMonitor monitor) {
        Assert.isLegal((monitor != null ? 1 : 0) != 0);
        this.progressMonitor = monitor;
        this.reconcilingStrategy.setProgressMonitor(monitor);
    }

    protected final boolean isIncrementalReconciler() {
        IPreferencesService prefs = Platform.getPreferencesService();
        return this.mIsIncrementalReconcilerAllowed && prefs.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.useIncrementalParsing", false, null);
    }

    protected final IDocument getDocument() {
        return this.document;
    }

    protected final ITextViewer getTextViewer() {
        return this.textViewer;
    }

    protected final IProgressMonitor getProgressMonitor() {
        return this.progressMonitor;
    }

    public final IReconcilingStrategy getReconcilingStrategy(String contentType) {
        Assert.isNotNull((Object)contentType);
        return this.reconcilingStrategy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void install(ITextViewer textViewer) {
        Assert.isNotNull((Object)textViewer);
        this.textViewer = textViewer;
        Reconciler reconciler = this;
        synchronized (reconciler) {
            if (this.backgroundThread != null) {
                return;
            }
            this.backgroundThread = new BackgroundThread(this.getClass().getName());
        }
        this.dirtyRegionQueue = new LinkedBlockingQueue();
        this.changeListener = new Listener();
        textViewer.addTextInputListener((ITextInputListener)this.changeListener);
        IDocument tmpDocument = textViewer.getDocument();
        if (tmpDocument != null) {
            this.changeListener.inputDocumentAboutToBeChanged(tmpDocument, tmpDocument);
            this.changeListener.inputDocumentChanged(tmpDocument, tmpDocument);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void uninstall() {
        if (this.changeListener != null) {
            this.textViewer.removeTextInputListener((ITextInputListener)this.changeListener);
            if (this.document != null) {
                this.changeListener.uninstall(this.document);
                this.changeListener.inputDocumentChanged(this.document, null);
            }
            this.changeListener = null;
            Reconciler reconciler = this;
            synchronized (reconciler) {
                BackgroundThread bt = this.backgroundThread;
                this.backgroundThread = null;
                bt.cancel();
            }
        }
    }

    private void createDirtyRegion(DocumentEvent e) {
        if (e.getLength() == 0 && e.getText() != null) {
            this.dirtyRegionQueue.add(new DirtyRegion(e.getOffset(), e.getText().length(), "__insert", e.getText()));
        } else if (e.getText() == null || e.getText().length() == 0) {
            this.dirtyRegionQueue.add(new DirtyRegion(e.getOffset(), e.getLength(), "__remove", null));
        } else {
            this.dirtyRegionQueue.add(new DirtyRegion(e.getOffset(), e.getLength(), "__remove", null));
            this.dirtyRegionQueue.add(new DirtyRegion(e.getOffset(), e.getText().length(), "__insert", e.getText()));
        }
    }

    private void requestFullAnalyzes() {
        this.dirtyRegionQueue.add(new DirtyRegion(-1, -1, "__insert", ""));
    }

    protected void aboutToBeReconciled() {
    }

    protected final void initialProcess() {
        this.dirtyRegionQueue.clear();
        this.reconcilingStrategy.initialReconcile();
    }

    protected final void forceReconciling() {
        if (this.document != null) {
            if (!this.backgroundThread.isDirty() && this.backgroundThread.isAlive()) {
                this.aboutToBeReconciled();
            }
            if (this.backgroundThread.isActive()) {
                this.progressMonitor.setCanceled(true);
            }
            if (this.isIncrementalReconciler()) {
                DocumentEvent e = new DocumentEvent(this.document, 0, this.document.getLength(), this.document.get());
                this.createDirtyRegion(e);
            } else {
                this.requestFullAnalyzes();
            }
            this.startReconciling();
        }
    }

    protected final synchronized void startReconciling() {
        if (this.backgroundThread == null) {
            return;
        }
        if (!this.backgroundThread.isAlive()) {
            try {
                this.backgroundThread.start();
            }
            catch (IllegalThreadStateException e) {
                ErrorReporter.logExceptionStackTrace((Exception)e);
            }
        } else {
            this.backgroundThread.reset();
        }
    }

    protected void reconcilerReset() {
    }

    protected final boolean isRunningInReconcilerThread() {
        return Thread.currentThread() == this.backgroundThread;
    }

    private final int getReconcilerTimeout() {
        IPreferencesService prefs = Platform.getPreferencesService();
        int timeout = prefs.getInt("org.eclipse.titan.designer", "org.eclipse.titan.designer.reconcilerTimeout", 1, null);
        return 1000 * timeout;
    }

    class Listener
    implements IDocumentListener,
    ITextInputListener {
        private int removedNL;

        Listener() {
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
            int change = event.getText().length() - event.fLength;
            try {
                String replaced = event.fDocument.get(event.fOffset, event.fLength);
                this.removedNL = (int)replaced.chars().filter(ch -> ch == 10).count();
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }

        public void documentChanged(DocumentEvent e) {
            if (this != ((LinkedList)MAP.get(Reconciler.this.document)).getFirst()) {
                return;
            }
            IFile file = DocumentTracker.getFile(Reconciler.this.document);
            AstSyntaxHighlightTokens.update(file.getFullPath().toOSString(), e);
            if (!Reconciler.this.backgroundThread.isDirty() && Reconciler.this.backgroundThread.isAlive()) {
                if (!Reconciler.this.isAllowedToModifyDocument && Thread.currentThread() == Reconciler.this.backgroundThread) {
                    throw new UnsupportedOperationException("The reconciler thread is not allowed to modify the document");
                }
                Reconciler.this.aboutToBeReconciled();
            }
            if (Reconciler.this.backgroundThread.isActive() || Reconciler.this.backgroundThread.isDirty() && Reconciler.this.backgroundThread.isAlive()) {
                Reconciler.this.progressMonitor.setCanceled(true);
            }
            if (Reconciler.this.isIncrementalReconciler()) {
                Reconciler.this.createDirtyRegion(e);
            } else {
                Reconciler.this.requestFullAnalyzes();
            }
            Reconciler.this.backgroundThread.reset();
        }

        public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
        }

        public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
            Reconciler.this.backgroundThread.reset();
            if (oldInput != null) {
                ((LinkedList)MAP.get(oldInput)).remove(this);
                oldInput.removeDocumentListener((IDocumentListener)this);
            }
            Reconciler.this.document = newInput;
            if (newInput == null) {
                return;
            }
            if (!MAP.containsKey(newInput)) {
                LinkedList temp = new LinkedList();
                MAP.putIfAbsent(newInput, temp);
            }
            ((LinkedList)MAP.get(newInput)).add(this);
            newInput.addDocumentListener((IDocumentListener)this);
            Reconciler.this.reconcilerDocumentChanged(newInput);
            Reconciler.this.aboutToBeReconciled();
            Reconciler.this.startReconciling();
        }

        public void uninstall(IDocument oldInput) {
            if (oldInput == Reconciler.this.document) {
                if (Reconciler.this.document != null) {
                    Reconciler.this.document.removeDocumentListener((IDocumentListener)this);
                    ((LinkedList)MAP.get(oldInput)).remove(this);
                }
                if (Reconciler.this.isIncrementalReconciler()) {
                    if (Reconciler.this.document != null && Reconciler.this.document.getLength() > 0 && Reconciler.this.backgroundThread.isDirty() && Reconciler.this.backgroundThread.isAlive()) {
                        DocumentEvent e = new DocumentEvent(Reconciler.this.document, 0, Reconciler.this.document.getLength(), "");
                        Reconciler.this.createDirtyRegion(e);
                        Reconciler.this.backgroundThread.uninstall();
                    }
                } else {
                    Reconciler.this.requestFullAnalyzes();
                }
                Reconciler.this.document = null;
            }
        }
    }

    class BackgroundThread
    extends Thread {
        private boolean isCanceled;
        private volatile boolean uninstallInvoked;
        private boolean isDirty;
        private boolean isStrategyActive;

        public BackgroundThread(String name) {
            super(name);
            this.isCanceled = false;
            this.uninstallInvoked = false;
            this.isDirty = false;
            this.isStrategyActive = false;
            this.setPriority(1);
            this.setDaemon(true);
        }

        public boolean isActive() {
            return this.isStrategyActive;
        }

        public synchronized boolean isDirty() {
            return this.isDirty;
        }

        public void cancel() {
            this.isCanceled = true;
            IProgressMonitor pm = Reconciler.this.progressMonitor;
            if (pm != null) {
                pm.setCanceled(true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reset() {
            BackgroundThread backgroundThread = this;
            synchronized (backgroundThread) {
                this.isDirty = true;
            }
            Reconciler.this.reconcilerReset();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void uninstall() {
            BackgroundThread backgroundThread = this;
            synchronized (backgroundThread) {
                this.isDirty = true;
                this.uninstallInvoked = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Reconciler.this.initialProcess();
            DirtyRegion region = null;
            while (!this.isCanceled) {
                if (!this.uninstallInvoked) {
                    try {
                        region = (DirtyRegion)Reconciler.this.dirtyRegionQueue.poll(Reconciler.this.getReconcilerTimeout() + 5, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException e) {
                        ErrorReporter.logExceptionStackTrace((Exception)e);
                    }
                }
                if (this.isCanceled) break;
                if (region == null) continue;
                List<DirtyRegion> oldRegions = new ArrayList<DirtyRegion>();
                while (region != null) {
                    oldRegions.add(region);
                    region = (DirtyRegion)Reconciler.this.dirtyRegionQueue.poll();
                }
                this.isStrategyActive = true;
                boolean full = false;
                for (DirtyRegion region2 : oldRegions) {
                    if (region2.getOffset() != -1) continue;
                    full = true;
                    break;
                }
                try {
                    IDocument tmpDocument;
                    if (full || !Reconciler.this.isIncrementalReconciler() || oldRegions.size() > 100) {
                        tmpDocument = Reconciler.this.getDocument();
                        if (tmpDocument != null) {
                            Reconciler.this.reconcilingStrategy.reconcile((IRegion)new Region(0, tmpDocument.getLength()));
                        }
                    } else if (!oldRegions.isEmpty()) {
                        oldRegions = this.mergeRegions(oldRegions);
                        for (int i = 0; i < oldRegions.size(); ++i) {
                            Reconciler.this.reconcilingStrategy.reconcileSyntax(oldRegions.get(i));
                        }
                        if (!TTCN3Editor.isSemanticCheckingDelayed()) {
                            Reconciler.this.reconcilingStrategy.reconcileSemantics();
                        }
                    } else {
                        tmpDocument = Reconciler.this.getDocument();
                        if (tmpDocument != null) {
                            Reconciler.this.reconcilingStrategy.reconcile((IRegion)new Region(0, tmpDocument.getLength()));
                        }
                    }
                }
                catch (Exception e) {
                    ErrorReporter.logExceptionStackTrace((Exception)e);
                }
                oldRegions.clear();
                BackgroundThread backgroundThread = this;
                synchronized (backgroundThread) {
                    this.isDirty = Reconciler.this.progressMonitor.isCanceled();
                }
                this.isStrategyActive = false;
            }
        }

        private List<DirtyRegion> mergeRegions(List<DirtyRegion> originalRegions) {
            ArrayList<DirtyRegion> mergedRegions = new ArrayList<DirtyRegion>();
            DirtyRegion actual = originalRegions.get(0);
            boolean merged = false;
            for (int i = 1; i < originalRegions.size(); ++i) {
                DirtyRegion next = originalRegions.get(i);
                merged = false;
                if ("__insert".equals(actual.getType())) {
                    if ("__insert".equals(next.getType())) {
                        if (actual.getOffset() + actual.getLength() == next.getOffset()) {
                            actual = new DirtyRegion(actual.getOffset(), actual.getLength() + next.getLength(), "__insert", actual.getText() + next.getText());
                            merged = true;
                        }
                    } else if (actual.getOffset() + actual.getLength() == next.getOffset() + next.getLength()) {
                        int diff = actual.getOffset() - next.getOffset();
                        actual = diff < 0 ? new DirtyRegion(actual.getOffset(), -1 * diff, "__insert", actual.getText().substring(0, -1 * diff)) : (diff > 0 ? new DirtyRegion(next.getOffset(), diff, "__remove", null) : new DirtyRegion(actual.getOffset(), 0, "__insert", ""));
                        merged = true;
                    }
                } else if ("__remove".equals(next.getType())) {
                    if (next.getOffset() + next.getLength() == actual.getOffset()) {
                        actual = new DirtyRegion(next.getOffset(), actual.getLength() + next.getLength(), "__remove", null);
                        merged = true;
                    } else if (next.getOffset() == actual.getOffset()) {
                        actual = new DirtyRegion(actual.getOffset(), actual.getLength() + next.getLength(), "__remove", null);
                        merged = true;
                    }
                }
                if (merged) continue;
                if (actual.getLength() != 0) {
                    mergedRegions.add(actual);
                }
                actual = next;
            }
            if (actual.getLength() != 0) {
                mergedRegions.add(actual);
            }
            return mergedRegions;
        }
    }
}

