/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.ttcn3editor;

import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.editors.controls.HoverContentType;
import org.eclipse.titan.designer.editors.controls.Ttcn3HoverContent;
import org.eclipse.ui.part.ViewPart;

public class DocumentCommentView
extends ViewPart {
    public static final String DOCUMENT_COMMENT_VIEW_ID = "org.eclipse.titan.designer.editors.ttcn3editor.DocumentCommentView";
    private Browser browser;

    public void createPartControl(Composite parent) {
        if (this.browser == null) {
            try {
                this.browser = new Browser(parent, 0);
            }
            catch (SWTError e) {
                ErrorReporter.INTERNAL_ERROR((String)("Could not instantiate SWT Browser: " + e.getMessage()));
                return;
            }
            Ttcn3HoverContent content = new Ttcn3HoverContent();
            content.addContent(HoverContentType.INFO, "Navigate in the source to show document comment info");
            content.closeHeader();
            this.browser.setText(content.getText(HoverContentType.INFO, true));
            this.browser.setVisible(true);
        }
    }

    public void setFocus() {
        this.browser.setFocus();
    }

    public void setContent(Ttcn3HoverContent content) {
        String text = null;
        if (content.hasText(HoverContentType.INFO)) {
            text = content.getText(HoverContentType.INFO, true);
        } else if (content.hasText(HoverContentType.SOURCE)) {
            text = content.getText(HoverContentType.SOURCE, true);
        }
        if (text != null) {
            this.browser.setText(text);
            this.browser.setVisible(true);
        }
    }
}

