/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.configeditor.pages.logging;

import java.util.ArrayList;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.titan.common.parsers.AddedParseTree;
import org.eclipse.titan.common.parsers.cfg.ConfigTreeNodeUtilities;
import org.eclipse.titan.common.parsers.cfg.indices.LoggingSectionHandler;
import org.eclipse.titan.designer.editors.configeditor.ConfigEditor;
import org.eclipse.titan.designer.editors.configeditor.pages.logging.LoggingPage;
import org.eclipse.titan.designer.editors.configeditor.pages.logging.ParamDataContentProvider;
import org.eclipse.titan.designer.editors.configeditor.pages.logging.ParamDataLabelProvider;
import org.eclipse.titan.designer.editors.configeditor.pages.logging.ParamDialog;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public final class GeneralOptionsSubPage {
    private Text logFileText;
    private CCombo timeStampFormat;
    private CCombo consoleTimeStampFormat;
    private CCombo sourceInfoFormat;
    private CCombo appendFile;
    private CCombo logEventTypes;
    private CCombo logEntityName;
    private CCombo matchingHints;
    private Text actualLogFileSizeText;
    private Text actualLogFileNumberText;
    private CCombo actualDiskFullAction;
    private TableViewer paramViewer;
    private Table paramTable;
    private Button addPluginParameter;
    private Button removePluginParameter;
    private Button editPluginParameter;
    private final ConfigEditor editor;
    private final LoggingPage loggingPage;
    private LoggingSectionHandler loggingSectionHandler;
    private LoggingSectionHandler.LogParamEntry selectedLogEntry;
    private boolean valueChanged = false;

    public GeneralOptionsSubPage(ConfigEditor editor, LoggingPage loggingPage) {
        this.editor = editor;
        this.loggingPage = loggingPage;
    }

    void createSectionGeneral(FormToolkit toolkit, Composite parent) {
        String temp;
        Section section = toolkit.createSection(parent, 256);
        section.setLayoutData((Object)new GridData(4, 0, true, false));
        section.setText("Logging options for the selected component/plugin");
        section.marginWidth = 10;
        section.marginHeight = 0;
        Composite client = toolkit.createComposite((Composite)section, 64);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        client.setLayout((Layout)layout);
        section.setClient((Control)client);
        Composite generalOptions = toolkit.createComposite(client);
        generalOptions.setLayoutData((Object)new GridData(4, 0, true, false));
        GridLayout layoutGeneral = new GridLayout(2, false);
        generalOptions.setLayout((Layout)layoutGeneral);
        toolkit.paintBordersFor(generalOptions);
        this.valueChanged = true;
        toolkit.createLabel(generalOptions, "LogFile:");
        this.logFileText = toolkit.createText(generalOptions, "", 4);
        this.logFileText.setLayoutData((Object)new GridData(4, 0, true, false));
        this.logFileText.setEnabled(false);
        this.logFileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (GeneralOptionsSubPage.this.valueChanged || GeneralOptionsSubPage.this.loggingSectionHandler == null) {
                    return;
                }
                GeneralOptionsSubPage.this.editor.setDirty();
                String temp = GeneralOptionsSubPage.this.logFileText.getText();
                if (temp == null || temp.length() == 0) {
                    if (GeneralOptionsSubPage.this.selectedLogEntry.getLogFileRoot() != null) {
                        ConfigTreeNodeUtilities.removeChild((ParseTree)GeneralOptionsSubPage.this.loggingSectionHandler.getLastSectionRoot(), (ParseTree)GeneralOptionsSubPage.this.selectedLogEntry.getLogFileRoot());
                    }
                    GeneralOptionsSubPage.this.selectedLogEntry.setLogFile(null);
                    GeneralOptionsSubPage.this.selectedLogEntry.setLogFileRoot(null);
                } else if (GeneralOptionsSubPage.this.selectedLogEntry.getLogFile() == null) {
                    GeneralOptionsSubPage.this.createLogFileNode(GeneralOptionsSubPage.this.loggingPage.getSelectedTreeElement(), GeneralOptionsSubPage.this.selectedLogEntry, temp.trim());
                } else {
                    ConfigTreeNodeUtilities.setText((ParseTree)GeneralOptionsSubPage.this.selectedLogEntry.getLogFile(), (String)temp.trim());
                }
            }
        });
        if (this.selectedLogEntry != null && this.selectedLogEntry.getLogFile() != null) {
            if (this.selectedLogEntry.getLogFile().getText().length() == 0) {
                temp = ConfigTreeNodeUtilities.toString((ParseTree)this.selectedLogEntry.getLogFile());
                ConfigTreeNodeUtilities.setText((ParseTree)this.selectedLogEntry.getLogFile(), (String)temp);
            }
            this.logFileText.setText(ConfigTreeNodeUtilities.toString((ParseTree)this.selectedLogEntry.getLogFile()));
        }
        toolkit.createLabel(generalOptions, "TimeStampFormat:");
        this.timeStampFormat = new CCombo(generalOptions, 0x800000);
        this.timeStampFormat.setEnabled(false);
        this.timeStampFormat.setLayoutData((Object)new GridData(100, -1));
        this.timeStampFormat.add("Time");
        this.timeStampFormat.add("DateTime");
        this.timeStampFormat.add("Seconds");
        this.timeStampFormat.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (GeneralOptionsSubPage.this.valueChanged || GeneralOptionsSubPage.this.loggingSectionHandler == null) {
                    return;
                }
                GeneralOptionsSubPage.this.editor.setDirty();
                String temp = GeneralOptionsSubPage.this.timeStampFormat.getText();
                if (temp == null || temp.length() == 0) {
                    if (GeneralOptionsSubPage.this.selectedLogEntry.getTimestampFormatRoot() != null) {
                        ConfigTreeNodeUtilities.removeChild((ParseTree)GeneralOptionsSubPage.this.loggingSectionHandler.getLastSectionRoot(), (ParseTree)GeneralOptionsSubPage.this.selectedLogEntry.getTimestampFormatRoot());
                    }
                    GeneralOptionsSubPage.this.selectedLogEntry.setTimestampFormat(null);
                    GeneralOptionsSubPage.this.selectedLogEntry.setTimestampFormatRoot(null);
                } else if (GeneralOptionsSubPage.this.selectedLogEntry.getTimestampFormat() == null) {
                    GeneralOptionsSubPage.this.createTimeStampFormatNode(GeneralOptionsSubPage.this.loggingPage.getSelectedTreeElement(), GeneralOptionsSubPage.this.selectedLogEntry, temp.trim());
                } else {
                    ConfigTreeNodeUtilities.setText((ParseTree)GeneralOptionsSubPage.this.selectedLogEntry.getTimestampFormat(), (String)temp.trim());
                }
            }
        });
        if (this.selectedLogEntry != null && this.selectedLogEntry.getTimestampFormat() != null) {
            temp = ConfigTreeNodeUtilities.toString((ParseTree)this.selectedLogEntry.getTimestampFormat()).trim();
            this.timeStampFormat.setText(temp);
        }
        toolkit.createLabel(generalOptions, "ConsoleTimeStampFormat:");
        this.consoleTimeStampFormat = new CCombo(generalOptions, 0x800000);
        this.consoleTimeStampFormat.setEnabled(false);
        this.consoleTimeStampFormat.setLayoutData((Object)new GridData(100, -1));
        this.consoleTimeStampFormat.add("Time");
        this.consoleTimeStampFormat.add("DateTime");
        this.consoleTimeStampFormat.add("Seconds");
        this.consoleTimeStampFormat.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (GeneralOptionsSubPage.this.valueChanged || GeneralOptionsSubPage.this.loggingSectionHandler == null) {
                    return;
                }
                GeneralOptionsSubPage.this.editor.setDirty();
                String temp = GeneralOptionsSubPage.this.consoleTimeStampFormat.getText();
                if (temp == null || temp.length() == 0) {
                    if (GeneralOptionsSubPage.this.selectedLogEntry.getConsoleTimestampFormatRoot() != null) {
                        ConfigTreeNodeUtilities.removeChild((ParseTree)GeneralOptionsSubPage.this.loggingSectionHandler.getLastSectionRoot(), (ParseTree)GeneralOptionsSubPage.this.selectedLogEntry.getConsoleTimestampFormatRoot());
                    }
                    GeneralOptionsSubPage.this.selectedLogEntry.setConsoleTimestampFormat(null);
                    GeneralOptionsSubPage.this.selectedLogEntry.setConsoleTimestampFormatRoot(null);
                } else if (GeneralOptionsSubPage.this.selectedLogEntry.getConsoleTimestampFormat() == null) {
                    GeneralOptionsSubPage.this.createConsoleTimeStampFormatNode(GeneralOptionsSubPage.this.loggingPage.getSelectedTreeElement(), GeneralOptionsSubPage.this.selectedLogEntry, temp.trim());
                } else {
                    ConfigTreeNodeUtilities.setText((ParseTree)GeneralOptionsSubPage.this.selectedLogEntry.getConsoleTimestampFormat(), (String)temp.trim());
                }
            }
        });
        if (this.selectedLogEntry != null && this.selectedLogEntry.getConsoleTimestampFormat() != null) {
            temp = ConfigTreeNodeUtilities.toString((ParseTree)this.selectedLogEntry.getConsoleTimestampFormat()).trim();
            this.consoleTimeStampFormat.setText(temp);
        }
        toolkit.createLabel(generalOptions, "SourceInfoFormat:");
        this.sourceInfoFormat = new CCombo(generalOptions, 0x800000);
        this.sourceInfoFormat.setEnabled(false);
        this.sourceInfoFormat.setLayoutData((Object)new GridData(100, -1));
        this.sourceInfoFormat.add("None");
        this.sourceInfoFormat.add("Single");
        this.sourceInfoFormat.add("Stack");
        this.sourceInfoFormat.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (GeneralOptionsSubPage.this.valueChanged || GeneralOptionsSubPage.this.loggingSectionHandler == null) {
                    return;
                }
                GeneralOptionsSubPage.this.editor.setDirty();
                String temp = GeneralOptionsSubPage.this.sourceInfoFormat.getText();
                if (temp == null || temp.length() == 0) {
                    if (GeneralOptionsSubPage.this.selectedLogEntry.getSourceInfoFormatRoot() != null) {
                        ConfigTreeNodeUtilities.removeChild((ParseTree)GeneralOptionsSubPage.this.loggingSectionHandler.getLastSectionRoot(), (ParseTree)GeneralOptionsSubPage.this.selectedLogEntry.getSourceInfoFormatRoot());
                    }
                    GeneralOptionsSubPage.this.selectedLogEntry.setSourceInfoFormat(null);
                    GeneralOptionsSubPage.this.selectedLogEntry.setSourceInfoFormatRoot(null);
                } else if (GeneralOptionsSubPage.this.selectedLogEntry.getSourceInfoFormat() == null) {
                    GeneralOptionsSubPage.this.createSourceInfoFormatNode(GeneralOptionsSubPage.this.loggingPage.getSelectedTreeElement(), GeneralOptionsSubPage.this.selectedLogEntry, temp.trim());
                } else {
                    ConfigTreeNodeUtilities.setText((ParseTree)GeneralOptionsSubPage.this.selectedLogEntry.getSourceInfoFormat(), (String)temp.trim());
                }
            }
        });
        if (this.selectedLogEntry != null && this.selectedLogEntry.getSourceInfoFormat() != null) {
            this.sourceInfoFormat.setText(ConfigTreeNodeUtilities.toString((ParseTree)this.selectedLogEntry.getSourceInfoFormat()).trim());
        }
        toolkit.createLabel(generalOptions, "AppendFile:");
        this.appendFile = new CCombo(generalOptions, 0x800000);
        this.appendFile.setEnabled(false);
        this.appendFile.setLayoutData((Object)new GridData(100, -1));
        this.appendFile.add("Yes");
        this.appendFile.add("No");
        this.appendFile.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (GeneralOptionsSubPage.this.valueChanged || GeneralOptionsSubPage.this.loggingSectionHandler == null) {
                    return;
                }
                GeneralOptionsSubPage.this.editor.setDirty();
                String temp = GeneralOptionsSubPage.this.appendFile.getText();
                if (temp == null || temp.length() == 0) {
                    if (GeneralOptionsSubPage.this.selectedLogEntry.getAppendFileRoot() != null) {
                        ConfigTreeNodeUtilities.removeChild((ParseTree)GeneralOptionsSubPage.this.loggingSectionHandler.getLastSectionRoot(), (ParseTree)GeneralOptionsSubPage.this.selectedLogEntry.getAppendFileRoot());
                    }
                    GeneralOptionsSubPage.this.selectedLogEntry.setAppendFile(null);
                    GeneralOptionsSubPage.this.selectedLogEntry.setAppendFileRoot(null);
                } else if (GeneralOptionsSubPage.this.selectedLogEntry.getAppendFile() == null) {
                    GeneralOptionsSubPage.this.createAppendFileNode(GeneralOptionsSubPage.this.loggingPage.getSelectedTreeElement(), GeneralOptionsSubPage.this.selectedLogEntry, temp.trim());
                } else {
                    ConfigTreeNodeUtilities.setText((ParseTree)GeneralOptionsSubPage.this.selectedLogEntry.getAppendFile(), (String)temp.trim());
                }
            }
        });
        if (this.selectedLogEntry != null && this.selectedLogEntry.getAppendFile() != null) {
            this.appendFile.setText(ConfigTreeNodeUtilities.toString((ParseTree)this.selectedLogEntry.getAppendFile()).trim());
        }
        toolkit.createLabel(generalOptions, "LogEventTypes:");
        this.logEventTypes = new CCombo(generalOptions, 0x800000);
        this.logEventTypes.setEnabled(false);
        this.logEventTypes.setLayoutData((Object)new GridData(100, -1));
        this.logEventTypes.add("Yes");
        this.logEventTypes.add("No");
        this.logEventTypes.add("Detailed");
        this.logEventTypes.add("Subcategories");
        this.logEventTypes.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (GeneralOptionsSubPage.this.valueChanged || GeneralOptionsSubPage.this.loggingSectionHandler == null) {
                    return;
                }
                GeneralOptionsSubPage.this.editor.setDirty();
                String temp = GeneralOptionsSubPage.this.logEventTypes.getText();
                if (temp == null || temp.length() == 0) {
                    if (GeneralOptionsSubPage.this.selectedLogEntry.getLogeventTypesRoot() != null) {
                        ConfigTreeNodeUtilities.removeChild((ParseTree)GeneralOptionsSubPage.this.loggingSectionHandler.getLastSectionRoot(), (ParseTree)GeneralOptionsSubPage.this.selectedLogEntry.getLogeventTypesRoot());
                    }
                    GeneralOptionsSubPage.this.selectedLogEntry.setLogeventTypes(null);
                    GeneralOptionsSubPage.this.selectedLogEntry.setLogeventTypesRoot(null);
                } else if (GeneralOptionsSubPage.this.selectedLogEntry.getLogeventTypes() == null) {
                    GeneralOptionsSubPage.this.createLogEventTypesNode(GeneralOptionsSubPage.this.loggingPage.getSelectedTreeElement(), GeneralOptionsSubPage.this.selectedLogEntry, temp.trim());
                } else {
                    ConfigTreeNodeUtilities.setText((ParseTree)GeneralOptionsSubPage.this.selectedLogEntry.getLogeventTypes(), (String)temp.trim());
                }
            }
        });
        if (this.selectedLogEntry != null && this.selectedLogEntry.getLogeventTypes() != null) {
            this.logEventTypes.setText(ConfigTreeNodeUtilities.toString((ParseTree)this.selectedLogEntry.getLogeventTypes()).trim());
        }
        toolkit.createLabel(generalOptions, "LogEntityName:");
        this.logEntityName = new CCombo(generalOptions, 0x800000);
        this.logEntityName.setEnabled(false);
        this.logEntityName.setLayoutData((Object)new GridData(100, -1));
        this.logEntityName.add("Yes");
        this.logEntityName.add("No");
        this.logEntityName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (GeneralOptionsSubPage.this.valueChanged || GeneralOptionsSubPage.this.loggingSectionHandler == null) {
                    return;
                }
                GeneralOptionsSubPage.this.editor.setDirty();
                String temp = GeneralOptionsSubPage.this.logEntityName.getText();
                if (temp == null || temp.length() == 0) {
                    if (GeneralOptionsSubPage.this.selectedLogEntry.getLogEntityNameRoot() != null) {
                        ConfigTreeNodeUtilities.removeChild((ParseTree)GeneralOptionsSubPage.this.loggingSectionHandler.getLastSectionRoot(), (ParseTree)GeneralOptionsSubPage.this.selectedLogEntry.getLogEntityNameRoot());
                    }
                    GeneralOptionsSubPage.this.selectedLogEntry.setLogEntityName(null);
                    GeneralOptionsSubPage.this.selectedLogEntry.setLogEntityNameRoot(null);
                } else if (GeneralOptionsSubPage.this.selectedLogEntry.getLogEntityName() == null) {
                    GeneralOptionsSubPage.this.createLogEntityNameNode(GeneralOptionsSubPage.this.loggingPage.getSelectedTreeElement(), GeneralOptionsSubPage.this.selectedLogEntry, temp.trim());
                } else {
                    ConfigTreeNodeUtilities.setText((ParseTree)GeneralOptionsSubPage.this.selectedLogEntry.getLogEntityName(), (String)temp.trim());
                }
            }
        });
        if (this.selectedLogEntry != null && this.selectedLogEntry.getLogEntityName() != null) {
            this.logEntityName.setText(ConfigTreeNodeUtilities.toString((ParseTree)this.selectedLogEntry.getLogEntityName()).trim());
        }
        toolkit.createLabel(generalOptions, "MatchingHints");
        this.matchingHints = new CCombo(generalOptions, 0x800000);
        this.matchingHints.setEnabled(false);
        this.matchingHints.setLayoutData((Object)new GridData(100, -1));
        this.matchingHints.add("Compact");
        this.matchingHints.add("Detailed");
        this.matchingHints.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (GeneralOptionsSubPage.this.valueChanged || GeneralOptionsSubPage.this.loggingSectionHandler == null) {
                    return;
                }
                GeneralOptionsSubPage.this.editor.setDirty();
                String temp = GeneralOptionsSubPage.this.matchingHints.getText();
                if (temp == null || temp.length() == 0) {
                    if (GeneralOptionsSubPage.this.selectedLogEntry.getMatchingHintsRoot() != null) {
                        ConfigTreeNodeUtilities.removeChild((ParseTree)GeneralOptionsSubPage.this.loggingSectionHandler.getLastSectionRoot(), (ParseTree)GeneralOptionsSubPage.this.selectedLogEntry.getMatchingHintsRoot());
                    }
                    GeneralOptionsSubPage.this.selectedLogEntry.setMatchingHints(null);
                    GeneralOptionsSubPage.this.selectedLogEntry.setMatchingHintsRoot(null);
                } else if (GeneralOptionsSubPage.this.selectedLogEntry.getMatchingHints() == null) {
                    GeneralOptionsSubPage.this.createMatchingHintsNode(GeneralOptionsSubPage.this.loggingPage.getSelectedTreeElement(), GeneralOptionsSubPage.this.selectedLogEntry, temp.trim());
                } else {
                    ConfigTreeNodeUtilities.setText((ParseTree)GeneralOptionsSubPage.this.selectedLogEntry.getMatchingHints(), (String)temp.trim());
                }
            }
        });
        if (this.selectedLogEntry != null && this.selectedLogEntry.getMatchingHints() != null) {
            this.matchingHints.setText(ConfigTreeNodeUtilities.toString((ParseTree)this.selectedLogEntry.getMatchingHints()).trim());
        }
        toolkit.createLabel(generalOptions, "Log file size:");
        this.actualLogFileSizeText = toolkit.createText(generalOptions, "", 4);
        this.actualLogFileSizeText.setEnabled(false);
        this.actualLogFileSizeText.setLayoutData((Object)new GridData(95, -1));
        this.actualLogFileSizeText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (GeneralOptionsSubPage.this.valueChanged || GeneralOptionsSubPage.this.selectedLogEntry == null) {
                    return;
                }
                GeneralOptionsSubPage.this.editor.setDirty();
                String temp = GeneralOptionsSubPage.this.actualLogFileSizeText.getText();
                if (temp == null || temp.length() == 0) {
                    if (GeneralOptionsSubPage.this.selectedLogEntry.getLogfileSize() != null) {
                        ConfigTreeNodeUtilities.removeChild((ParseTree)GeneralOptionsSubPage.this.loggingSectionHandler.getLastSectionRoot(), (ParseTree)GeneralOptionsSubPage.this.selectedLogEntry.getLogfileSizeRoot());
                    }
                    GeneralOptionsSubPage.this.selectedLogEntry.setLogfileSize(null);
                    GeneralOptionsSubPage.this.selectedLogEntry.setLogfileSizeRoot(null);
                } else if (GeneralOptionsSubPage.this.selectedLogEntry.getLogfileSize() == null) {
                    GeneralOptionsSubPage.this.createLogFileSizeNode(GeneralOptionsSubPage.this.loggingPage.getSelectedTreeElement(), GeneralOptionsSubPage.this.selectedLogEntry, temp.trim());
                } else {
                    ConfigTreeNodeUtilities.setText((ParseTree)GeneralOptionsSubPage.this.selectedLogEntry.getLogfileSize(), (String)temp.trim());
                }
            }
        });
        if (this.selectedLogEntry != null && this.selectedLogEntry.getLogfileSize() != null) {
            this.actualLogFileSizeText.setText(ConfigTreeNodeUtilities.toString((ParseTree)this.selectedLogEntry.getLogfileSize()));
        }
        toolkit.createLabel(generalOptions, "Log file number:");
        this.actualLogFileNumberText = toolkit.createText(generalOptions, "", 4);
        this.actualLogFileNumberText.setEnabled(false);
        this.actualLogFileNumberText.setLayoutData((Object)new GridData(95, -1));
        this.actualLogFileNumberText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (GeneralOptionsSubPage.this.valueChanged || GeneralOptionsSubPage.this.selectedLogEntry == null) {
                    return;
                }
                GeneralOptionsSubPage.this.editor.setDirty();
                String temp = GeneralOptionsSubPage.this.actualLogFileNumberText.getText();
                if (temp == null || temp.length() == 0) {
                    if (GeneralOptionsSubPage.this.selectedLogEntry.getLogfileNumber() != null) {
                        ConfigTreeNodeUtilities.removeChild((ParseTree)GeneralOptionsSubPage.this.loggingSectionHandler.getLastSectionRoot(), (ParseTree)GeneralOptionsSubPage.this.selectedLogEntry.getLogfileNumberRoot());
                    }
                    GeneralOptionsSubPage.this.selectedLogEntry.setLogfileNumber(null);
                    GeneralOptionsSubPage.this.selectedLogEntry.setLogfileNumberRoot(null);
                } else if (GeneralOptionsSubPage.this.selectedLogEntry.getLogfileNumber() == null) {
                    GeneralOptionsSubPage.this.createLogFileNumberNode(GeneralOptionsSubPage.this.loggingPage.getSelectedTreeElement(), GeneralOptionsSubPage.this.selectedLogEntry, temp.trim());
                } else {
                    ConfigTreeNodeUtilities.setText((ParseTree)GeneralOptionsSubPage.this.selectedLogEntry.getLogfileNumber(), (String)temp.trim());
                }
            }
        });
        if (this.selectedLogEntry != null && this.selectedLogEntry.getLogfileNumber() != null) {
            this.actualLogFileNumberText.setText(ConfigTreeNodeUtilities.toString((ParseTree)this.selectedLogEntry.getLogfileNumber()));
        }
        toolkit.createLabel(generalOptions, "Disk full action:");
        this.actualDiskFullAction = new CCombo(generalOptions, 0x800000);
        this.actualDiskFullAction.setEnabled(false);
        this.actualDiskFullAction.setLayoutData((Object)new GridData(100, -1));
        this.actualDiskFullAction.add("Stop");
        this.actualDiskFullAction.add("Retry");
        this.actualDiskFullAction.add("Delete");
        this.actualDiskFullAction.add("Error");
        this.actualDiskFullAction.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (GeneralOptionsSubPage.this.valueChanged || GeneralOptionsSubPage.this.selectedLogEntry == null) {
                    return;
                }
                GeneralOptionsSubPage.this.editor.setDirty();
                String temp = GeneralOptionsSubPage.this.actualDiskFullAction.getText();
                if (temp == null || temp.length() == 0) {
                    if (GeneralOptionsSubPage.this.selectedLogEntry.getDiskFullAction() != null) {
                        ConfigTreeNodeUtilities.removeChild((ParseTree)GeneralOptionsSubPage.this.loggingSectionHandler.getLastSectionRoot(), (ParseTree)GeneralOptionsSubPage.this.selectedLogEntry.getDiskFullActionRoot());
                    }
                    GeneralOptionsSubPage.this.selectedLogEntry.setDiskFullAction(null);
                    GeneralOptionsSubPage.this.selectedLogEntry.setDiskFullActionRoot(null);
                } else if (GeneralOptionsSubPage.this.selectedLogEntry.getDiskFullAction() == null) {
                    GeneralOptionsSubPage.this.createDiskFullActionNode(GeneralOptionsSubPage.this.loggingPage.getSelectedTreeElement(), GeneralOptionsSubPage.this.selectedLogEntry, temp.trim());
                } else {
                    ConfigTreeNodeUtilities.setText((ParseTree)GeneralOptionsSubPage.this.selectedLogEntry.getDiskFullAction(), (String)temp.trim());
                }
            }
        });
        if (this.selectedLogEntry != null && this.selectedLogEntry.getDiskFullAction() != null) {
            this.actualDiskFullAction.setText(ConfigTreeNodeUtilities.toString((ParseTree)this.selectedLogEntry.getDiskFullAction()));
        }
        toolkit.createLabel(generalOptions, "Plugin specific:");
        Composite components = toolkit.createComposite(generalOptions, 64);
        GridLayout tablelayout = new GridLayout();
        tablelayout.numColumns = 2;
        components.setLayout((Layout)tablelayout);
        components.setLayoutData((Object)new GridData(4, 4, true, true));
        toolkit.paintBordersFor(components);
        this.paramTable = toolkit.createTable(components, 66308);
        GridData gd = new GridData(4, 4, true, true);
        this.paramTable.setLayoutData((Object)gd);
        this.paramTable.setEnabled(this.loggingSectionHandler != null);
        this.paramViewer = new TableViewer(this.paramTable);
        this.paramViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                GeneralOptionsSubPage.this.internalRefresh();
            }
        });
        TableColumn column = new TableColumn(this.paramTable, 16384, 0);
        column.setText("Parameter");
        column.setMoveable(false);
        column.setWidth(80);
        TableColumn column2 = new TableColumn(this.paramTable, 16384, 0);
        column2.setText("Value");
        column2.setMoveable(false);
        column2.setWidth(90);
        this.paramTable.setLinesVisible(true);
        this.paramTable.setHeaderVisible(true);
        this.paramTable.setEnabled(false);
        this.paramViewer.setContentProvider((IContentProvider)new ParamDataContentProvider());
        this.paramViewer.setLabelProvider((IBaseLabelProvider)new ParamDataLabelProvider());
        Composite buttons = toolkit.createComposite(components);
        buttons.setLayout((Layout)new GridLayout());
        buttons.setLayoutData((Object)new GridData(1026));
        this.addPluginParameter = toolkit.createButton(buttons, "Add...", 8);
        GridData gdButton = new GridData(258);
        this.addPluginParameter.setLayoutData((Object)gdButton);
        this.addPluginParameter.setEnabled(false);
        this.addPluginParameter.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParamDialog d;
                if (GeneralOptionsSubPage.this.loggingSectionHandler == null) {
                    return;
                }
                if (GeneralOptionsSubPage.this.loggingSectionHandler.getLastSectionRoot() == null) {
                    GeneralOptionsSubPage.this.loggingPage.createLoggingSection();
                }
                if ((d = new ParamDialog(null, GeneralOptionsSubPage.this.selectedLogEntry, null)).open() == 0) {
                    TableItem[] items;
                    LoggingSectionHandler.PluginSpecificParam psp = GeneralOptionsSubPage.this.createPluginSpecificParamNode(d.getName(), d.getValue());
                    GeneralOptionsSubPage.this.paramViewer.setInput((Object)GeneralOptionsSubPage.this.selectedLogEntry);
                    for (TableItem item : items = GeneralOptionsSubPage.this.paramTable.getItems()) {
                        if (!item.getData().equals(psp)) continue;
                        GeneralOptionsSubPage.this.paramTable.setSelection(item);
                        GeneralOptionsSubPage.this.paramTable.showSelection();
                        break;
                    }
                    GeneralOptionsSubPage.this.internalRefresh();
                    GeneralOptionsSubPage.this.editor.setDirty();
                }
            }
        });
        buttons.setLayout((Layout)new GridLayout());
        buttons.setLayoutData((Object)new GridData(1026));
        this.editPluginParameter = toolkit.createButton(buttons, "Edit...", 8);
        gdButton = new GridData(258);
        this.editPluginParameter.setLayoutData((Object)gdButton);
        this.editPluginParameter.setEnabled(false);
        this.editPluginParameter.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (GeneralOptionsSubPage.this.loggingSectionHandler == null) {
                    return;
                }
                if (GeneralOptionsSubPage.this.loggingSectionHandler.getLastSectionRoot() == null) {
                    GeneralOptionsSubPage.this.loggingPage.createLoggingSection();
                }
                StructuredSelection selection = (StructuredSelection)GeneralOptionsSubPage.this.paramViewer.getSelection();
                LoggingSectionHandler.PluginSpecificParam psp = (LoggingSectionHandler.PluginSpecificParam)selection.getFirstElement();
                ParamDialog d = new ParamDialog(null, GeneralOptionsSubPage.this.selectedLogEntry, psp);
                if (d.open() == 0) {
                    TableItem[] items;
                    if (psp.getParam() != null) {
                        ConfigTreeNodeUtilities.removeChild((ParseTree)GeneralOptionsSubPage.this.loggingSectionHandler.getLastSectionRoot(), (ParseTree)psp.getParam());
                    }
                    GeneralOptionsSubPage.this.selectedLogEntry.getPluginSpecificParam().remove(psp);
                    psp = GeneralOptionsSubPage.this.createPluginSpecificParamNode(d.getName(), d.getValue());
                    for (TableItem item : items = GeneralOptionsSubPage.this.paramTable.getItems()) {
                        if (!item.getData().equals(psp)) continue;
                        GeneralOptionsSubPage.this.paramTable.setSelection(item);
                        GeneralOptionsSubPage.this.paramTable.showSelection();
                        break;
                    }
                    GeneralOptionsSubPage.this.internalRefresh();
                    GeneralOptionsSubPage.this.editor.setDirty();
                }
            }
        });
        this.removePluginParameter = toolkit.createButton(buttons, "Remove", 8);
        gdButton = new GridData(258);
        this.removePluginParameter.setLayoutData((Object)gdButton);
        this.removePluginParameter.setEnabled(false);
        this.removePluginParameter.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (GeneralOptionsSubPage.this.loggingSectionHandler == null) {
                    return;
                }
                StructuredSelection selection = (StructuredSelection)GeneralOptionsSubPage.this.paramViewer.getSelection();
                LoggingSectionHandler.PluginSpecificParam psp = (LoggingSectionHandler.PluginSpecificParam)selection.getFirstElement();
                if (psp.getParam() != null) {
                    ConfigTreeNodeUtilities.removeChild((ParseTree)GeneralOptionsSubPage.this.loggingSectionHandler.getLastSectionRoot(), (ParseTree)psp.getParam());
                }
                GeneralOptionsSubPage.this.selectedLogEntry.getPluginSpecificParam().remove(psp);
                GeneralOptionsSubPage.this.internalRefresh();
                GeneralOptionsSubPage.this.editor.setDirty();
            }
        });
        this.valueChanged = false;
    }

    private void createNode(LoggingSectionHandler.LoggerTreeElement aLte, LoggingSectionHandler.LogParamEntry aLogEntry, String aValue, String aNodeText, ParseTree aRoot, ParseTree aData) {
        ConfigTreeNodeUtilities.addChild((ParseTree)this.loggingSectionHandler.getLastSectionRoot(), (ParseTree)aRoot);
        StringBuilder name = new StringBuilder();
        aLte.writeNamePrefix(name);
        name.append(aNodeText + " := ");
        ConfigTreeNodeUtilities.addChild((ParseTree)aRoot, (ParseTree)new AddedParseTree("\n"));
        ConfigTreeNodeUtilities.addChild((ParseTree)aRoot, (ParseTree)new AddedParseTree(name.toString()));
        ConfigTreeNodeUtilities.addChild((ParseTree)aRoot, (ParseTree)aData);
    }

    private void createLogFileNode(LoggingSectionHandler.LoggerTreeElement lte, LoggingSectionHandler.LogParamEntry logentry, String value) {
        logentry.setLogFileRoot((ParseTree)new ParserRuleContext());
        logentry.setLogFile((ParseTree)new AddedParseTree(value));
        this.createNode(lte, logentry, value, "LogFile", logentry.getLogFileRoot(), logentry.getLogFile());
    }

    private void createTimeStampFormatNode(LoggingSectionHandler.LoggerTreeElement lte, LoggingSectionHandler.LogParamEntry logentry, String value) {
        logentry.setTimestampFormatRoot((ParseTree)new ParserRuleContext());
        logentry.setTimestampFormat((ParseTree)new AddedParseTree(value));
        this.createNode(lte, logentry, value, "TimeStampFormat", logentry.getTimestampFormatRoot(), logentry.getTimestampFormat());
    }

    private void createConsoleTimeStampFormatNode(LoggingSectionHandler.LoggerTreeElement lte, LoggingSectionHandler.LogParamEntry logentry, String value) {
        logentry.setConsoleTimestampFormatRoot((ParseTree)new ParserRuleContext());
        logentry.setConsoleTimestampFormat((ParseTree)new AddedParseTree(value));
        this.createNode(lte, logentry, value, "ConsoleTimeStampFormat", logentry.getConsoleTimestampFormatRoot(), logentry.getConsoleTimestampFormat());
    }

    private void createSourceInfoFormatNode(LoggingSectionHandler.LoggerTreeElement lte, LoggingSectionHandler.LogParamEntry logentry, String value) {
        logentry.setSourceInfoFormatRoot((ParseTree)new ParserRuleContext());
        logentry.setSourceInfoFormat((ParseTree)new AddedParseTree(value));
        this.createNode(lte, logentry, value, "SourceInfoFormat", logentry.getSourceInfoFormatRoot(), logentry.getSourceInfoFormat());
    }

    private void createAppendFileNode(LoggingSectionHandler.LoggerTreeElement lte, LoggingSectionHandler.LogParamEntry logentry, String value) {
        logentry.setAppendFileRoot((ParseTree)new ParserRuleContext());
        logentry.setAppendFile((ParseTree)new AddedParseTree(value));
        this.createNode(lte, logentry, value, "AppendFile", logentry.getAppendFileRoot(), logentry.getAppendFile());
    }

    private void createLogEventTypesNode(LoggingSectionHandler.LoggerTreeElement lte, LoggingSectionHandler.LogParamEntry logentry, String value) {
        logentry.setLogeventTypesRoot((ParseTree)new ParserRuleContext());
        logentry.setLogeventTypes((ParseTree)new AddedParseTree(value));
        this.createNode(lte, logentry, value, "LogEventTypes", logentry.getLogeventTypesRoot(), logentry.getLogeventTypes());
    }

    private void createLogEntityNameNode(LoggingSectionHandler.LoggerTreeElement lte, LoggingSectionHandler.LogParamEntry logentry, String value) {
        logentry.setLogEntityNameRoot((ParseTree)new ParserRuleContext());
        logentry.setLogEntityName((ParseTree)new AddedParseTree(value));
        this.createNode(lte, logentry, value, "LogEntityName", logentry.getLogEntityNameRoot(), logentry.getLogEntityName());
    }

    private void createMatchingHintsNode(LoggingSectionHandler.LoggerTreeElement lte, LoggingSectionHandler.LogParamEntry logentry, String value) {
        logentry.setMatchingHintsRoot((ParseTree)new ParserRuleContext());
        logentry.setMatchingHints((ParseTree)new AddedParseTree(value));
        this.createNode(lte, logentry, value, "MatchingHints", logentry.getMatchingHintsRoot(), logentry.getMatchingHints());
    }

    private void createLogFileSizeNode(LoggingSectionHandler.LoggerTreeElement lte, LoggingSectionHandler.LogParamEntry logentry, String value) {
        logentry.setLogfileSizeRoot((ParseTree)new ParserRuleContext());
        logentry.setLogfileSize((ParseTree)new AddedParseTree(value));
        this.createNode(lte, logentry, value, "LogFileSize", logentry.getLogfileSizeRoot(), logentry.getLogfileSize());
    }

    private void createLogFileNumberNode(LoggingSectionHandler.LoggerTreeElement lte, LoggingSectionHandler.LogParamEntry logentry, String value) {
        logentry.setLogfileNumberRoot((ParseTree)new ParserRuleContext());
        logentry.setLogfileNumber((ParseTree)new AddedParseTree(value));
        this.createNode(lte, logentry, value, "LogFileNumber", logentry.getLogfileNumberRoot(), logentry.getLogfileNumber());
    }

    private void createDiskFullActionNode(LoggingSectionHandler.LoggerTreeElement lte, LoggingSectionHandler.LogParamEntry logentry, String value) {
        logentry.setDiskFullActionRoot((ParseTree)new ParserRuleContext());
        logentry.setDiskFullAction((ParseTree)new AddedParseTree(value));
        this.createNode(lte, logentry, value, "DiskFullAction", logentry.getDiskFullActionRoot(), logentry.getDiskFullAction());
    }

    private LoggingSectionHandler.PluginSpecificParam createPluginSpecificParamNode(String param, String value) {
        StringBuilder name = new StringBuilder();
        this.loggingPage.getSelectedTreeElement().writeNamePrefix(name);
        name.append(param);
        name.append(" := ");
        AddedParseTree keyAST = new AddedParseTree(name.toString());
        AddedParseTree valueAST = new AddedParseTree(value);
        ParserRuleContext root = new ParserRuleContext();
        ConfigTreeNodeUtilities.addChild((ParseTree)this.loggingSectionHandler.getLastSectionRoot(), (ParseTree)root);
        ConfigTreeNodeUtilities.addChild((ParseTree)root, (ParseTree)new AddedParseTree("\n"));
        ConfigTreeNodeUtilities.addChild((ParseTree)root, (ParseTree)keyAST);
        ConfigTreeNodeUtilities.addChild((ParseTree)root, (ParseTree)valueAST);
        LoggingSectionHandler.PluginSpecificParam psp = new LoggingSectionHandler.PluginSpecificParam((ParseTree)root, (ParseTree)keyAST, (ParseTree)valueAST, param);
        this.selectedLogEntry.getPluginSpecificParam().add(psp);
        return psp;
    }

    private void internalRefresh() {
        if (this.selectedLogEntry == null) {
            this.logFileText.setEnabled(false);
            this.timeStampFormat.setEnabled(false);
            this.consoleTimeStampFormat.setEnabled(false);
            this.sourceInfoFormat.setEnabled(false);
            this.appendFile.setEnabled(false);
            this.logEventTypes.setEnabled(false);
            this.logEntityName.setEnabled(false);
            this.matchingHints.setEnabled(false);
            this.actualLogFileSizeText.setEnabled(false);
            this.actualLogFileNumberText.setEnabled(false);
            this.actualDiskFullAction.setEnabled(false);
            this.paramTable.setEnabled(false);
            this.addPluginParameter.setEnabled(false);
            this.editPluginParameter.setEnabled(false);
            this.removePluginParameter.setEnabled(false);
            return;
        }
        this.addPluginParameter.setEnabled(true);
        if (((StructuredSelection)this.paramViewer.getSelection()).getFirstElement() != null) {
            this.editPluginParameter.setEnabled(true);
            this.removePluginParameter.setEnabled(true);
        }
        this.valueChanged = true;
        if (this.logFileText != null) {
            if (this.selectedLogEntry.getLogFile() == null) {
                this.logFileText.setText("");
            } else {
                this.logFileText.setText(ConfigTreeNodeUtilities.toString((ParseTree)this.selectedLogEntry.getLogFile()).trim());
            }
            this.logFileText.setEnabled(true);
        }
        if (this.timeStampFormat != null) {
            if (this.selectedLogEntry.getTimestampFormat() == null) {
                this.timeStampFormat.setText("");
            } else {
                this.timeStampFormat.setText(ConfigTreeNodeUtilities.toString((ParseTree)this.selectedLogEntry.getTimestampFormat()).trim());
            }
            this.timeStampFormat.setEnabled(true);
        }
        if (this.consoleTimeStampFormat != null) {
            if (this.selectedLogEntry.getConsoleTimestampFormat() == null) {
                this.consoleTimeStampFormat.setText("");
            } else {
                this.consoleTimeStampFormat.setText(ConfigTreeNodeUtilities.toString((ParseTree)this.selectedLogEntry.getConsoleTimestampFormat()).trim());
            }
            this.consoleTimeStampFormat.setEnabled(true);
        }
        if (this.sourceInfoFormat != null) {
            if (this.selectedLogEntry.getSourceInfoFormat() == null) {
                this.sourceInfoFormat.setText("");
            } else {
                this.sourceInfoFormat.setText(ConfigTreeNodeUtilities.toString((ParseTree)this.selectedLogEntry.getSourceInfoFormat()).trim());
            }
            this.sourceInfoFormat.setEnabled(true);
        }
        if (this.appendFile != null) {
            if (this.selectedLogEntry.getAppendFile() == null) {
                this.appendFile.setText("");
            } else {
                this.appendFile.setText(ConfigTreeNodeUtilities.toString((ParseTree)this.selectedLogEntry.getAppendFile()).trim());
            }
            this.appendFile.setEnabled(true);
        }
        if (this.logEventTypes != null) {
            if (this.selectedLogEntry.getLogeventTypes() == null) {
                this.logEventTypes.setText("");
            } else {
                this.logEventTypes.setText(ConfigTreeNodeUtilities.toString((ParseTree)this.selectedLogEntry.getLogeventTypes()).trim());
            }
            this.logEventTypes.setEnabled(true);
        }
        if (this.logEntityName != null) {
            if (this.selectedLogEntry.getLogEntityName() == null) {
                this.logEntityName.setText("");
            } else {
                this.logEntityName.setText(ConfigTreeNodeUtilities.toString((ParseTree)this.selectedLogEntry.getLogEntityName()).trim());
            }
            this.logEntityName.setEnabled(true);
        }
        if (this.matchingHints != null) {
            if (this.selectedLogEntry.getMatchingHints() == null) {
                this.matchingHints.setText("");
            } else {
                this.matchingHints.setText(ConfigTreeNodeUtilities.toString((ParseTree)this.selectedLogEntry.getMatchingHints()).trim());
            }
            this.matchingHints.setEnabled(true);
        }
        if (this.actualLogFileSizeText != null) {
            if (this.selectedLogEntry.getLogfileSize() == null) {
                this.actualLogFileSizeText.setText("");
            } else {
                this.actualLogFileSizeText.setText(ConfigTreeNodeUtilities.toString((ParseTree)this.selectedLogEntry.getLogfileSize()).trim());
            }
            this.actualLogFileSizeText.setEnabled(true);
        }
        if (this.actualLogFileNumberText != null) {
            if (this.selectedLogEntry.getLogfileNumber() == null) {
                this.actualLogFileNumberText.setText("");
            } else {
                this.actualLogFileNumberText.setText(ConfigTreeNodeUtilities.toString((ParseTree)this.selectedLogEntry.getLogfileNumber()).trim());
            }
            this.actualLogFileNumberText.setEnabled(true);
        }
        if (this.actualDiskFullAction != null) {
            if (this.selectedLogEntry.getDiskFullAction() == null) {
                this.actualDiskFullAction.setText("");
            } else {
                this.actualDiskFullAction.setText(ConfigTreeNodeUtilities.toString((ParseTree)this.selectedLogEntry.getDiskFullAction()).trim());
            }
            this.actualDiskFullAction.setEnabled(true);
        }
        if (this.paramTable != null) {
            this.paramTable.setEnabled(true);
            this.paramViewer.setInput((Object)this.selectedLogEntry);
        }
        this.valueChanged = false;
    }

    public void initializeEntry(LoggingSectionHandler.LoggerTreeElement lte, LoggingSectionHandler.LogParamEntry logentry) {
        if (logentry == null) {
            return;
        }
        this.createLogFileNode(lte, logentry, "\"%e.%h-%r-part%i.%s\"");
        this.createTimeStampFormatNode(lte, logentry, "Time");
        this.createConsoleTimeStampFormatNode(lte, logentry, "Time");
        this.createSourceInfoFormatNode(lte, logentry, "None");
        this.createAppendFileNode(lte, logentry, "No");
        this.createLogEventTypesNode(lte, logentry, "No");
        this.createLogEntityNameNode(lte, logentry, "No");
        this.createLogFileSizeNode(lte, logentry, "0");
        this.createLogFileNumberNode(lte, logentry, "1");
        this.createDiskFullActionNode(lte, logentry, "Error");
        this.paramTable.setEnabled(true);
        this.paramViewer.setInput((Object)logentry);
    }

    public void pluginRenamed() {
        LoggingSectionHandler.LoggerTreeElement lte = this.loggingPage.getSelectedTreeElement();
        if (this.selectedLogEntry.getLogFileRoot() != null) {
            ConfigTreeNodeUtilities.removeChild((ParseTree)this.loggingSectionHandler.getLastSectionRoot(), (ParseTree)this.selectedLogEntry.getLogFileRoot());
            this.createLogFileNode(lte, this.selectedLogEntry, this.logFileText.getText().trim());
        }
        if (this.selectedLogEntry.getTimestampFormatRoot() != null) {
            ConfigTreeNodeUtilities.removeChild((ParseTree)this.loggingSectionHandler.getLastSectionRoot(), (ParseTree)this.selectedLogEntry.getTimestampFormatRoot());
            this.createTimeStampFormatNode(lte, this.selectedLogEntry, this.timeStampFormat.getText().trim());
        }
        if (this.selectedLogEntry.getConsoleTimestampFormatRoot() != null) {
            ConfigTreeNodeUtilities.removeChild((ParseTree)this.loggingSectionHandler.getLastSectionRoot(), (ParseTree)this.selectedLogEntry.getConsoleTimestampFormatRoot());
            this.createConsoleTimeStampFormatNode(lte, this.selectedLogEntry, this.consoleTimeStampFormat.getText().trim());
        }
        if (this.selectedLogEntry.getSourceInfoFormatRoot() != null) {
            ConfigTreeNodeUtilities.removeChild((ParseTree)this.loggingSectionHandler.getLastSectionRoot(), (ParseTree)this.selectedLogEntry.getSourceInfoFormatRoot());
            this.createSourceInfoFormatNode(lte, this.selectedLogEntry, this.sourceInfoFormat.getText().trim());
        }
        if (this.selectedLogEntry.getAppendFileRoot() != null) {
            ConfigTreeNodeUtilities.removeChild((ParseTree)this.loggingSectionHandler.getLastSectionRoot(), (ParseTree)this.selectedLogEntry.getAppendFileRoot());
            this.createAppendFileNode(lte, this.selectedLogEntry, this.appendFile.getText().trim());
        }
        if (this.selectedLogEntry.getLogeventTypesRoot() != null) {
            ConfigTreeNodeUtilities.removeChild((ParseTree)this.loggingSectionHandler.getLastSectionRoot(), (ParseTree)this.selectedLogEntry.getLogeventTypesRoot());
            this.createLogEventTypesNode(lte, this.selectedLogEntry, this.logEventTypes.getText().trim());
        }
        if (this.selectedLogEntry.getLogEntityNameRoot() != null) {
            ConfigTreeNodeUtilities.removeChild((ParseTree)this.loggingSectionHandler.getLastSectionRoot(), (ParseTree)this.selectedLogEntry.getLogEntityNameRoot());
            this.createLogEntityNameNode(lte, this.selectedLogEntry, this.logEntityName.getText().trim());
        }
        if (this.selectedLogEntry.getLogfileSizeRoot() != null) {
            ConfigTreeNodeUtilities.removeChild((ParseTree)this.loggingSectionHandler.getLastSectionRoot(), (ParseTree)this.selectedLogEntry.getLogfileSizeRoot());
            this.createLogFileSizeNode(lte, this.selectedLogEntry, this.actualLogFileSizeText.getText().trim());
        }
        if (this.selectedLogEntry.getLogfileNumberRoot() != null) {
            ConfigTreeNodeUtilities.removeChild((ParseTree)this.loggingSectionHandler.getLastSectionRoot(), (ParseTree)this.selectedLogEntry.getLogfileNumberRoot());
            this.createLogFileNumberNode(lte, this.selectedLogEntry, this.actualLogFileNumberText.getText().trim());
        }
        if (this.selectedLogEntry.getDiskFullActionRoot() != null) {
            ConfigTreeNodeUtilities.removeChild((ParseTree)this.loggingSectionHandler.getLastSectionRoot(), (ParseTree)this.selectedLogEntry.getDiskFullActionRoot());
            this.createDiskFullActionNode(lte, this.selectedLogEntry, this.actualDiskFullAction.getText().trim());
        }
        ArrayList list = new ArrayList(this.selectedLogEntry.getPluginSpecificParam());
        for (LoggingSectionHandler.PluginSpecificParam param : list) {
            ConfigTreeNodeUtilities.removeChild((ParseTree)this.loggingSectionHandler.getLastSectionRoot(), (ParseTree)param.getParam());
        }
        this.selectedLogEntry.getPluginSpecificParam().clear();
        for (LoggingSectionHandler.PluginSpecificParam param : list) {
            this.createPluginSpecificParamNode(param.getParamName(), param.getValue().getText());
        }
        this.paramViewer.setInput((Object)this.selectedLogEntry);
    }

    public void refreshData(LoggingSectionHandler loggingSectionHandler, LoggingSectionHandler.LogParamEntry logentry) {
        this.loggingSectionHandler = loggingSectionHandler;
        this.selectedLogEntry = logentry;
        if (this.logFileText != null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    GeneralOptionsSubPage.this.internalRefresh();
                }
            });
        }
    }
}

