/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.configeditor.pages.include;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.titan.common.parsers.cfg.indices.DefineSectionHandler;
import org.eclipse.titan.common.parsers.cfg.indices.IncludeSectionHandler;
import org.eclipse.titan.designer.editors.configeditor.ConfigEditor;
import org.eclipse.titan.designer.editors.configeditor.pages.include.DefineSubPage;
import org.eclipse.titan.designer.editors.configeditor.pages.include.IncludeSubPage;
import org.eclipse.titan.designer.graphics.ImageCache;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public final class IncludeDefinePage
extends FormPage {
    private final ConfigEditor editor;
    private ScrolledForm form;
    private final IncludeSubPage includeSubPage;
    private final DefineSubPage defineSubPage;

    public IncludeDefinePage(ConfigEditor editor) {
        super((FormEditor)editor, "Include_Define_section_page", "Include and Define");
        this.editor = editor;
        this.includeSubPage = new IncludeSubPage(editor);
        this.defineSubPage = new DefineSubPage(editor);
    }

    protected void createFormContent(IManagedForm managedForm) {
        this.form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        this.form.setText("Include and Define sections");
        this.form.setBackgroundImage(ImageCache.getImage("form_banner.gif"));
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        this.form.getBody().setLayout((Layout)layout);
        Composite componentsMC = toolkit.createComposite(this.form.getBody());
        layout = new GridLayout();
        layout.numColumns = 1;
        componentsMC.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        gd.grabExcessVerticalSpace = true;
        componentsMC.setLayoutData((Object)gd);
        this.includeSubPage.createIncludeSection(componentsMC, this.form, toolkit);
        this.defineSubPage.createDefinitionSection(componentsMC, this.form, toolkit);
        this.setErrorMessage();
    }

    public void refreshData(IncludeSectionHandler includeSectionHandler, DefineSectionHandler defineSectionHandler) {
        this.includeSubPage.refreshData(includeSectionHandler);
        this.defineSubPage.refreshData(defineSectionHandler);
    }

    public void setActive(boolean active) {
        this.setErrorMessage();
        super.setActive(active);
    }

    public void setErrorMessage() {
        if (this.form != null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (IncludeDefinePage.this.editor.getErrorMessage() == null) {
                        IncludeDefinePage.this.form.getForm().setMessage(null, 0);
                    } else {
                        IncludeDefinePage.this.form.getForm().setMessage(IncludeDefinePage.this.editor.getErrorMessage(), 3);
                    }
                    IncludeDefinePage.this.form.getForm().getHead().layout();
                    IncludeDefinePage.this.form.getForm().getHead().redraw();
                }
            });
        }
    }
}

