/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.values.expressions;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.TemplateRestriction;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.TemplateInstance;
import org.eclipse.titan.designer.AST.TTCN3.values.Expression_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionStruct;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.IsValueExpression;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public class Ttcn2StringExpression
extends Expression_Value {
    private static final String OPERANDERROR = "Cannot determine the argument type of `ttcn2string()' operation";
    private final TemplateInstance templateInstance;

    public Ttcn2StringExpression(TemplateInstance templateInstance) {
        this.templateInstance = templateInstance;
        if (templateInstance != null) {
            templateInstance.setFullNameParent(this);
        }
    }

    @Override
    public Expression_Value.Operation_type getOperationType() {
        return Expression_Value.Operation_type.TTCN2STRING_OPERATION;
    }

    @Override
    public boolean checkExpressionSelfReference(CompilationTimeStamp timestamp, Assignment lhs) {
        return this.templateInstance != null && this.templateInstance.getTemplateBody().checkExpressionSelfReferenceTemplate(timestamp, lhs);
    }

    @Override
    public String createStringRepresentation() {
        StringBuilder builder = new StringBuilder("ttcn2string(");
        builder.append(this.templateInstance.createStringRepresentation());
        builder.append(')');
        return builder.toString();
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.templateInstance != null) {
            this.templateInstance.setMyScope(scope);
        }
    }

    @Override
    public void setCodeSection(GovernedSimple.CodeSectionType codeSection) {
        super.setCodeSection(codeSection);
        if (this.templateInstance != null) {
            this.templateInstance.setCodeSection(codeSection);
        }
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.templateInstance == child) {
            return builder.append(".<operand>");
        }
        return builder;
    }

    @Override
    public IType.Type_type getExpressionReturntype(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        return IType.Type_type.TYPE_CHARSTRING;
    }

    @Override
    public boolean isUnfoldable(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        return true;
    }

    @Override
    public IValue setLoweridToReference(CompilationTimeStamp timestamp) {
        if (this.templateInstance != null && this.templateInstance.getType() != null && this.templateInstance.getDerivedReference() != null) {
            this.templateInstance.getTemplateBody().setLoweridToReference(timestamp);
        }
        return this;
    }

    @Override
    public IValue evaluateValue(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return this.lastValue;
        }
        this.isErroneous = false;
        this.lastTimeChecked = timestamp;
        this.lastValue = this;
        if (this.templateInstance == null) {
            return this.lastValue;
        }
        this.checkExpressionOperands(timestamp, expectedValue, referenceChain);
        if (this.getIsErroneous(timestamp)) {
            return this.lastValue;
        }
        if (this.isUnfoldable(timestamp, referenceChain)) {
            return this.lastValue;
        }
        return this.lastValue;
    }

    private void checkExpressionOperands(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        Expected_Value_type internalExpectation = Expected_Value_type.EXPECTED_DYNAMIC_VALUE.equals((Object)expectedValue) ? Expected_Value_type.EXPECTED_TEMPLATE : expectedValue;
        ITTCN3Template template = this.templateInstance.getTemplateBody();
        template.setMyGovernor(null);
        IType governor = this.templateInstance.getExpressionGovernor(timestamp, internalExpectation);
        if (governor == null) {
            template = template.setLoweridToReference(timestamp);
            governor = template.getExpressionGovernor(timestamp, internalExpectation);
        }
        if (governor == null) {
            if (!template.getIsErroneous(timestamp)) {
                this.templateInstance.getLocation().reportSemanticError(OPERANDERROR);
            }
            this.setIsErroneous(true);
        } else {
            this.templateInstance.getExpressionReturntype(timestamp, internalExpectation);
            IsValueExpression.checkExpressionTemplateInstance(timestamp, this, this.templateInstance, governor, referenceChain, expectedValue);
        }
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.templateInstance != null) {
            this.templateInstance.updateSyntax(reparser, false);
            reparser.updateLocation(this.templateInstance.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.templateInstance == null) {
            return;
        }
        this.templateInstance.findReferences(referenceFinder, foundIdentifiers);
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        return this.templateInstance == null || this.templateInstance.accept(v);
    }

    @Override
    public void reArrangeInitCode(JavaGenData aData, StringBuilder source, Module usageModule) {
        if (this.templateInstance != null) {
            this.templateInstance.reArrangeInitCode(aData, source, usageModule);
        }
    }

    @Override
    public void generateCodeExpressionExpression(JavaGenData aData, ExpressionStruct expression) {
        aData.addCommonLibraryImport("TTCN_Logger");
        aData.addBuiltinTypeImport("TitanCharString");
        aData.addBuiltinTypeImport("TTCN_Logger.data_log_format_t");
        expression.preamble.append("//TODO: initial implement, original: Logger_Format_Scope\n");
        expression.preamble.append("TTCN_Logger.set_log_format(data_log_format_t.LF_TTCN);\n");
        expression.preamble.append("TTCN_Logger.begin_event_log2str();\n");
        ExpressionStruct expression2 = new ExpressionStruct();
        if (this.templateInstance != null) {
            this.templateInstance.generateCode(aData, expression2, TemplateRestriction.Restriction_type.TR_NONE);
            expression2.expression.append(".log();\n");
            expression.preamble.append((CharSequence)expression2.preamble);
            expression.preamble.append((CharSequence)expression2.expression);
        }
        String tempId = aData.getTemporaryVariableName();
        expression.preamble.append(MessageFormat.format("final TitanCharString {0} = TTCN_Logger.end_event_log2str();\n", tempId));
        expression.preamble.append("TTCN_Logger.set_log_format(data_log_format_t.LF_LEGACY);\n");
        expression.expression.append(tempId);
    }
}

