/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.values.expressions;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.ReferenceChain;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.TemplateRestriction;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.TemplateInstance;
import org.eclipse.titan.designer.AST.TTCN3.values.Charstring_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Expression_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionStruct;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.IsValueExpression;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class IsTemplateKindExpression
extends Expression_Value {
    private static final String OPERAND1_ERROR1 = "Cannot determine the type of the 1st operand of the `istemplatekind' operation";
    private static final String OPERAND1_ERROR2 = "The 1st operand of the `istemplatekind' operation cannot be encoded";
    private static final String OPERAND2_ERROR1 = "The 2nd operand of the `istemplatekind' operation should be a charstring value";
    private final TemplateInstance templateInstance;
    private final Value value;

    public IsTemplateKindExpression(TemplateInstance templateInstance, Value value) {
        this.templateInstance = templateInstance;
        this.value = value;
        if (templateInstance != null) {
            templateInstance.setFullNameParent(this);
        }
        if (value != null) {
            value.setFullNameParent(this);
        }
    }

    @Override
    public Expression_Value.Operation_type getOperationType() {
        return Expression_Value.Operation_type.ISTEMPLATEKIND_OPERATION;
    }

    @Override
    public boolean checkExpressionSelfReference(CompilationTimeStamp timestamp, Assignment lhs) {
        if (this.templateInstance != null && this.templateInstance.getTemplateBody().checkExpressionSelfReferenceTemplate(timestamp, lhs)) {
            return true;
        }
        return this.value != null && this.value.checkExpressionSelfReferenceValue(timestamp, lhs);
    }

    @Override
    public String createStringRepresentation() {
        StringBuilder builder = new StringBuilder("istemplatekind(");
        builder.append(this.templateInstance.createStringRepresentation());
        builder.append(", ");
        builder.append(this.value == null ? "null" : this.value.createStringRepresentation());
        builder.append(')');
        return builder.toString();
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.templateInstance != null) {
            this.templateInstance.setMyScope(scope);
        }
        if (this.value != null) {
            this.value.setMyScope(scope);
        }
    }

    @Override
    public void setCodeSection(GovernedSimple.CodeSectionType codeSection) {
        super.setCodeSection(codeSection);
        if (this.templateInstance != null) {
            this.templateInstance.setCodeSection(codeSection);
        }
        if (this.value != null) {
            this.value.setCodeSection(codeSection);
        }
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.templateInstance == child) {
            return builder.append(".<operand1>");
        }
        if (this.value == child) {
            return builder.append(".<operand2>");
        }
        return builder;
    }

    @Override
    public IType.Type_type getExpressionReturntype(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        return IType.Type_type.TYPE_BOOL;
    }

    @Override
    public boolean isUnfoldable(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        return true;
    }

    private void checkExpressionOperands(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        this.checkExpressionOperand1(timestamp, expectedValue, referenceChain);
        this.checkExpressionOperand2(timestamp, expectedValue, referenceChain);
    }

    private void checkExpressionOperand1(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        if (this.templateInstance == null) {
            this.setIsErroneous(true);
            return;
        }
        Expected_Value_type internalExpectation = Expected_Value_type.EXPECTED_DYNAMIC_VALUE.equals((Object)expectedValue) ? Expected_Value_type.EXPECTED_TEMPLATE : expectedValue;
        ITTCN3Template template = this.templateInstance.getTemplateBody();
        template.setMyGovernor(null);
        IType governor = this.templateInstance.getExpressionGovernor(timestamp, internalExpectation);
        if (governor == null) {
            template = template.setLoweridToReference(timestamp);
            governor = template.getExpressionGovernor(timestamp, internalExpectation);
        }
        if (governor == null) {
            if (!template.getIsErroneous(timestamp)) {
                this.templateInstance.getLocation().reportSemanticError(OPERAND1_ERROR1);
            }
            this.setIsErroneous(true);
            return;
        }
        IsValueExpression.checkExpressionTemplateInstance(timestamp, this, this.templateInstance, governor, referenceChain, expectedValue);
        if (this.getIsErroneous(timestamp)) {
            return;
        }
        governor = governor.getTypeRefdLast(timestamp);
        switch (governor.getTypetype()) {
            case TYPE_UNDEFINED: 
            case TYPE_NULL: 
            case TYPE_REFERENCED: 
            case TYPE_VERDICT: 
            case TYPE_PORT: 
            case TYPE_COMPONENT: 
            case TYPE_DEFAULT: 
            case TYPE_SIGNATURE: 
            case TYPE_FUNCTION: 
            case TYPE_ALTSTEP: 
            case TYPE_TESTCASE: {
                if (this.isErroneous) break;
                this.location.reportSemanticError(OPERAND1_ERROR2);
                this.setIsErroneous(true);
                break;
            }
        }
    }

    private void checkExpressionOperand2(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        String text;
        if (this.value == null) {
            this.setIsErroneous(true);
            return;
        }
        this.value.setLoweridToReference(timestamp);
        IType.Type_type tempType = this.value.getExpressionReturntype(timestamp, expectedValue);
        switch (tempType) {
            case TYPE_CHARSTRING: {
                break;
            }
            case TYPE_UNDEFINED: {
                this.setIsErroneous(true);
                break;
            }
            default: {
                if (this.isErroneous) break;
                this.location.reportSemanticError(OPERAND2_ERROR1);
                this.setIsErroneous(true);
            }
        }
        ReferenceChain chain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
        IValue lastValue = this.value.getValueRefdLast(timestamp, chain);
        chain.release();
        if (!(lastValue.isUnfoldable(timestamp) || "value".equals(text = ((Charstring_Value)lastValue).getValue()) || "list".equals(text) || "complement".equals(text) || "AnyValue".equals(text) || "?".equals(text) || "AnyValueOrNone".equals(text) || "*".equals(text) || "range".equals(text) || "superset".equals(text) || "subset".equals(text) || "omit".equals(text) || "decmatch".equals(text) || "AnyElement".equals(text) || "AnyElementsOrNone".equals(text) || "permutation".equals(text) || "length".equals(text) || "ifpresent".equals(text) || "pattern".equals(text))) {
            this.value.getLocation().reportSemanticError(MessageFormat.format("Incorrect second parameter ({0}) was passed to istemplatekind.", text));
            this.setIsErroneous(true);
        }
    }

    @Override
    public IValue evaluateValue(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return this.lastValue;
        }
        this.isErroneous = false;
        this.lastTimeChecked = timestamp;
        this.lastValue = this;
        if (this.templateInstance != null) {
            this.checkExpressionOperands(timestamp, expectedValue, referenceChain);
        }
        return this.lastValue;
    }

    @Override
    public void checkRecursions(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        if (referenceChain.add(this)) {
            if (this.templateInstance != null) {
                referenceChain.markState();
                this.templateInstance.checkRecursions(timestamp, referenceChain);
                referenceChain.previousState();
            }
            if (this.value != null) {
                referenceChain.markState();
                this.value.checkRecursions(timestamp, referenceChain);
                referenceChain.previousState();
            }
        }
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.templateInstance != null) {
            this.templateInstance.updateSyntax(reparser, false);
            reparser.updateLocation(this.templateInstance.getLocation());
        }
        if (this.value != null) {
            this.value.updateSyntax(reparser, false);
            reparser.updateLocation(this.value.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.templateInstance != null) {
            this.templateInstance.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.value != null) {
            this.value.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.templateInstance != null && !this.templateInstance.accept(v)) {
            return false;
        }
        return this.value == null || this.value.accept(v);
    }

    @Override
    public boolean returnsNative() {
        return true;
    }

    @Override
    public void reArrangeInitCode(JavaGenData aData, StringBuilder source, Module usageModule) {
        if (this.templateInstance != null) {
            this.templateInstance.reArrangeInitCode(aData, source, usageModule);
        }
        if (this.value != null) {
            this.value.reArrangeInitCode(aData, source, usageModule);
        }
    }

    @Override
    public boolean canGenerateSingleExpression() {
        return this.value.canGenerateSingleExpression() && this.templateInstance.hasSingleExpression();
    }

    @Override
    public StringBuilder generateCodeInit(JavaGenData aData, StringBuilder source, String name) {
        ExpressionStruct expression = new ExpressionStruct();
        expression.expression.append(name);
        expression.expression.append(".operator_assign(");
        this.generateCodeExpressionExpression(aData, expression);
        expression.expression.append(")");
        expression.mergeExpression(source);
        return source;
    }

    @Override
    public void generateCodeExpressionExpression(JavaGenData aData, ExpressionStruct expression) {
        this.templateInstance.generateCode(aData, expression, TemplateRestriction.Restriction_type.TR_NONE);
        expression.expression.append(".get_istemplate_kind( ");
        if (this.value.isUnfoldable(CompilationTimeStamp.getBaseTimestamp())) {
            this.value.generateCodeExpressionMandatory(aData, expression, false);
        } else {
            IValue refdLast = this.value.getValueRefdLast(CompilationTimeStamp.getBaseTimestamp(), null);
            refdLast.generateCodeExpression(aData, expression, false);
        }
        expression.expression.append(')');
    }
}

