/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.values;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.ArraySubReference;
import org.eclipse.titan.designer.AST.FieldSubReference;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceChain;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.types.HexString_Type;
import org.eclipse.titan.designer.AST.TTCN3.values.Bitstring_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Integer_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Octetstring_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.Hex2BitExpression;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.Hex2OctExpression;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Hexstring_Value
extends Value {
    private final String value;

    public Hexstring_Value(String value) {
        this.value = value.replaceAll("\\s", "");
    }

    @Override
    public IValue.Value_type getValuetype() {
        return IValue.Value_type.HEXSTRING_VALUE;
    }

    @Override
    public IType.Type_type getExpressionReturntype(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        return IType.Type_type.TYPE_HEXSTRING;
    }

    @Override
    public String createStringRepresentation() {
        StringBuilder builder = new StringBuilder();
        builder.append('\'').append(this.value).append("'H");
        return builder.toString();
    }

    @Override
    public IType getExpressionGovernor(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        if (this.myGovernor != null) {
            return this.myGovernor;
        }
        return new HexString_Type();
    }

    @Override
    public IValue getReferencedSubValue(CompilationTimeStamp timestamp, Reference reference, int actualSubReference, IReferenceChain refChain) {
        List<ISubReference> subreferences = reference.getSubreferences();
        if (this.getIsErroneous(timestamp) || subreferences.size() <= actualSubReference) {
            return this;
        }
        IType type = this.myGovernor.getTypeRefdLast(timestamp);
        ISubReference subreference = subreferences.get(actualSubReference);
        switch (subreference.getReferenceType()) {
            case arraySubReference: {
                Value arrayIndex = ((ArraySubReference)subreference).getValue();
                IValue valueIndex = arrayIndex.getValueRefdLast(timestamp, refChain);
                if (!valueIndex.isUnfoldable(timestamp)) {
                    if (IValue.Value_type.INTEGER_VALUE.equals((Object)valueIndex.getValuetype())) {
                        int index = ((Integer_Value)valueIndex).intValue();
                        return this.getStringElement(index, arrayIndex.getLocation());
                    }
                    arrayIndex.getLocation().reportSemanticError("An integer value was expected as index");
                    return null;
                }
                return null;
            }
            case fieldSubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid field reference `{0}'': type `{1}'' does not have fields.", ((FieldSubReference)subreference).getId().getDisplayName(), type.getTypename()));
                return null;
            }
            case parameterisedSubReference: {
                subreference.getLocation().reportSemanticError("Invalid reference: internal parameterisation is not supported");
                return null;
            }
        }
        subreference.getLocation().reportSemanticError("Unsupported subreference kind.");
        return null;
    }

    @Override
    public boolean isUnfoldable(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        return false;
    }

    public String getValue() {
        return this.value;
    }

    public int getValueLength() {
        if (this.value == null || this.isErroneous) {
            return 0;
        }
        return this.value.length();
    }

    public Hexstring_Value getStringElement(int index, Location location) {
        if (this.value == null) {
            return null;
        }
        if (index < 0) {
            location.reportSemanticError(MessageFormat.format("A non-negative integer value was expected instead of {0} for indexing a string element", index));
            return null;
        }
        if (index >= this.value.length()) {
            location.reportSemanticError(MessageFormat.format("Index overflow when accessing a string element: the index is {0}, but the string has only {1} elements", index, this.value.length()));
            return null;
        }
        Hexstring_Value result = new Hexstring_Value(this.value.substring(index, index + 1));
        result.setMyGovernor(this.myGovernor);
        result.setMyScope(this.myScope);
        return result;
    }

    @Override
    public Value setValuetype(CompilationTimeStamp timestamp, IValue.Value_type newType) {
        switch (newType) {
            case BITSTRING_VALUE: {
                return new Bitstring_Value(this);
            }
            case OCTETSTRING_VALUE: {
                return new Octetstring_Value(this);
            }
        }
        return super.setValuetype(timestamp, newType);
    }

    @Override
    public boolean checkEquality(CompilationTimeStamp timestamp, IValue other) {
        ReferenceChain referenceChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
        IValue last = other.getValueRefdLast(timestamp, referenceChain);
        referenceChain.release();
        return IValue.Value_type.HEXSTRING_VALUE.equals((Object)last.getValuetype()) && this.value.equals(((Hexstring_Value)last).getValue());
    }

    @Override
    public boolean evaluateIsvalue(boolean fromSequence) {
        return true;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        return true;
    }

    @Override
    public StringBuilder generateCodeInit(JavaGenData aData, StringBuilder source, String name) {
        source.append(MessageFormat.format("{0}.operator_assign({1});\n", name, this.generateSingleExpression(aData)));
        this.lastTimeGenerated = aData.getBuildTimstamp();
        return source;
    }

    @Override
    public boolean canGenerateSingleExpression() {
        return true;
    }

    @Override
    public StringBuilder generateSingleExpression(JavaGenData aData) {
        StringBuilder result = new StringBuilder();
        if (this.myGovernor != null) {
            IType type = this.myGovernor.getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp());
            switch (type.getTypetype()) {
                case TYPE_BITSTRING: 
                case TYPE_BITSTRING_A: {
                    aData.addBuiltinTypeImport("TitanBitString");
                    String bitValue = Hex2BitExpression.hex2bit(this.value);
                    result.append(MessageFormat.format("new TitanBitString(\"{0}\")\n", bitValue));
                    return result;
                }
                case TYPE_OCTETSTRING: {
                    aData.addBuiltinTypeImport("TitanOctetString");
                    String octetValue = this.isAsn() ? Hex2OctExpression.asn_hex2oct(this.value) : Hex2OctExpression.hex2oct(this.value);
                    result.append(MessageFormat.format("new TitanOctetString(\"{0}\")", octetValue));
                    return result;
                }
                case TYPE_ANY: {
                    aData.addBuiltinTypeImport("TitanAsn_Any");
                    aData.addBuiltinTypeImport("TitanOctetString");
                    String octetValue = this.isAsn() ? Hex2OctExpression.asn_hex2oct(this.value) : Hex2OctExpression.hex2oct(this.value);
                    result.append(MessageFormat.format("new TitanAsn_Any(new TitanOctetString(\"{0}\"))", octetValue));
                    return result;
                }
            }
        }
        aData.addBuiltinTypeImport("TitanHexString");
        result.append(MessageFormat.format("new TitanHexString(\"{0}\")", this.value));
        return result;
    }
}

