/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.types;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.titan.designer.AST.ASTNode;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.BridgingNamedNode;
import org.eclipse.titan.designer.AST.ILocateableNode;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.NULL_Location;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.IIncrementallyUpdateable;
import org.eclipse.titan.designer.AST.TTCN3.attributes.AttributeSpecification;
import org.eclipse.titan.designer.AST.TTCN3.attributes.ExtensionAttribute;
import org.eclipse.titan.designer.AST.TTCN3.attributes.FunctionTypeMappingTarget;
import org.eclipse.titan.designer.AST.TTCN3.attributes.PortTypeAttribute;
import org.eclipse.titan.designer.AST.TTCN3.attributes.Qualifiers;
import org.eclipse.titan.designer.AST.TTCN3.attributes.SingleWithAttribute;
import org.eclipse.titan.designer.AST.TTCN3.attributes.TypeMapping;
import org.eclipse.titan.designer.AST.TTCN3.attributes.TypeMappingTarget;
import org.eclipse.titan.designer.AST.TTCN3.attributes.TypeMappings;
import org.eclipse.titan.designer.AST.TTCN3.attributes.UserPortTypeAttribute;
import org.eclipse.titan.designer.AST.TTCN3.attributes.WithAttributesPath;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Function;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Var;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Var_Template;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definitions;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameterList;
import org.eclipse.titan.designer.AST.TTCN3.definitions.TTCN3Module;
import org.eclipse.titan.designer.AST.TTCN3.types.PortGenerator;
import org.eclipse.titan.designer.AST.TTCN3.types.Port_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.Signature_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.TypeSet;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.editors.ttcn3editor.TTCN3CodeSkeletons;
import org.eclipse.titan.designer.graphics.ImageCache;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.extensionattributeparser.ExtensionAttributeAnalyzer;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class PortTypeBody
extends ASTNode
implements ILocateableNode,
IIncrementallyUpdateable {
    private static final String FULLNAMEPART1 = ".<in_list>";
    private static final String FULLNAMEPART2 = ".<out_list>";
    private static final String FULLNAMEPART3 = ".<inout_list>";
    private static final String FULLNAMEPART4 = ".<incoming_signatures>";
    private static final String FULLNAMEPART5 = ".<outgoing_signatures>";
    private static final String FULLNAMEPART6 = ".<incoming_messages>";
    private static final String FULLNAMEPART7 = ".<outgoing_messages>";
    private static final String REDUNDANTINALL = "Redundant `in all' and `inout all'";
    private static final String REDUNDANTOUTALL = "Redundant `out all' and `inout all' directives";
    private static final String UNSUPPORTEDINOUTALL = "Unsupported `inout all' directive was ignored";
    private static final String UNSUPPORTEDINALL = "Unsupported `in all' directive was ignored";
    private static final String UNSUPPORTEDOUTALL = "Unsupported `out all' directive was ignored";
    private static final String SIGNATUREONMESSAGEPORT = "Signature `{0}'' cannot be used on a message based port";
    private static final String DATAONPROCEDUREPORT = "Data type `{0}'' cannot be {1} on procedure based port";
    private static final String DUPLICATEDINSIGNATURE = "Duplicate incoming signature `{0}''";
    private static final String DUPLICATEDOUTSIGNATURE = "Duplicate outgoing signature `{0}''";
    private static final String DUPLICATEDINMESSAGE = "Duplicate incoming message type `{0}''";
    private static final String DUPLICATEDOUTMESSAGE = "Duplicate outgoing message type `{0}''";
    private final OperationModes operationMode;
    private TestPortAPI_type testportType;
    private PortType_type portType;
    private PortType_type parsedPortType;
    private Port_Type myType;
    private boolean legacy = true;
    private List<IType> inTypes = null;
    private boolean inAll = false;
    private List<IType> outTypes = null;
    private boolean outAll = false;
    private List<IType> inoutTypes = null;
    private boolean inoutAll = false;
    private TypeSet inMessages;
    private TypeSet outMessages;
    private TypeSet inSignatures;
    private TypeSet outSignatures;
    private final ArrayList<Reference> providerReferences = new ArrayList();
    private final ArrayList<Port_Type> providerTypes = new ArrayList();
    private TypeMappings inMappings;
    private TypeMappings outMappings;
    private Definitions vardefs;
    private FormalParameterList mapParams;
    private FormalParameterList unmapParams;
    private boolean realtime;
    private CompilationTimeStamp lastTimeChecked;
    private CompilationTimeStamp lastTimeAttributesChecked;
    private Location location = NULL_Location.INSTANCE;

    public PortTypeBody(OperationModes operationMode) {
        this.operationMode = operationMode;
        this.testportType = TestPortAPI_type.TP_REGULAR;
        this.portType = PortType_type.PT_REGULAR;
        this.parsedPortType = PortType_type.PT_REGULAR;
    }

    public void setMyType(Port_Type myType) {
        this.myType = myType;
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.inTypes != null) {
            for (IType inType : this.inTypes) {
                if (inType != child) continue;
                return builder.append(FULLNAMEPART1);
            }
        }
        if (this.outTypes != null) {
            for (IType outType : this.outTypes) {
                if (outType != child) continue;
                return builder.append(FULLNAMEPART2);
            }
        }
        if (this.inoutTypes != null) {
            for (IType inoutType : this.inoutTypes) {
                if (inoutType != child) continue;
                return builder.append(FULLNAMEPART3);
            }
        }
        if (this.inMessages == child) {
            return builder.append(FULLNAMEPART4);
        }
        if (this.outMessages == child) {
            return builder.append(FULLNAMEPART5);
        }
        if (this.inSignatures == child) {
            return builder.append(FULLNAMEPART6);
        }
        if (this.outSignatures == child) {
            return builder.append(FULLNAMEPART7);
        }
        for (int i = 0; i < this.providerReferences.size(); ++i) {
            if (this.providerReferences.get(i) != child) continue;
            return builder.append(".<provider_ref>");
        }
        if (this.inMappings == child) {
            return builder.append(".<inMappings>");
        }
        if (this.outMappings == child) {
            return builder.append(".<outMappings>");
        }
        if (this.vardefs == child) {
            return builder.append(".<port_var>");
        }
        if (this.mapParams == child) {
            return builder.append(".<map_params>");
        }
        if (this.unmapParams == child) {
            return builder.append(".<unmap_params>");
        }
        return builder;
    }

    @Override
    public void setLocation(Location location) {
        this.location = location;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    public void addInTypes(List<IType> types) {
        if (types == null) {
            this.inAll = true;
        } else {
            if (this.inTypes == null) {
                this.inTypes = new ArrayList<IType>();
            }
            this.inTypes.addAll(types);
        }
    }

    public void addOutTypes(List<IType> types) {
        if (types == null) {
            this.outAll = true;
        } else {
            if (this.outTypes == null) {
                this.outTypes = new ArrayList<IType>();
            }
            this.outTypes.addAll(types);
        }
    }

    public void addInoutTypes(List<IType> types) {
        if (types == null) {
            this.inoutAll = true;
        } else {
            if (this.inoutTypes == null) {
                this.inoutTypes = new ArrayList<IType>();
            }
            this.inoutTypes.addAll(types);
        }
    }

    public void addDefinitions(List<Definition> definitions) {
        if (this.vardefs == null) {
            this.vardefs = new Definitions();
        }
        this.vardefs.addDefinitions(definitions);
    }

    public void setMapParams(FormalParameterList params) {
        if (this.mapParams != null) {
            this.location.reportSemanticError("Multiple `map' parameter lists in port type definition");
            return;
        }
        this.mapParams = params;
    }

    public FormalParameterList getMapParameters() {
        return this.mapParams;
    }

    public void setUnmapParams(FormalParameterList params) {
        if (this.unmapParams != null) {
            this.location.reportSemanticError("Multiple `unmap' parameter lists in port type definition");
            return;
        }
        this.unmapParams = params;
    }

    public FormalParameterList getUnmapParameters() {
        return this.unmapParams;
    }

    public void setRealtime() {
        this.realtime = true;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.inTypes != null) {
            for (IType inType : this.inTypes) {
                inType.setMyScope(scope);
            }
        }
        if (this.outTypes != null) {
            for (IType outType : this.outTypes) {
                outType.setMyScope(scope);
            }
        }
        if (this.inoutTypes != null) {
            for (IType inoutType : this.inoutTypes) {
                inoutType.setMyScope(scope);
            }
        }
        for (Reference reference : this.providerReferences) {
            reference.setMyScope(scope);
        }
        if (this.inMappings != null) {
            this.inMappings.setMyScope(scope);
        }
        if (this.outMappings != null) {
            this.outMappings.setMyScope(scope);
        }
        if (this.vardefs != null) {
            this.vardefs.setParentScope(scope);
        }
        if (this.mapParams != null) {
            this.mapParams.setMyScope(scope);
        }
        if (this.unmapParams != null) {
            this.unmapParams.setMyScope(scope);
        }
    }

    public OperationModes getOperationMode() {
        return this.operationMode;
    }

    public TestPortAPI_type getTestportType() {
        return this.testportType;
    }

    public PortType_type getPortType() {
        return this.portType;
    }

    public IType getProviderType() {
        return this.providerTypes.size() > 0 ? (IType)this.providerTypes.get(0) : null;
    }

    public TypeSet getInMessages() {
        return this.inMessages;
    }

    public TypeSet getOutMessage() {
        return this.outMessages;
    }

    public TypeSet getInSignatures() {
        return this.inSignatures;
    }

    public TypeSet getOutSignatures() {
        return this.outSignatures;
    }

    public Definitions getVariableDefinitions() {
        return this.vardefs;
    }

    public boolean isRealtime() {
        return this.realtime;
    }

    public boolean isInternal() {
        return TestPortAPI_type.TP_INTERNAL.equals((Object)this.testportType);
    }

    public IType getAddressType(CompilationTimeStamp timestamp) {
        if (this.lastTimeChecked == null || !TestPortAPI_type.TP_ADDRESS.equals((Object)this.testportType)) {
            return null;
        }
        IType t = null;
        t = PortType_type.PT_USER.equals((Object)this.portType) && !this.providerTypes.isEmpty() ? (IType)this.providerTypes.get(0) : this.myType;
        return ((TTCN3Module)t.getMyScope().getModuleScope()).getAddressType(timestamp);
    }

    private void addProviderAttribute() {
        this.portType = PortType_type.PT_PROVIDER;
        this.providerReferences.clear();
        this.providerTypes.clear();
        this.inMappings = null;
        this.outMappings = null;
    }

    public void addUserAttribute(List<Reference> providerReferences, boolean legacy) {
        this.parsedPortType = PortType_type.PT_USER;
        this.providerReferences.clear();
        for (int i = 0; i < providerReferences.size(); ++i) {
            Reference temp = providerReferences.get(i);
            this.providerReferences.add(temp);
            temp.setFullNameParent(new BridgingNamedNode(this, ".<provider_ref>"));
            temp.setMyScope(this.myType.getMyScope());
        }
        this.providerTypes.clear();
        this.legacy = legacy;
    }

    public void addUserAttribute(ArrayList<Reference> providerReferences, TypeMappings inMappings, TypeMappings outMappings, boolean legacy) {
        this.portType = PortType_type.PT_USER;
        this.providerReferences.clear();
        for (int i = 0; i < providerReferences.size(); ++i) {
            Reference temp = providerReferences.get(i);
            this.providerReferences.add(temp);
            temp.setFullNameParent(new BridgingNamedNode(this, ".<provider_ref>"));
            temp.setMyScope(this.myType.getMyScope());
        }
        this.providerTypes.clear();
        this.inMappings = inMappings;
        if (inMappings != null) {
            this.inMappings.setFullNameParent(new BridgingNamedNode(this, ".<inMappings>"));
            this.inMappings.setMyScope(this.myType.getMyScope());
        }
        this.outMappings = outMappings;
        if (outMappings != null) {
            this.outMappings.setFullNameParent(new BridgingNamedNode(this, ".<outMappings>"));
            this.outMappings.setMyScope(this.myType.getMyScope());
        }
        this.legacy = legacy;
    }

    public void addInMapping(TypeMapping inMapping) {
        if (this.inMappings == null) {
            this.inMappings = new TypeMappings();
        }
        this.inMappings.addMapping(inMapping);
        if (inMapping != null) {
            inMapping.setFullNameParent(new BridgingNamedNode(this, ".<inMappings>"));
            inMapping.setMyScope(this.myType.getMyScope());
        }
    }

    public void addOutMapping(TypeMapping outMapping) {
        if (this.outMappings == null) {
            this.outMappings = new TypeMappings();
        }
        this.outMappings.addMapping(outMapping);
        if (outMapping != null) {
            outMapping.setFullNameParent(new BridgingNamedNode(this, ".<outMappings>"));
            outMapping.setMyScope(this.myType.getMyScope());
        }
    }

    public void check(CompilationTimeStamp timestamp) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.inMessages = null;
        this.outMessages = null;
        this.inSignatures = null;
        this.outSignatures = null;
        this.testportType = TestPortAPI_type.TP_REGULAR;
        this.portType = this.parsedPortType;
        this.lastTimeChecked = timestamp;
        if (this.inoutAll) {
            if (this.inAll) {
                this.location.reportSemanticWarning(REDUNDANTINALL);
                this.inAll = false;
            }
            if (this.outAll) {
                this.location.reportSemanticWarning(REDUNDANTOUTALL);
                this.outAll = false;
            }
            this.location.reportSemanticWarning(UNSUPPORTEDINOUTALL);
        } else {
            if (this.inAll) {
                this.location.reportSemanticWarning(UNSUPPORTEDINALL);
            }
            if (this.outAll) {
                this.location.reportSemanticWarning(UNSUPPORTEDOUTALL);
            }
        }
        if (this.inTypes != null) {
            this.checkList(timestamp, this.inTypes, true, false);
        }
        if (this.outTypes != null) {
            this.checkList(timestamp, this.outTypes, false, true);
        }
        if (this.inoutTypes != null) {
            this.checkList(timestamp, this.inoutTypes, true, true);
        }
        if (this.vardefs != null) {
            if (this.providerReferences.isEmpty() && this.vardefs.getNofAssignments() > 0) {
                this.getLocation().reportSemanticError("Port variables can only be used when the port is a translation port.");
            }
            this.vardefs.check(timestamp);
        }
        if (this.mapParams != null) {
            this.mapParams.check(timestamp, Assignment.Assignment_type.A_PORT);
        }
        if (this.unmapParams != null) {
            this.unmapParams.check(timestamp, Assignment.Assignment_type.A_PORT);
        }
    }

    private void checkMapTranslation(CompilationTimeStamp timestamp) {
        int i;
        TypeSet mappingIns = new TypeSet();
        if (this.inMappings != null) {
            for (i = 0; i < this.inMappings.getNofMappings(); ++i) {
                TypeMapping mapping = this.inMappings.getMappingByIndex(i);
                for (int j = 0; j < mapping.getNofTargets(); ++j) {
                    Type targetType = mapping.getTargetByIndex(j).getTargetType();
                    if (mappingIns.hasType(timestamp, targetType)) continue;
                    mappingIns.addType(targetType);
                }
            }
        }
        for (i = 0; i < this.providerTypes.size(); ++i) {
            int k;
            int j;
            Port_Type providerType = this.providerTypes.get(i);
            PortTypeBody providerBody = providerType.getPortBody();
            if (providerBody.inMessages != null) {
                for (j = 0; j < providerBody.inMessages.getNofTypes(); ++j) {
                    boolean found = false;
                    if (this.inoutTypes != null) {
                        for (int k2 = 0; k2 < this.inoutTypes.size(); ++k2) {
                            if (!providerBody.inMessages.hasType(timestamp, this.inoutTypes.get(k2))) continue;
                            found = true;
                            break;
                        }
                    }
                    IType inMessageType = providerBody.inMessages.getTypeByIndex(j);
                    if (this.inMessages != null && this.inMessages.hasType(timestamp, inMessageType) || mappingIns.hasType(timestamp, inMessageType) || found) continue;
                    this.getLocation().reportSemanticError(MessageFormat.format("Incoming message type `{0}'' is not present in the in(out) message list or in the from mapping types, coming from port: `{1}''.", inMessageType.getTypename(), providerType.getGenNameOwn()));
                }
            }
            if (this.inoutTypes != null) {
                for (j = 0; j < this.inoutTypes.size(); ++j) {
                    IType inoutType = this.inoutTypes.get(j);
                    boolean foundIn = false;
                    if (providerBody.inMessages != null) {
                        for (k = 0; k < providerBody.inMessages.getNofTypes(); ++k) {
                            IType inType = providerBody.inMessages.getTypeByIndex(k);
                            if (!inoutType.getTypename().equals(inType.getTypename())) continue;
                            foundIn = true;
                            break;
                        }
                    }
                    boolean foundOut = false;
                    if (providerBody.outMessages != null) {
                        for (int k3 = 0; k3 < providerBody.outMessages.getNofTypes(); ++k3) {
                            IType outType = providerBody.outMessages.getTypeByIndex(k3);
                            if (!inoutType.getTypename().equals(outType.getTypename())) continue;
                            foundOut = true;
                            break;
                        }
                    }
                    if (foundIn && foundOut) continue;
                    this.getLocation().reportSemanticError(MessageFormat.format("Inout message type `{0}'' is not present on the in and out messages or the inout messages of port `{1}''.", inoutType.getTypename(), providerType.getGenNameOwn()));
                }
            }
            if (this.outTypes == null) continue;
            for (j = 0; j < this.outTypes.size(); ++j) {
                boolean found = false;
                if (providerBody.outMessages != null) {
                    for (int k4 = 0; k4 < providerBody.outMessages.getNofTypes(); ++k4) {
                        if (!this.outMessages.hasType(timestamp, providerBody.outMessages.getTypeByIndex(k4))) continue;
                        found = true;
                        break;
                    }
                }
                if (!found && this.outMappings != null && this.outMappings.hasMappingForType(timestamp, this.outMessages.getTypeByIndex(j))) {
                    TypeMapping typeMapping = this.outMappings.getMappingForType(timestamp, this.outMessages.getTypeByIndex(j));
                    for (k = 0; k < typeMapping.getNofTargets(); ++k) {
                        if (!providerBody.outMessages.hasType(timestamp, typeMapping.getTargetByIndex(k).getTargetType())) continue;
                        found = true;
                        break;
                    }
                }
                if (found) continue;
                this.getLocation().reportSemanticError(MessageFormat.format("Neither out message type `{0}'', nor one of its target mappings are present in the out or inout message list of the port `{1}''.", this.outTypes.get(j).getTypename(), providerType.getGenNameOwn()));
            }
        }
    }

    private void checkUserAttribute(CompilationTimeStamp timestamp) {
        IType signatureType;
        Type targetType;
        int j;
        int nofTargets;
        TypeMapping mapping;
        IType messageType;
        Type sourceType;
        int i;
        this.providerTypes.clear();
        PortTypeBody providerBody = null;
        for (int p = 0; p < this.providerReferences.size(); ++p) {
            providerBody = null;
            Assignment assignment = this.providerReferences.get(p).getRefdAssignment(timestamp, true);
            if (assignment != null) {
                if (Assignment.Assignment_type.A_TYPE.semanticallyEquals(assignment.getAssignmentType())) {
                    IType type = assignment.getType(timestamp).getTypeRefdLast(timestamp);
                    if (IType.Type_type.TYPE_PORT.equals((Object)type.getTypetype())) {
                        boolean found = false;
                        for (int i2 = 0; i2 < this.providerTypes.size(); ++i2) {
                            if (this.providerTypes.get(i2) != type) continue;
                            found = true;
                            this.myType.getLocation().reportSemanticError(MessageFormat.format("Duplicate port mappings, the type `{0}'' appears more than once.", type.getTypename()));
                            break;
                        }
                        if (!found) {
                            this.providerTypes.add((Port_Type)type);
                            providerBody = ((Port_Type)type).getPortBody();
                        }
                    } else {
                        this.providerReferences.get(0).getLocation().reportSemanticError(MessageFormat.format("Type reference `{0}'' does not refer to a port type", this.providerReferences.get(0).getDisplayName()));
                    }
                } else {
                    this.providerReferences.get(0).getLocation().reportSemanticError(MessageFormat.format("Reference `{0}'' does not refer to a type", this.providerReferences.get(0).getDisplayName()));
                }
            }
            if (providerBody == null || TestPortAPI_type.TP_INTERNAL.equals((Object)this.testportType)) continue;
            if (!PortType_type.PT_PROVIDER.equals((Object)providerBody.portType)) {
                this.providerReferences.get(p).getLocation().reportSemanticError(MessageFormat.format("The referenced port type `{0}'' must have the `provider'' attribute", this.providerTypes.get(this.providerTypes.size() - 1).getTypename()));
            }
            switch (providerBody.testportType) {
                case TP_REGULAR: {
                    if (!TestPortAPI_type.TP_ADDRESS.equals((Object)this.testportType)) break;
                    this.providerReferences.get(p).getLocation().reportSemanticError(MessageFormat.format("Attribute `address'' cannot be used because the provider port type `{0}'' does not have attribute `address''", this.providerTypes.get(this.providerTypes.size() - 1).getTypename()));
                    break;
                }
                case TP_INTERNAL: {
                    this.providerReferences.get(p).getLocation().reportSemanticError(MessageFormat.format("Missing attribute `internal''. Provider port type `{0}'' has attribute `internal'', which must be also present here", this.providerTypes.get(this.providerTypes.size() - 1).getTypename()));
                    break;
                }
                case TP_ADDRESS: {
                    break;
                }
            }
            this.testportType = providerBody.testportType;
        }
        if (this.legacy && this.inMappings != null && this.inMappings.getNofMappings() != 0) {
            this.inMappings.check(timestamp, this.myType, this.legacy, true);
            if (providerBody != null) {
                if (providerBody.inMessages != null) {
                    int size = this.inMappings.getNofMappings();
                    for (i = 0; i < size; ++i) {
                        sourceType = this.inMappings.getMappingByIndex(i).getSourceType();
                        if (sourceType == null || providerBody.inMessages.hasType(timestamp, sourceType)) continue;
                        sourceType.getLocation().reportSemanticError(MessageFormat.format("Source type `{0}'' of the `in'' mapping is not present on the list of incoming messages in provider port type `{1}''", sourceType.getTypename(), this.providerTypes.get(0).getTypename()));
                    }
                    size = providerBody.inMessages.getNofTypes();
                    for (i = 0; i < size; ++i) {
                        messageType = providerBody.inMessages.getTypeByIndex(i);
                        if (this.inMappings.hasMappingForType(timestamp, messageType)) continue;
                        this.inMappings.getLocation().reportSemanticError(MessageFormat.format("Incoming message type `{0}'' of provider port type `{1}'' is not handled by the incoming mappings", messageType.getTypename(), this.providerTypes.get(0).getTypename()));
                        this.inMappings.hasMappingForType(timestamp, messageType);
                    }
                } else {
                    this.inMappings.getLocation().reportSemanticError(MessageFormat.format("Invalid incoming mappings. Provider port type `{0}' does not have incoming message types'", this.providerTypes.get(0).getTypename()));
                }
            }
            int size = this.inMappings.getNofMappings();
            for (i = 0; i < size; ++i) {
                mapping = this.inMappings.getMappingByIndex(i);
                nofTargets = mapping.getNofTargets();
                for (j = 0; j < nofTargets; ++j) {
                    targetType = mapping.getTargetByIndex(j).getTargetType();
                    if (targetType == null || this.inMessages != null && this.inMessages.hasType(timestamp, targetType)) continue;
                    targetType.getLocation().reportSemanticError(MessageFormat.format("Target type `{0}'' of the `in'' mapping is not present on the list of incoming messages in user port type `{1}''", targetType.getTypename(), this.myType.getTypename()));
                }
            }
        } else if (this.legacy && providerBody != null && providerBody.inMessages != null) {
            this.location.reportSemanticError(MessageFormat.format("Missing `in'' mappings to handle the incoming message types of provider port type `{0}''", this.providerTypes.get(0).getTypename()));
        }
        if (this.legacy && this.outMappings != null && this.outMappings.getNofMappings() != 0) {
            this.outMappings.check(timestamp, this.myType, this.legacy, false);
            if (this.outMessages != null) {
                int size = this.outMappings.getNofMappings();
                for (i = 0; i < size; ++i) {
                    sourceType = this.outMappings.getMappingByIndex(i).getSourceType();
                    if (sourceType == null || this.outMessages.hasType(timestamp, sourceType)) continue;
                    sourceType.getLocation().reportSemanticError(MessageFormat.format("Source type `{0}'' of the `out'' mapping is not present on the list of outgoing messages in user port type `{1}''", sourceType.getTypename(), this.myType.getTypename()));
                }
                size = this.outMessages.getNofTypes();
                for (i = 0; i < size; ++i) {
                    messageType = this.outMessages.getTypeByIndex(i);
                    if (this.outMappings.hasMappingForType(timestamp, messageType)) continue;
                    this.outMappings.getLocation().reportSemanticError(MessageFormat.format("Outgoing message type `{0}'' of user port type `{1}'' is not handled by the outgoing mappings", messageType.getTypename(), this.myType.getTypename()));
                }
            } else {
                this.outMappings.getLocation().reportSemanticError(MessageFormat.format("Invalid outgoing mappings. User port type `{0}'' does not have outgoing message types", this.myType.getTypename()));
            }
            if (providerBody != null) {
                int size = this.outMappings.getNofMappings();
                for (i = 0; i < size; ++i) {
                    mapping = this.outMappings.getMappingByIndex(i);
                    nofTargets = mapping.getNofTargets();
                    for (j = 0; j < nofTargets; ++j) {
                        targetType = mapping.getTargetByIndex(j).getTargetType();
                        if (targetType == null || providerBody.outMessages != null && providerBody.outMessages.hasType(timestamp, targetType)) continue;
                        targetType.getLocation().reportSemanticError(MessageFormat.format("Target type `{0}'' of the `out'' mapping is not present on the list of outgoing messages in provider port type `{1}''", targetType.getTypename(), this.providerTypes.get(0).getTypename()));
                    }
                }
            }
        } else if (this.legacy && this.outMessages != null) {
            this.location.reportSemanticError(MessageFormat.format("Missing `out'' mapping to handle the outgoing message types of user port type `{0}''", this.myType.getTypename()));
        }
        if (providerBody == null) {
            return;
        }
        if (this.legacy && this.inSignatures != null) {
            int size = this.inSignatures.getNofTypes();
            for (i = 0; i < size; ++i) {
                Signature_Type lastSignature;
                IType last;
                signatureType = this.inSignatures.getTypeByIndex(i);
                if (providerBody.inSignatures != null && providerBody.inSignatures.hasType(timestamp, signatureType) || (last = signatureType.getTypeRefdLast(timestamp)).getIsErroneous(timestamp) || !IType.Type_type.TYPE_SIGNATURE.equals((Object)last.getTypetype()) || (lastSignature = (Signature_Type)last).isNonblocking() && lastSignature.getSignatureExceptions() == null) continue;
                signatureType.getLocation().reportSemanticError(MessageFormat.format("Incoming signature `{0}'' of user port type `{1}'' is not present on the list of incoming signatures in provider port type `{2}''", signatureType.getTypename(), this.myType.getTypename(), this.providerTypes.get(0).getTypename()));
            }
        }
        if (providerBody.inSignatures != null) {
            int size = providerBody.inSignatures.getNofTypes();
            for (i = 0; i < size; ++i) {
                signatureType = providerBody.inSignatures.getTypeByIndex(i);
                if (this.inSignatures != null && this.inSignatures.hasType(timestamp, signatureType)) continue;
                this.location.reportSemanticError(MessageFormat.format("Incoming signature `{0}'' of provider port type `{1}'' is not present on the list of incoming signatures in user port type `{2}''", signatureType.getTypename(), this.providerTypes.get(0).getTypename(), this.myType.getTypename()));
            }
        }
        if (this.outSignatures != null) {
            int size = this.outSignatures.getNofTypes();
            for (i = 0; i < size; ++i) {
                signatureType = this.outSignatures.getTypeByIndex(i);
                if (providerBody.outSignatures != null && providerBody.outSignatures.hasType(timestamp, signatureType)) continue;
                signatureType.getLocation().reportSemanticError(MessageFormat.format("Outgoing signature `{0}'' of user port type `{1}'' is not present on the list of outgoing signatures in provider port type `{2}''", signatureType.getTypename(), this.myType.getTypename(), this.providerTypes.get(0).getTypename()));
            }
        }
        if (providerBody.outSignatures != null) {
            int size = providerBody.outSignatures.getNofTypes();
            for (i = 0; i < size; ++i) {
                Signature_Type lastSignature;
                IType last;
                signatureType = providerBody.outSignatures.getTypeByIndex(i);
                if (this.outSignatures != null && this.outSignatures.hasType(timestamp, signatureType) || (last = signatureType.getTypeRefdLast(timestamp)).getIsErroneous(timestamp) || !IType.Type_type.TYPE_SIGNATURE.equals((Object)last.getTypetype()) || (lastSignature = (Signature_Type)last).isNonblocking() && lastSignature.getSignatureExceptions() == null) continue;
                this.location.reportSemanticError(MessageFormat.format("Outgoing signature `{0}'' of provider port type `{1}'' is not present on the list of outgoing signatures in user port type `{2}''", signatureType.getTypename(), this.providerTypes.get(0).getTypename(), this.myType.getTypename()));
            }
        }
        if (!this.legacy) {
            if (this.outMappings != null) {
                this.outMappings.check(timestamp, this.myType, this.legacy, false);
            }
            if (this.inMappings != null) {
                this.inMappings.check(timestamp, this.myType, this.legacy, true);
            }
            this.checkMapTranslation(timestamp);
            if (this.vardefs != null) {
                this.vardefs.check(timestamp);
            }
        }
    }

    public void checkAttributes(CompilationTimeStamp timestamp, WithAttributesPath withAttributesPath) {
        TTCN3Module module;
        int i;
        if (this.lastTimeAttributesChecked != null && !this.lastTimeAttributesChecked.isLess(timestamp)) {
            return;
        }
        this.lastTimeAttributesChecked = this.lastTimeChecked;
        List<SingleWithAttribute> realAttributes = withAttributesPath.getRealAttributes(timestamp);
        ArrayList<ExtensionAttribute> attributes = new ArrayList<ExtensionAttribute>();
        ArrayList<AttributeSpecification> specifications = null;
        for (i = 0; i < realAttributes.size(); ++i) {
            AttributeSpecification specification;
            Qualifiers qualifiers;
            SingleWithAttribute attribute = realAttributes.get(i);
            if (!SingleWithAttribute.Attribute_Type.Extension_Attribute.equals((Object)attribute.getAttributeType()) || (qualifiers = attribute.getQualifiers()) != null && qualifiers.getNofQualifiers() != 0) continue;
            if (specifications == null) {
                specifications = new ArrayList<AttributeSpecification>();
            }
            if ((specification = attribute.getAttributeSpecification()).getSpecification() == null) continue;
            specifications.add(specification);
        }
        if (specifications != null) {
            for (int i2 = 0; i2 < specifications.size(); ++i2) {
                AttributeSpecification specification = (AttributeSpecification)specifications.get(i2);
                ExtensionAttributeAnalyzer analyzer = new ExtensionAttributeAnalyzer();
                analyzer.parse(specification);
                List<ExtensionAttribute> temp = analyzer.getAttributes();
                if (temp == null) continue;
                attributes.addAll(temp);
            }
        }
        this.testportType = TestPortAPI_type.TP_REGULAR;
        block28: for (i = 0; i < attributes.size(); ++i) {
            ExtensionAttribute extensionAttribute = (ExtensionAttribute)attributes.get(i);
            if (!ExtensionAttribute.ExtensionAttribute_type.PORTTYPE.equals((Object)extensionAttribute.getAttributeType())) continue;
            PortTypeAttribute portAttribute = (PortTypeAttribute)extensionAttribute;
            switch (portAttribute.getPortTypeType()) {
                case INTERNAL: {
                    switch (this.testportType) {
                        case TP_REGULAR: {
                            break;
                        }
                        case TP_INTERNAL: {
                            extensionAttribute.getLocation().reportSemanticWarning("Duplicate attribute `internal'");
                            break;
                        }
                        case TP_ADDRESS: {
                            extensionAttribute.getLocation().reportSemanticError("Attributes `address' and `internal' cannot be used at the same time");
                            break;
                        }
                    }
                    this.testportType = TestPortAPI_type.TP_INTERNAL;
                    continue block28;
                }
                case ADDRESS: {
                    switch (this.testportType) {
                        case TP_REGULAR: {
                            break;
                        }
                        case TP_INTERNAL: {
                            extensionAttribute.getLocation().reportSemanticError("Attributes `address' and `internal' cannot be used at the same time");
                            break;
                        }
                        case TP_ADDRESS: {
                            extensionAttribute.getLocation().reportSemanticWarning("Duplicate attribute `address'");
                            break;
                        }
                    }
                    this.testportType = TestPortAPI_type.TP_ADDRESS;
                    continue block28;
                }
                case PROVIDER: {
                    switch (this.portType) {
                        case PT_REGULAR: {
                            break;
                        }
                        case PT_PROVIDER: {
                            extensionAttribute.getLocation().reportSemanticWarning("Duplicate attribute `provider'");
                            break;
                        }
                        case PT_USER: {
                            if (this.legacy) {
                                extensionAttribute.getLocation().reportSemanticError("Attributes `user' and `provider' cannot be used at the same time");
                                break;
                            }
                            extensionAttribute.getLocation().reportSemanticError("The `provider' attribute cannot be used on translation ports");
                            break;
                        }
                    }
                    this.addProviderAttribute();
                    continue block28;
                }
                case USER: {
                    switch (this.portType) {
                        case PT_REGULAR: {
                            break;
                        }
                        case PT_PROVIDER: {
                            extensionAttribute.getLocation().reportSemanticError("Attributes `provider' and `user' cannot be used at the same time");
                            break;
                        }
                        case PT_USER: {
                            if (this.legacy) {
                                extensionAttribute.getLocation().reportSemanticError("Duplicate attribute `user'");
                                break;
                            }
                            extensionAttribute.getLocation().reportSemanticError("Attribute `user' cannot be used on translation ports.");
                            break;
                        }
                    }
                    UserPortTypeAttribute user = (UserPortTypeAttribute)portAttribute;
                    ArrayList<Reference> references = new ArrayList<Reference>();
                    references.add(user.getReference());
                    this.addUserAttribute(references, user.getInMappings(), user.getOutMappings(), true);
                    continue block28;
                }
            }
        }
        if (PortType_type.PT_USER.equals((Object)this.portType)) {
            this.checkUserAttribute(timestamp);
        } else if (TestPortAPI_type.TP_ADDRESS.equals((Object)this.testportType) && (module = (TTCN3Module)this.myType.getMyScope().getModuleScope()).getAddressType(timestamp) == null) {
            this.location.reportSemanticError(MessageFormat.format("Type `address'' is not defined in module `{0}''", module.getIdentifier().getDisplayName()));
        }
    }

    private void checkList(CompilationTimeStamp timestamp, List<IType> list, boolean isIn, boolean isOut) {
        String errorMessage = isIn ? (isOut ? "sent or received" : "received") : "sent";
        block3: for (IType type : list) {
            IType last;
            type.check(timestamp);
            if (type.isComponentInternal(timestamp)) {
                HashSet<IType> typeSet = new HashSet<IType>();
                type.checkComponentInternal(timestamp, typeSet, "sent or received on a port");
            }
            if ((last = type.getTypeRefdLast(timestamp)) == null || last.getIsErroneous(timestamp)) continue;
            switch (last.getTypetype()) {
                case TYPE_SIGNATURE: {
                    if (OperationModes.OP_Message.equals((Object)this.operationMode)) {
                        type.getLocation().reportSemanticError(MessageFormat.format(SIGNATUREONMESSAGEPORT, last.getTypename()));
                    }
                    if (isIn) {
                        if (this.inSignatures != null && this.inSignatures.hasType(timestamp, last)) {
                            type.getLocation().reportSemanticError(MessageFormat.format(DUPLICATEDINSIGNATURE, last.getTypename()));
                        } else {
                            if (this.inSignatures == null) {
                                this.inSignatures = new TypeSet();
                                this.inSignatures.setFullNameParent(this);
                            }
                            this.inSignatures.addType(type);
                        }
                    }
                    if (!isOut) continue block3;
                    if (this.outSignatures != null && this.outSignatures.hasType(timestamp, last)) {
                        type.getLocation().reportSemanticError(MessageFormat.format(DUPLICATEDOUTSIGNATURE, last.getTypename()));
                        continue block3;
                    }
                    if (this.outSignatures == null) {
                        this.outSignatures = new TypeSet();
                        this.outSignatures.setFullNameParent(this);
                    }
                    this.outSignatures.addType(type);
                    continue block3;
                }
            }
            if (OperationModes.OP_Procedure.equals((Object)this.operationMode)) {
                type.getLocation().reportSemanticError(MessageFormat.format(DATAONPROCEDUREPORT, last.getTypename(), errorMessage));
            }
            if (isIn) {
                if (this.inMessages != null && this.inMessages.hasType(timestamp, last)) {
                    type.getLocation().reportSemanticError(MessageFormat.format(DUPLICATEDINMESSAGE, type.getTypename()));
                } else {
                    if (this.inMessages == null) {
                        this.inMessages = new TypeSet();
                        this.inMessages.setFullNameParent(this);
                    }
                    this.inMessages.addType(type);
                }
            }
            if (!isOut) continue;
            if (this.outMessages != null && this.outMessages.hasType(timestamp, last)) {
                type.getLocation().reportSemanticError(MessageFormat.format(DUPLICATEDOUTMESSAGE, type.getTypename()));
                continue;
            }
            if (this.outMessages == null) {
                this.outMessages = new TypeSet();
                this.outMessages.setFullNameParent(this);
            }
            this.outMessages.addType(type);
        }
    }

    public boolean hasQueue(CompilationTimeStamp timestamp) {
        this.check(timestamp);
        if (this.inMessages != null || this.inSignatures != null) {
            return true;
        }
        if (this.outSignatures != null) {
            int size = this.outSignatures.getNofTypes();
            for (int i = 0; i < size; ++i) {
                Signature_Type signature = (Signature_Type)this.outSignatures.getTypeByIndex(i).getTypeRefdLast(timestamp);
                if (signature.isNonblocking() && signature.getSignatureExceptions() == null) continue;
                return true;
            }
        }
        return false;
    }

    public boolean getreplyAllowed(CompilationTimeStamp timestamp) {
        this.check(timestamp);
        if (this.outSignatures != null) {
            IType tempType = null;
            int size = this.outSignatures.getNofTypes();
            for (int i = 0; i < size; ++i) {
                tempType = this.outSignatures.getTypeByIndex(i).getTypeRefdLast(timestamp);
                if (((Signature_Type)tempType).isNonblocking()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean catchAllowed(CompilationTimeStamp timestamp) {
        this.check(timestamp);
        if (this.outSignatures != null) {
            IType tempType = null;
            int size = this.outSignatures.getNofTypes();
            for (int i = 0; i < size; ++i) {
                tempType = this.outSignatures.getTypeByIndex(i).getTypeRefdLast(timestamp);
                if (((Signature_Type)tempType).getSignatureExceptions() == null) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isMappable(CompilationTimeStamp timestamp, PortTypeBody other) {
        int i;
        int size;
        if (this == other) {
            return true;
        }
        if (this.outMessages != null) {
            if (other.outMessages == null) {
                return false;
            }
            size = this.outMessages.getNofTypes();
            for (i = 0; i < size; ++i) {
                if (other.outMessages.hasType(timestamp, this.outMessages.getTypeByIndex(i))) continue;
                return false;
            }
        }
        if (this.outSignatures != null) {
            if (other.outSignatures == null) {
                return false;
            }
            size = this.outSignatures.getNofTypes();
            for (i = 0; i < size; ++i) {
                if (other.outSignatures.hasType(timestamp, this.outSignatures.getTypeByIndex(i))) continue;
                return false;
            }
        }
        if (other.inMessages != null) {
            if (this.inMessages == null) {
                return false;
            }
            size = other.inMessages.getNofTypes();
            for (i = 0; i < size; ++i) {
                if (this.inMessages.hasType(timestamp, other.inMessages.getTypeByIndex(i))) continue;
                return false;
            }
        }
        if (other.inSignatures != null) {
            if (this.inSignatures == null) {
                return false;
            }
            size = other.inSignatures.getNofTypes();
            for (i = 0; i < size; ++i) {
                if (this.inSignatures.hasType(timestamp, other.inSignatures.getTypeByIndex(i))) continue;
                return false;
            }
        }
        return true;
    }

    public void reportMappingErrors(CompilationTimeStamp timestamp, PortTypeBody other) {
        IType signatureType;
        IType messageType;
        int i;
        int size;
        if (this.outMessages != null) {
            size = this.outMessages.getNofTypes();
            for (i = 0; i < size; ++i) {
                messageType = this.outMessages.getTypeByIndex(i);
                if (other.outMessages != null && other.outMessages.hasType(timestamp, messageType)) continue;
                messageType.getLocation().reportSemanticError(MessageFormat.format("Outgoing message type `{0}'' of test component port type `{1}'' is not present on the outgoing list of system port type `{2}''", messageType.getTypename(), this.myType.getTypename(), other.myType.getTypename()));
            }
        }
        if (this.outSignatures != null) {
            size = this.outSignatures.getNofTypes();
            for (i = 0; i < size; ++i) {
                signatureType = this.outSignatures.getTypeByIndex(i);
                if (other.outSignatures != null && other.outSignatures.hasType(timestamp, signatureType)) continue;
                signatureType.getLocation().reportSemanticError(MessageFormat.format("Outgoing signature type `{0}'' of test component port type `{1}'' is not present on the outgoing list of system port type `{2}''", signatureType.getTypename(), this.myType.getTypename(), other.myType.getTypename()));
            }
        }
        if (other.inMessages != null) {
            size = other.inMessages.getNofTypes();
            for (i = 0; i < size; ++i) {
                messageType = other.inMessages.getTypeByIndex(i);
                if (this.inMessages != null && this.inMessages.hasType(timestamp, messageType)) continue;
                messageType.getLocation().reportSemanticError(MessageFormat.format("Incoming message type `{0}'' of system port type `{1}'' is not present on the incoming list of test component port type `{2}''", messageType.getTypename(), other.myType.getTypename(), this.myType.getTypename()));
            }
        }
        if (other.inSignatures != null) {
            size = other.inSignatures.getNofTypes();
            for (i = 0; i < size; ++i) {
                signatureType = other.inSignatures.getTypeByIndex(i);
                if (this.inSignatures != null && this.inSignatures.hasType(timestamp, signatureType)) continue;
                signatureType.getLocation().reportSemanticError(MessageFormat.format("Incoming signature type `{0}'' of system port type `{1}'' is not present on the incoming list of test component port type `{2}''", signatureType.getTypename(), other.myType.getTypename(), this.myType.getTypename()));
            }
        }
    }

    public boolean isTranslate(PortTypeBody other) {
        for (int i = 0; i < this.providerTypes.size(); ++i) {
            if (this.providerTypes.get(i) != other.getMyType()) continue;
            return true;
        }
        return false;
    }

    public boolean mapCanReceiveOrSend(PortTypeBody other) {
        if (!(this.operationMode != OperationModes.OP_Message || this.outMessages != null && this.outMessages.getNofTypes() != 0 || other.inMessages != null && other.inMessages.getNofTypes() != 0)) {
            return false;
        }
        if (!(this.operationMode != OperationModes.OP_Procedure || this.outSignatures != null && this.outSignatures.getNofTypes() != 0 || other.inSignatures != null && other.inSignatures.getNofTypes() != 0)) {
            return false;
        }
        return this.operationMode != OperationModes.OP_Mixed || this.outMessages != null && this.outMessages.getNofTypes() != 0 || other.inMessages != null && other.inMessages.getNofTypes() != 0 || this.outSignatures != null && this.outSignatures.getNofTypes() != 0 || other.inSignatures != null && other.inSignatures.getNofTypes() != 0;
    }

    public Port_Type getMyType() {
        return this.myType;
    }

    public boolean isLegacy() {
        return this.legacy;
    }

    public boolean isConnectable(CompilationTimeStamp timestamp, PortTypeBody other) {
        int i;
        int size;
        if (this.outMessages != null) {
            if (other.inMessages == null) {
                return false;
            }
            size = this.outMessages.getNofTypes();
            for (i = 0; i < size; ++i) {
                if (other.inMessages.hasType(timestamp, this.outMessages.getTypeByIndex(i))) continue;
                return false;
            }
        } else if ((OperationModes.OP_Message.equals((Object)this.operationMode) || OperationModes.OP_Mixed.equals((Object)this.operationMode)) && other.outMessages == null) {
            return false;
        }
        if (this.outSignatures != null) {
            if (other.inSignatures == null) {
                return false;
            }
            size = this.outSignatures.getNofTypes();
            for (i = 0; i < size; ++i) {
                if (other.inSignatures.hasType(timestamp, this.outSignatures.getTypeByIndex(i))) continue;
                return false;
            }
        }
        return true;
    }

    public void reportConnectionErrors(CompilationTimeStamp timestamp, PortTypeBody other, Location connectionLocation) {
        int i;
        int size;
        if (this.outMessages != null) {
            size = this.outMessages.getNofTypes();
            for (i = 0; i < size; ++i) {
                IType messageType = this.outMessages.getTypeByIndex(i);
                if (other.inMessages != null && other.inMessages.hasType(timestamp, messageType)) continue;
                connectionLocation.reportSemanticError(MessageFormat.format("Outgoing message type `{0}'' of port type `{1}'' is not present on the incoming list of port type `{2}''", messageType.getTypename(), this.myType.getTypename(), other.myType.getTypename()));
            }
        } else if ((OperationModes.OP_Message.equals((Object)this.operationMode) || OperationModes.OP_Mixed.equals((Object)this.operationMode)) && other.outMessages == null) {
            connectionLocation.reportSemanticError(MessageFormat.format("Neither port type `{0}'' nor port type `{1}'' can send messages", this.myType.getTypename(), other.myType.getTypename()));
        }
        if (this.outSignatures != null) {
            size = this.outSignatures.getNofTypes();
            for (i = 0; i < size; ++i) {
                IType signatureType = this.outSignatures.getTypeByIndex(i);
                if (other.inSignatures != null && other.inSignatures.hasType(timestamp, this.outSignatures.getTypeByIndex(i))) continue;
                connectionLocation.reportSemanticError(MessageFormat.format("Outgoing signature type `{0}'' of port type `{1}'' is not present on the incoming list of port type `{2}''", signatureType.getTypename(), this.myType.getTypename(), other.myType.getTypename()));
            }
        }
    }

    public void addProposal(ProposalCollector propCollector, int i) {
        List<ISubReference> subrefs = propCollector.getReference().getSubreferences();
        if (subrefs.size() != i + 1 || ISubReference.Subreference_type.arraySubReference.equals((Object)subrefs.get(i).getReferenceType())) {
            return;
        }
        if (OperationModes.OP_Message.equals((Object)this.operationMode) || OperationModes.OP_Mixed.equals((Object)this.operationMode)) {
            propCollector.addTemplateProposal("send", new Template("send( templateInstance )", "", propCollector.getContextIdentifier(), "send( ${templateInstance} );", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
            propCollector.addTemplateProposal("send", new Template("send( templateInstance ) to location", "", propCollector.getContextIdentifier(), "send( ${templateInstance} ) to ${location};", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
            PortTypeBody.addReceiveProposals(propCollector, i);
            PortTypeBody.addTriggerProposals(propCollector, i);
        }
        if (OperationModes.OP_Procedure.equals((Object)this.operationMode) || OperationModes.OP_Mixed.equals((Object)this.operationMode)) {
            propCollector.addTemplateProposal("call", new Template("call( templateInstance )", "", propCollector.getContextIdentifier(), "call( ${templateInstance} );", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
            propCollector.addTemplateProposal("call", new Template("call( templateInstance , callTimer )", "with timer", propCollector.getContextIdentifier(), "call( ${templateInstance} , ${callTimer} );", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
            propCollector.addTemplateProposal("call", new Template("call( templateInstance ) to location", "with to clause", propCollector.getContextIdentifier(), "call( ${templateInstance} ) to ${location};", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
            propCollector.addTemplateProposal("call", new Template("call( templateInstance , callTimer ) to location", "with timer and to clause", propCollector.getContextIdentifier(), "call( ${templateInstance} , ${callTimer} ) to ${location};", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
            PortTypeBody.addGetcallProposals(propCollector, i);
            propCollector.addTemplateProposal("reply", new Template("reply( templateInstance )", "", propCollector.getContextIdentifier(), "reply( ${templateInstance} );", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
            propCollector.addTemplateProposal("reply", new Template("reply( templateInstance ) to location", "", propCollector.getContextIdentifier(), "reply( ${templateInstance} ) to ${location};", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
            PortTypeBody.addGetreplyProposals(propCollector, i);
            propCollector.addTemplateProposal("raise", new Template("raise( signature, templateInstance )", "", propCollector.getContextIdentifier(), "raise( ${signature}, ${templateInstance} );", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
            propCollector.addTemplateProposal("raise", new Template("raise( signature, templateInstance ) to location", "with to clause", propCollector.getContextIdentifier(), "raise( ${signature}, ${templateInstance} ) to ${location};", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
            PortTypeBody.addCatchProposals(propCollector, i);
        }
        PortTypeBody.addCheckProposals(propCollector, i);
        propCollector.addProposal("clear;", "clear", ImageCache.getImage("port.gif"), "");
        propCollector.addProposal("start;", "start", ImageCache.getImage("port.gif"), "");
        propCollector.addProposal("stop;", "stop", ImageCache.getImage("port.gif"), "");
        propCollector.addProposal("halt;", "halt", ImageCache.getImage("port.gif"), "");
    }

    public static void addAnyorAllProposal(ProposalCollector propCollector, int i) {
        List<ISubReference> subrefs = propCollector.getReference().getSubreferences();
        if (i != 0 || subrefs.isEmpty() || ISubReference.Subreference_type.arraySubReference.equals((Object)subrefs.get(0).getReferenceType())) {
            return;
        }
        String fakeModuleName = propCollector.getReference().getModuleIdentifier().getDisplayName();
        if ("any port".equals(fakeModuleName)) {
            PortTypeBody.addReceiveProposals(propCollector, i);
            PortTypeBody.addTriggerProposals(propCollector, i);
            PortTypeBody.addGetcallProposals(propCollector, i);
            PortTypeBody.addGetreplyProposals(propCollector, i);
            PortTypeBody.addCatchProposals(propCollector, i);
            PortTypeBody.addCheckProposals(propCollector, i);
        } else if ("all port".equals(fakeModuleName)) {
            propCollector.addProposal("clear;", "clear", ImageCache.getImage("port.gif"), "");
            propCollector.addProposal("start;", "start", ImageCache.getImage("port.gif"), "");
            propCollector.addProposal("stop;", "stop", ImageCache.getImage("port.gif"), "");
            propCollector.addProposal("halt;", "halt", ImageCache.getImage("port.gif"), "");
        }
    }

    private static void addReceiveProposals(ProposalCollector propCollector, int i) {
        propCollector.addProposal("receive", "receive", ImageCache.getImage("port.gif"), "");
        propCollector.addTemplateProposal("receive", new Template("receive -> value myVar", "value redirect", propCollector.getContextIdentifier(), "receive -> value ${myVar};", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
        propCollector.addTemplateProposal("receive", new Template("receive -> sender myPeer", "sender redirect", propCollector.getContextIdentifier(), "receive -> sender ${myPeer};", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
        propCollector.addTemplateProposal("receive", new Template("receive -> value myVar sender myPeer", "value and sender redirect", propCollector.getContextIdentifier(), "receive -> value ${myVar} sender ${myPeer};", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
        propCollector.addTemplateProposal("receive", new Template("receive from myPeer", "from clause", propCollector.getContextIdentifier(), "receive from ${myPeer};", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
        propCollector.addTemplateProposal("receive", new Template("receive from myPeer -> value myVar", "from clause with value redirect", propCollector.getContextIdentifier(), "receive from ${myPeer} -> value ${myVar};", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
        propCollector.addTemplateProposal("receive", new Template("receive( templateInstance )", "", propCollector.getContextIdentifier(), "receive( ${template} );", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
        propCollector.addTemplateProposal("receive", new Template("receive( templateInstance ) -> value myVar", "value redirect", propCollector.getContextIdentifier(), "receive( ${templateInstance} ) -> value ${myVar};", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
        propCollector.addTemplateProposal("receive", new Template("receive( templateInstance ) -> sender myPeer", "sender redirect", propCollector.getContextIdentifier(), "receive( ${templateInstance} ) -> sender ${myPeer};", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
        propCollector.addTemplateProposal("receive", new Template("receive( templateInstance ) -> value myVar sender myPeer", "value and sender redirect", propCollector.getContextIdentifier(), "receive( ${templateInstance} ) -> value ${myVar} sender ${myPeer};", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
        propCollector.addTemplateProposal("receive", new Template("receive( templateInstance ) from myPeer", "from clause", propCollector.getContextIdentifier(), "receive( ${templateInstance} ) from ${myPeer};", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
        propCollector.addTemplateProposal("receive", new Template("receive( templateInstance ) from myPeer -> value myVar", "from clause with value redirect", propCollector.getContextIdentifier(), "receive( ${templateInstance} ) from ${myPeer} -> value ${myVar};", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
    }

    public static void addTriggerProposals(ProposalCollector propCollector, int i) {
        propCollector.addProposal("trigger", "trigger", ImageCache.getImage("port.gif"), "");
        propCollector.addTemplateProposal("trigger", new Template("trigger -> value myVar", "value redirect", propCollector.getContextIdentifier(), "trigger -> value ${myVar};", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
        propCollector.addTemplateProposal("trigger", new Template("trigger -> sender myPeer", "sender redirect", propCollector.getContextIdentifier(), "trigger -> sender ${myPeer};", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
        propCollector.addTemplateProposal("trigger", new Template("trigger -> value myVar sender myPeer", "value and sender redirect", propCollector.getContextIdentifier(), "trigger -> value ${myVar} sender ${myPeer};", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
        propCollector.addTemplateProposal("trigger", new Template("trigger from myPeer", "from clause", propCollector.getContextIdentifier(), "trigger from ${myPeer};", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
        propCollector.addTemplateProposal("trigger", new Template("trigger from myPeer -> value myVar", "from clause with value redirect", propCollector.getContextIdentifier(), "trigger from ${myPeer} -> value ${myVar};", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
        propCollector.addTemplateProposal("trigger", new Template("trigger( templateInstance )", "", propCollector.getContextIdentifier(), "trigger( ${templateInstance} );", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
        propCollector.addTemplateProposal("trigger", new Template("trigger( templateInstance ) -> value myVar", "value redirect", propCollector.getContextIdentifier(), "trigger( ${templateInstance} ) -> value ${myVar};", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
        propCollector.addTemplateProposal("trigger", new Template("trigger( templateInstance ) -> sender myPeer", "sender redirect", propCollector.getContextIdentifier(), "trigger( ${templateInstance} ) -> sender ${myPeer};", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
        propCollector.addTemplateProposal("trigger", new Template("trigger( templateInstance ) -> value myVar sender myPeer", "value and sender redirect", propCollector.getContextIdentifier(), "trigger( ${templateInstance} ) -> value ${myVar} sender ${myPeer};", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
        propCollector.addTemplateProposal("trigger", new Template("trigger( templateInstance ) from myPeer", "from clause", propCollector.getContextIdentifier(), "trigger( ${templateInstance} ) from ${myPeer};", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
        propCollector.addTemplateProposal("trigger", new Template("trigger( templateInstance ) from myPeer -> value myVar", "from clause with value redirect", propCollector.getContextIdentifier(), "trigger( ${templateInstance} ) from ${myPeer} -> value ${myVar};", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
    }

    public static void addGetcallProposals(ProposalCollector propCollector, int i) {
        propCollector.addProposal("getcall", "getcall", ImageCache.getImage("port.gif"), "");
        propCollector.addTemplateProposal("getcall", new Template("getcall from myPartner", "from clause", propCollector.getContextIdentifier(), "getcall from ${myPartner};", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
        propCollector.addTemplateProposal("getcall", new Template("getcall -> sender myPartnerVar", "sender redirect", propCollector.getContextIdentifier(), "getcall -> sender ${myPartnerVar};", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
        propCollector.addTemplateProposal("getcall", new Template("getcall( templateInstance )", "", propCollector.getContextIdentifier(), "getcall( ${templateInstance} );", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
        propCollector.addTemplateProposal("getcall", new Template("getcall( templateInstance ) from myPartner", "from clause", propCollector.getContextIdentifier(), "getcall( ${templateInstance} ) from ${myPartner};", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
        propCollector.addTemplateProposal("getcall", new Template("getcall( templateInstance ) -> sender myPartnerVar", "sender redirect", propCollector.getContextIdentifier(), "getcall( ${templateInstance} ) -> sender ${myPartnerVar};", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
        propCollector.addTemplateProposal("getcall", new Template("getcall( templateInstance ) -> param(parameters)", "parameters", propCollector.getContextIdentifier(), "getcall( ${templateInstance} ) -> param( ${parameters} );", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
        propCollector.addTemplateProposal("getcall", new Template("getcall( templateInstance ) from myPartner -> param(parameters)", "from clause and parameters", propCollector.getContextIdentifier(), "getcall( ${templateInstance} ) from ${myPartner} -> param( ${parameters} );", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
        propCollector.addTemplateProposal("getcall", new Template("getcall( templateInstance ) -> param(parameters) sender mySenderVar", "parameters and sender clause", propCollector.getContextIdentifier(), "getcall( ${templateInstance} ) -> param( ${parameters} ) sender ${mySenderVar};", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
    }

    public static void addGetreplyProposals(ProposalCollector propCollector, int i) {
        propCollector.addProposal("getreply", "getreply", ImageCache.getImage("port.gif"), "");
        propCollector.addTemplateProposal("getreply", new Template("getreply from myPartner", "from clause", propCollector.getContextIdentifier(), "getreply from ${myPartner};", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
        propCollector.addTemplateProposal("getreply", new Template("getreply( templateInstance ) -> value myReturnValue param(parameters) sender mySenderVar", "value, parameters and sender clause", propCollector.getContextIdentifier(), "getreply( ${templateInstance} ) -> value ${myReturnValue} param( ${parameters} ) sender ${mySenderVar};", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
    }

    public static void addCatchProposals(ProposalCollector propCollector, int i) {
        propCollector.addProposal("catch", "catch", ImageCache.getImage("port.gif"), "");
        propCollector.addTemplateProposal("catch", new Template("catch -> value myVar", "value redirect", propCollector.getContextIdentifier(), "catch -> value ${myVar};", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
        propCollector.addTemplateProposal("catch", new Template("catch -> sender myPeer", "sender redirect", propCollector.getContextIdentifier(), "catch -> sender ${myPeer};", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
        propCollector.addTemplateProposal("catch", new Template("catch -> value myVar sender myPeer", "value and sender redirect", propCollector.getContextIdentifier(), "catch -> value ${myVar} sender ${myPeer};", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
        propCollector.addTemplateProposal("catch", new Template("catch from myPeer", "from clause", propCollector.getContextIdentifier(), "catch from ${myPeer};", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
        propCollector.addTemplateProposal("catch", new Template("catch from myPeer -> value myVar", "from clause with value redirect", propCollector.getContextIdentifier(), "catch from ${myPeer} -> value ${myVar};", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
        propCollector.addTemplateProposal("catch", new Template("catch( signature, templateInstance )", "", propCollector.getContextIdentifier(), "catch( ${signature}, ${templateInstance} );", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
        propCollector.addTemplateProposal("catch", new Template("catch( signature, templateInstance ) -> value myVar", "value redirect", propCollector.getContextIdentifier(), "catch( ${signature}, ${templateInstance} ) -> value ${myVar};", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
        propCollector.addTemplateProposal("catch", new Template("catch( signature, templateInstance ) -> sender myPeer", "sender redirect", propCollector.getContextIdentifier(), "catch( ${signature}, ${templateInstance} ) -> sender ${myPeer};", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
        propCollector.addTemplateProposal("catch", new Template("catch( signature, templateInstance ) -> value myVar sender myPeer", "value and sender redirect", propCollector.getContextIdentifier(), "catch( ${signature}, ${templateInstance} ) -> value ${myVar} sender ${myPeer};", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
        propCollector.addTemplateProposal("catch", new Template("catch( signature, templateInstance ) from myPeer", "from clause", propCollector.getContextIdentifier(), "catch( ${signature}, ${templateInstance} ) from ${myPeer};", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
        propCollector.addTemplateProposal("catch", new Template("catch( signature, templateInstance ) from myPeer -> value myVar", "from clause with value redirect", propCollector.getContextIdentifier(), "catch( ${signature}, ${templateInstance} ) from ${myPeer} -> value ${myVar};", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
        propCollector.addTemplateProposal("catch", new Template("catch( timeout )", "", propCollector.getContextIdentifier(), "catch( timeout );", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
    }

    public static void addCheckProposals(ProposalCollector propCollector, int i) {
        propCollector.addProposal("check", "check", ImageCache.getImage("port.gif"), "");
        propCollector.addTemplateProposal("check", new Template("check( portOperation )", "", propCollector.getContextIdentifier(), "check( ${portOperation} );", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
        propCollector.addTemplateProposal("check", new Template("check( from myPeer)", "form clause", propCollector.getContextIdentifier(), "check( from ${myPeer});", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
        propCollector.addTemplateProposal("check", new Template("check( from myPeer -> value myVar)", "form and value clause", propCollector.getContextIdentifier(), "check( from ${myPeer} -> value ${myVar});", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
        propCollector.addTemplateProposal("check", new Template("check( -> value myVar)", "value clause", propCollector.getContextIdentifier(), "check( -> value ${myVar} );", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
        propCollector.addTemplateProposal("check", new Template("check( -> value myVar sender myPeer)", "value and sender clause", propCollector.getContextIdentifier(), "check( -> value ${myVar} sender ${myPeer} );", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        int i;
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.inTypes != null) {
            for (IType type : this.inTypes) {
                if (type instanceof IIncrementallyUpdateable) {
                    ((IIncrementallyUpdateable)((Object)type)).updateSyntax(reparser, false);
                    reparser.updateLocation(type.getLocation());
                    continue;
                }
                throw new ReParseException();
            }
        }
        if (this.outTypes != null) {
            for (IType type : this.outTypes) {
                if (type instanceof IIncrementallyUpdateable) {
                    ((IIncrementallyUpdateable)((Object)type)).updateSyntax(reparser, false);
                    reparser.updateLocation(type.getLocation());
                    continue;
                }
                throw new ReParseException();
            }
        }
        if (this.inoutTypes != null) {
            for (IType type : this.inoutTypes) {
                if (type instanceof IIncrementallyUpdateable) {
                    ((IIncrementallyUpdateable)((Object)type)).updateSyntax(reparser, false);
                    reparser.updateLocation(type.getLocation());
                    continue;
                }
                throw new ReParseException();
            }
        }
        for (i = 0; i < this.providerReferences.size(); ++i) {
            Reference reference = this.providerReferences.get(i);
            reference.updateSyntax(reparser, false);
            reparser.updateLocation(reference.getLocation());
        }
        if (this.inMappings != null) {
            this.inMappings.updateSyntax(reparser, false);
            reparser.updateLocation(this.inMappings.getLocation());
        }
        if (this.outMappings != null) {
            this.outMappings.updateSyntax(reparser, false);
            reparser.updateLocation(this.outMappings.getLocation());
        }
        if (this.vardefs != null) {
            for (i = 0; i < this.vardefs.getNofAssignments(); ++i) {
                Definition definition = this.vardefs.getAssignmentByIndex(i);
                definition.updateSyntax(reparser, false);
                reparser.updateLocation(definition.getLocation());
            }
            reparser.updateLocation(this.vardefs.getLocation());
        }
        if (this.mapParams != null) {
            this.mapParams.updateSyntax(reparser, false);
            reparser.updateLocation(this.mapParams.getLocation());
        }
        if (this.unmapParams != null) {
            this.unmapParams.updateSyntax(reparser, false);
            reparser.updateLocation(this.unmapParams.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.inTypes != null) {
            for (IType t : this.inTypes) {
                t.findReferences(referenceFinder, foundIdentifiers);
            }
        }
        if (this.outTypes != null) {
            for (IType t : this.outTypes) {
                t.findReferences(referenceFinder, foundIdentifiers);
            }
        }
        if (this.inoutTypes != null) {
            for (IType t : this.inoutTypes) {
                t.findReferences(referenceFinder, foundIdentifiers);
            }
        }
        for (int i = 0; i < this.providerReferences.size(); ++i) {
            this.providerReferences.get(i).findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.inMappings != null) {
            this.inMappings.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.outMappings != null) {
            this.outMappings.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.vardefs != null) {
            this.vardefs.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.mapParams != null) {
            this.mapParams.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.unmapParams != null) {
            this.unmapParams.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.inTypes != null) {
            for (IType t : this.inTypes) {
                if (t.accept(v)) continue;
                return false;
            }
        }
        if (this.outTypes != null) {
            for (IType t : this.outTypes) {
                if (t.accept(v)) continue;
                return false;
            }
        }
        if (this.inoutTypes != null) {
            for (IType t : this.inoutTypes) {
                if (t.accept(v)) continue;
                return false;
            }
        }
        for (int i = 0; i < this.providerReferences.size(); ++i) {
            if (this.providerReferences.get(i).accept(v)) continue;
            return false;
        }
        if (this.inMappings != null && !this.inMappings.accept(v)) {
            return false;
        }
        if (this.outMappings != null && !this.outMappings.accept(v)) {
            return false;
        }
        if (this.vardefs != null && !this.vardefs.accept(v)) {
            return false;
        }
        if (this.mapParams != null && !this.mapParams.accept(v)) {
            return false;
        }
        return this.unmapParams == null || this.unmapParams.accept(v);
    }

    public String getClassName(JavaGenData aData, StringBuilder source) {
        PortGenerator.PortDefinition portDefinition = this.generateDefinitionForCodeGeneration(aData, source);
        return PortGenerator.getClassName(aData, source, portDefinition, this.myScope);
    }

    public void generateCode(JavaGenData aData, StringBuilder source) {
        PortGenerator.PortDefinition portDefinition = this.generateDefinitionForCodeGeneration(aData, source);
        PortGenerator.generateClass(aData, source, this.myScope.getModuleScopeGen().getProject(), portDefinition);
    }

    public PortGenerator.PortDefinition generateDefinitionForCodeGeneration(JavaGenData aData, StringBuilder source) {
        PortGenerator.procedureSignatureInfo info;
        Signature_Type signature;
        TypeMapping mapping;
        IType outType;
        int i;
        String genName = this.myType.getGenNameOwn();
        PortGenerator.PortDefinition portDefinition = new PortGenerator.PortDefinition(genName, this.getFullName());
        portDefinition.legacy = this.legacy;
        portDefinition.realtime = this.realtime;
        if (this.inMessages != null) {
            for (i = 0; i < this.inMessages.getNofTypes(); ++i) {
                IType inType = this.inMessages.getTypeByIndex(i);
                PortGenerator.messageTypeInfo info2 = new PortGenerator.messageTypeInfo(inType.getGenNameValue(aData, source), inType.getGenNameTemplate(aData, source), inType.getTypename());
                portDefinition.inMessages.add(info2);
            }
        }
        if (this.outMessages != null) {
            for (i = 0; i < this.outMessages.getNofTypes(); ++i) {
                outType = this.outMessages.getTypeByIndex(i);
                PortGenerator.MessageMappedTypeInfo mappedType = new PortGenerator.MessageMappedTypeInfo(outType.getGenNameValue(aData, source), outType.getGenNameTemplate(aData, source), outType.getTypename());
                if (this.portType == PortType_type.PT_USER && (this.legacy || this.outMappings != null)) {
                    if (this.legacy || this.outMappings.hasMappingForType(CompilationTimeStamp.getBaseTimestamp(), outType)) {
                        mapping = this.outMappings.getMappingForType(CompilationTimeStamp.getBaseTimestamp(), outType);
                        ArrayList<PortGenerator.MessageTypeMappingTarget> targets = new ArrayList<PortGenerator.MessageTypeMappingTarget>(mapping.getNofTargets());
                        for (int j = 0; j < mapping.getNofTargets(); ++j) {
                            AtomicBoolean hasSliding = new AtomicBoolean();
                            PortGenerator.MessageTypeMappingTarget tempTarget = mapping.getTargetByIndex(j).fillTypeMappingTarget(aData, source, outType, hasSliding);
                            tempTarget.targetIndex = -1;
                            targets.add(tempTarget);
                        }
                        mappedType.addTargets(targets);
                    } else if (!this.legacy) {
                        ArrayList<PortGenerator.MessageTypeMappingTarget> targets = new ArrayList<PortGenerator.MessageTypeMappingTarget>(1);
                        PortGenerator.MessageTypeMappingTarget tempTarget = new PortGenerator.MessageTypeMappingTarget(outType.getGenNameValue(aData, source), outType.getTypename());
                        targets.add(tempTarget);
                        mappedType.addTargets(targets);
                    }
                }
                portDefinition.outMessages.add(mappedType);
            }
        }
        if (this.inSignatures != null) {
            for (i = 0; i < this.inSignatures.getNofTypes(); ++i) {
                outType = this.inSignatures.getTypeByIndex(i);
                signature = (Signature_Type)outType.getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp());
                info = new PortGenerator.procedureSignatureInfo(outType.getGenNameValue(aData, source), outType.getTypename(), signature.isNonblocking(), signature.getSignatureExceptions() != null, false);
                portDefinition.inProcedures.add(info);
            }
        }
        if (this.outSignatures != null) {
            for (i = 0; i < this.outSignatures.getNofTypes(); ++i) {
                outType = this.outSignatures.getTypeByIndex(i);
                signature = (Signature_Type)outType.getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp());
                info = new PortGenerator.procedureSignatureInfo(outType.getGenNameValue(aData, source), outType.getTypename(), signature.isNonblocking(), signature.getSignatureExceptions() != null, signature.getSignatureReturnType() != null);
                portDefinition.outProcedures.add(info);
            }
        }
        switch (this.testportType) {
            case TP_REGULAR: {
                portDefinition.testportType = PortGenerator.TestportType.NORMAL;
                break;
            }
            case TP_INTERNAL: {
                portDefinition.testportType = PortGenerator.TestportType.INTERNAL;
                break;
            }
            case TP_ADDRESS: {
                portDefinition.testportType = PortGenerator.TestportType.ADDRESS;
                IType address = this.getAddressType(CompilationTimeStamp.getBaseTimestamp());
                portDefinition.addressName = address.getGenNameValue(aData, source);
                break;
            }
            default: {
                portDefinition.testportType = PortGenerator.TestportType.NORMAL;
            }
        }
        if (this.portType == PortType_type.PT_USER) {
            portDefinition.portType = PortGenerator.PortType.USER;
            if (this.legacy) {
                Port_Type providerType = this.providerTypes.get(0);
                PortTypeBody providerBody = providerType.getPortBody();
                portDefinition.providerMessageOutList = new ArrayList();
                String providerName = providerType.getGenNameOwn();
                PortGenerator.portMessageProvider temp = new PortGenerator.portMessageProvider(providerName, null, providerBody.realtime);
                portDefinition.providerMessageOutList.add(temp);
                if (providerBody.inMessages != null) {
                    portDefinition.providerInMessages = new ArrayList(providerBody.inMessages.getNofTypes());
                    for (int i2 = 0; i2 < providerBody.inMessages.getNofTypes(); ++i2) {
                        IType type = providerBody.inMessages.getTypeByIndex(i2);
                        String typeName = type.getGenNameValue(aData, source);
                        String templateName = type.getGenNameTemplate(aData, source);
                        String displayName = type.getTypename();
                        PortGenerator.MessageMappedTypeInfo mappedType = new PortGenerator.MessageMappedTypeInfo(typeName, templateName, displayName);
                        TypeMapping mapping2 = this.inMappings.getMappingForType(CompilationTimeStamp.getBaseTimestamp(), type);
                        ArrayList<PortGenerator.MessageTypeMappingTarget> targets = new ArrayList<PortGenerator.MessageTypeMappingTarget>(mapping2.getNofTargets());
                        for (int j = 0; j < mapping2.getNofTargets(); ++j) {
                            TypeMappingTarget target = mapping2.getTargetByIndex(j);
                            AtomicBoolean sliding = new AtomicBoolean();
                            PortGenerator.MessageTypeMappingTarget mtmTarget = target.fillTypeMappingTarget(aData, source, type, sliding);
                            targets.add(mtmTarget);
                            portDefinition.has_sliding |= sliding.get();
                            Type targetType = target.getTargetType();
                            mtmTarget.targetIndex = targetType == null ? -1 : (this.inMessages.hasType(CompilationTimeStamp.getBaseTimestamp(), targetType) ? this.inMessages.getIndexByType(targetType) : -1);
                        }
                        mappedType.addTargets(targets);
                        portDefinition.providerInMessages.add(mappedType);
                    }
                }
            } else {
                Def_Function function;
                IType functionPortType;
                int i3;
                portDefinition.providerMessageOutList = new ArrayList(this.providerTypes.size());
                for (i3 = 0; i3 < this.providerTypes.size(); ++i3) {
                    Port_Type providerType = this.providerTypes.get(i3);
                    String name = providerType.getGenNameValue(aData, source);
                    PortTypeBody providerTypeBody = providerType.getPortBody();
                    ArrayList<String> names = null;
                    if (providerTypeBody.outMessages != null) {
                        names = new ArrayList<String>(providerTypeBody.outMessages.getNofTypes());
                        for (int j = 0; j < providerTypeBody.outMessages.getNofTypes(); ++j) {
                            names.add(providerTypeBody.outMessages.getTypeByIndex(j).getGenNameValue(aData, source));
                        }
                    }
                    PortGenerator.portMessageProvider temp = new PortGenerator.portMessageProvider(name, names, providerTypeBody.realtime);
                    portDefinition.providerMessageOutList.add(temp);
                }
                if (this.inMessages != null) {
                    portDefinition.providerInMessages = new ArrayList(this.inMessages.getNofTypes());
                    for (i3 = 0; i3 < this.inMessages.getNofTypes(); ++i3) {
                        IType type = this.inMessages.getTypeByIndex(i3);
                        String typeName = type.getGenNameValue(aData, source);
                        String templateName = type.getGenNameTemplate(aData, source);
                        String displayName = type.getTypename();
                        PortGenerator.MessageMappedTypeInfo mappedType = new PortGenerator.MessageMappedTypeInfo(typeName, templateName, displayName);
                        ArrayList<PortGenerator.MessageTypeMappingTarget> targets = new ArrayList<PortGenerator.MessageTypeMappingTarget>(1);
                        String targetType = type.getGenNameValue(aData, source);
                        String targetDisplayName = type.getTypename();
                        PortGenerator.MessageTypeMappingTarget mtmTarget = new PortGenerator.MessageTypeMappingTarget(targetType, targetDisplayName);
                        mtmTarget.targetIndex = this.inMessages.getIndexByType(type);
                        targets.add(mtmTarget);
                        mappedType.addTargets(targets);
                        portDefinition.providerInMessages.add(mappedType);
                    }
                }
                if (this.inMappings != null) {
                    for (int j = 0; j < this.inMappings.getNofMappings(); ++j) {
                        TypeMapping mapping3 = this.inMappings.getMappingByIndex(j);
                        for (int u = 0; u < mapping3.getNofTargets(); ++u) {
                            TypeMappingTarget mappingTarget = mapping3.getTargetByIndex(u);
                            Type mappingTargetType = mappingTarget.getTargetType();
                            PortGenerator.MessageMappedTypeInfo mappedType = null;
                            for (int k = 0; k < portDefinition.providerInMessages.size(); ++k) {
                                if (!portDefinition.providerInMessages.get((int)k).mDisplayName.equals(mappingTargetType.getTypename())) continue;
                                mappedType = portDefinition.providerInMessages.get(k);
                                break;
                            }
                            if (mappedType == null) {
                                String typeName = mappingTargetType.getGenNameValue(aData, source);
                                String templeName = mappingTargetType.getGenNameTemplate(aData, source);
                                String displayName = mappingTargetType.getTypename();
                                mappedType = new PortGenerator.MessageMappedTypeInfo(typeName, templeName, displayName);
                                portDefinition.providerInMessages.add(mappedType);
                            }
                            Def_Function targetFunction = ((FunctionTypeMappingTarget)mappingTarget).getFunction();
                            String functionName = targetFunction.getGenNameFromScope(aData, source, "");
                            String functionDisplayName = targetFunction.getFullName();
                            Type sourceType = mapping3.getSourceType();
                            String targetType = sourceType.getGenNameValue(aData, source);
                            String targetDisplayName = sourceType.getTypename();
                            PortGenerator.MessageTypeMappingTarget newTarget = new PortGenerator.MessageTypeMappingTarget(targetType, targetDisplayName, functionName, functionDisplayName, PortGenerator.FunctionPrototype_Type.FAST);
                            mappedType.addTarget(newTarget);
                            if (!this.inMessages.hasType(CompilationTimeStamp.getBaseTimestamp(), sourceType)) continue;
                            newTarget.targetIndex = this.inMessages.getIndexByType(sourceType);
                        }
                    }
                }
                if (this.vardefs != null) {
                    StringBuilder tempVarDefs = new StringBuilder();
                    StringBuilder tempVarInit = new StringBuilder();
                    for (int i4 = 0; i4 < this.vardefs.getNofAssignments(); ++i4) {
                        Definition def = this.vardefs.getAssignmentByIndex(i4);
                        String type = "";
                        switch (def.getAssignmentType()) {
                            case A_VAR: {
                                type = def.getType(CompilationTimeStamp.getBaseTimestamp()).getGenNameValue(aData, source);
                                if (((Def_Var)def).getInitialValue() == null) {
                                    tempVarInit.append(MessageFormat.format("{0}.clean_up();\n", def.getGenName()));
                                    break;
                                }
                                def.generateCodeInitComp(aData, tempVarInit, def);
                                break;
                            }
                            case A_CONST: {
                                type = def.getType(CompilationTimeStamp.getBaseTimestamp()).getGenNameValue(aData, source);
                                def.generateCodeInitComp(aData, tempVarInit, def);
                                break;
                            }
                            case A_VAR_TEMPLATE: {
                                type = def.getType(CompilationTimeStamp.getBaseTimestamp()).getGenNameTemplate(aData, source);
                                if (((Def_Var_Template)def).getInitialValue() == null) {
                                    tempVarInit.append(MessageFormat.format("{0}.clean_up();\n", def.getGenName()));
                                    break;
                                }
                                def.generateCodeInitComp(aData, tempVarInit, def);
                                break;
                            }
                        }
                        tempVarDefs.append(MessageFormat.format("private {0} {1} = new {0}();\n", type, def.getGenName()));
                    }
                    portDefinition.varDefs = tempVarDefs.toString();
                    portDefinition.varInit = tempVarInit.toString();
                }
                HashSet<Def_Function> functions = new HashSet<Def_Function>();
                StringBuilder tempTranslationFunctions = new StringBuilder();
                if (this.outMappings != null) {
                    for (int i5 = 0; i5 < this.outMappings.getNofMappings(); ++i5) {
                        mapping = this.outMappings.getMappingByIndex(i5);
                        for (int j = 0; j < mapping.getNofTargets(); ++j) {
                            TypeMappingTarget mappingTarget = mapping.getTargetByIndex(j);
                            if (mappingTarget.getTypeMappingType() != TypeMappingTarget.TypeMapping_type.FUNCTION || (functionPortType = (function = ((FunctionTypeMappingTarget)mappingTarget).getFunction()).getPortType(CompilationTimeStamp.getBaseTimestamp())) == null || functionPortType != this.myType || functions.contains(function)) continue;
                            function.generateCodePortBody(aData, tempTranslationFunctions);
                            functions.add(function);
                        }
                    }
                }
                if (this.inMappings != null) {
                    for (int i6 = 0; i6 < this.inMappings.getNofMappings(); ++i6) {
                        mapping = this.inMappings.getMappingByIndex(i6);
                        for (int j = 0; j < mapping.getNofTargets(); ++j) {
                            TypeMappingTarget mappingTarget = mapping.getTargetByIndex(j);
                            if (mappingTarget.getTypeMappingType() != TypeMappingTarget.TypeMapping_type.FUNCTION || (functionPortType = (function = ((FunctionTypeMappingTarget)mappingTarget).getFunction()).getPortType(CompilationTimeStamp.getBaseTimestamp())) == null || functionPortType != this.myType || functions.contains(function)) continue;
                            function.generateCodePortBody(aData, tempTranslationFunctions);
                            functions.add(function);
                        }
                    }
                }
                portDefinition.translationFunctions = tempTranslationFunctions.toString();
            }
        } else {
            portDefinition.portType = this.portType == PortType_type.PT_PROVIDER && this.testportType != TestPortAPI_type.TP_INTERNAL ? PortGenerator.PortType.PROVIDER : PortGenerator.PortType.REGULAR;
        }
        return portDefinition;
    }

    public static enum PortType_type {
        PT_REGULAR,
        PT_PROVIDER,
        PT_USER;

    }

    public static enum TestPortAPI_type {
        TP_REGULAR,
        TP_INTERNAL,
        TP_ADDRESS;

    }

    public static enum OperationModes {
        OP_Message,
        OP_Procedure,
        OP_Mixed;

    }
}

