/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.templates;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTNode;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.IIncrementallyUpdateable;
import org.eclipse.titan.designer.AST.TTCN3.templates.TTCN3Template;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Templates
extends ASTNode
implements IIncrementallyUpdateable,
Iterable<TTCN3Template> {
    private final List<TTCN3Template> templates = new ArrayList<TTCN3Template>();

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        for (TTCN3Template template : this.templates) {
            template.setMyScope(scope);
        }
    }

    public void addTemplate(TTCN3Template template) {
        this.templates.add(template);
    }

    public int getNofTemplates() {
        return this.templates.size();
    }

    public TTCN3Template getTemplateByIndex(int index) {
        return this.templates.get(index);
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        for (TTCN3Template template : this.templates) {
            template.updateSyntax(reparser, false);
            reparser.updateLocation(template.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.templates == null) {
            return;
        }
        for (TTCN3Template template : this.templates) {
            template.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.templates != null) {
            for (TTCN3Template t : this.templates) {
                if (t.accept(v)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public Iterator<TTCN3Template> iterator() {
        return this.templates.iterator();
    }

    public void addAll(Collection<TTCN3Template> collectionToAdd) {
        this.templates.addAll(collectionToAdd);
    }
}

