/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.templates;

import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.ILocateableNode;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.ReferenceChain;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.templates.LengthRestriction;
import org.eclipse.titan.designer.AST.TTCN3.types.Integer_Type;
import org.eclipse.titan.designer.AST.TTCN3.values.ArrayDimension;
import org.eclipse.titan.designer.AST.TTCN3.values.Integer_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionStruct;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class SingleLenghtRestriction
extends LengthRestriction {
    private final Value value;
    private CompilationTimeStamp lastTimeChecked;

    public SingleLenghtRestriction(Value value) {
        this.value = value;
        if (value != null) {
            value.setFullNameParent(this);
        }
    }

    public IValue getRestriction(CompilationTimeStamp timestamp) {
        if (this.value == null) {
            return null;
        }
        ReferenceChain chain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
        IValue last = this.value.getValueRefdLast(timestamp, chain);
        chain.release();
        return last;
    }

    @Override
    public String createStringRepresentation() {
        if (this.value == null) {
            return "<erroneous length restriction>";
        }
        StringBuilder builder = new StringBuilder("length(");
        builder.append(this.value.createStringRepresentation());
        builder.append(')');
        return builder.toString();
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.value != null) {
            this.value.setMyScope(scope);
        }
    }

    @Override
    public void setCodeSection(GovernedSimple.CodeSectionType codeSection) {
        if (this.value != null) {
            this.value.setCodeSection(codeSection);
        }
    }

    @Override
    public void check(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.lastTimeChecked = timestamp;
        if (this.value == null) {
            return;
        }
        Integer_Type integer = new Integer_Type();
        this.value.setMyGovernor(integer);
        IValue last = integer.checkThisValueRef(timestamp, this.value);
        integer.checkThisValue(timestamp, last, null, new IType.ValueCheckingOptions(expectedValue, false, false, true, false, false));
        ReferenceChain chain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
        last = last.getValueRefdLast(timestamp, chain);
        chain.release();
        if (last.getIsErroneous(timestamp)) {
            return;
        }
        switch (last.getValuetype()) {
            case INTEGER_VALUE: {
                BigInteger temp = ((Integer_Value)last).getValueValue();
                if (temp.compareTo(BigInteger.ZERO) != -1) break;
                this.value.getLocation().reportSemanticError(MessageFormat.format("The length restriction must be a non-negative integer value instead of {0}", temp));
                this.value.setIsErroneous(true);
                break;
            }
        }
    }

    @Override
    public void checkArraySize(CompilationTimeStamp timestamp, ArrayDimension dimension) {
        BigInteger length;
        int compareResult;
        if (this.lastTimeChecked == null || dimension.getIsErroneous(timestamp) || this.value == null) {
            return;
        }
        boolean errorFlag = false;
        long arraySize = dimension.getSize();
        ReferenceChain chain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
        IValue last = this.value.getValueRefdLast(timestamp, chain);
        chain.release();
        if (IValue.Value_type.INTEGER_VALUE.equals((Object)last.getValuetype()) && !last.getIsErroneous(timestamp) && (compareResult = (length = ((Integer_Value)last).getValueValue()).compareTo(BigInteger.valueOf(arraySize))) != 0) {
            String message = MessageFormat.format("There number of elements allowed by the length restriction ({0}) contradicts the array size ({1})", length, arraySize);
            this.value.getLocation().reportSemanticError(message);
            errorFlag = true;
        }
        if (!errorFlag) {
            this.getLocation().reportSemanticWarning("Length restriction is useless for an array template");
        }
    }

    @Override
    public void checkNofElements(CompilationTimeStamp timestamp, int nofElements, boolean lessAllowed, boolean moreAllowed, boolean hasAnyornone, ILocateableNode locatable) {
        if (this.value == null) {
            return;
        }
        ReferenceChain chain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
        IValue last = this.value.getValueRefdLast(timestamp, chain);
        chain.release();
        if (IValue.Value_type.INTEGER_VALUE.equals((Object)last.getValuetype()) && !last.getIsErroneous(timestamp)) {
            BigInteger length = ((Integer_Value)last).getValueValue();
            int compareResult = length.compareTo(BigInteger.valueOf(nofElements));
            if (compareResult == -1 && !moreAllowed) {
                String message = MessageFormat.format("There are more ({0}{1}) elements than it is allowed by the length restriction ({2})", hasAnyornone ? "at least " : "", nofElements, length);
                locatable.getLocation().reportSemanticError(message);
            } else if (compareResult == 1 && !lessAllowed) {
                locatable.getLocation().reportSemanticError(MessageFormat.format("There are fewer ({0}) elements than it is allowed by the length restriction ({1})", nofElements, length));
            }
        }
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.value != null) {
            this.value.updateSyntax(reparser, false);
            reparser.updateLocation(this.value.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.value != null) {
            this.value.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        return this.value == null || this.value.accept(v);
    }

    @Override
    public void reArrangeInitCode(JavaGenData aData, StringBuilder source, Module usageModule) {
        if (this.value != null) {
            this.value.reArrangeInitCode(aData, source, usageModule);
        }
    }

    @Override
    public void generateCodeInit(JavaGenData aData, StringBuilder source, String name) {
        ExpressionStruct expression = new ExpressionStruct();
        this.value.generateCodeExpression(aData, expression, false);
        if (expression.preamble.length() > 0 || expression.postamble.length() > 0) {
            source.append("{\n");
            source.append((CharSequence)expression.preamble);
            source.append(MessageFormat.format("{0}.set_single_length({1});\n", name, expression.expression));
            source.append((CharSequence)expression.postamble);
            source.append("}\n");
        } else {
            source.append(MessageFormat.format("{0}.set_single_length({1});\n", name, expression.expression));
        }
    }
}

