/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.templates;

import java.util.List;
import org.eclipse.titan.designer.AST.ASTNode;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.ILocateableNode;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferencingElement;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.ITypeWithComponents;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.NULL_Location;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.IIncrementallyUpdateable;
import org.eclipse.titan.designer.AST.TTCN3.templates.Named_Template_List;
import org.eclipse.titan.designer.AST.TTCN3.templates.TTCN3Template;
import org.eclipse.titan.designer.declarationsearch.Declaration;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class NamedTemplate
extends ASTNode
implements ILocateableNode,
IIncrementallyUpdateable,
IReferencingElement {
    private final Identifier name;
    private final TTCN3Template template;
    private Location location;
    private final boolean parsed;

    public NamedTemplate(Identifier name, TTCN3Template template) {
        this.name = name;
        this.template = template;
        this.location = NULL_Location.INSTANCE;
        this.parsed = true;
        if (template != null) {
            template.setFullNameParent(this);
        }
    }

    public NamedTemplate(Identifier name, TTCN3Template template, boolean parsed) {
        this.name = name;
        this.template = template;
        this.location = NULL_Location.INSTANCE;
        this.parsed = parsed;
        if (template != null) {
            template.setFullNameParent(this);
        }
    }

    public Identifier getName() {
        return this.name;
    }

    public TTCN3Template getTemplate() {
        return this.template;
    }

    public boolean isParsed() {
        return this.parsed;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.template != null) {
            this.template.setMyScope(scope);
        }
    }

    @Override
    public void setLocation(Location location) {
        this.location = location;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        reparser.updateLocation(this.name.getLocation());
        if (this.template != null) {
            this.template.updateSyntax(reparser, false);
            reparser.updateLocation(this.template.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.template != null) {
            this.template.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.name != null && !this.name.accept(v)) {
            return false;
        }
        return this.template == null || this.template.accept(v);
    }

    @Override
    public Declaration getDeclaration() {
        INamedNode inamedNode = this.getNameParent();
        while (!(inamedNode instanceof Named_Template_List)) {
            if (inamedNode == null) {
                return null;
            }
            inamedNode = inamedNode.getNameParent();
        }
        Named_Template_List namedTemplList = (Named_Template_List)inamedNode;
        IType type = namedTemplList.getMyGovernor();
        if (type == null) {
            return null;
        }
        if ((type = type.getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp())) instanceof ITypeWithComponents) {
            Identifier id = ((ITypeWithComponents)((Object)type)).getComponentIdentifierByName(this.getName());
            return Declaration.createInstance(type.getDefiningAssignment(), id);
        }
        return null;
    }
}

