/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.statements;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.PortReference;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.definitions.ActualParameter;
import org.eclipse.titan.designer.AST.TTCN3.definitions.ActualParameterList;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameter;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameterList;
import org.eclipse.titan.designer.AST.TTCN3.statements.Port_Utility;
import org.eclipse.titan.designer.AST.TTCN3.statements.Statement;
import org.eclipse.titan.designer.AST.TTCN3.templates.ParsedActualParameters;
import org.eclipse.titan.designer.AST.TTCN3.types.PortTypeBody;
import org.eclipse.titan.designer.AST.TTCN3.types.Port_Type;
import org.eclipse.titan.designer.AST.TTCN3.values.Expression_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionStruct;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Unmap_Statement
extends Statement {
    private static final String FULLNAMEPART1 = ".componentreference1";
    private static final String FULLNAMEPART2 = ".portreference1";
    private static final String FULLNAMEPART3 = ".componentreference2";
    private static final String FULLNAMEPART4 = ".portreference2";
    private static final String FULLNAMEPART5 = ".parsedParameterList";
    private static final String STATEMENT_NAME = "unmap";
    private final Value componentReference1;
    private final PortReference portReference1;
    private final Value componentReference2;
    private final PortReference portReference2;
    private boolean translate = false;
    private final ParsedActualParameters parsedParameterList;
    private ActualParameterList actualParameterList;
    private FormalParameterList formalParList;

    public Unmap_Statement(Value componentReference1, PortReference portReference1, Value componentReference2, PortReference portReference2, ParsedActualParameters parameters) {
        this.componentReference1 = componentReference1;
        this.portReference1 = portReference1;
        this.componentReference2 = componentReference2;
        this.portReference2 = portReference2;
        this.parsedParameterList = parameters;
        if (componentReference1 != null) {
            componentReference1.setFullNameParent(this);
        }
        if (portReference1 != null) {
            portReference1.setFullNameParent(this);
        }
        if (componentReference2 != null) {
            componentReference2.setFullNameParent(this);
        }
        if (portReference2 != null) {
            portReference2.setFullNameParent(this);
        }
        if (parameters != null) {
            parameters.setFullNameParent(this);
        }
    }

    @Override
    public Statement.Statement_type getType() {
        return Statement.Statement_type.S_UNMAP;
    }

    @Override
    public String getStatementName() {
        return STATEMENT_NAME;
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.componentReference1 == child) {
            return builder.append(FULLNAMEPART1);
        }
        if (this.portReference1 == child) {
            return builder.append(FULLNAMEPART2);
        }
        if (this.componentReference2 == child) {
            return builder.append(FULLNAMEPART3);
        }
        if (this.portReference2 == child) {
            return builder.append(FULLNAMEPART4);
        }
        if (this.parsedParameterList == child) {
            return builder.append(FULLNAMEPART5);
        }
        return builder;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.componentReference1 != null) {
            this.componentReference1.setMyScope(scope);
        }
        if (this.portReference1 != null) {
            this.portReference1.setSubreferencesScope(scope);
        }
        if (this.componentReference2 != null) {
            this.componentReference2.setMyScope(scope);
        }
        if (this.portReference2 != null) {
            this.portReference2.setSubreferencesScope(scope);
        }
        if (this.parsedParameterList != null) {
            this.parsedParameterList.setMyScope(scope);
        }
    }

    @Override
    public void setCodeSection(GovernedSimple.CodeSectionType codeSection) {
        if (this.componentReference1 != null) {
            this.componentReference1.setCodeSection(codeSection);
        }
        if (this.portReference1 != null) {
            this.portReference1.setCodeSection(codeSection);
        }
        if (this.componentReference2 != null) {
            this.componentReference2.setCodeSection(codeSection);
        }
        if (this.portReference2 != null) {
            this.portReference2.setCodeSection(codeSection);
        }
        if (this.parsedParameterList != null) {
            this.parsedParameterList.setCodeSection(codeSection);
        }
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        PortTypeBody body2;
        IType portType2;
        PortTypeBody body1;
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        boolean cref1IsTestcomponents = false;
        boolean cref1IsSystem = false;
        boolean cref2IsTestcomponent = false;
        boolean cref2IsSystem = false;
        IType portType1 = Port_Utility.checkConnectionEndpoint(timestamp, this, this.componentReference1, this.portReference1, true);
        if (portType1 == null) {
            body1 = null;
        } else {
            body1 = ((Port_Type)portType1).getPortBody();
            if (body1.isInternal()) {
                this.componentReference1.getLocation().reportSemanticWarning(MessageFormat.format("Port type `{0}'' was marked as `internal''", portType1.getTypename()));
            }
        }
        IValue configReference1 = this.componentReference1.getValueRefdLast(timestamp, Expected_Value_type.EXPECTED_DYNAMIC_VALUE, null);
        if (IValue.Value_type.EXPRESSION_VALUE.equals((Object)configReference1.getValuetype())) {
            switch (((Expression_Value)configReference1).getOperationType()) {
                case MTC_COMPONENT_OPERATION: {
                    cref1IsTestcomponents = true;
                    break;
                }
                case SELF_COMPONENT_OPERATION: {
                    cref1IsTestcomponents = true;
                    break;
                }
                case COMPONENT_CREATE_OPERATION: {
                    cref1IsTestcomponents = true;
                    break;
                }
                case SYSTEM_COMPONENT_OPERATION: {
                    cref1IsSystem = true;
                    break;
                }
            }
        }
        if ((portType2 = Port_Utility.checkConnectionEndpoint(timestamp, this, this.componentReference2, this.portReference2, true)) == null) {
            body2 = null;
        } else {
            body2 = ((Port_Type)portType2).getPortBody();
            if (body2.isInternal()) {
                this.componentReference2.getLocation().reportSemanticWarning(MessageFormat.format("Port type `{0}'' was marked as `internal''", portType2.getTypename()));
            }
        }
        IValue configReference2 = this.componentReference2.getValueRefdLast(timestamp, Expected_Value_type.EXPECTED_DYNAMIC_VALUE, null);
        if (IValue.Value_type.EXPRESSION_VALUE.equals((Object)configReference2.getValuetype())) {
            switch (((Expression_Value)configReference2).getOperationType()) {
                case MTC_COMPONENT_OPERATION: {
                    cref2IsTestcomponent = true;
                    break;
                }
                case SELF_COMPONENT_OPERATION: {
                    cref2IsTestcomponent = true;
                    break;
                }
                case COMPONENT_CREATE_OPERATION: {
                    cref2IsTestcomponent = true;
                    break;
                }
                case SYSTEM_COMPONENT_OPERATION: {
                    cref2IsSystem = true;
                    break;
                }
            }
        }
        this.lastTimeChecked = timestamp;
        if (cref1IsTestcomponents && cref2IsTestcomponent) {
            this.location.reportSemanticError("Both endpoints of the mapping are test component ports");
            return;
        }
        if (cref1IsSystem && cref2IsSystem) {
            this.location.reportSemanticError("Both endpoints of the mapping are system ports");
            return;
        }
        if (body1 == null || body2 == null) {
            if (body1 != null && body1.isInternal()) {
                this.portReference1.getLocation().reportSemanticWarning(MessageFormat.format("Port type `{0}'' was marked as `internal''", portType1.getTypename()));
            }
            if (body2 != null && body2.isInternal()) {
                this.portReference2.getLocation().reportSemanticWarning(MessageFormat.format("Port type `{0}'' was marked as `internal''", portType2.getTypename()));
            }
            if (body1 != null && !body1.isLegacy() && body1.getPortType() == PortTypeBody.PortType_type.PT_USER || body2 != null && !body2.isLegacy() && body2.getPortType() == PortTypeBody.PortType_type.PT_USER) {
                this.getLocation().reportSemanticWarning(MessageFormat.format("This mapping is not done in translation mode, because the {0} endpoint is unknown", body1 != null ? "second" : "first"));
            }
            this.check_map_params(timestamp, cref1IsSystem ? body1 : (cref2IsSystem ? body2 : null));
            return;
        }
        if (cref1IsTestcomponents || cref2IsSystem) {
            boolean bl = this.translate = !body1.isLegacy() && body1.isTranslate(body2);
            if (!this.translate && !body1.isMappable(timestamp, body2)) {
                this.location.reportSemanticError(MessageFormat.format("The mapping between test component port type `{0}'' and system port type `{1}'' is not consistent", portType1.getTypename(), portType2.getTypename()));
                body1.reportMappingErrors(timestamp, body2);
            }
            if (!this.translate && !body1.mapCanReceiveOrSend(body2)) {
                this.getLocation().reportSemanticWarning(MessageFormat.format("Port type `{0}'' cannot send or receive from system port type `{1}''.", portType1.getTypename(), portType2.getTypename()));
            }
        } else if (cref2IsTestcomponent || cref1IsSystem) {
            boolean bl = this.translate = !body2.isLegacy() && body2.isTranslate(body1);
            if (!this.translate && !body2.isMappable(timestamp, body1)) {
                this.location.reportSemanticError(MessageFormat.format("The mapping between system port type `{0}'' and test component port type `{1}'' is not consistent", portType1.getTypename(), portType2.getTypename()));
                body2.reportMappingErrors(timestamp, body1);
            }
            if (!this.translate && !body2.mapCanReceiveOrSend(body1)) {
                this.getLocation().reportSemanticWarning(MessageFormat.format("Port type `{0}'' cannot send or receive from system port type `{1}''.", portType2.getTypename(), portType1.getTypename()));
            }
        } else {
            boolean firstMappedToSecond = !body1.isLegacy() && body1.isTranslate(body2);
            boolean secondMappedToFirst = !body2.isLegacy() && body2.isTranslate(body1);
            boolean bl = this.translate = firstMappedToSecond || secondMappedToFirst;
            if (!(this.translate || body1.isMappable(timestamp, body2) || body2.isMappable(timestamp, body1))) {
                this.location.reportSemanticError(MessageFormat.format("The mapping between port types `{0}'' and `{1}'' is not consistent", portType1.getTypename(), portType2.getTypename()));
            }
        }
        if (!this.translate) {
            if (body1.isInternal()) {
                this.portReference1.getLocation().reportSemanticWarning(MessageFormat.format("Port type `{0}'' was marked as `internal''", portType1.getTypename()));
            }
            if (body2.isInternal()) {
                this.portReference2.getLocation().reportSemanticWarning(MessageFormat.format("Port type `{0}'' was marked as `internal''", portType2.getTypename()));
            }
            if (!body1.isLegacy() && body1.getPortType() == PortTypeBody.PortType_type.PT_USER || !body2.isLegacy() && body2.getPortType() == PortTypeBody.PortType_type.PT_USER) {
                this.getLocation().reportSemanticWarning("This mapping is not done in translation mode");
            }
        }
        this.check_map_params(timestamp, cref1IsSystem ? body1 : (cref2IsSystem ? body2 : null));
    }

    private void check_map_params(CompilationTimeStamp timestamp, PortTypeBody system_port) {
        if (this.parsedParameterList == null) {
            return;
        }
        if (system_port != null) {
            this.formalParList = system_port.getUnmapParameters();
        } else {
            this.getLocation().reportSemanticError("Cannot determine system component in `unmap' operation with `param' clause");
        }
        if (this.formalParList != null) {
            this.actualParameterList = new ActualParameterList();
            if (this.formalParList.checkActualParameterList(timestamp, this.parsedParameterList, this.actualParameterList)) {
                this.actualParameterList = null;
            } else {
                this.actualParameterList.setFullNameParent(this);
                this.actualParameterList.setMyScope(this.getMyScope());
            }
        }
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.componentReference1 != null) {
            this.componentReference1.updateSyntax(reparser, false);
            reparser.updateLocation(this.componentReference1.getLocation());
        }
        if (this.portReference1 != null) {
            this.portReference1.updateSyntax(reparser, false);
            reparser.updateLocation(this.portReference1.getLocation());
        }
        if (this.componentReference2 != null) {
            this.componentReference2.updateSyntax(reparser, false);
            reparser.updateLocation(this.componentReference2.getLocation());
        }
        if (this.portReference2 != null) {
            this.portReference2.updateSyntax(reparser, false);
            reparser.updateLocation(this.portReference2.getLocation());
        }
        if (this.parsedParameterList != null) {
            this.parsedParameterList.updateSyntax(reparser, false);
            reparser.updateLocation(this.parsedParameterList.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.componentReference1 != null) {
            this.componentReference1.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.portReference1 != null) {
            this.portReference1.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.componentReference2 != null) {
            this.componentReference2.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.portReference2 != null) {
            this.portReference2.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.parsedParameterList != null) {
            this.parsedParameterList.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.componentReference1 != null && !this.componentReference1.accept(v)) {
            return false;
        }
        if (this.portReference1 != null && !this.portReference1.accept(v)) {
            return false;
        }
        if (this.componentReference2 != null && !this.componentReference2.accept(v)) {
            return false;
        }
        if (this.portReference2 != null && !this.portReference2.accept(v)) {
            return false;
        }
        return this.parsedParameterList == null || this.parsedParameterList.accept(v);
    }

    @Override
    public void generateCode(JavaGenData aData, StringBuilder source) {
        aData.addBuiltinTypeImport("TitanPort");
        ExpressionStruct expression = new ExpressionStruct();
        expression.expression.append("TTCN_Runtime.unmap_port(");
        this.componentReference1.generateCodeExpression(aData, expression, true);
        expression.expression.append(", ");
        if (this.componentReference1.getExpressionGovernor(CompilationTimeStamp.getBaseTimestamp(), Expected_Value_type.EXPECTED_DYNAMIC_VALUE) == null) {
            Port_Utility.generate_code_portref(aData, expression, this.portReference1);
        } else {
            this.portReference1.generateCode(aData, expression);
            expression.expression.append(".get_name()");
        }
        expression.expression.append(", ");
        this.componentReference2.generateCodeExpression(aData, expression, true);
        expression.expression.append(", ");
        if (this.componentReference2.getExpressionGovernor(CompilationTimeStamp.getBaseTimestamp(), Expected_Value_type.EXPECTED_DYNAMIC_VALUE) == null) {
            Port_Utility.generate_code_portref(aData, expression, this.portReference2);
        } else {
            this.portReference2.generateCode(aData, expression);
            expression.expression.append(".get_name()");
        }
        if (this.actualParameterList == null) {
            String tempID = aData.getTemporaryVariableName();
            expression.preamble.append(MessageFormat.format("final TitanPort.Map_Params {0} = new TitanPort.Map_Params(0);\n", tempID));
            expression.expression.append(MessageFormat.format(", {0}", tempID));
        } else {
            aData.addBuiltinTypeImport("TitanCharString");
            int nofParameters = this.actualParameterList.getNofParameters();
            String tempID = aData.getTemporaryVariableName();
            expression.preamble.append(MessageFormat.format("TitanPort.Map_Params {0} = new TitanPort.Map_Params({1});\n", tempID, nofParameters));
            for (int i = 0; i < nofParameters; ++i) {
                ActualParameter actualParameter = this.actualParameterList.getParameter(i);
                FormalParameter formalParameter = this.formalParList.getParameterByIndex(i);
                ExpressionStruct parameterExpression = new ExpressionStruct();
                actualParameter.generateCode(aData, parameterExpression, formalParameter);
                if (formalParameter.getAssignmentType() == Assignment.Assignment_type.A_PAR_VAL_OUT) {
                    expression.preamble.append(MessageFormat.format("{0}.set_param({1}, new TitanCharString(\"\"));\n", tempID, i));
                } else {
                    if (parameterExpression.preamble.length() > 0) {
                        expression.preamble.append((CharSequence)parameterExpression.preamble);
                    }
                    expression.preamble.append(MessageFormat.format("{0}.set_param({1}, TitanCharString.ttcn_to_string({2}));\n", tempID, i, parameterExpression.expression.toString()));
                }
                if (formalParameter.getAssignmentType() != Assignment.Assignment_type.A_PAR_VAL_OUT && formalParameter.getAssignmentType() != Assignment.Assignment_type.A_PAR_VAL_INOUT) continue;
                expression.postamble.append(MessageFormat.format("if({0}.get_param({1}).lengthof().get_int() > 0) '{'\n", tempID, i));
                expression.postamble.append(MessageFormat.format("TitanCharString.string_to_ttcn({0}.get_param({1}), {2});\n", tempID, i, parameterExpression.expression));
                expression.postamble.append("}\n");
                if (parameterExpression.postamble.length() <= 0) continue;
                expression.postamble.append((CharSequence)parameterExpression.postamble);
            }
            expression.expression.append(MessageFormat.format(", {0}", tempID));
        }
        if (this.translate) {
            expression.expression.append(", true)");
        } else {
            expression.expression.append(", false)");
        }
        expression.mergeExpression(source);
    }
}

