/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.statements;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.ParameterisedSubReference;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.definitions.ActualParameterList;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Testcase;
import org.eclipse.titan.designer.AST.TTCN3.statements.Statement;
import org.eclipse.titan.designer.AST.TTCN3.values.Real_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionStruct;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Testcase_Instance_Statement
extends Statement {
    private static final String FLOATEXPECTED = "float value expected";
    private static final String FLOATEXPECTED2 = "{0} can not be used as the testcase quard timer duration";
    private static final String DEFINITIONWITHOUTRUNSONEXPECTED = "A definition that has `runs on' clause cannot execute testcases";
    private static final String NEGATIVEDURATION = "The testcase quard timer has negative duration: `{0}''";
    private static final String TESTCASEEXPECTED = "Reference to a testcase was expected in the argument instead of {0}";
    private static final String FULLNAMEPART1 = ".testcasereference";
    private static final String FULLNAMEPART2 = ".timerValue";
    private static final String STATEMENT_NAME = "execute";
    private final Reference testcaseReference;
    private final Value timerValue;

    public Testcase_Instance_Statement(Reference testcaseReference, Value timerValue) {
        this.testcaseReference = testcaseReference;
        this.timerValue = timerValue;
        if (testcaseReference != null) {
            testcaseReference.setFullNameParent(this);
        }
        if (timerValue != null) {
            timerValue.setFullNameParent(this);
        }
    }

    @Override
    public Statement.Statement_type getType() {
        return Statement.Statement_type.S_TESTCASE_INSTANCE;
    }

    @Override
    public String getStatementName() {
        return STATEMENT_NAME;
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.testcaseReference == child) {
            return builder.append(FULLNAMEPART1);
        }
        if (this.timerValue == child) {
            return builder.append(FULLNAMEPART2);
        }
        return builder;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.testcaseReference != null) {
            this.testcaseReference.setMyScope(scope);
        }
        if (this.timerValue != null) {
            this.timerValue.setMyScope(scope);
        }
    }

    @Override
    public void setCodeSection(GovernedSimple.CodeSectionType codeSection) {
        if (this.testcaseReference != null) {
            this.testcaseReference.setCodeSection(codeSection);
        }
        if (this.timerValue != null) {
            this.timerValue.setCodeSection(codeSection);
        }
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.lastTimeChecked = timestamp;
        if (this.testcaseReference == null) {
            return;
        }
        Assignment assignment = this.testcaseReference.getRefdAssignment(timestamp, true);
        if (assignment == null) {
            return;
        }
        if (!Assignment.Assignment_type.A_TESTCASE.semanticallyEquals(assignment.getAssignmentType())) {
            this.testcaseReference.getLocation().reportSemanticError(MessageFormat.format(TESTCASEEXPECTED, assignment.getFullName()));
            return;
        }
        if (this.myStatementBlock.getScopeRunsOn() != null) {
            this.testcaseReference.getLocation().reportSemanticError(DEFINITIONWITHOUTRUNSONEXPECTED);
            return;
        }
        if (this.timerValue != null) {
            this.timerValue.setLoweridToReference(timestamp);
            IType.Type_type temporalType = this.timerValue.getExpressionReturntype(timestamp, Expected_Value_type.EXPECTED_DYNAMIC_VALUE);
            switch (temporalType) {
                case TYPE_REAL: {
                    IValue last = this.timerValue.getValueRefdLast(timestamp, Expected_Value_type.EXPECTED_DYNAMIC_VALUE, null);
                    if (last.isUnfoldable(timestamp)) break;
                    Real_Value real = (Real_Value)last;
                    double i = real.getValue();
                    if (i < 0.0) {
                        this.timerValue.getLocation().reportSemanticError(MessageFormat.format(NEGATIVEDURATION, real.createStringRepresentation()));
                        break;
                    }
                    if (!real.isPositiveInfinity()) break;
                    this.timerValue.getLocation().reportSemanticError(MessageFormat.format(FLOATEXPECTED2, real.createStringRepresentation()));
                    break;
                }
                default: {
                    this.timerValue.getLocation().reportSemanticError(FLOATEXPECTED);
                }
            }
        }
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.testcaseReference != null) {
            this.testcaseReference.updateSyntax(reparser, false);
            reparser.updateLocation(this.testcaseReference.getLocation());
        }
        if (this.timerValue != null) {
            this.timerValue.updateSyntax(reparser, false);
            reparser.updateLocation(this.timerValue.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.testcaseReference != null) {
            this.testcaseReference.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.timerValue != null) {
            this.timerValue.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.testcaseReference != null && !this.testcaseReference.accept(v)) {
            return false;
        }
        return this.timerValue == null || this.timerValue.accept(v);
    }

    @Override
    public void generateCode(JavaGenData aData, StringBuilder source) {
        ActualParameterList actualParList;
        source.append("\t\t");
        ExpressionStruct expression = new ExpressionStruct();
        Assignment testcase = this.testcaseReference.getRefdAssignment(CompilationTimeStamp.getBaseTimestamp(), false);
        expression.expression.append(MessageFormat.format("{0}(", testcase.getGenNameFromScope(aData, source, "testcase_")));
        List<ISubReference> subReferences = this.testcaseReference.getSubreferences();
        if (!subReferences.isEmpty() && subReferences.get(0) instanceof ParameterisedSubReference && (actualParList = ((ParameterisedSubReference)subReferences.get(0)).getActualParameters()).getNofParameters() > 0) {
            actualParList.generateCodeAlias(aData, expression, ((Def_Testcase)testcase).getFormalParameterList());
            expression.expression.append(", ");
        }
        if (this.timerValue != null) {
            expression.expression.append("true, ");
            this.timerValue.generateCodeExpression(aData, expression, true);
            expression.expression.append(')');
        } else {
            aData.addBuiltinTypeImport("TitanFloat");
            aData.addBuiltinTypeImport("Ttcn3Float");
            expression.expression.append("false, new TitanFloat( new Ttcn3Float( 0.0 ) ))");
        }
        expression.mergeExpression(source);
    }
}

