/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.statements;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.TemplateRestriction;
import org.eclipse.titan.designer.AST.TTCN3.statements.Statement;
import org.eclipse.titan.designer.AST.TTCN3.templates.TemplateInstance;
import org.eclipse.titan.designer.AST.TTCN3.values.Integer_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionStruct;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public class SetState_Statement
extends Statement {
    private static final String OPERANDERROR1 = "The first operand of the `setstate' operation should be an integer value";
    private static final String FULLNAMEPART1 = ".value";
    private static final String FULLNAMEPART2 = ".template_instance";
    private static final String STATEMENT_NAME = "setstate";
    private final Value value;
    private final TemplateInstance templateInstance;

    public SetState_Statement(Value value, TemplateInstance templateInstance) {
        this.value = value;
        this.templateInstance = templateInstance;
        if (value != null) {
            value.setFullNameParent(this);
        }
        if (templateInstance != null) {
            templateInstance.setFullNameParent(this);
        }
    }

    @Override
    public Statement.Statement_type getType() {
        return Statement.Statement_type.S_SETSTATE;
    }

    @Override
    public String getStatementName() {
        return STATEMENT_NAME;
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.value == child) {
            return builder.append(FULLNAMEPART1);
        }
        if (this.templateInstance == child) {
            return builder.append(FULLNAMEPART2);
        }
        return builder;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.value != null) {
            this.value.setMyScope(scope);
        }
        if (this.templateInstance != null) {
            this.templateInstance.setMyScope(scope);
        }
    }

    @Override
    public void setCodeSection(GovernedSimple.CodeSectionType codeSection) {
        if (this.value != null) {
            this.value.setCodeSection(codeSection);
        }
        if (this.templateInstance != null) {
            this.templateInstance.setCodeSection(codeSection);
        }
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        if (this.value != null) {
            this.value.setLoweridToReference(timestamp);
            IType.Type_type temporalType = this.value.getExpressionReturntype(timestamp, Expected_Value_type.EXPECTED_DYNAMIC_VALUE);
            switch (temporalType) {
                case TYPE_INTEGER: {
                    IValue last = this.value.getValueRefdLast(timestamp, Expected_Value_type.EXPECTED_DYNAMIC_VALUE, null);
                    if (this.value.isUnfoldable(timestamp) || !IValue.Value_type.INTEGER_VALUE.equals((Object)last.getValuetype())) break;
                    boolean error = false;
                    Integer_Value intValue = (Integer_Value)last;
                    if (intValue.isNative()) {
                        if (intValue.getValue() < 0L || intValue.getValue() > 4L) {
                            error = true;
                        }
                    } else {
                        error = true;
                    }
                    if (!error) break;
                    this.value.getLocation().reportSemanticError("The value of the first parameter must be 0, 1, 2, 3 or 4.");
                    break;
                }
                case TYPE_UNDEFINED: {
                    this.setIsErroneous();
                    break;
                }
                default: {
                    if (this.isErroneous) break;
                    this.location.reportSemanticError(OPERANDERROR1);
                }
            }
        }
        if (this.templateInstance != null) {
            IType governor = this.templateInstance.getExpressionGovernor(timestamp, Expected_Value_type.EXPECTED_DYNAMIC_VALUE);
            if (governor == null) {
                this.templateInstance.getLocation().reportSemanticError("Cannot determine the type of the parameter.");
            } else {
                this.templateInstance.check(timestamp, governor);
            }
        }
        this.lastTimeChecked = timestamp;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.value != null) {
            this.value.updateSyntax(reparser, false);
            reparser.updateLocation(this.value.getLocation());
        }
        if (this.templateInstance != null) {
            this.templateInstance.updateSyntax(reparser, false);
            reparser.updateLocation(this.templateInstance.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.value != null) {
            this.value.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.templateInstance != null) {
            this.templateInstance.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.value != null && !this.value.accept(v)) {
            return false;
        }
        return this.templateInstance == null || this.templateInstance.accept(v);
    }

    @Override
    public void generateCode(JavaGenData aData, StringBuilder source) {
        aData.addCommonLibraryImport("TTCN_Runtime");
        ExpressionStruct expression = new ExpressionStruct();
        expression.expression.append("TTCN_Runtime.set_port_state(");
        this.value.generateCodeExpression(aData, expression, true);
        expression.expression.append(", ");
        if (this.templateInstance == null) {
            expression.expression.append("new TitanCharString(\"\"), false)");
        } else {
            expression.preamble.append("TTCN_Logger.begin_event_log2str();\n");
            ExpressionStruct expression2 = new ExpressionStruct();
            this.templateInstance.generateCode(aData, expression2, TemplateRestriction.Restriction_type.TR_NONE);
            expression2.expression.append(".log()");
            expression2.mergeExpression(expression.preamble);
            String tempId = aData.getTemporaryVariableName();
            expression.preamble.append(MessageFormat.format("final TitanCharString {0} = TTCN_Logger.end_event_log2str();\n", tempId));
            expression.expression.append(MessageFormat.format("{0}, false)", tempId));
        }
        expression.mergeExpression(source);
    }
}

