/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.statements;

import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.statements.Port_Utility;
import org.eclipse.titan.designer.AST.TTCN3.statements.Statement;
import org.eclipse.titan.designer.AST.TTCN3.types.Array_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.PortGenerator;
import org.eclipse.titan.designer.AST.TTCN3.values.ArrayDimensions;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionStruct;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Killed_Statement
extends Statement {
    private static final String FULLNAMEPART1 = ".componentreference";
    private static final String FULLNAMEPART2 = ".redirectIndex";
    private static final String STATEMENT_NAME = "killed";
    private final Value componentReference;
    private final boolean isAny;
    private final boolean anyFrom;
    private final Reference redirectIndex;

    public Killed_Statement(Value componentReference, boolean isAny, boolean any_from, Reference redirectIndex) {
        this.componentReference = componentReference;
        this.isAny = isAny;
        this.anyFrom = any_from;
        this.redirectIndex = redirectIndex;
        if (componentReference != null) {
            componentReference.setFullNameParent(this);
        }
        if (redirectIndex != null) {
            redirectIndex.setFullNameParent(this);
        }
    }

    @Override
    public Statement.Statement_type getType() {
        return Statement.Statement_type.S_KILLED;
    }

    @Override
    public String getStatementName() {
        return STATEMENT_NAME;
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.componentReference == child) {
            return builder.append(FULLNAMEPART1);
        }
        if (this.redirectIndex == child) {
            return builder.append(FULLNAMEPART2);
        }
        return builder;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.componentReference != null) {
            this.componentReference.setMyScope(scope);
        }
        if (this.redirectIndex != null) {
            this.redirectIndex.setMyScope(scope);
        }
    }

    @Override
    public void setCodeSection(GovernedSimple.CodeSectionType codeSection) {
        if (this.componentReference != null) {
            this.componentReference.setCodeSection(codeSection);
        }
        if (this.redirectIndex != null) {
            this.redirectIndex.setCodeSection(codeSection);
        }
    }

    @Override
    public boolean hasReceivingStatement() {
        return true;
    }

    @Override
    public boolean canRepeat() {
        return true;
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        IType referencedType = Port_Utility.checkComponentReference(timestamp, this, this.componentReference, false, false, this.anyFrom);
        if (this.redirectIndex != null && referencedType != null) {
            referencedType = referencedType.getTypeRefdLast(timestamp);
            ArrayDimensions temp = new ArrayDimensions();
            while (referencedType.getTypetype() == IType.Type_type.TYPE_ARRAY) {
                temp.add(((Array_Type)referencedType).getDimension());
                referencedType = ((Array_Type)referencedType).getElementType();
            }
            Killed_Statement.checkIndexRedirection(timestamp, this.redirectIndex, temp, this.anyFrom, "component");
        }
        if (this.redirectIndex != null) {
            this.redirectIndex.setUsedOnLeftHandSide();
        }
        this.lastTimeChecked = timestamp;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.componentReference != null) {
            this.componentReference.updateSyntax(reparser, false);
            reparser.updateLocation(this.componentReference.getLocation());
        }
        if (this.redirectIndex != null) {
            this.redirectIndex.updateSyntax(reparser, false);
            reparser.updateLocation(this.redirectIndex.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.componentReference != null) {
            this.componentReference.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.redirectIndex != null) {
            this.redirectIndex.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.componentReference != null && !this.componentReference.accept(v)) {
            return false;
        }
        return this.redirectIndex == null || this.redirectIndex.accept(v);
    }

    @Override
    public void generateCode(JavaGenData aData, StringBuilder source) {
        ExpressionStruct expression = new ExpressionStruct();
        this.generateCodeExpression(aData, expression, null);
        source.append((CharSequence)expression.preamble);
        PortGenerator.generateCodeStandalone(aData, source, expression.expression.toString(), this.getStatementName(), this.canRepeat(), this.getLocation());
    }

    @Override
    public void generateCodeExpression(JavaGenData aData, ExpressionStruct expression, String callTimer) {
        aData.addCommonLibraryImport("TTCN_Runtime");
        aData.addBuiltinTypeImport("TitanComponent");
        if (this.componentReference != null) {
            this.componentReference.generateCodeExpressionMandatory(aData, expression, true);
            expression.expression.append(".killed(");
            if (this.redirectIndex == null) {
                expression.expression.append("null");
            } else {
                Killed_Statement.generateCodeIndexRedirect(aData, expression, this.redirectIndex, this.getMyScope());
            }
            expression.expression.append(')');
        } else if (this.isAny) {
            expression.expression.append("TTCN_Runtime.component_killed(TitanComponent.ANY_COMPREF)");
        } else {
            expression.expression.append("TTCN_Runtime.component_killed(TitanComponent.ALL_COMPREF)");
        }
    }
}

