/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.statements;

import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.TTCN3.statements.AltGuards;
import org.eclipse.titan.designer.AST.TTCN3.statements.Statement;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Break_Statement
extends Statement {
    private static final String INCORRECTUSAGE = "Break statement cannot be used outside loops, alt or interleave statements, altsteps or response and exception handling part of call operations";
    private static final String STATEMENT_NAME = "break";
    private Statement loop_stmt;
    private AltGuards altGuards;

    @Override
    public Statement.Statement_type getType() {
        return Statement.Statement_type.S_BREAK;
    }

    @Override
    public String getStatementName() {
        return STATEMENT_NAME;
    }

    @Override
    public boolean isTerminating(CompilationTimeStamp timestamp) {
        return true;
    }

    @Override
    protected void setMyLaicStmt(AltGuards pAltGuards, Statement pLoopStmt) {
        if (pLoopStmt != null) {
            this.loop_stmt = pLoopStmt;
        }
        this.altGuards = pAltGuards;
    }

    @Override
    public void setCodeSection(GovernedSimple.CodeSectionType codeSection) {
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        if (this.myStatementBlock == null || !this.myStatementBlock.hasEnclosingLoopOrAltguard()) {
            this.location.reportSemanticError(INCORRECTUSAGE);
        }
        if (this.loop_stmt == null && this.altGuards == null) {
            this.location.reportSemanticError(INCORRECTUSAGE);
        }
        if (this.loop_stmt != null) {
            // empty if block
        }
        this.lastTimeChecked = timestamp;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        return true;
    }

    @Override
    public void generateCode(JavaGenData aData, StringBuilder source) {
        if (this.altGuards != null && this.altGuards.getIsAltstep()) {
            source.append("return TitanAlt_Status.ALT_BREAK;\n");
        } else {
            source.append("break;\n");
        }
    }
}

