/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.definitions;

import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Template;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Getter;
import org.eclipse.titan.designer.AST.TTCN3.definitions.PropertyFunctionContainer;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Property_Function;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Setter;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.types.Class_Type;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public class PropertyBody
implements IVisitableNode {
    private static final String DUPLICATEGETTER = "Duplicate getter declaration";
    private static final String PREVGETTERHERE = "Previous getter declared here";
    private static final String DUPLICATESETTER = "Duplicate setter declaration";
    private static final String PREVSETTERHERE = "Previous setter declared here";
    private static final String PROPERTYOUTSIDECLASS = "Properties can only be declared as class members";
    private static final String INITIALWITHOUTSETTER = "Property without a setter cannot have an initial value";
    private Getter getter = null;
    private Setter setter = null;
    private Definition myDef = null;

    public void setFunction(Property_Function function) {
        if (function instanceof Getter) {
            if (this.getter != null) {
                function.getLocation().reportSemanticError(DUPLICATEGETTER);
                this.getter.getLocation().reportMixedWarning(PREVGETTERHERE);
            } else {
                this.getter = (Getter)function;
            }
        }
        if (function instanceof Setter) {
            if (this.setter != null) {
                function.getLocation().reportSemanticError(DUPLICATESETTER);
                this.setter.getLocation().reportMixedWarning(PREVSETTERHERE);
            } else {
                this.setter = (Setter)function;
            }
        }
    }

    public Getter getGetter() {
        return this.getter;
    }

    public Setter getSetter() {
        return this.setter;
    }

    public void check(CompilationTimeStamp timestamp, Definition definition) {
        this.myDef = definition;
        if (!this.myDef.getMyScope().isClassScope()) {
            this.myDef.getLocation().reportSemanticError(PROPERTYOUTSIDECLASS);
            return;
        }
        boolean isTemplate = this.myDef.getAssignmentType() == Assignment.Assignment_type.A_VAR_TEMPLATE;
        ITTCN3Template initialValue = null;
        if (isTemplate) {
            initialValue = ((Def_Template)this.myDef).getTemplate(timestamp);
        }
        if (this.getter != null) {
            this.getter.check(timestamp, this.myDef);
        }
        if (this.setter != null) {
            this.setter.check(timestamp, this.myDef);
        } else if (initialValue != null) {
            initialValue.getLocation().reportSemanticError(INITIALWITHOUTSETTER);
        }
    }

    @Override
    public boolean accept(ASTVisitor v) {
        if (this.getter != null && !this.getter.accept(v)) {
            return false;
        }
        return this.setter == null || this.setter.accept(v);
    }

    public static PropertyFunctionContainer getInheritedPropertyFunction(CompilationTimeStamp timestamp, Assignment def, boolean isGetter) {
        PropertyFunctionContainer container = new PropertyFunctionContainer();
        container.isAutomatic = false;
        container.function = null;
        for (Class_Type baseClass = def.getMyScope().getScopeClass().getBaseClass(); container.function == null && baseClass != null; baseClass = baseClass.getBaseClass()) {
            Assignment propertyDef = baseClass.getLocalAssignmentByID(timestamp, def.getIdentifier());
            if (propertyDef == null || !propertyDef.isProperty()) continue;
            PropertyBody inheritedBody = propertyDef.getPropertyBody();
            if (inheritedBody != null) {
                if (!isGetter) continue;
                container.function = isGetter ? inheritedBody.getGetter() : inheritedBody.getSetter();
                continue;
            }
            if (propertyDef.isAbstract()) continue;
            container.isAutomatic = true;
            container.definition = propertyDef;
            return container;
        }
        return container;
    }
}

