/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST;

import java.text.MessageFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.Activator;

public final class NamingConventionHelper {
    private static final String INCORRECTWORKSPACELEVEL = "At least one of the naming convention checking regular expressions set on workspace level is incorrect, please correct it.";
    private static final Pattern VISIBILITY_PATTERN = Pattern.compile(".*(?:public|private|friend).*");
    private static final QualifiedName FOLDER_SPECIFIC_CONVENTIONS_ENABLED = new QualifiedName("org.eclipse.titan.designer.Properties.Folder.NamingConventions", "org.eclipse.titan.designer.enableFolderSpecificNamingConventions");
    private static final QualifiedName PROJECT_SPECIFIC_CONVENTIONS_ENABLED = new QualifiedName("org.eclipse.titan.designer.Properties.Project.NamingConventions", "org.eclipse.titan.designer.enableProjectSpecificNamingConventions");
    private static IResource lastSource = null;
    private static IResource lastResult = null;
    private static String namingSeverity;
    private static String containsModuleNameSeverity;
    private static String containsVisibilitySeverity;
    private static boolean silentMode;

    private NamingConventionHelper() {
    }

    public static void clearCaches() {
        lastSource = null;
        lastResult = null;
    }

    private static String getPatternText(String preference, Location location) {
        IResource resource = location.getFile();
        if (lastSource == resource) {
            resource = lastResult;
        } else {
            lastSource = resource;
            lastResult = null;
        }
        while (resource != null) {
            block12: {
                if (resource instanceof IFolder) {
                    IFolder folder = (IFolder)resource;
                    try {
                        if ("true".equals(folder.getPersistentProperty(FOLDER_SPECIFIC_CONVENTIONS_ENABLED))) {
                            lastResult = resource;
                            return folder.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Folder.NamingConventions", preference));
                        }
                        break block12;
                    }
                    catch (CoreException e) {
                        ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
                        return null;
                    }
                }
                if (resource instanceof IProject) {
                    IProject project = (IProject)resource;
                    try {
                        if ("true".equals(project.getPersistentProperty(PROJECT_SPECIFIC_CONVENTIONS_ENABLED))) {
                            lastResult = resource;
                            return project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project.NamingConventions", preference));
                        }
                        break block12;
                    }
                    catch (CoreException e) {
                        ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
                        return null;
                    }
                }
                if (resource instanceof IWorkspaceRoot) {
                    lastResult = resource;
                    return Platform.getPreferencesService().getString("org.eclipse.titan.designer", preference, ".", null);
                }
            }
            resource = resource.getParent();
        }
        return null;
    }

    private static void reportErrorOnPatternLocation(Location location) {
        IResource resource = location.getFile();
        if (lastSource == resource) {
            resource = lastResult;
        } else {
            lastSource = resource;
            lastResult = null;
        }
        while (resource != null) {
            block12: {
                if (resource instanceof IFolder) {
                    IFolder folder = (IFolder)resource;
                    try {
                        if ("true".equals(folder.getPersistentProperty(FOLDER_SPECIFIC_CONVENTIONS_ENABLED))) {
                            lastResult = resource;
                            ErrorReporter.logError((String)("At least one of the naming convention checking regular expressions set on folder " + folder.getName() + " is incorrect, please correct it."));
                            return;
                        }
                        break block12;
                    }
                    catch (CoreException e) {
                        ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
                        return;
                    }
                }
                if (resource instanceof IProject) {
                    IProject project = (IProject)resource;
                    try {
                        if ("true".equals(project.getPersistentProperty(PROJECT_SPECIFIC_CONVENTIONS_ENABLED))) {
                            lastResult = resource;
                            ErrorReporter.logError((String)("At least one of the naming convention checking regular expressions set on project " + project.getName() + " is incorrect, please correct it."));
                            return;
                        }
                        break block12;
                    }
                    catch (CoreException e) {
                        ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
                        return;
                    }
                }
                if (resource instanceof IWorkspaceRoot) {
                    lastResult = resource;
                    ErrorReporter.logError((String)INCORRECTWORKSPACELEVEL);
                    return;
                }
            }
            resource = resource.getParent();
        }
    }

    public static void checkConvention(String preference, Identifier identifier, Assignment checkedItem) {
        if (silentMode) {
            return;
        }
        Location identifierLocation = identifier.getLocation();
        String patternText = NamingConventionHelper.getPatternText(preference, identifierLocation);
        if (patternText == null) {
            return;
        }
        if (NamingConventionHelper.internalCheckConvention(preference, identifier, patternText)) {
            String message = MessageFormat.format("The {0} with name {1} breaks the naming convention  `{2}''", checkedItem.getDescription(), identifier.getDisplayName(), patternText);
            identifierLocation.reportConfigurableSemanticProblem(namingSeverity, message);
        }
    }

    public static void checkConvention(String preference, Identifier identifier, String description) {
        if (silentMode) {
            return;
        }
        Location identifierLocation = identifier.getLocation();
        String patternText = NamingConventionHelper.getPatternText(preference, identifierLocation);
        if (patternText == null) {
            return;
        }
        if (NamingConventionHelper.internalCheckConvention(preference, identifier, patternText)) {
            identifierLocation.reportConfigurableSemanticProblem(namingSeverity, MessageFormat.format("The {0} with name {1} breaks the naming convention  `{2}''", description, identifier.getDisplayName(), patternText));
        }
    }

    private static boolean internalCheckConvention(String preference, Identifier identifier, String patternText) {
        Pattern pattern;
        if (patternText == null) {
            return false;
        }
        try {
            pattern = Pattern.compile(patternText);
        }
        catch (PatternSyntaxException e) {
            NamingConventionHelper.reportErrorOnPatternLocation(identifier.getLocation());
            ErrorReporter.logExceptionStackTrace((Exception)e);
            return false;
        }
        Matcher matcher = pattern.matcher(identifier.getDisplayName());
        return !matcher.matches();
    }

    public static void checkNameContents(Identifier identifier, Identifier moduleID, String description) {
        Location identifierLocation;
        String displayName = identifier.getDisplayName();
        if (displayName.contains(moduleID.getDisplayName())) {
            identifierLocation = identifier.getLocation();
            identifierLocation.reportConfigurableSemanticProblem(containsModuleNameSeverity, MessageFormat.format("The name {1} of the {0} contains the module name {2} it is located in", description, displayName, moduleID.getDisplayName()));
        }
        if (VISIBILITY_PATTERN.matcher(displayName).matches()) {
            identifierLocation = identifier.getLocation();
            identifierLocation.reportConfigurableSemanticProblem(containsVisibilitySeverity, MessageFormat.format("The name {1} of the {0} contains visibility attributes", description, displayName));
        }
    }

    static {
        silentMode = true;
        namingSeverity = Platform.getPreferencesService().getString("org.eclipse.titan.designer", "org.eclipse.titan.designer.reportNamingConventionProblems", "warning", null);
        silentMode = "ignore".equals(namingSeverity);
        containsModuleNameSeverity = Platform.getPreferencesService().getString("org.eclipse.titan.designer", "org.eclipse.titan.designer.reportModuleNameInDefinition", "ignore", null);
        containsVisibilitySeverity = Platform.getPreferencesService().getString("org.eclipse.titan.designer", "org.eclipse.titan.designer.reportVisibilityInDefinition", "ignore", null);
        Activator activator = Activator.getDefault();
        if (activator != null) {
            activator.getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    String property = event.getProperty();
                    if ("org.eclipse.titan.designer.reportNamingConventionProblems".equals(property)) {
                        namingSeverity = Platform.getPreferencesService().getString("org.eclipse.titan.designer", "org.eclipse.titan.designer.reportNamingConventionProblems", "warning", null);
                        silentMode = "ignore".equals(namingSeverity);
                    } else if ("org.eclipse.titan.designer.reportModuleNameInDefinition".equals(property)) {
                        containsModuleNameSeverity = Platform.getPreferencesService().getString("org.eclipse.titan.designer", "org.eclipse.titan.designer.reportModuleNameInDefinition", "ignore", null);
                    } else if ("org.eclipse.titan.designer.reportVisibilityInDefinition".equals(property)) {
                        containsVisibilitySeverity = Platform.getPreferencesService().getString("org.eclipse.titan.designer", "org.eclipse.titan.designer.reportVisibilityInDefinition", "ignore", null);
                    }
                }
            });
        }
    }
}

