/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.ASN1.types;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.titan.designer.AST.ASN1.types.ComponentType;
import org.eclipse.titan.designer.AST.ASTNode;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.types.CompField;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public final class ComponentTypeList
extends ASTNode {
    private final List<ComponentType> componentTypes = new ArrayList<ComponentType>();

    public void addComponentType(ComponentType componentType) {
        if (null != componentType) {
            this.componentTypes.add(componentType);
            componentType.setFullNameParent(this);
        }
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        for (ComponentType componentType : this.componentTypes) {
            componentType.setMyScope(scope);
        }
    }

    public int getNofComps() {
        int result = 0;
        for (ComponentType componentType : this.componentTypes) {
            result += componentType.getNofComps();
        }
        return result;
    }

    public CompField getCompByIndex(int index) {
        int offset = index;
        for (int i = 0; i < this.componentTypes.size(); ++i) {
            int subSize = this.componentTypes.get(i).getNofComps();
            if (offset < subSize) {
                return this.componentTypes.get(i).getCompByIndex(offset);
            }
            offset -= subSize;
        }
        return null;
    }

    public boolean hasCompWithName(Identifier identifier) {
        for (ComponentType componentType : this.componentTypes) {
            if (!componentType.hasCompWithName(identifier)) continue;
            return true;
        }
        return false;
    }

    public CompField getCompByName(Identifier identifier) {
        for (ComponentType componentType : this.componentTypes) {
            if (!componentType.hasCompWithName(identifier)) continue;
            return componentType.getCompByName(identifier);
        }
        return null;
    }

    public void trCompsof(CompilationTimeStamp timestamp, IReferenceChain referenceChain, boolean isSet) {
        for (ComponentType componentType : this.componentTypes) {
            componentType.trCompsof(timestamp, referenceChain, isSet);
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.componentTypes == null) {
            return;
        }
        for (ComponentType ct : this.componentTypes) {
            ct.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.componentTypes != null) {
            for (ComponentType ct : this.componentTypes) {
                if (ct.accept(v)) continue;
                return false;
            }
        }
        return true;
    }
}

