/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.ASN1.Object;

import java.text.MessageFormat;
import org.eclipse.titan.designer.AST.ASN1.ASN1Type;
import org.eclipse.titan.designer.AST.ASN1.IASN1Type;
import org.eclipse.titan.designer.AST.ASN1.Object.FieldSpecification;
import org.eclipse.titan.designer.AST.ASN1.Object.ObjectClass_Definition;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.ISetting;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.ReferenceChain;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.editors.actions.DeclarationCollector;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public final class FixedTypeValue_FieldSpecification
extends FieldSpecification {
    private final ASN1Type fixedType;
    private final boolean isUnique;
    private final boolean hasDefault;
    private final IValue defaultValue;

    public FixedTypeValue_FieldSpecification(Identifier identifier, ASN1Type fixedType, boolean isUnique, boolean isOptional, boolean hasDefault, IValue defaultValue) {
        super(identifier, isOptional);
        this.fixedType = fixedType;
        this.isUnique = isUnique;
        this.hasDefault = hasDefault;
        this.defaultValue = defaultValue;
        if (null != fixedType) {
            fixedType.setOwnertype(IType.TypeOwner_type.OT_FT_V_FLD, this);
            fixedType.setFullNameParent(this);
        }
        if (null != defaultValue) {
            defaultValue.setFullNameParent(this);
        }
    }

    @Override
    public FieldSpecification.Fieldspecification_types getFieldSpecificationType() {
        return FieldSpecification.Fieldspecification_types.FS_V_FT;
    }

    @Override
    public void setMyObjectClass(ObjectClass_Definition objectClass) {
        super.setMyObjectClass(objectClass);
        if (null != this.fixedType) {
            this.fixedType.setMyScope(this.myObjectClass.getMyScope());
        }
        if (null != this.defaultValue) {
            this.defaultValue.setMyScope(this.myObjectClass.getMyScope());
        }
    }

    @Override
    public boolean hasDefault() {
        return this.hasDefault;
    }

    @Override
    public ISetting getDefault() {
        return this.defaultValue;
    }

    public IASN1Type getType() {
        return this.fixedType;
    }

    @Override
    public boolean isUnique() {
        return this.isUnique;
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        if (null != this.lastTimeChecked && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        if (null != this.fixedType) {
            this.fixedType.setGenName(this.myObjectClass.getGenNameOwn(), this.identifier.getName());
            this.fixedType.check(timestamp);
            if (null != this.defaultValue) {
                if (this.isOptional) {
                    this.getLocation().reportSemanticError("OPTIONAL and DEFAULT are mutual exclusive");
                    this.isOptional = false;
                } else if (this.isUnique) {
                    this.getLocation().reportSemanticError("UNIQUE and DEFAULT are mutual exclusive");
                }
                this.defaultValue.setMyGovernor(this.fixedType);
                IValue tempValue = this.fixedType.checkThisValueRef(timestamp, this.defaultValue);
                this.fixedType.checkThisValue(timestamp, tempValue, null, new IType.ValueCheckingOptions(Expected_Value_type.EXPECTED_CONSTANT, false, false, true, false, false));
                this.defaultValue.setGenNamePrefix("const_");
                this.defaultValue.setGenNameRecursive(this.fixedType.getGenNameOwn() + "_defval_");
                this.defaultValue.setCodeSection(GovernedSimple.CodeSectionType.CS_PRE_INIT);
            }
        }
        this.lastTimeChecked = timestamp;
    }

    @Override
    public void addDeclaration(DeclarationCollector declarationCollector, int i) {
        if (null != this.fixedType) {
            this.fixedType.addDeclaration(declarationCollector, i);
        }
    }

    @Override
    public void addProposal(ProposalCollector propCollector, int i) {
        if (null != this.fixedType) {
            this.fixedType.addProposal(propCollector, i);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.identifier != null && !this.identifier.accept(v)) {
            return false;
        }
        if (this.fixedType != null && !this.fixedType.accept(v)) {
            return false;
        }
        return this.defaultValue == null || this.defaultValue.accept(v);
    }

    @Override
    public void generateCode(JavaGenData aData) {
        if (this.fixedType == null) {
            return;
        }
        String typeGenName = this.fixedType.getGenNameOwn();
        StringBuilder sb = aData.getCodeForType(typeGenName);
        StringBuilder typeSource = new StringBuilder();
        this.fixedType.generateCode(aData, typeSource);
        sb.append((CharSequence)typeSource);
        if (this.defaultValue != null) {
            StringBuilder valueSource = new StringBuilder();
            String defValueGenName = this.defaultValue.getGenNameOwn();
            String typeGeneratedName = this.fixedType.getGenNameValue(aData, valueSource);
            if (this.defaultValue.canGenerateSingleExpression()) {
                if (this.defaultValue.returnsNative()) {
                    valueSource.append(MessageFormat.format("\tpublic static final {0} {1} = new {0}({2});\n", typeGeneratedName, defValueGenName, this.defaultValue.generateSingleExpression(aData)));
                } else {
                    valueSource.append(MessageFormat.format("\tpublic static final {0} {1} = {2};\n", typeGeneratedName, defValueGenName, this.defaultValue.generateSingleExpression(aData)));
                }
            } else {
                valueSource.append(MessageFormat.format("\tstatic final {0} {1} = new {0}();\n", typeGeneratedName, defValueGenName));
                this.getLocation().update_location_object(aData, aData.getPreInit());
                ReferenceChain referenceChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
                IValue last = this.defaultValue.getValueRefdLast(CompilationTimeStamp.getBaseTimestamp(), referenceChain);
                referenceChain.release();
                last.generateCodeInit(aData, aData.getPreInit(), defValueGenName);
            }
            aData.addGlobalVariable(typeGeneratedName, valueSource.toString());
        }
    }
}

