/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.ASN1.Object;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTNode;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Identifier;

public final class FieldName
extends ASTNode {
    private final List<Identifier> fields = new ArrayList<Identifier>(1);

    public FieldName newInstance() {
        FieldName temp = new FieldName();
        for (Identifier field : this.fields) {
            temp.addField(field.newInstance());
        }
        return temp;
    }

    public String getDisplayName() {
        StringBuilder builder = new StringBuilder();
        for (Identifier field : this.fields) {
            builder.append('.').append(field.getDisplayName());
        }
        return builder.toString();
    }

    public void addField(Identifier identifier) {
        if (null == identifier) {
            return;
        }
        this.fields.add(identifier);
    }

    public int getNofFields() {
        return this.fields.size();
    }

    public Identifier getFieldByIndex(int index) {
        return this.fields.get(index);
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.fields != null) {
            for (Identifier id : this.fields) {
                if (id.accept(v)) continue;
                return false;
            }
        }
        return true;
    }
}

