/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.eval.preferences;

import java.util.Arrays;
import java.util.List;
import org.eclipse.actf.ui.preferences.GroupFieldEditorPreferencePage;
import org.eclipse.actf.visualization.eval.guideline.GuidelineHolder;
import org.eclipse.actf.visualization.eval.guideline.IGuidelineData;
import org.eclipse.actf.visualization.eval.preferences.GuidelineTreeContentProvider;
import org.eclipse.actf.visualization.eval.preferences.GuidelineTreeItemData;
import org.eclipse.actf.visualization.eval.preferences.GuidelineTreeItemType;
import org.eclipse.actf.visualization.eval.preferences.GuidelineTreeLabelProvider;
import org.eclipse.actf.visualization.eval.preferences.IGuidelineTreeItem;
import org.eclipse.actf.visualization.internal.eval.EvaluationPlugin;
import org.eclipse.actf.visualization.internal.eval.Messages;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class GuidelinePreferencePage
extends GroupFieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = GuidelinePreferencePage.class.getName();
    private GuidelineHolder _guidelineHolder;
    private String[] _checkerOptionNames;
    private String[] _criteriaNames;
    private String[] _criteriaNamesOrg;
    private Button[] _criteriaCheckButtons;
    private CheckboxTreeViewer _guidelineTreeViewer;
    private TreeItem[] _guidelineTreeItems = null;

    public GuidelinePreferencePage() {
        this.setPreferenceStore(EvaluationPlugin.getDefault().getPreferenceStore());
    }

    public void init(IWorkbench iWorkbench) {
        this._guidelineHolder = GuidelineHolder.getInstance();
        this._checkerOptionNames = this._guidelineHolder.getGuidelineNamesWithLevels();
        this._criteriaNamesOrg = this._guidelineHolder.getMetricsNames();
        this._criteriaNames = this._guidelineHolder.getLocalizedMetricsNames();
    }

    protected void createFieldEditors() {
        Composite composite = this.getFieldEditorParent();
        this.createGuidelineTreePart(composite);
        this.createCriteriaOptionPart(composite);
        this.createLineNumberInfoPart(composite);
        this.updateSelectableMetricsButton();
        Composite composite2 = new Composite(composite, 0);
        GridData gridData = new GridData(4, 4, false, false);
        gridData.verticalIndent = 5;
        composite2.setLayoutData((Object)gridData);
        composite2.setLayout((Layout)new GridLayout());
        Label label = new Label(composite, 0);
        gridData = new GridData();
        gridData.verticalIndent = 10;
        label.setLayoutData((Object)gridData);
    }

    private void createGuidelineTreePart(Composite composite) {
        TreeItem[] treeItemArray;
        int n;
        Group group = new Group(composite, 0);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = 280;
        group.setLayoutData((Object)gridData);
        group.setLayout((Layout)new GridLayout());
        group.setText(Messages.adesigner_preference_guideline_list_group_text);
        this._guidelineTreeViewer = new CheckboxTreeViewer((Composite)group, 2048);
        this._guidelineTreeViewer.setLabelProvider((IBaseLabelProvider)new GuidelineTreeLabelProvider());
        this._guidelineTreeViewer.setContentProvider((IContentProvider)new GuidelineTreeContentProvider());
        Tree tree = this._guidelineTreeViewer.getTree();
        tree.setLinesVisible(true);
        tree.setHeaderVisible(true);
        tree.setLayoutData((Object)new GridData(4, 4, true, true));
        TreeColumn treeColumn = new TreeColumn(tree, 0);
        treeColumn.setWidth(240);
        treeColumn.setText(Messages.GuidelinePreferencePage_0);
        TreeColumn treeColumn2 = new TreeColumn(tree, 0);
        treeColumn2.setWidth(450);
        treeColumn2.setText(Messages.GuidelinePreferencePage_1);
        GuidelineTreeItemData guidelineTreeItemData = new GuidelineTreeItemData(null);
        GuidelineTreeItemType guidelineTreeItemType = new GuidelineTreeItemType(10);
        GuidelineTreeItemType guidelineTreeItemType2 = new GuidelineTreeItemType(11);
        guidelineTreeItemData.add(guidelineTreeItemType);
        boolean bl = false;
        IGuidelineData[] iGuidelineDataArray = this._guidelineHolder.getLeafGuidelineData();
        this._checkerOptionNames = this._guidelineHolder.getGuidelineNamesWithLevels();
        int n2 = this._checkerOptionNames.length;
        boolean[][] blArray = this._guidelineHolder.getCorrespondingMetricsOfLeafGuideline();
        int n3 = 0;
        while (n3 < n2) {
            n = 0;
            String[] stringArray = iGuidelineDataArray[n3].getMIMEtypes();
            int n4 = 0;
            while (n4 < stringArray.length) {
                if (stringArray[n4].equals("text/html") || stringArray[n4].equals("application/xhtml+xml")) {
                    n = 1;
                    break;
                }
                ++n4;
            }
            treeItemArray = new GuidelineTreeItemData(this._checkerOptionNames[n3]);
            treeItemArray.setCorrespondingCriteria(blArray[n3]);
            if (n != 0) {
                guidelineTreeItemType.add((IGuidelineTreeItem)treeItemArray);
            } else {
                if (!bl) {
                    guidelineTreeItemData.add(guidelineTreeItemType2);
                    bl = true;
                }
                guidelineTreeItemType2.add((IGuidelineTreeItem)treeItemArray);
            }
            treeItemArray.setIndex(n3);
            treeItemArray.setEnabled(iGuidelineDataArray[n3].isEnabled());
            treeItemArray.setCategory(iGuidelineDataArray[n3].getCategory());
            treeItemArray.setDescription(iGuidelineDataArray[n3].getDescription());
            ++n3;
        }
        this._guidelineTreeViewer.setInput((Object)guidelineTreeItemData);
        this._guidelineTreeViewer.expandAll();
        this._guidelineTreeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
                if (checkStateChangedEvent.getElement() instanceof GuidelineTreeItemType) {
                    GuidelineTreeItemType guidelineTreeItemType = (GuidelineTreeItemType)checkStateChangedEvent.getElement();
                    List<IGuidelineTreeItem> list = guidelineTreeItemType.getChildren();
                    int n = 0;
                    while (n < list.size()) {
                        GuidelineTreeItemData guidelineTreeItemData = (GuidelineTreeItemData)list.get(n);
                        boolean bl = checkStateChangedEvent.getChecked();
                        guidelineTreeItemData.setEnabled(bl);
                        GuidelinePreferencePage.this._guidelineTreeItems[guidelineTreeItemData.getIndex()].setChecked(bl);
                        ++n;
                    }
                }
                GuidelinePreferencePage.this.updateSelectableMetricsButton();
            }
        });
        this._guidelineTreeItems = new TreeItem[n2];
        TreeItem[] treeItemArray2 = tree.getItems();
        n = 0;
        while (n < treeItemArray2.length) {
            boolean bl2 = true;
            treeItemArray = treeItemArray2[n].getItems();
            int n5 = 0;
            while (n5 < treeItemArray.length) {
                GuidelineTreeItemData guidelineTreeItemData2 = (GuidelineTreeItemData)treeItemArray[n5].getData();
                treeItemArray[n5].setText(new String[]{guidelineTreeItemData2.getCategory(), guidelineTreeItemData2.getDescription()});
                Image[] imageArray = new Image[2];
                imageArray[1] = guidelineTreeItemData2.getGuidelineImage();
                treeItemArray[n5].setImage(imageArray);
                boolean bl3 = guidelineTreeItemData2.isEnabled();
                treeItemArray[n5].setChecked(bl3);
                if (!bl3) {
                    bl2 = false;
                }
                this._guidelineTreeItems[guidelineTreeItemData2.getIndex()] = treeItemArray[n5];
                ++n5;
            }
            treeItemArray2[n].setChecked(bl2);
            ++n;
        }
    }

    private void createCriteriaOptionPart(Composite composite) {
        int n = 4;
        Group group = new Group(composite, 0);
        group.setText(Messages.adesigner_preference_guideline_criteria_group_text);
        group.setLayoutData((Object)new GridData(4, 4, false, false));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = n;
        group.setLayout((Layout)gridLayout);
        int n2 = this._criteriaNames.length;
        this._criteriaCheckButtons = new Button[n2];
        boolean[] blArray = this._guidelineHolder.getEnabledMetrics();
        int n3 = 0;
        while (n3 < n2) {
            this._criteriaCheckButtons[n3] = new Button((Composite)group, 32);
            this._criteriaCheckButtons[n3].setText(this._criteriaNames[n3]);
            this._criteriaCheckButtons[n3].setSelection(blArray[n3]);
            if (this._criteriaNamesOrg[n3].matches("(Perceivable|Operable|Understandable|Robust)")) {
                this._criteriaCheckButtons[n3].setEnabled(false);
            }
            if (n3 % n != 0) {
                GridData gridData = new GridData();
                gridData.horizontalIndent = 20;
                this._criteriaCheckButtons[n3].setLayoutData((Object)gridData);
            }
            ++n3;
        }
    }

    private void createLineNumberInfoPart(Composite composite) {
        this.addField((FieldEditor)new RadioGroupFieldEditor("checker.targetDOM", Messages.DialogCheckerOption_Line_Number_Information_19, 1, (String[][])new String[][]{{Messages.DialogCheckerOption_Add_line_number_20, "checker.orgDOM"}, {Messages.DialogCheckerOption_LIVE_DOM, "checker.liveDOM"}}, composite));
    }

    public boolean performOk() {
        boolean bl = super.performOk();
        this.setParameters();
        return bl;
    }

    private void setParameters() {
        int n;
        boolean[] blArray;
        if (this._criteriaCheckButtons != null) {
            blArray = new boolean[this._criteriaCheckButtons.length];
            Arrays.fill(blArray, false);
            n = 0;
            while (n < this._criteriaCheckButtons.length) {
                if (this._criteriaCheckButtons[n] != null && (this._criteriaNamesOrg[n].matches("(Perceivable|Operable|Understandable|Robust)") || this._criteriaCheckButtons[n].isEnabled() && this._criteriaCheckButtons[n].getSelection())) {
                    blArray[n] = true;
                }
                ++n;
            }
            this._guidelineHolder.setEnabledMetrics(blArray);
        }
        if (this._guidelineTreeItems != null) {
            blArray = new boolean[this._guidelineTreeItems.length];
            Arrays.fill(blArray, false);
            n = 0;
            while (n < this._guidelineTreeItems.length) {
                if (this._guidelineTreeItems[n] != null && this._guidelineTreeItems[n].getChecked()) {
                    blArray[n] = true;
                }
                ++n;
            }
            this._guidelineHolder.setEnabledGuidelineWithLevels(blArray);
        }
    }

    private void updateSelectableMetricsButton() {
        boolean[] blArray = new boolean[this._criteriaCheckButtons.length];
        Arrays.fill(blArray, false);
        int n = 0;
        while (n < this._guidelineTreeItems.length) {
            if (this._guidelineTreeItems[n].getChecked()) {
                GuidelineTreeItemData guidelineTreeItemData = (GuidelineTreeItemData)this._guidelineTreeItems[n].getData();
                int n2 = 0;
                while (n2 < this._criteriaCheckButtons.length) {
                    blArray[n2] = blArray[n2] | guidelineTreeItemData.getCorrespondingCriteria()[n2];
                    ++n2;
                }
            }
            ++n;
        }
        n = 0;
        while (n < this._criteriaCheckButtons.length) {
            if (!this._criteriaNamesOrg[n].matches("(Perceivable|Operable|Understandable|Robust)")) {
                this._criteriaCheckButtons[n].setEnabled(blArray[n]);
            }
            ++n;
        }
    }
}

