/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.flash.ui.actions;

import org.eclipse.actf.accservice.swtbridge.AccessibleObject;
import org.eclipse.actf.model.flash.util.FlashMSAAUtil;
import org.eclipse.actf.util.win32.VariantUtil;
import org.eclipse.actf.util.win32.comclutch.IDispatch;
import org.eclipse.actf.visualization.gui.ui.views.IFlashDOMView;
import org.eclipse.actf.visualization.gui.ui.views.MSAAViewRegistory;
import org.eclipse.actf.visualization.internal.flash.Messages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.ole.win32.OleAutomation;
import org.eclipse.swt.ole.win32.Variant;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class FlashRectFinder {
    private boolean viewVisible = false;
    private AccessibleObject playerWindow = null;
    private Rectangle msaaRect = null;
    private AccessibleObject targetObject = null;

    public FlashRectFinder(Object object) {
        if (object instanceof AccessibleObject && MSAAViewRegistory.findViewReference((String)"org.eclipse.actf.visualization.flash.ui.views.FlashDOMView") != null) {
            boolean bl = this.viewVisible = MSAAViewRegistory.showView((String)"org.eclipse.actf.visualization.flash.ui.views.FlashDOMView", (boolean)false) != null;
            if (this.viewVisible) {
                AccessibleObject accessibleObject = (AccessibleObject)object;
                while (accessibleObject != null) {
                    if (FlashMSAAUtil.isFlash((int)accessibleObject.getPtr())) {
                        this.playerWindow = accessibleObject;
                    }
                    if (this.msaaRect == null) {
                        this.msaaRect = accessibleObject.getAccLocation();
                        this.targetObject = accessibleObject;
                    }
                    accessibleObject = accessibleObject.getCachedParent();
                }
            }
        }
    }

    public void find(Shell shell) {
        if (this.viewVisible) {
            if (this.msaaRect == null) {
                MessageDialog.openInformation((Shell)shell, (String)Messages.flash_flash_dom, (String)Messages.flash_error_no_location);
            } else if (this.playerWindow == null) {
                MessageDialog.openInformation((Shell)shell, (String)Messages.flash_flash_dom, (String)Messages.flash_error_select_flash);
            } else {
                this.reCalculateRect();
                IFlashDOMView iFlashDOMView = (IFlashDOMView)MSAAViewRegistory.showView((String)"org.eclipse.actf.visualization.flash.ui.views.FlashDOMView", (boolean)true);
                if (iFlashDOMView != null) {
                    Rectangle rectangle = this.playerWindow.getAccLocation();
                    this.msaaRect.x -= rectangle.x;
                    this.msaaRect.y -= rectangle.y;
                    iFlashDOMView.findRectangle(this.msaaRect, (Object)this.playerWindow);
                }
            }
        }
    }

    private void reCalculateRect() {
        IDispatch iDispatch = FlashMSAAUtil.getHtmlElementFromPtr((int)this.playerWindow.getPtr());
        Variant variant = VariantUtil.createVariantFromIDispatchAddress((int)((int)iDispatch.getPtr()));
        if (variant != null) {
            int[] nArray;
            OleAutomation oleAutomation = variant.getAutomation();
            if (oleAutomation != null && (nArray = oleAutomation.getIDsOfNames(new String[]{"AlignMode"})) != null) {
                AccessibleObject[] accessibleObjectArray = this.targetObject.getCachedParent().getChildren();
                Rectangle[] rectangleArray = new Rectangle[accessibleObjectArray.length];
                int n = 0;
                while (n < accessibleObjectArray.length) {
                    if (accessibleObjectArray[n] != null) {
                        rectangleArray[n] = accessibleObjectArray[n].getAccLocation();
                    }
                    ++n;
                }
                Variant variant2 = oleAutomation.getProperty(nArray[0]);
                oleAutomation.setProperty(nArray[0], new Variant(5));
                FlashRectFinder.wait(500, 1000);
                Rectangle rectangle = this.targetObject.getAccLocation();
                if (rectangle.equals((Object)this.msaaRect)) {
                    int n2 = 0;
                    while (n2 < accessibleObjectArray.length) {
                        if (rectangleArray[n2] != null && !(rectangle = accessibleObjectArray[n2].getAccLocation()).equals((Object)rectangleArray[n2])) {
                            this.msaaRect.x += rectangle.x - rectangleArray[n2].x;
                            this.msaaRect.y += rectangle.y - rectangleArray[n2].y;
                            break;
                        }
                        ++n2;
                    }
                } else {
                    this.msaaRect = rectangle;
                }
                oleAutomation.setProperty(nArray[0], variant2);
                FlashRectFinder.wait(500, 1000);
            }
            variant.dispose();
        }
    }

    private static void wait(int n, int n2) {
        int n3 = 0;
        int n4 = 1;
        Display display = Display.getCurrent();
        while (n3++ < n2) {
            if (display.readAndDispatch()) continue;
            if (n3 >= n) break;
            if (n4-- <= 0) continue;
            display.sleep();
        }
        if (n3 > n) {
            System.out.println("wait count=" + n3);
        }
    }

    public boolean IsValid() {
        return this.viewVisible && this.playerWindow != null && this.msaaRect != null;
    }
}

