/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.platform.util;

import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.sphinx.platform.util.ConsoleLog;
import org.eclipse.sphinx.platform.util.StatusUtil;

public final class PlatformLogUtil {
    private static ILog consoleLog = null;

    public static ILog getLog(Plugin plugin) {
        if (plugin != null) {
            return plugin.getLog();
        }
        if (consoleLog == null) {
            consoleLog = new ConsoleLog();
        }
        return consoleLog;
    }

    public static void logAsError(Plugin plugin, Object object) {
        IStatus status = StatusUtil.createErrorStatus(plugin, object);
        PlatformLogUtil.getLog(plugin).log(status);
    }

    public static void logAsWarning(Plugin plugin, Object object) {
        IStatus status = StatusUtil.createWarningStatus(plugin, object);
        PlatformLogUtil.getLog(plugin).log(status);
    }

    public static void logAsInfo(Plugin plugin, Object object) {
        IStatus status = StatusUtil.createInfoStatus(plugin, object);
        PlatformLogUtil.getLog(plugin).log(status);
    }
}

