/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.xtendxpand;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckEvaluationRequest {
    private Collection<IFile> checkFiles;
    private Collection<Object> modelObjects;

    protected static Collection<Object> getAllContents(Object modelObject) {
        Assert.isNotNull((Object)modelObject);
        ArrayList<Object> modelObjects = new ArrayList<Object>();
        modelObjects.add(modelObject);
        if (modelObject instanceof EObject) {
            TreeIterator eAllContents = ((EObject)modelObject).eAllContents();
            while (eAllContents.hasNext()) {
                EObject element = (EObject)eAllContents.next();
                modelObjects.add(element);
            }
        }
        return modelObjects;
    }

    public CheckEvaluationRequest(IFile checkFile, Object modelRootObject) {
        this(Collections.singleton(checkFile), modelRootObject);
    }

    public CheckEvaluationRequest(Collection<IFile> checkFiles, Object modelRootObject) {
        this(checkFiles, CheckEvaluationRequest.getAllContents(modelRootObject));
    }

    public CheckEvaluationRequest(IFile checkFile, Collection<Object> modelObjects) {
        this(Collections.singleton(checkFile), modelObjects);
    }

    public CheckEvaluationRequest(Collection<IFile> checkFiles, Collection<Object> modelObjects) {
        Assert.isNotNull(checkFiles);
        this.checkFiles = checkFiles;
        this.modelObjects = modelObjects;
    }

    public Collection<IFile> getCheckFiles() {
        return this.checkFiles;
    }

    public Collection<Object> getModelObjects() {
        return this.modelObjects;
    }

    public Object getModelRootObject() {
        Object object;
        if (this.modelObjects != null && (object = this.modelObjects.iterator().next()) instanceof EObject) {
            return EcoreUtil.getRootContainer((EObject)((EObject)object));
        }
        return null;
    }
}

