/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.platform.resources;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceChangeDispatcher
implements IResourceChangeListener {
    private Map<ResourceChangeDispatchPhase, Collection<ResourceChangeListenerDescriptor>> resourceChangeListenerDescriptors = new HashMap<ResourceChangeDispatchPhase, Collection<ResourceChangeListenerDescriptor>>();
    public static final ResourceChangeDispatcher INSTANCE = new ResourceChangeDispatcher();

    private ResourceChangeDispatcher() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 63);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        this.dispatchResourceChanged(event, this.resourceChangeListenerDescriptors.get((Object)ResourceChangeDispatchPhase.PRE));
        this.dispatchResourceChanged(event, this.resourceChangeListenerDescriptors.get((Object)ResourceChangeDispatchPhase.MAIN));
        this.dispatchResourceChanged(event, this.resourceChangeListenerDescriptors.get((Object)ResourceChangeDispatchPhase.POST));
    }

    protected void dispatchResourceChanged(IResourceChangeEvent event, Collection<ResourceChangeListenerDescriptor> listenerDescriptors) {
        if (listenerDescriptors != null) {
            int type = event.getType();
            for (ResourceChangeListenerDescriptor descriptor : listenerDescriptors) {
                IResourceChangeListener listener = descriptor.getResourceChangeListener();
                if ((type & descriptor.getEventMask()) == 0) continue;
                listener.resourceChanged(event);
            }
        }
    }

    public void addResourceChangeListener(IResourceChangeListener listener, ResourceChangeDispatchPhase dispatchPhase) {
        this.addResourceChangeListener(listener, 7, dispatchPhase);
    }

    public void addResourceChangeListener(IResourceChangeListener listener, int eventMask, ResourceChangeDispatchPhase dispatchPhase) {
        Collection<ResourceChangeListenerDescriptor> listenerdescriptorsForPhase;
        if (dispatchPhase == null) {
            dispatchPhase = ResourceChangeDispatchPhase.MAIN;
        }
        if ((listenerdescriptorsForPhase = this.resourceChangeListenerDescriptors.get((Object)dispatchPhase)) == null) {
            listenerdescriptorsForPhase = new HashSet<ResourceChangeListenerDescriptor>();
            this.resourceChangeListenerDescriptors.put(dispatchPhase, listenerdescriptorsForPhase);
        }
        ResourceChangeListenerDescriptor listenerdescriptor = new ResourceChangeListenerDescriptor(listener, eventMask);
        listenerdescriptorsForPhase.add(listenerdescriptor);
    }

    public Map<ResourceChangeDispatchPhase, Collection<ResourceChangeListenerDescriptor>> getResourceChangeListeners() {
        return this.resourceChangeListenerDescriptors;
    }

    public void removeResourceChangeListener(IResourceChangeListener listener) {
        Collection<ResourceChangeListenerDescriptor> listenerDescriptorsForPOST;
        Collection<ResourceChangeListenerDescriptor> listenerDescriptorsForMAIN;
        Collection<ResourceChangeListenerDescriptor> listenerDescriptorsForPRE = this.resourceChangeListenerDescriptors.get((Object)ResourceChangeDispatchPhase.PRE);
        if (listenerDescriptorsForPRE != null) {
            for (ResourceChangeListenerDescriptor preDescriptor : listenerDescriptorsForPRE) {
                if (preDescriptor.resourceChangeListener != listener) continue;
                listenerDescriptorsForPRE.remove(preDescriptor);
                return;
            }
        }
        if ((listenerDescriptorsForMAIN = this.resourceChangeListenerDescriptors.get((Object)ResourceChangeDispatchPhase.MAIN)) != null) {
            for (ResourceChangeListenerDescriptor mainDescriptor : listenerDescriptorsForMAIN) {
                if (mainDescriptor.resourceChangeListener != listener) continue;
                listenerDescriptorsForMAIN.remove(mainDescriptor);
                return;
            }
        }
        if ((listenerDescriptorsForPOST = this.resourceChangeListenerDescriptors.get((Object)ResourceChangeDispatchPhase.POST)) != null) {
            for (ResourceChangeListenerDescriptor postDescriptor : listenerDescriptorsForPOST) {
                if (postDescriptor.resourceChangeListener != listener) continue;
                listenerDescriptorsForPOST.remove(postDescriptor);
                return;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ResourceChangeDispatchPhase {
        PRE,
        MAIN,
        POST;

    }

    public class ResourceChangeListenerDescriptor {
        private IResourceChangeListener resourceChangeListener;
        private int eventMask;

        public ResourceChangeListenerDescriptor(IResourceChangeListener resourceChangeListener, int eventMask) {
            this.resourceChangeListener = resourceChangeListener;
            this.eventMask = eventMask;
        }

        public IResourceChangeListener getResourceChangeListener() {
            return this.resourceChangeListener;
        }

        public int getEventMask() {
            return this.eventMask;
        }
    }
}

