/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.examples.validation.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.validation.model.Category;
import org.eclipse.emf.validation.model.CategoryManager;
import org.eclipse.emf.validation.service.IConstraintFilter;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.sphinx.emf.validation.diagnostic.filters.ConstraintCategoryFilter;
import org.eclipse.sphinx.emf.validation.util.ValidationUtil;
import org.eclipse.sphinx.examples.validation.ui.internal.Activator;
import org.eclipse.sphinx.examples.validation.ui.internal.messages.Messages;
import org.eclipse.sphinx.platform.ui.util.ExtendedPlatformUI;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;
import org.eclipse.ui.dialogs.ListSelectionDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicValidateSelectedCategoriesAction
extends BaseSelectionListenerAction {
    public BasicValidateSelectedCategoriesAction() {
        super(Messages.action_validateSelectedCategories_label);
    }

    public void run() {
        final List<IConstraintFilter> selectedCategories = this.getSelectedCategories();
        if (selectedCategories == null || selectedCategories.isEmpty()) {
            return;
        }
        try {
            WorkspaceModifyDelegatingOperation operation = new WorkspaceModifyDelegatingOperation(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    ArrayList objects = new ArrayList();
                    Iterator it = BasicValidateSelectedCategoriesAction.this.getStructuredSelection().iterator();
                    while (it.hasNext()) {
                        objects.add(it.next());
                    }
                    ValidationUtil.validate(objects, (Collection)selectedCategories, (IProgressMonitor)monitor);
                }
            });
            new ProgressMonitorDialog(ExtendedPlatformUI.getActiveShell()).run(true, true, (IRunnableWithProgress)operation);
        }
        catch (Exception ex) {
            PlatformLogUtil.logAsError((Plugin)Activator.getDefault(), (Object)ex);
        }
    }

    private List<IConstraintFilter> getSelectedCategories() {
        Shell shell = ExtendedPlatformUI.getActiveShell();
        IStructuredContentProvider contentProvider = this.createContentProvider();
        ILabelProvider labelProvider = this.createLabelProvider();
        String desc = Messages.dialog_SelectConstraintCategories_description;
        String title = Messages.dialog_SelectConstraintCategories_title;
        ListSelectionDialog dialog = new ListSelectionDialog(shell, new Object(), contentProvider, labelProvider, desc);
        dialog.setTitle(title);
        dialog.setBlockOnOpen(true);
        int result = dialog.open();
        if (result == 0) {
            ArrayList<IConstraintFilter> categories = new ArrayList<IConstraintFilter>();
            Object[] objectArray = dialog.getResult();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                if (obj instanceof Category) {
                    categories.add((IConstraintFilter)new ConstraintCategoryFilter(((Category)obj).getId()));
                }
                ++n2;
            }
            return categories;
        }
        return null;
    }

    private IStructuredContentProvider createContentProvider() {
        return new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return CategoryManager.getInstance().getTopLevelCategories().toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        };
    }

    private ILabelProvider createLabelProvider() {
        return new ILabelProvider(){

            public Image getImage(Object element) {
                return null;
            }

            public String getText(Object element) {
                if (element instanceof Category) {
                    return ((Category)element).getName();
                }
                return element != null ? element.toString() : "";
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        };
    }
}

