/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.property;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.list.IListProperty;
import org.eclipse.core.databinding.property.map.IMapProperty;
import org.eclipse.core.databinding.property.set.ISetProperty;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.core.internal.databinding.property.list.SelfListProperty;
import org.eclipse.core.internal.databinding.property.map.SelfMapProperty;
import org.eclipse.core.internal.databinding.property.set.SelfSetProperty;
import org.eclipse.core.internal.databinding.property.value.ObservableValueProperty;
import org.eclipse.core.internal.databinding.property.value.SelfValueProperty;

public class Properties {
    @SafeVarargs
    public static <E, P> IObservableMap<E, ? extends P>[] observeEach(IObservableSet<E> domainSet, IValueProperty<? super E, ? extends P> ... properties) {
        IObservableMap[] maps = new IObservableMap[properties.length];
        int i = 0;
        while (i < maps.length) {
            maps[i] = properties[i].observeDetail(domainSet);
            ++i;
        }
        return maps;
    }

    @SafeVarargs
    public static <K, V, P> IObservableMap<K, ? extends P>[] observeEach(IObservableMap<K, V> domainMap, IValueProperty<? super V, ? extends P> ... properties) {
        IObservableMap[] maps = new IObservableMap[properties.length];
        int i = 0;
        while (i < maps.length) {
            maps[i] = properties[i].observeDetail(domainMap);
            ++i;
        }
        return maps;
    }

    public static <T> IValueProperty<T, T> selfValue(Object valueType) {
        return new SelfValueProperty(valueType);
    }

    public static <E> IListProperty<List<E>, E> selfList(Object elementType) {
        return new SelfListProperty(elementType);
    }

    public static <E> ISetProperty<Set<E>, E> selfSet(Object elementType) {
        return new SelfSetProperty(elementType);
    }

    public static <K, V> IMapProperty<Map<K, V>, K, V> selfMap(Object keyType, Object valueType) {
        return new SelfMapProperty(keyType, valueType);
    }

    public static <T> IValueProperty<IObservableValue<T>, T> observableValue(Object valueType) {
        return new ObservableValueProperty(valueType);
    }
}

