/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.demo.controls;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.rap.demo.controls.ExampleTab;
import org.eclipse.rwt.widgets.ExternalBrowser;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

final class BrowserTab
extends ExampleTab {
    private static final String PROP_PROGRESS_LISTENER = "progressListener";
    private static final String DEFAULT_HTML = "<html>\n<head>\n<script type=\"text/javascript\">\n  function show( msg ) {\n    alert( msg );\n}\n</script>\n</head>\n<body>\n  <p id=\"a\">Hello World</p>\n</body>\n</html>";
    private Browser browser;
    private BrowserFunction function;

    public BrowserTab(CTabFolder folder) {
        super(folder, "Browser");
    }

    protected void createStyleControls(Composite parent) {
        this.createStyleButton("BORDER", 2048);
        this.createVisibilityButton();
        this.createEnablementButton();
        this.createUrlAndHTMLSelector(parent);
        this.createPropertyCheckbox("Add Progress Listener", PROP_PROGRESS_LISTENER);
        this.createExternalBrowserSelector(parent);
        this.createBrowserFunctionSelector(parent);
    }

    protected void createExampleControls(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.browser = new Browser(parent, this.getStyle());
        if (this.hasCreateProperty(PROP_PROGRESS_LISTENER)) {
            this.browser.addProgressListener(new ProgressListener(){

                public void changed(ProgressEvent event) {
                    BrowserTab.this.log("changed: " + event);
                }

                public void completed(ProgressEvent event) {
                    BrowserTab.this.log("completed: " + event);
                }
            });
        }
        this.registerControl((Control)this.browser);
    }

    private void createUrlAndHTMLSelector(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        Label lblURL = new Label(composite, 0);
        lblURL.setText("URL");
        final Text txtURL = new Text(composite, 2048);
        txtURL.setText("http://eclipse.org/rap");
        Button btnURL = new Button(composite, 8);
        btnURL.setText("Go");
        btnURL.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                BrowserTab.this.browser.setUrl(txtURL.getText());
            }
        });
        Label lblHTML = new Label(composite, 0);
        lblHTML.setText("HTML");
        lblHTML.setLayoutData((Object)new GridData(2));
        final Text txtHTML = new Text(composite, 2050);
        txtHTML.setText(DEFAULT_HTML);
        txtHTML.setLayoutData((Object)new GridData(110, 100));
        Button btnHTML = new Button(composite, 8);
        btnHTML.setText("Go");
        btnHTML.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                BrowserTab.this.browser.setText(txtHTML.getText());
            }
        });
        btnHTML.setLayoutData((Object)new GridData(2));
        Label lblExecute = new Label(composite, 0);
        lblExecute.setText("Execute");
        final Text txtExecute = new Text(composite, 2048);
        Button btnExecButton = new Button(composite, 8);
        btnExecButton.setText("Go");
        btnExecButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                boolean result = BrowserTab.this.browser.execute(txtExecute.getText());
                String msg = result ? "Execution was successful." : "Execution was not successful.";
                BrowserTab.this.log(msg);
            }
        });
    }

    private void createExternalBrowserSelector(Composite parent) {
        Group group = new Group(parent, 0);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setText("External Browser");
        Label lblId = new Label((Composite)group, 0);
        lblId.setText("Id");
        final Text txtId = new Text((Composite)group, 2048);
        txtId.setLayoutData((Object)BrowserTab.grapExcessHorizontalSpace());
        txtId.setText("1");
        Label lblUrl = new Label((Composite)group, 0);
        lblUrl.setText("URL");
        final Text txtUrl = new Text((Composite)group, 2048);
        txtUrl.setLayoutData((Object)BrowserTab.grapExcessHorizontalSpace());
        txtUrl.setText("http://eclipse.org/rap");
        final Button cbLocationBar = new Button((Composite)group, 32);
        cbLocationBar.setLayoutData((Object)BrowserTab.horizontalSpan2());
        cbLocationBar.setText("LOCATION_BAR");
        final Button cbNavigationBar = new Button((Composite)group, 32);
        cbNavigationBar.setLayoutData((Object)BrowserTab.horizontalSpan2());
        cbNavigationBar.setText("NAVIGATION_BAR");
        final Button cbStatusBar = new Button((Composite)group, 32);
        cbStatusBar.setLayoutData((Object)BrowserTab.horizontalSpan2());
        cbStatusBar.setText("STATUS");
        Button btnOpen = new Button((Composite)group, 8);
        btnOpen.setLayoutData((Object)BrowserTab.horizontalSpan2());
        btnOpen.setText("open( id, url, style )");
        btnOpen.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                boolean locationBar = cbLocationBar.getSelection();
                boolean statusBar = cbStatusBar.getSelection();
                boolean navigationBar = cbNavigationBar.getSelection();
                int style = BrowserTab.computeStyle(locationBar, statusBar, navigationBar);
                ExternalBrowser.open((String)txtId.getText(), (String)txtUrl.getText(), (int)style);
            }
        });
        Button btnClose = new Button((Composite)group, 8);
        btnClose.setLayoutData((Object)BrowserTab.horizontalSpan2());
        btnClose.setText("close( id )");
        btnClose.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ExternalBrowser.close((String)txtId.getText());
            }
        });
        Button btnMailTo = new Button((Composite)group, 8);
        btnMailTo.setText("mailto:...");
        btnMailTo.setLayoutData((Object)BrowserTab.horizontalSpan2());
        btnMailTo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                boolean locationBar = cbLocationBar.getSelection();
                boolean statusBar = cbStatusBar.getSelection();
                boolean navigationBar = cbNavigationBar.getSelection();
                int style = BrowserTab.computeStyle(locationBar, statusBar, navigationBar);
                ExternalBrowser.open((String)"mailto", (String)"mailto:someone@nowhere.org", (int)style);
                ExternalBrowser.close((String)"mailto");
            }
        });
    }

    private void createBrowserFunctionSelector(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText("BrowserFunction");
        group.setLayout((Layout)new GridLayout(3, false));
        Label lblHTML = new Label((Composite)group, 0);
        lblHTML.setText("HTML");
        lblHTML.setLayoutData((Object)new GridData(2));
        final Text txtHTML = new Text((Composite)group, 2050);
        txtHTML.setText(this.createBrowserFunctionHTML());
        txtHTML.setLayoutData((Object)new GridData(200, 200));
        Button btnHTML = new Button((Composite)group, 8);
        btnHTML.setText("Go");
        btnHTML.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                BrowserTab.this.browser.setText(txtHTML.getText());
                BrowserTab.this.function = new CustomFunction(BrowserTab.this.browser, "theJavaFunction");
            }
        });
        btnHTML.setLayoutData((Object)new GridData(2));
        GridData buttonsGridData = new GridData();
        buttonsGridData.horizontalSpan = 3;
        Button createButton = new Button((Composite)group, 8);
        createButton.setLayoutData((Object)buttonsGridData);
        createButton.setText("Create theJavaFunction");
        createButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                BrowserTab.this.function = new CustomFunction(BrowserTab.this.browser, "theJavaFunction");
            }
        });
        Button disposeButton = new Button((Composite)group, 8);
        disposeButton.setLayoutData((Object)buttonsGridData);
        disposeButton.setText("Dispose theJavaFunction");
        disposeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                BrowserTab.this.function.dispose();
            }
        });
    }

    private static GridData horizontalSpan2() {
        GridData result = new GridData();
        result.horizontalSpan = 2;
        return result;
    }

    private static GridData grapExcessHorizontalSpace() {
        GridData result = new GridData(4, 0x1000000, true, false);
        return result;
    }

    private static int computeStyle(boolean locationBar, boolean statusBar, boolean navigationBar) {
        int style = 0;
        if (locationBar) {
            style |= 2;
        }
        if (navigationBar) {
            style |= 4;
        }
        if (statusBar) {
            style |= 8;
        }
        return style;
    }

    private String createBrowserFunctionHTML() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<html>\n");
        buffer.append("<head>\n");
        buffer.append("<script language=\"JavaScript\">\n");
        buffer.append("function function1() {\n");
        buffer.append("    var result;\n");
        buffer.append("    try {\n");
        buffer.append("        result = theJavaFunction(12, false, null, [3.6, ['swt', true]], 'eclipse');\n");
        buffer.append("    } catch (e) {\n");
        buffer.append("        alert('a java error occurred: ' + e.message);\n");
        buffer.append("        return;\n");
        buffer.append("    }\n");
        buffer.append("}\n");
        buffer.append("</script>\n");
        buffer.append("</head>\n");
        buffer.append("<body>\n");
        buffer.append("<input id=button type=\"button\" value=\"Push to Invoke Java\" onclick=\"function1();\">\n");
        buffer.append("</body>\n");
        buffer.append("</html>\n");
        return buffer.toString();
    }

    private class CustomFunction
    extends BrowserFunction {
        CustomFunction(Browser browser, String name) {
            super(browser, name);
        }

        public Object function(Object[] arguments) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("theJavaFunction() called from javascript with args:\n");
            this.dumpArguments(arguments, "", buffer);
            String title = "BrowserFunction called";
            MessageDialog.openInformation((Shell)BrowserTab.this.getShell(), (String)title, (String)buffer.toString());
            Object[] objectArray = new Object[6];
            objectArray[0] = new Short(3);
            objectArray[1] = new Boolean(true);
            objectArray[3] = new Object[]{"a string", new Boolean(false)};
            objectArray[4] = "hi";
            objectArray[5] = new Float(0.6666667f);
            Object[] returnValue = objectArray;
            return returnValue;
        }

        private void dumpArguments(Object[] arguments, String tabString, StringBuffer buffer) {
            String tab = String.valueOf(tabString) + "    ";
            int i = 0;
            while (i < arguments.length) {
                Object arg = arguments[i];
                if (arg == null) {
                    buffer.append(tab);
                    buffer.append("-->null\n");
                } else {
                    buffer.append(tab);
                    buffer.append("-->");
                    buffer.append(arg.getClass().getName());
                    buffer.append(": ");
                    buffer.append(arg.toString());
                    buffer.append("\n");
                    if (arg.getClass().isArray()) {
                        Object[] arg1 = (Object[])arg;
                        this.dumpArguments(arg1, tab, buffer);
                    }
                }
                ++i;
            }
        }
    }
}

