/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.engine;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.rwt.internal.util.ClassUtil;
import org.eclipse.rwt.internal.util.ParamCheck;

public class ApplicationContext {
    private final Map instances = new HashMap();

    public ApplicationContext() {
        this(new Class[0]);
    }

    public ApplicationContext(Class[] instanceTypes) {
        this.createInstances(instanceTypes);
    }

    Object getInstance(Class instanceType) {
        ParamCheck.notNull(instanceType, "instanceType");
        Object result = this.findInstance(instanceType);
        ApplicationContext.checkRegistered(instanceType, result);
        return result;
    }

    private void createInstances(Class[] instanceTypes) {
        int i = 0;
        while (i < instanceTypes.length) {
            Object instance = ClassUtil.newInstance(instanceTypes[i]);
            this.bufferInstance(instanceTypes[i], instance);
            ++i;
        }
    }

    private Object findInstance(Class instanceType) {
        return this.instances.get(instanceType);
    }

    private void bufferInstance(Class instanceType, Object instance) {
        Object toRegister = ApplicationContext.createInstanceFromFactory(instance);
        Class registrationType = ApplicationContext.getTypeFromFactory(instanceType, instance);
        ApplicationContext.checkInstanceOf(toRegister, registrationType);
        this.checkAlreadyRegistered(registrationType);
        this.instances.put(registrationType, toRegister);
    }

    private void checkAlreadyRegistered(Class registrationType) {
        if (this.instances.containsKey(registrationType)) {
            String pattern = "The instance type ''{0}'' has already been registered.";
            Object[] arguments = new Object[]{registrationType.getName()};
            ApplicationContext.throwIllegalArgumentException(pattern, arguments);
        }
    }

    private static Object createInstanceFromFactory(Object instance) {
        Object result = instance;
        if (instance instanceof InstanceTypeFactory) {
            InstanceTypeFactory factory = (InstanceTypeFactory)instance;
            result = factory.createInstance();
        }
        return result;
    }

    private static Class getTypeFromFactory(Class instanceType, Object instance) {
        Class result = instanceType;
        if (instance instanceof InstanceTypeFactory) {
            InstanceTypeFactory factory = (InstanceTypeFactory)instance;
            result = factory.getInstanceType();
        }
        return result;
    }

    private static void checkRegistered(Class instanceType, Object instance) {
        if (instance == null) {
            String pattern = "Unregistered instance type ''{0}''";
            Object[] arguments = new Object[]{instanceType};
            ApplicationContext.throwIllegalArgumentException(pattern, arguments);
        }
    }

    private static void checkInstanceOf(Object instance, Class type) {
        if (!type.isInstance(instance)) {
            String pattern = "Instance to register does not match declared type ''{0}''.";
            Object[] arguments = new Object[]{type.getName()};
            ApplicationContext.throwIllegalArgumentException(pattern, arguments);
        }
    }

    private static void throwIllegalArgumentException(String pattern, Object[] arx) {
        String msg = MessageFormat.format(pattern, arx);
        throw new IllegalArgumentException(msg);
    }

    public static interface InstanceTypeFactory {
        public Object createInstance();

        public Class getInstanceType();
    }
}

