/*******************************************************************************
 * Copyright (c) 2016 Fundacin Tecnalia Research & Innovation and KPIT Technologies.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   Huascar Espinoza(Tecnalia) - initial API and implementation
 *   Alejandra Ruz(Tecnalia) - initial API and implementation
 *   Idoya Del Ro(Tecnalia) - initial API and implementation
 *   Mari Carmen Palacios(Tecnalia) - initial API and implementation
 *   Angel Lpez(Tecnalia) - initial API and implementation
 *   Jan Mauersberger(KPIT)- LayoutUtil implementation
 *   Sascha Baumgart(KPIT)- LayoutUtil implementation
 *******************************************************************************/
package gsnfigures;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.draw2d.ui.figures.PolylineConnectionEx;
import org.eclipse.draw2d.ColorConstants;

public class GSNSolvedBy extends PolylineConnectionEx {

	//says if the element is related with any multiplicity extension
	private  int shape;

	public GSNSolvedBy(){
		this.setShape(0);
		
	}
	@Override
	public void paint(Graphics graphics) {
		Rectangle r =getPoints().getBounds();
		int radius=(r.width+r.height)/32;
		super.paint(graphics);
		Rectangle circle=new Rectangle(r.getCenter().x-radius, r.getCenter().y-radius, 2*radius, 2*radius);
		if(shape==1){
			graphics.setBackgroundColor(ColorConstants.white);
			graphics.setForegroundColor(ColorConstants.black);
			graphics.drawOval(circle);
			graphics.fillOval(circle);
		}
		else if(shape==2){
			graphics.setBackgroundColor(ColorConstants.black);
			graphics.setForegroundColor(ColorConstants.black);
			graphics.drawOval(circle);
			graphics.fillOval(circle);
		}

	}
	
	public void setShape(int shape) {
		this.shape = shape;
	}
	public int getShape() {
		return shape;
	}
}
