/*****************************************************************************
 * Copyright (c) 2010 CEA LIST.
 *
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  Chokri MRAIDHA (CEA LIST) chokri.mraidha@cea.fr - Initial API and implementation
 *
 *****************************************************************************/
package org.eclipse.papyrus.MARTE.MARTE_Annexes.VSL.DataTypes.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.papyrus.MARTE.MARTE_Annexes.VSL.DataTypes.DataTypesPackage;
import org.eclipse.papyrus.MARTE.MARTE_Annexes.VSL.DataTypes.IntervalType;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Property;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Interval Type</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 * <li>{@link org.eclipse.papyrus.MARTE.MARTE_Annexes.VSL.DataTypes.impl.IntervalTypeImpl#getIntervalAttrib <em>Interval Attrib</em>}</li>
 * <li>{@link org.eclipse.papyrus.MARTE.MARTE_Annexes.VSL.DataTypes.impl.IntervalTypeImpl#getBase_DataType <em>Base Data Type</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class IntervalTypeImpl extends EObjectImpl implements IntervalType {
	/**
	 * The cached value of the '{@link #getIntervalAttrib() <em>Interval Attrib</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @see #getIntervalAttrib()
	 * @generated
	 * @ordered
	 */
	protected Property intervalAttrib;

	/**
	 * The cached value of the '{@link #getBase_DataType() <em>Base Data Type</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @see #getBase_DataType()
	 * @generated
	 * @ordered
	 */
	protected DataType base_DataType;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	protected IntervalTypeImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return DataTypesPackage.Literals.INTERVAL_TYPE;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Property getIntervalAttrib() {
		if (intervalAttrib != null && intervalAttrib.eIsProxy()) {
			InternalEObject oldIntervalAttrib = (InternalEObject) intervalAttrib;
			intervalAttrib = (Property) eResolveProxy(oldIntervalAttrib);
			if (intervalAttrib != oldIntervalAttrib) {
				if (eNotificationRequired()) {
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, DataTypesPackage.INTERVAL_TYPE__INTERVAL_ATTRIB, oldIntervalAttrib, intervalAttrib));
				}
			}
		}
		return intervalAttrib;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	public Property basicGetIntervalAttrib() {
		return intervalAttrib;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public void setIntervalAttrib(Property newIntervalAttrib) {
		Property oldIntervalAttrib = intervalAttrib;
		intervalAttrib = newIntervalAttrib;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET, DataTypesPackage.INTERVAL_TYPE__INTERVAL_ATTRIB, oldIntervalAttrib, intervalAttrib));
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public DataType getBase_DataType() {
		if (base_DataType != null && base_DataType.eIsProxy()) {
			InternalEObject oldBase_DataType = (InternalEObject) base_DataType;
			base_DataType = (DataType) eResolveProxy(oldBase_DataType);
			if (base_DataType != oldBase_DataType) {
				if (eNotificationRequired()) {
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, DataTypesPackage.INTERVAL_TYPE__BASE_DATA_TYPE, oldBase_DataType, base_DataType));
				}
			}
		}
		return base_DataType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	public DataType basicGetBase_DataType() {
		return base_DataType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public void setBase_DataType(DataType newBase_DataType) {
		DataType oldBase_DataType = base_DataType;
		base_DataType = newBase_DataType;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET, DataTypesPackage.INTERVAL_TYPE__BASE_DATA_TYPE, oldBase_DataType, base_DataType));
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
		case DataTypesPackage.INTERVAL_TYPE__INTERVAL_ATTRIB:
			if (resolve) {
				return getIntervalAttrib();
			}
			return basicGetIntervalAttrib();
		case DataTypesPackage.INTERVAL_TYPE__BASE_DATA_TYPE:
			if (resolve) {
				return getBase_DataType();
			}
			return basicGetBase_DataType();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
		case DataTypesPackage.INTERVAL_TYPE__INTERVAL_ATTRIB:
			setIntervalAttrib((Property) newValue);
			return;
		case DataTypesPackage.INTERVAL_TYPE__BASE_DATA_TYPE:
			setBase_DataType((DataType) newValue);
			return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
		case DataTypesPackage.INTERVAL_TYPE__INTERVAL_ATTRIB:
			setIntervalAttrib((Property) null);
			return;
		case DataTypesPackage.INTERVAL_TYPE__BASE_DATA_TYPE:
			setBase_DataType((DataType) null);
			return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
		case DataTypesPackage.INTERVAL_TYPE__INTERVAL_ATTRIB:
			return intervalAttrib != null;
		case DataTypesPackage.INTERVAL_TYPE__BASE_DATA_TYPE:
			return base_DataType != null;
		}
		return super.eIsSet(featureID);
	}

} // IntervalTypeImpl
