/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.evm.evidspec.presentation;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.dawn.editors.IDawnEditor;
import org.eclipse.emf.cdo.dawn.editors.IDawnEditorSupport;
import org.eclipse.emf.cdo.dawn.emf.editors.impl.DawnEMFEditorSupport;
import org.eclipse.emf.cdo.dawn.ui.DawnEditorInput;
import org.eclipse.emf.cdo.dawn.ui.DawnLabelProvider;
import org.eclipse.emf.cdo.dawn.ui.DawnSelectionViewerAdapterFactoryContentProvider;
import org.eclipse.emf.cdo.dawn.util.connection.CDOConnectionUtil;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.opencert.apm.assuranceassets.assuranceasset.EventKind;
import org.eclipse.opencert.evm.evidspec.evidence.Artefact;
import org.eclipse.opencert.evm.evidspec.evidence.presentation.EvidenceEditor;
import org.eclipse.opencert.evm.evidspec.evidence.util.ArtefactModificationController;
import org.eclipse.opencert.evm.evidspec.presentation.ArtefactsRelationImpactContentProvider;
import org.eclipse.opencert.evm.evidspec.presentation.ArtefactsRelationImpactLabelProvider;
import org.eclipse.opencert.evm.evidspec.presentation.EclipseOpencertClientConfigurationAdapter;
import org.eclipse.opencert.impactanalysis.ImpactAnalyser;
import org.eclipse.opencert.impactanalysis.ImpactSource;
import org.eclipse.opencert.impactanalysis.relations.IArtefactRelationImpact;
import org.eclipse.opencert.storage.cdo.property.IOpencertClientConfigurationAdapter;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.dialogs.CheckedTreeSelectionDialog;

public class DawnEvidenceEditor
extends EvidenceEditor
implements IDawnEditor {
    private static final String SELECT_THE_NODES_FROM_THE_TREE_TO_CONFIRM_THE_CHANGES = "Select the nodes from the tree to confirm the changes.";
    private static final String IMPACT_TREE_SELECTION = "IMPACT ANALYSER Confirmation";
    private static final String CONFIRM = "Confirm";
    private IDawnEditorSupport dawnEditorSupport = new DawnEMFEditorSupport((IDawnEditor)this);
    public static String ID = "org.eclipse.opencert.evm.evidspec.presentation.DawnEvidenceEditorID";

    protected void setInput(IEditorInput input) {
        super.setInput(input);
        if (input instanceof DawnEditorInput) {
            this.dawnEditorSupport.setView(((DawnEditorInput)input).getView());
            this.dawnEditorSupport.registerListeners();
        }
    }

    protected void setInputWithNotify(IEditorInput input) {
        super.setInput(input);
        if (input instanceof DawnEditorInput) {
            CDOResource resource = ((DawnEditorInput)input).getResource();
            URI uri = URI.createURI((String)((DawnEditorInput)input).getURI().toString());
            if (resource == null || resource.cdoView() == null) {
                ResourceSet resourceSet = this.editingDomain.getResourceSet();
                CDOTransaction transaction = CDOConnectionUtil.instance.openCurrentTransaction(resourceSet, uri.toString());
                resource = (CDOResource)resourceSet.getResource(uri, true);
                if (resource == null || resource.cdoView() == null) {
                    resource = transaction.getOrCreateResource(uri.toString());
                }
            }
            ((DawnEditorInput)input).setResource(resource);
            this.dawnEditorSupport.setView(((DawnEditorInput)input).getView());
            this.dawnEditorSupport.registerListeners();
        }
    }

    public void createPages() {
        super.createPages();
        if (!(this.getEditorInput() instanceof DawnEditorInput)) {
            return;
        }
        this.selectionViewer.setContentProvider((IContentProvider)new DawnSelectionViewerAdapterFactoryContentProvider((AdapterFactory)this.adapterFactory, ((DawnEditorInput)this.getEditorInput()).getResource()));
        this.selectionViewer.setLabelProvider((IBaseLabelProvider)new DawnLabelProvider((AdapterFactory)this.adapterFactory, this.dawnEditorSupport.getView(), this.selectionViewer));
        this.parentViewer.setLabelProvider((IBaseLabelProvider)new DawnLabelProvider((AdapterFactory)this.adapterFactory, this.dawnEditorSupport.getView(), this.selectionViewer));
        this.listViewer.setLabelProvider((IBaseLabelProvider)new DawnLabelProvider((AdapterFactory)this.adapterFactory, this.dawnEditorSupport.getView(), this.selectionViewer));
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new DawnLabelProvider((AdapterFactory)this.adapterFactory, this.dawnEditorSupport.getView(), this.selectionViewer));
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new DawnLabelProvider((AdapterFactory)this.adapterFactory, this.dawnEditorSupport.getView(), this.selectionViewer));
        this.treeViewerWithColumns.setLabelProvider((IBaseLabelProvider)new DawnLabelProvider((AdapterFactory)this.adapterFactory, this.dawnEditorSupport.getView(), this.selectionViewer));
        CDOResource resource = ((DawnEditorInput)this.getEditorInput()).getResource();
        this.selectionViewer.setInput((Object)resource.getResourceSet());
        this.selectionViewer.setSelection((ISelection)new StructuredSelection((Object)resource), true);
        this.parentViewer.setContentProvider((IContentProvider)new EvidenceEditor.ReverseAdapterFactoryContentProvider((EvidenceEditor)this, (AdapterFactory)this.adapterFactory));
    }

    public void doSave(IProgressMonitor progressMonitor) {
        CDOView view = this.dawnEditorSupport.getView();
        if (view instanceof CDOTransaction) {
            if (view.hasConflict()) {
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"conflict", (String)"Your Resource is in conflict and cannot be committed");
            } else {
                super.doSave(progressMonitor);
                this.callImpactAnalyser();
            }
        } else {
            super.doSave(progressMonitor);
            this.callImpactAnalyser();
        }
    }

    private void callImpactAnalyser() {
        ArtefactModificationController amc = ArtefactModificationController.getInstance();
        ArrayList<ImpactSource> impactSources = new ArrayList<ImpactSource>();
        try (ImpactAnalyser impactAnalyser = new ImpactAnalyser((IOpencertClientConfigurationAdapter)new EclipseOpencertClientConfigurationAdapter());){
            Iterator iter = amc.getModifiedArtefacts().iterator();
            while (iter.hasNext()) {
                Artefact modArtefact = (Artefact)iter.next();
                if (modArtefact instanceof EObject) {
                    Artefact elobjeto = modArtefact;
                    CDOObject cdo = CDOUtil.getCDOObject((EObject)elobjeto);
                    CDOID id = cdo.cdoID();
                    Long initialArtefactCDOId = new Long(id.toURIFragment());
                    ImpactSource impactSource = new ImpactSource(initialArtefactCDOId, EventKind.MODIFICATION);
                    impactSources.add(impactSource);
                }
                iter.remove();
            }
            List artefactsRelationImpacts = impactAnalyser.listArtefactsRelationImpacts(impactSources);
            ArrayList<IArtefactRelationImpact> artefactsRelationImpactsExecute = new ArrayList<IArtefactRelationImpact>();
            if (artefactsRelationImpacts.size() != 0) {
                CheckedTreeSelectionDialog dialog2 = new CheckedTreeSelectionDialog(Display.getDefault().getActiveShell(), (ILabelProvider)new ArtefactsRelationImpactLabelProvider(), new ArtefactsRelationImpactContentProvider(artefactsRelationImpacts)){

                    public Button getOkButton() {
                        super.getOkButton().setText(DawnEvidenceEditor.CONFIRM);
                        return super.getOkButton();
                    }

                    protected Point getInitialSize() {
                        return new Point(1000, 700);
                    }
                };
                dialog2.setTitle(IMPACT_TREE_SELECTION);
                dialog2.setMessage(SELECT_THE_NODES_FROM_THE_TREE_TO_CONFIRM_THE_CHANGES);
                dialog2.setExpandedElements(artefactsRelationImpacts.toArray());
                dialog2.setInput((Object)artefactsRelationImpacts);
                int response = dialog2.open();
                if (response == 0) {
                    Object[] sele;
                    Object[] objectArray = sele = dialog2.getResult();
                    int n = sele.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object oneImpact = objectArray[n2];
                        if (oneImpact instanceof IArtefactRelationImpact) {
                            artefactsRelationImpactsExecute.add((IArtefactRelationImpact)oneImpact);
                        }
                        ++n2;
                    }
                    impactAnalyser.executeArtefactsRelationImpacts(artefactsRelationImpactsExecute);
                }
            }
        }
        amc.getEvaluatedArtefacts().clear();
    }

    public String getContributorID() {
        return "org.eclipse.opencert.evm.evidspec.evidence.properties";
    }

    public CDOView getView() {
        return this.dawnEditorSupport.getView();
    }

    public void setDirty() {
        this.dawnEditorSupport.setDirty(true);
    }

    public void dispose() {
        try {
            super.dispose();
        }
        finally {
            this.dawnEditorSupport.close();
        }
    }

    public String getContributorId() {
        return "org.eclipse.opencert.evm.evidspec.evidence.properties";
    }

    public IDawnEditorSupport getDawnEditorSupport() {
        return this.dawnEditorSupport;
    }
}

