/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.userguidance.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.opencert.userguidance.label.WrappingLabel2;
import org.eclipse.opencert.userguidance.labelparser.tokens.HighlightItem;
import org.eclipse.opencert.userguidance.labelparser.tokens.Token;

public class HitTestUtil {
    public static HighlightItem getHighlightItemScreen(DiagramEditor editor, int screenX, int screenY) {
        org.eclipse.swt.graphics.Point editorLocation = editor.getDiagramGraphicalViewer().getControl().toDisplay(0, 0);
        int mouseEditorLocationX = screenX - editorLocation.x;
        int mouseEditorLocationY = screenY - editorLocation.y;
        return HitTestUtil.getHighlightItem(editor, mouseEditorLocationX, mouseEditorLocationY);
    }

    public static HighlightItem getHighlightItem(DiagramEditor editor, int controlX, int controlY) {
        EditPart ep = editor.getDiagramGraphicalViewer().findObjectAt(new Point(controlX, controlY));
        if (ep instanceof GraphicalEditPart) {
            int diagY;
            GraphicalEditPart gep = (GraphicalEditPart)ep;
            Rectangle diagramBounds = ((DiagramEditPart)ep.getRoot().getChildren().get(0)).getFigure().getBounds();
            FigureCanvas canvas = (FigureCanvas)editor.getDiagramGraphicalViewer().getControl();
            int scrollYOffset = canvas.getVerticalBar().getSelection();
            int scrollXOffset = canvas.getHorizontalBar().getSelection();
            int diagX = controlX + scrollXOffset + diagramBounds.x;
            WrappingLabel2 label = HitTestUtil.findWrappingLabel(gep, diagX, diagY = controlY + scrollYOffset + diagramBounds.y);
            if (label != null) {
                Rectangle labelBounds = label.getBounds();
                Token token = label.getTokenAt(diagX - labelBounds.x, diagY - labelBounds.y);
                if (token instanceof HighlightItem) {
                    return (HighlightItem)token;
                }
            }
        }
        return null;
    }

    private static WrappingLabel2 findWrappingLabel(GraphicalEditPart shape, int diagX, int diagY) {
        ArrayList<WrappingLabel2> labels = new ArrayList<WrappingLabel2>();
        HitTestUtil.getWrappingLabels(shape.getFigure(), labels);
        WrappingLabel2 result = null;
        for (WrappingLabel2 label : labels) {
            Rectangle labelBounds = label.getBounds();
            if (diagX <= labelBounds.x || diagX >= labelBounds.x + labelBounds.width || diagY <= labelBounds.y || diagY >= labelBounds.y + labelBounds.height) continue;
            result = label;
            break;
        }
        return result;
    }

    private static void getWrappingLabels(IFigure figure, List<WrappingLabel2> result) {
        if (figure instanceof WrappingLabel2) {
            result.add((WrappingLabel2)figure);
        } else {
            for (Object obj : figure.getChildren()) {
                if (!(obj instanceof IFigure)) continue;
                HitTestUtil.getWrappingLabels((IFigure)obj, result);
            }
        }
    }
}

