/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.variables;

import java.util.ArrayList;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.jdt.debug.core.IJavaVariable;
import org.eclipse.jdt.internal.debug.ui.IJDIPreferencesConstants;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jface.preference.IPreferenceStore;

public class JavaContentProviderFilter {
    public static Object[] filterVariables(Object[] variables, IPresentationContext context) throws DebugException {
        boolean filterConstants;
        boolean filterStatics = !JavaContentProviderFilter.includeStatic(context);
        boolean bl = filterConstants = !JavaContentProviderFilter.includeConstants(context);
        if (filterStatics || filterConstants) {
            ArrayList<Object> keep = new ArrayList<Object>(variables.length);
            int i = 0;
            while (i < variables.length) {
                IJavaVariable var;
                boolean filter = false;
                if (variables[i] instanceof IJavaVariable && (var = (IJavaVariable)variables[i]).isStatic()) {
                    filter = var.isFinal() ? filterConstants : filterStatics;
                }
                if (!filter) {
                    keep.add(variables[i]);
                }
                ++i;
            }
            return keep.toArray(new Object[keep.size()]);
        }
        return variables;
    }

    private static boolean includeStatic(IPresentationContext context) {
        IPreferenceStore store = JDIDebugUIPlugin.getDefault().getPreferenceStore();
        String statics = String.valueOf(context.getId()) + "." + IJDIPreferencesConstants.PREF_SHOW_STATIC_VARIABLES;
        return store.getBoolean(statics);
    }

    private static boolean includeConstants(IPresentationContext context) {
        IPreferenceStore store = JDIDebugUIPlugin.getDefault().getPreferenceStore();
        String constants = String.valueOf(context.getId()) + "." + IJDIPreferencesConstants.PREF_SHOW_CONSTANTS;
        return store.getBoolean(constants);
    }
}

