/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.apm.assurproj.wizards.ui.wizards.Etl;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.epsilon.common.parse.problem.ParseProblem;
import org.eclipse.epsilon.emc.emf.EmfModel;
import org.eclipse.epsilon.eol.IEolExecutableModule;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelElementTypeNotFoundException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelLoadingException;
import org.eclipse.epsilon.eol.models.IModel;
import org.eclipse.epsilon.etl.EtlModule;
import org.eclipse.epsilon.etl.dom.TransformationRule;
import org.eclipse.epsilon.etl.trace.Transformation;
import org.eclipse.opencert.apm.assurproj.wizards.ui.wizards.Etl.EtlTransformParameters;
import org.eclipse.opencert.apm.assurproj.wizards.ui.wizards.Etl.RedirectSystemErr;

public class EtlTransformation {
    private static final String UTF_8 = "UTF-8";
    private String etlTransformation;
    private String sourceName;
    private String sourceMetaModelURI;
    private Object result;
    private Object IoldEPackage;
    private Object OoldEPackage;
    private String sourceMetaModelFilePath;
    private String sourceModelFilePath;
    private boolean sourceReadOnLoad;
    private boolean sourceStoreOnDisposal;
    private String targetName;
    private String targetMetaModelURI;
    private String targetMetaModelFilePath;
    private String targetModelFilePath;
    private boolean targetReadOnLoad;
    private boolean targetStoreOnDisposal;
    private String pluginID;

    public EtlTransformation(String name) {
    }

    private IEolExecutableModule createModule() {
        return new EtlModule();
    }

    private void postProcess() {
    }

    private void preProcess() {
    }

    public void execute() throws Exception {
        URL resolvedTransformationURL = null;
        URI transformURI = null;
        String file = null;
        try {
            String spluginPath = Platform.getBundle((String)"org.eclipse.opencert.apm.assurproj.wizards").getLocation();
            RedirectSystemErr.out("spluginPath:= ." + spluginPath + ".");
            if (spluginPath.contains("plugins")) {
                String file2;
                String pluginPath = "configuration";
                Iterator transformationEntry = Platform.getBundle((String)this.pluginID).getEntry(this.etlTransformation);
                resolvedTransformationURL = FileLocator.resolve((URL)((Object)transformationEntry));
                file = resolvedTransformationURL.getFile();
                file = file.replace(" ", "%20");
                String wrong = file.substring(file.indexOf("plugins"), file.indexOf("/" + this.etlTransformation));
                file = file2 = file.replace(wrong, pluginPath);
            } else {
                URL transformationEntry = Platform.getBundle((String)this.pluginID).getEntry(this.etlTransformation);
                resolvedTransformationURL = FileLocator.resolve((URL)transformationEntry);
                file = "file:" + resolvedTransformationURL.getFile();
                file = file.replace(" ", "%20");
            }
            RedirectSystemErr.out("rules file:= ." + file + ".");
            transformURI = new URI(file);
        }
        catch (IOException e) {
            e.printStackTrace();
            RedirectSystemErr.out("execute exception 1: " + e.toString());
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            RedirectSystemErr.out("execute exception 2: " + e.toString());
        }
        EtlModule etlModule = new EtlModule();
        try {
            etlModule.parse(transformURI);
        }
        catch (Exception e) {
            e.printStackTrace();
            RedirectSystemErr.out("execute exception 3: " + e.toString());
        }
        if (etlModule.getParseProblems().size() > 0) {
            System.err.println("Parse errors occured...");
            for (ParseProblem problem : etlModule.getParseProblems()) {
                System.err.println(problem.toString());
                RedirectSystemErr.out("encontrado " + problem.toString());
            }
        }
        for (TransformationRule rule : etlModule.getTransformationRules()) {
            RedirectSystemErr.out("rule = ." + rule.toString() + ".");
        }
        EmfModel sourceModel = this.createSource();
        EmfModel targetModel = this.createTarget();
        if (sourceModel == null) {
            RedirectSystemErr.out("sourceModel is null");
        }
        if (targetModel == null) {
            RedirectSystemErr.out("targetModel is null");
        }
        etlModule.getContext().getModelRepository().addModel((IModel)sourceModel);
        etlModule.getContext().getModelRepository().addModel((IModel)targetModel);
        try {
            this.result = etlModule.execute();
        }
        catch (EolRuntimeException e) {
            e.printStackTrace();
            RedirectSystemErr.out("execute exception 4: " + e.toString());
        }
        RedirectSystemErr.out("execute voy a leer reglas disparadas ");
        for (Transformation elem : etlModule.getContext().getTransformationTrace().getTransformations()) {
            TransformationRule rule = elem.getRule();
            Object source = elem.getSource();
            Collection targets = elem.getTargets();
            System.out.println("Fired rule =" + rule.getName() + ": source =[" + source.toString() + "] & tragets =[" + targets.toString() + "]");
        }
        sourceModel.dispose();
        targetModel.dispose();
        etlModule.getContext().getModelRepository().dispose();
    }

    public Object getResult() {
        return this.result;
    }

    protected EmfModel createSource() {
        int i;
        String[] metaModelURIs;
        EmfModel emfModel = new EmfModel();
        emfModel.setName(this.sourceName);
        if (this.sourceMetaModelURI != null && !this.sourceMetaModelURI.isEmpty()) {
            emfModel.setMetamodelFileBased(false);
            if (this.sourceMetaModelURI.contains(",")) {
                metaModelURIs = this.sourceMetaModelURI.split(",");
                ArrayList<String> uris = new ArrayList<String>(metaModelURIs.length);
                i = 0;
                while (i < metaModelURIs.length) {
                    uris.add(metaModelURIs[i].trim());
                    ++i;
                }
                RedirectSystemErr.out("uris:= ." + ((Object)uris).toString() + ".");
                emfModel.setMetamodelUris(uris);
            } else {
                RedirectSystemErr.out("sourceMetaModelURI:= ." + this.sourceMetaModelURI + ".");
                emfModel.setMetamodelUri(this.sourceMetaModelURI);
            }
        }
        if (this.sourceMetaModelFilePath != null && !this.sourceMetaModelFilePath.isEmpty()) {
            emfModel.setMetamodelFileBased(true);
            if (this.sourceMetaModelFilePath.contains(",")) {
                metaModelURIs = this.sourceMetaModelFilePath.split(",");
                ArrayList<String> files = new ArrayList<String>(metaModelURIs.length);
                new ArrayList(metaModelURIs.length);
                i = 0;
                while (i < metaModelURIs.length) {
                    files.add(metaModelURIs[i].trim());
                    ++i;
                }
                RedirectSystemErr.out("files:= ." + ((Object)files).toString() + ".");
                emfModel.setMetamodelFiles(files);
            } else {
                RedirectSystemErr.out("sourceMetaModelFilePath:= ." + this.sourceMetaModelFilePath + ".");
                emfModel.setMetamodelFile(this.sourceMetaModelFilePath);
            }
        }
        RedirectSystemErr.out("sourceModelFilePath:= ." + this.sourceModelFilePath + ".");
        emfModel.setModelFile(this.sourceModelFilePath);
        emfModel.setReadOnLoad(this.sourceReadOnLoad);
        emfModel.setStoredOnDisposal(this.sourceStoreOnDisposal);
        emfModel.setCachingEnabled(true);
        emfModel.setExpand(true);
        try {
            emfModel.load();
            System.out.println("emfModel.getAllOfType=" + emfModel.getAllOfType("BaseFramework").toString());
            RedirectSystemErr.out("emfModel.getAllOfType=" + emfModel.getAllOfType("BaseFramework").toString());
            System.out.println("emfModel.getAllOfKind=" + emfModel.getAllOfKind("BaseFramework").toString());
            RedirectSystemErr.out("emfModel.getAllOfKind=" + emfModel.getAllOfKind("BaseFramework").toString());
        }
        catch (EolModelLoadingException e) {
            e.printStackTrace();
        }
        catch (EolModelElementTypeNotFoundException e) {
            e.printStackTrace();
        }
        return emfModel;
    }

    protected EmfModel createTarget() {
        int i;
        String[] metaModelURIs;
        EmfModel emfModel = new EmfModel();
        emfModel.setName(this.targetName);
        if (this.targetMetaModelURI != null && !this.targetMetaModelURI.isEmpty()) {
            emfModel.setMetamodelFileBased(false);
            if (this.targetMetaModelURI.contains(",")) {
                metaModelURIs = this.targetMetaModelURI.split(",");
                ArrayList<String> uris = new ArrayList<String>(metaModelURIs.length);
                i = 0;
                while (i < metaModelURIs.length) {
                    uris.add(metaModelURIs[i].trim());
                    ++i;
                }
                RedirectSystemErr.out("target uris:= ." + ((Object)uris).toString() + ".");
                emfModel.setMetamodelUris(uris);
            } else {
                RedirectSystemErr.out("targetMetaModelURI:= ." + this.targetMetaModelURI + ".");
                emfModel.setMetamodelUri(this.targetMetaModelURI);
            }
        }
        if (this.targetMetaModelFilePath != null && !this.targetMetaModelFilePath.isEmpty()) {
            emfModel.setMetamodelFileBased(true);
            if (this.targetMetaModelFilePath.contains(",")) {
                metaModelURIs = this.targetMetaModelFilePath.split(",");
                ArrayList<String> files = new ArrayList<String>(metaModelURIs.length);
                new ArrayList(metaModelURIs.length);
                i = 0;
                while (i < metaModelURIs.length) {
                    files.add(metaModelURIs[i].trim());
                    ++i;
                }
                RedirectSystemErr.out("target files:= ." + ((Object)files).toString() + ".");
                emfModel.setMetamodelFiles(files);
            } else {
                RedirectSystemErr.out("targetMetaModelFilePath:= ." + this.targetMetaModelFilePath + ".");
                emfModel.setMetamodelFile(this.targetMetaModelFilePath);
            }
        }
        RedirectSystemErr.out("targetModelFilePath:= ." + this.targetModelFilePath + ".");
        emfModel.setModelFile(this.targetModelFilePath);
        emfModel.setReadOnLoad(this.targetReadOnLoad);
        emfModel.setStoredOnDisposal(this.targetStoreOnDisposal);
        emfModel.setCachingEnabled(true);
        emfModel.setExpand(true);
        try {
            emfModel.load();
            System.out.println("emfModel.getAllOfType=" + emfModel.getAllOfType("Case").toString());
            RedirectSystemErr.out("emfModel.getAllOfType=" + emfModel.getAllOfType("Case").toString());
            System.out.println("emfModel.getAllOfKind=" + emfModel.getAllOfKind("Case").toString());
            RedirectSystemErr.out("emfModel.getAllOfKind=" + emfModel.getAllOfKind("Case").toString());
        }
        catch (EolModelLoadingException e) {
            e.printStackTrace();
        }
        catch (EolModelElementTypeNotFoundException e) {
            e.printStackTrace();
        }
        return emfModel;
    }

    public void createJob(EtlTransformParameters parameters) {
        this.pluginID = parameters.getPluginID();
        this.etlTransformation = parameters.getEtlTransform();
        this.sourceName = parameters.getSourceName();
        this.sourceMetaModelURI = parameters.getSourceMetaModelURI();
        this.sourceMetaModelFilePath = parameters.getSourceMetaModelFilePath();
        this.IoldEPackage = parameters.getIOldEPackages();
        this.OoldEPackage = parameters.getOOldEPackages();
        this.sourceModelFilePath = parameters.getSourceModelFilePath();
        this.sourceReadOnLoad = parameters.isSourceReadOnLoad();
        this.targetName = parameters.getTargetName();
        this.targetMetaModelURI = parameters.getTargetMetaModelURI();
        this.targetMetaModelFilePath = parameters.getTargetMetaModelFilePath();
        this.targetModelFilePath = parameters.getTargetModelFilePath();
        this.targetReadOnLoad = parameters.isTargetReadOnLoad();
        this.targetStoreOnDisposal = parameters.isTargetStoreOnDisposal();
    }
}

