/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.apm.baseline.baseline.diagram.part;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecoretools.diagram.ui.outline.AdditionalResources;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.IWrapperItemProvider;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.opencert.apm.baseline.baseline.util.ModelStorage;

public class MyNavigatorContentProvider
implements ITreeContentProvider {
    private static final Object[] NO_CHILDREN = new Object[0];
    private ITreeContentProvider delegatedModelProvider;
    private Resource diagramResource;
    private AdditionalResources resources;

    public MyNavigatorContentProvider(Resource viewer, ITreeContentProvider delegatedProvider) {
        this.delegatedModelProvider = delegatedProvider;
        this.diagramResource = viewer;
        this.resources = new AdditionalResources(this.diagramResource.getResourceSet());
        ModelStorage ms = ModelStorage.getInstance();
        ms.setResourceURI(this.resources);
    }

    protected AdditionalResources getAdditionalResources() {
        return this.resources;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof Diagram) {
            return NO_CHILDREN;
        }
        if (parentElement instanceof AdditionalResources) {
            return ((AdditionalResources)parentElement).getResources().toArray();
        }
        ArrayList<Object> children = new ArrayList<Object>();
        Object[] modelChildren = this.delegatedModelProvider.getChildren(parentElement);
        int i = 0;
        while (i < modelChildren.length) {
            Object child = modelChildren[i];
            children.add(child);
            ++i;
        }
        if (parentElement instanceof EObject || parentElement instanceof IWrapperItemProvider || parentElement instanceof FeatureMap.Entry) {
            children.addAll(this.findAllExistingDiagram(this.diagramResource, (EObject)AdapterFactoryEditingDomain.unwrap((Object)parentElement)));
        }
        return children.toArray();
    }

    private Collection<Diagram> findAllExistingDiagram(Resource diagramResource, EObject modelObject) {
        ArrayList<Diagram> diagrams = new ArrayList<Diagram>();
        if (diagramResource != null) {
            for (EObject content : diagramResource.getContents()) {
                if (!(content instanceof Diagram) || !modelObject.equals(((Diagram)content).getElement())) continue;
                diagrams.add((Diagram)content);
            }
        }
        return diagrams;
    }

    public Object getParent(Object element) {
        if (element instanceof Diagram) {
            return ((Diagram)element).getElement();
        }
        if (element instanceof IWrapperItemProvider || element instanceof FeatureMap.Entry || element instanceof EObject) {
            return this.delegatedModelProvider.getParent(element);
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof Diagram) {
            return false;
        }
        return this.getChildren(element).length > 0;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof Resource) {
            Object[] objects;
            ArrayList<Object> children = new ArrayList<Object>();
            Object[] objectArray = objects = this.delegatedModelProvider.getChildren(inputElement);
            int n = objects.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                if (object instanceof EObject) {
                    children.add(object);
                }
                ++n2;
            }
            children.add(this.resources);
            return children.toArray();
        }
        return NO_CHILDREN;
    }

    public void dispose() {
        this.delegatedModelProvider.dispose();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.delegatedModelProvider.inputChanged(viewer, oldInput, newInput);
    }
}

