/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.apm.baseline.baseline.diagram.navigator;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParser;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserOptions;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ITreePathLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.opencert.apm.baseline.baseline.BaseFramework;
import org.eclipse.opencert.apm.baseline.baseline.diagram.navigator.BaselineNavigatorGroup;
import org.eclipse.opencert.apm.baseline.baseline.diagram.navigator.BaselineNavigatorItem;
import org.eclipse.opencert.apm.baseline.baseline.diagram.part.BaselineDiagramEditorPlugin;
import org.eclipse.opencert.apm.baseline.baseline.diagram.part.BaselineVisualIDRegistry;
import org.eclipse.opencert.apm.baseline.baseline.diagram.providers.BaselineElementTypes;
import org.eclipse.opencert.apm.baseline.baseline.diagram.providers.BaselineParserProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonLabelProvider;

public class BaselineNavigatorLabelProvider
extends LabelProvider
implements ICommonLabelProvider,
ITreePathLabelProvider {
    static {
        BaselineDiagramEditorPlugin.getInstance().getImageRegistry().put("Navigator?UnknownElement", ImageDescriptor.getMissingImageDescriptor());
        BaselineDiagramEditorPlugin.getInstance().getImageRegistry().put("Navigator?ImageNotFound", ImageDescriptor.getMissingImageDescriptor());
    }

    public void updateLabel(ViewerLabel label, TreePath elementPath) {
        Object element = elementPath.getLastSegment();
        if (element instanceof BaselineNavigatorItem && !this.isOwnView(((BaselineNavigatorItem)((Object)element)).getView())) {
            return;
        }
        label.setText(this.getText(element));
        label.setImage(this.getImage(element));
    }

    public Image getImage(Object element) {
        View view;
        if (element instanceof BaselineNavigatorGroup) {
            BaselineNavigatorGroup group = (BaselineNavigatorGroup)((Object)element);
            return BaselineDiagramEditorPlugin.getInstance().getBundledImage(group.getIcon());
        }
        if (element instanceof BaselineNavigatorItem) {
            BaselineNavigatorItem navigatorItem = (BaselineNavigatorItem)((Object)element);
            if (!this.isOwnView(navigatorItem.getView())) {
                return super.getImage(element);
            }
            return this.getImage(navigatorItem.getView());
        }
        if (element instanceof IAdaptable && (view = (View)((IAdaptable)element).getAdapter(View.class)) != null && this.isOwnView(view)) {
            return this.getImage(view);
        }
        return super.getImage(element);
    }

    public Image getImage(View view) {
        switch (BaselineVisualIDRegistry.getVisualID(view)) {
            case 1000: {
                return this.getImage("Navigator?Diagram?http://baseline/1.0?BaseFramework", BaselineElementTypes.BaseFramework_1000);
            }
            case 2001: {
                return this.getImage("Navigator?TopLevelNode?http://baseline/1.0?BaseActivity", BaselineElementTypes.BaseActivity_2001);
            }
            case 2002: {
                return this.getImage("Navigator?TopLevelNode?http://baseline/1.0?BaseArtefact", BaselineElementTypes.BaseArtefact_2002);
            }
            case 2003: {
                return this.getImage("Navigator?TopLevelNode?http://baseline/1.0?BaseRole", BaselineElementTypes.BaseRole_2003);
            }
            case 3001: {
                return this.getImage("Navigator?Node?http://baseline/1.0?BaseActivity", BaselineElementTypes.BaseActivity_3001);
            }
            case 4001: {
                return this.getImage("Navigator?Link?http://baseline/1.0?BaseActivity?requiredArtefact", BaselineElementTypes.BaseActivityRequiredArtefact_4001);
            }
            case 4002: {
                return this.getImage("Navigator?Link?http://baseline/1.0?BaseActivity?producedArtefact", BaselineElementTypes.BaseActivityProducedArtefact_4002);
            }
            case 4003: {
                return this.getImage("Navigator?Link?http://baseline/1.0?BaseActivity?precedingActivity", BaselineElementTypes.BaseActivityPrecedingActivity_4003);
            }
            case 4004: {
                return this.getImage("Navigator?Link?http://baseline/1.0?BaseActivity?role", BaselineElementTypes.BaseActivityRole_4004);
            }
        }
        return this.getImage("Navigator?UnknownElement", null);
    }

    private Image getImage(String key, IElementType elementType) {
        ImageRegistry imageRegistry = BaselineDiagramEditorPlugin.getInstance().getImageRegistry();
        Image image = imageRegistry.get(key);
        if (image == null && elementType != null && BaselineElementTypes.isKnownElementType(elementType)) {
            image = BaselineElementTypes.getImage((IAdaptable)elementType);
            imageRegistry.put(key, image);
        }
        if (image == null) {
            image = imageRegistry.get("Navigator?ImageNotFound");
            imageRegistry.put(key, image);
        }
        return image;
    }

    public String getText(Object element) {
        View view;
        if (element instanceof BaselineNavigatorGroup) {
            BaselineNavigatorGroup group = (BaselineNavigatorGroup)((Object)element);
            return group.getGroupName();
        }
        if (element instanceof BaselineNavigatorItem) {
            BaselineNavigatorItem navigatorItem = (BaselineNavigatorItem)((Object)element);
            if (!this.isOwnView(navigatorItem.getView())) {
                return null;
            }
            return this.getText(navigatorItem.getView());
        }
        if (element instanceof IAdaptable && (view = (View)((IAdaptable)element).getAdapter(View.class)) != null && this.isOwnView(view)) {
            return this.getText(view);
        }
        return super.getText(element);
    }

    public String getText(View view) {
        if (view.getElement() != null && view.getElement().eIsProxy()) {
            return this.getUnresolvedDomainElementProxyText(view);
        }
        switch (BaselineVisualIDRegistry.getVisualID(view)) {
            case 1000: {
                return this.getBaseFramework_1000Text(view);
            }
            case 2001: {
                return this.getBaseActivity_2001Text(view);
            }
            case 2002: {
                return this.getBaseArtefact_2002Text(view);
            }
            case 2003: {
                return this.getBaseRole_2003Text(view);
            }
            case 3001: {
                return this.getBaseActivity_3001Text(view);
            }
            case 4001: {
                return this.getBaseActivityRequiredArtefact_4001Text(view);
            }
            case 4002: {
                return this.getBaseActivityProducedArtefact_4002Text(view);
            }
            case 4003: {
                return this.getBaseActivityPrecedingActivity_4003Text(view);
            }
            case 4004: {
                return this.getBaseActivityRole_4004Text(view);
            }
        }
        return this.getUnknownElementText(view);
    }

    private String getBaseFramework_1000Text(View view) {
        BaseFramework domainModelElement = (BaseFramework)view.getElement();
        if (domainModelElement != null) {
            return domainModelElement.getName();
        }
        BaselineDiagramEditorPlugin.getInstance().logError("No domain element for view with visualID = 1000");
        return "";
    }

    private String getBaseActivity_2001Text(View view) {
        IParser parser = BaselineParserProvider.getParser(BaselineElementTypes.BaseActivity_2001, (EObject)(view.getElement() != null ? view.getElement() : view), BaselineVisualIDRegistry.getType(5002));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        BaselineDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5002");
        return "";
    }

    private String getBaseArtefact_2002Text(View view) {
        IParser parser = BaselineParserProvider.getParser(BaselineElementTypes.BaseArtefact_2002, (EObject)(view.getElement() != null ? view.getElement() : view), BaselineVisualIDRegistry.getType(5003));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        BaselineDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5003");
        return "";
    }

    private String getBaseRole_2003Text(View view) {
        IParser parser = BaselineParserProvider.getParser(BaselineElementTypes.BaseRole_2003, (EObject)(view.getElement() != null ? view.getElement() : view), BaselineVisualIDRegistry.getType(5004));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        BaselineDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5004");
        return "";
    }

    private String getBaseActivity_3001Text(View view) {
        IParser parser = BaselineParserProvider.getParser(BaselineElementTypes.BaseActivity_3001, (EObject)(view.getElement() != null ? view.getElement() : view), BaselineVisualIDRegistry.getType(5001));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        BaselineDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5001");
        return "";
    }

    private String getBaseActivityRequiredArtefact_4001Text(View view) {
        IParser parser = BaselineParserProvider.getParser(BaselineElementTypes.BaseActivityRequiredArtefact_4001, (EObject)(view.getElement() != null ? view.getElement() : view), "Description");
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        BaselineDiagramEditorPlugin.getInstance().logError("Parser was not found for label 6001");
        return "";
    }

    private String getBaseActivityProducedArtefact_4002Text(View view) {
        IParser parser = BaselineParserProvider.getParser(BaselineElementTypes.BaseActivityProducedArtefact_4002, (EObject)(view.getElement() != null ? view.getElement() : view), "Description");
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        BaselineDiagramEditorPlugin.getInstance().logError("Parser was not found for label 6002");
        return "";
    }

    private String getBaseActivityPrecedingActivity_4003Text(View view) {
        IParser parser = BaselineParserProvider.getParser(BaselineElementTypes.BaseActivityPrecedingActivity_4003, (EObject)(view.getElement() != null ? view.getElement() : view), "Description");
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        BaselineDiagramEditorPlugin.getInstance().logError("Parser was not found for label 6003");
        return "";
    }

    private String getBaseActivityRole_4004Text(View view) {
        IParser parser = BaselineParserProvider.getParser(BaselineElementTypes.BaseActivityRole_4004, (EObject)(view.getElement() != null ? view.getElement() : view), "Description");
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        BaselineDiagramEditorPlugin.getInstance().logError("Parser was not found for label 6004");
        return "";
    }

    private String getUnknownElementText(View view) {
        return "<UnknownElement Visual_ID = " + view.getType() + ">";
    }

    private String getUnresolvedDomainElementProxyText(View view) {
        return "<Unresolved domain element Visual_ID = " + view.getType() + ">";
    }

    public void init(ICommonContentExtensionSite aConfig) {
    }

    public void restoreState(IMemento aMemento) {
    }

    public void saveState(IMemento aMemento) {
    }

    public String getDescription(Object anElement) {
        return null;
    }

    private boolean isOwnView(View view) {
        return "Baseline".equals(BaselineVisualIDRegistry.getModelID(view));
    }
}

